/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.mutate.DeleteDeltaVo;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.scanner.LazyBlockletLoader;
import org.apache.carbondata.core.scan.scanner.LazyPageLoader;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsModel;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.log4j.Logger;

public abstract class BlockletScannedResult {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BlockletScannedResult.class.getName());
    protected int currentRow = -1;
    protected int pageCounter;
    protected int[][] pageFilteredRowId;
    protected int fixedLengthKeySize;
    private int[] pageFilteredRowCount;
    private int[] pageIdFiltered;
    protected int rowCounter;
    protected DimensionColumnPage[][] dimensionColumnPages;
    protected DimensionRawColumnChunk[] dimRawColumnChunks;
    protected MeasureRawColumnChunk[] msrRawColumnChunks;
    protected ColumnPage[][] measureColumnPages;
    protected int[] dictionaryColumnChunkIndexes;
    protected int[] noDictionaryColumnChunkIndexes;
    public Map<Integer, GenericQueryType> complexParentIndexToQueryMap;
    private int totalDimensionsSize;
    private String blockletId;
    private int[] complexParentBlockIndexes;
    private Map<String, DeleteDeltaVo> deletedRecordMap;
    private DeleteDeltaVo currentDeleteDeltaVo;
    private String blockletNumber;
    protected List<Integer> validRowIds;
    protected QueryStatisticsModel queryStatisticsModel;
    protected LazyBlockletLoader lazyBlockletLoader;
    private ReusableDataBuffer[] dimensionReusableBuffer;
    private ReusableDataBuffer[] measureReusableBuffer;

    public BlockletScannedResult(BlockExecutionInfo blockExecutionInfo, QueryStatisticsModel queryStatisticsModel) {
        this.dimensionReusableBuffer = blockExecutionInfo.getDimensionReusableDataBuffer();
        this.measureReusableBuffer = blockExecutionInfo.getMeasureReusableDataBuffer();
        this.fixedLengthKeySize = blockExecutionInfo.getFixedLengthKeySize();
        this.noDictionaryColumnChunkIndexes = blockExecutionInfo.getNoDictionaryColumnChunkIndexes();
        this.dictionaryColumnChunkIndexes = blockExecutionInfo.getDictionaryColumnChunkIndex();
        this.complexParentIndexToQueryMap = blockExecutionInfo.getComlexDimensionInfoMap();
        this.complexParentBlockIndexes = blockExecutionInfo.getComplexColumnParentBlockIndexes();
        this.totalDimensionsSize = blockExecutionInfo.getProjectionDimensions().length;
        this.deletedRecordMap = blockExecutionInfo.getDeletedRecordsMap();
        this.queryStatisticsModel = queryStatisticsModel;
        this.validRowIds = new ArrayList<Integer>(16);
    }

    public void setDimensionColumnPages(DimensionColumnPage[][] columnPages) {
        this.dimensionColumnPages = columnPages;
    }

    public void setMeasureColumnPages(ColumnPage[][] columnPages) {
        this.measureColumnPages = columnPages;
    }

    public void setDimRawColumnChunks(DimensionRawColumnChunk[] dimRawColumnChunks) {
        this.dimRawColumnChunks = dimRawColumnChunks;
    }

    public void setMsrRawColumnChunks(MeasureRawColumnChunk[] msrRawColumnChunks) {
        this.msrRawColumnChunks = msrRawColumnChunks;
    }

    public LazyBlockletLoader getLazyBlockletLoader() {
        return this.lazyBlockletLoader;
    }

    public void setLazyBlockletLoader(LazyBlockletLoader lazyBlockletLoader) {
        this.lazyBlockletLoader = lazyBlockletLoader;
    }

    public ColumnPage getMeasureChunk(int ordinal) {
        return this.measureColumnPages[ordinal][this.pageCounter];
    }

    protected int[] getDictionaryKeyIntegerArray(int rowId) {
        int[] completeKey = new int[this.totalDimensionsSize];
        int column = 0;
        for (int i = 0; i < this.dictionaryColumnChunkIndexes.length; ++i) {
            column = this.dimensionColumnPages[this.dictionaryColumnChunkIndexes[i]][this.pageCounter].fillSurrogateKey(rowId, column, completeKey);
        }
        return completeKey;
    }

    public void fillColumnarDictionaryBatch(ColumnVectorInfo[] vectorInfo) {
        int column = 0;
        for (int i = 0; i < this.dictionaryColumnChunkIndexes.length; ++i) {
            column = this.dimensionColumnPages[this.dictionaryColumnChunkIndexes[i]][this.pageCounter].fillVector(vectorInfo, column);
        }
    }

    public void fillColumnarNoDictionaryBatch(ColumnVectorInfo[] vectorInfo) {
        for (int i = 0; i < this.noDictionaryColumnChunkIndexes.length; ++i) {
            this.dimensionColumnPages[this.noDictionaryColumnChunkIndexes[i]][this.pageCounter].fillVector(vectorInfo, i);
        }
    }

    public void fillColumnarMeasureBatch(ColumnVectorInfo[] vectorInfo, int[] measuresOrdinal) {
        for (int i = 0; i < measuresOrdinal.length; ++i) {
            vectorInfo[i].measureVectorFiller.fillMeasureVector(this.measureColumnPages[measuresOrdinal[i]][this.pageCounter], vectorInfo[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillColumnarComplexBatch(ColumnVectorInfo[] vectorInfos) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ReUsableByteArrayDataOutputStream reuseableDataOutput = new ReUsableByteArrayDataOutputStream(byteStream);
        boolean isExceptionThrown = false;
        for (int i = 0; i < vectorInfos.length; ++i) {
            int offset = vectorInfos[i].offset;
            int len = offset + vectorInfos[i].size;
            int vectorOffset = vectorInfos[i].vectorOffset;
            CarbonColumnVector vector = vectorInfos[i].vector;
            for (int j = offset; j < len; ++j) {
                try {
                    vectorInfos[i].genericQueryType.parseBlocksAndReturnComplexColumnByteArray(this.dimRawColumnChunks, this.dimensionColumnPages, this.pageFilteredRowId == null ? j : this.pageFilteredRowId[this.pageCounter][j], this.pageCounter, reuseableDataOutput);
                    Object data = vectorInfos[i].genericQueryType.getDataBasedOnDataType(ByteBuffer.wrap(reuseableDataOutput.getByteArray()));
                    vector.putObject(vectorOffset++, data);
                    reuseableDataOutput.reset();
                    if (!isExceptionThrown) continue;
                }
                catch (IOException e) {
                    try {
                        isExceptionThrown = true;
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        if (!isExceptionThrown) continue;
                    }
                    catch (Throwable throwable) {
                        if (isExceptionThrown) {
                            CarbonUtil.closeStreams(reuseableDataOutput);
                            CarbonUtil.closeStreams(byteStream);
                        }
                        throw throwable;
                    }
                    CarbonUtil.closeStreams(reuseableDataOutput);
                    CarbonUtil.closeStreams(byteStream);
                    continue;
                }
                CarbonUtil.closeStreams(reuseableDataOutput);
                CarbonUtil.closeStreams(byteStream);
                continue;
            }
        }
        CarbonUtil.closeStreams(reuseableDataOutput);
        CarbonUtil.closeStreams(byteStream);
    }

    public void fillColumnarImplicitBatch(ColumnVectorInfo[] vectorInfo) {
        for (int i = 0; i < vectorInfo.length; ++i) {
            ColumnVectorInfo columnVectorInfo = vectorInfo[i];
            CarbonColumnVector vector = columnVectorInfo.vector;
            int offset = columnVectorInfo.offset;
            int vectorOffset = columnVectorInfo.vectorOffset;
            int len = offset + columnVectorInfo.size;
            for (int j = offset; j < len; ++j) {
                String data = this.getBlockletId();
                if ("tupleId".equals(columnVectorInfo.dimension.getColumnName())) {
                    data = data + "/" + this.pageCounter + "/" + (this.pageFilteredRowId == null ? j : this.pageFilteredRowId[this.pageCounter][j]);
                }
                vector.putByteArray(vectorOffset++, data.getBytes(Charset.forName("UTF-8")));
            }
        }
    }

    public void incrementCounter() {
        ++this.rowCounter;
        ++this.currentRow;
    }

    public void incrementCounter(int delta) {
        this.rowCounter += delta;
        this.currentRow += delta;
    }

    public void incrementPageCounter() {
        this.rowCounter = 0;
        this.currentRow = -1;
        ++this.pageCounter;
        this.fillDataChunks();
        if (null != this.deletedRecordMap) {
            this.currentDeleteDeltaVo = this.deletedRecordMap.get(this.blockletNumber + "_" + this.pageCounter);
        }
    }

    public void incrementPageCounter(ColumnVectorInfo[] vectorInfos) {
        this.rowCounter = 0;
        this.currentRow = -1;
        ++this.pageCounter;
        if (null != this.deletedRecordMap && this.pageCounter < this.pageIdFiltered.length) {
            this.currentDeleteDeltaVo = this.deletedRecordMap.get(this.blockletNumber + "_" + this.pageIdFiltered[this.pageCounter]);
        }
    }

    public void fillDataChunks() {
        int i;
        this.freeDataChunkMemory();
        if (this.pageCounter >= this.pageFilteredRowCount.length) {
            return;
        }
        long startTime = System.currentTimeMillis();
        for (i = 0; i < this.dimensionColumnPages.length; ++i) {
            if (this.dimensionColumnPages[i][this.pageCounter] != null || this.dimRawColumnChunks[i] == null) continue;
            this.dimensionColumnPages[i][this.pageCounter] = this.dimRawColumnChunks[i].convertToDimColDataChunkWithOutCache(this.pageCounter, null);
        }
        for (i = 0; i < this.measureColumnPages.length; ++i) {
            if (this.measureColumnPages[i][this.pageCounter] != null || this.msrRawColumnChunks[i] == null) continue;
            this.measureColumnPages[i][this.pageCounter] = this.msrRawColumnChunks[i].convertToColumnPageWithOutCache(this.pageCounter, null);
        }
        QueryStatistic pageUncompressTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("page uncompress time");
        pageUncompressTime.addCountStatistic("page uncompress time", pageUncompressTime.getCount() + (System.currentTimeMillis() - startTime));
    }

    public void fillDataChunks(ColumnVectorInfo[] dictionaryInfo, ColumnVectorInfo[] noDictionaryInfo, ColumnVectorInfo[] msrVectorInfo, int[] measuresOrdinal) {
        int i;
        this.freeDataChunkMemory();
        if (this.pageCounter >= this.pageFilteredRowCount.length) {
            return;
        }
        for (int i2 = 0; i2 < this.dictionaryColumnChunkIndexes.length; ++i2) {
            dictionaryInfo[i2].vector.setLazyPage(new LazyPageLoader(this.lazyBlockletLoader, this.dictionaryColumnChunkIndexes[i2], false, this.pageIdFiltered[this.pageCounter], dictionaryInfo[i2], this.dimensionReusableBuffer[i2]));
        }
        int startIndex = this.dictionaryColumnChunkIndexes.length;
        for (i = 0; i < this.noDictionaryColumnChunkIndexes.length; ++i) {
            noDictionaryInfo[i].vector.setLazyPage(new LazyPageLoader(this.lazyBlockletLoader, this.noDictionaryColumnChunkIndexes[i], false, this.pageIdFiltered[this.pageCounter], noDictionaryInfo[i], this.dimensionReusableBuffer[startIndex++]));
        }
        for (i = 0; i < measuresOrdinal.length; ++i) {
            msrVectorInfo[i].vector.setLazyPage(new LazyPageLoader(this.lazyBlockletLoader, measuresOrdinal[i], true, this.pageIdFiltered[this.pageCounter], msrVectorInfo[i], this.measureReusableBuffer[i]));
        }
    }

    private void freeDataChunkMemory() {
        int i;
        for (i = 0; i < this.dimensionColumnPages.length; ++i) {
            if (this.pageCounter <= 0 || this.dimensionColumnPages[i][this.pageCounter - 1] == null) continue;
            this.dimensionColumnPages[i][this.pageCounter - 1].freeMemory();
            this.dimensionColumnPages[i][this.pageCounter - 1] = null;
        }
        for (i = 0; i < this.measureColumnPages.length; ++i) {
            if (this.pageCounter <= 0 || this.measureColumnPages[i][this.pageCounter - 1] == null) continue;
            this.measureColumnPages[i][this.pageCounter - 1].freeMemory();
            this.measureColumnPages[i][this.pageCounter - 1] = null;
        }
        this.clearValidRowIdList();
    }

    public int numberOfpages() {
        return this.pageFilteredRowCount.length;
    }

    public int[] getPageIdFiltered() {
        return this.pageIdFiltered;
    }

    public void setPageIdFiltered(int[] pageIdFiltered) {
        this.pageIdFiltered = pageIdFiltered;
    }

    public int getCurrentPageRowCount() {
        return this.pageFilteredRowCount[this.pageCounter];
    }

    public int getCurrentPageCounter() {
        return this.pageCounter;
    }

    public void setRowCounter(int rowCounter) {
        this.rowCounter = rowCounter;
    }

    protected byte[][] getNoDictionaryKeyArray(int rowId) {
        byte[][] noDictionaryColumnsKeys = new byte[this.noDictionaryColumnChunkIndexes.length][];
        int position = 0;
        for (int i = 0; i < this.noDictionaryColumnChunkIndexes.length; ++i) {
            noDictionaryColumnsKeys[position++] = this.dimensionColumnPages[this.noDictionaryColumnChunkIndexes[i]][this.pageCounter].getChunkData(rowId);
        }
        return noDictionaryColumnsKeys;
    }

    public abstract void fillValidRowIdsBatchFilling(int var1, int var2);

    protected void clearValidRowIdList() {
        if (null != this.validRowIds && !this.validRowIds.isEmpty()) {
            this.validRowIds.clear();
        }
    }

    public List<Integer> getValidRowIds() {
        return this.validRowIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<byte[][]> getComplexTypeKeyArrayBatch() {
        int i;
        ArrayList<byte[][]> complexTypeArrayList = new ArrayList<byte[][]>(this.validRowIds.size());
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ReUsableByteArrayDataOutputStream reUseableDataOutput = new ReUsableByteArrayDataOutputStream(byteStream);
        boolean isExceptionThrown = false;
        Object complexTypeData = null;
        for (i = 0; i < this.validRowIds.size(); ++i) {
            complexTypeData = new byte[this.complexParentBlockIndexes.length][];
            complexTypeArrayList.add((byte[][])complexTypeData);
        }
        for (i = 0; i < this.complexParentBlockIndexes.length; ++i) {
            GenericQueryType genericQueryType = this.complexParentIndexToQueryMap.get(this.complexParentBlockIndexes[i]);
            for (int j = 0; j < this.validRowIds.size(); ++j) {
                try {
                    genericQueryType.parseBlocksAndReturnComplexColumnByteArray(this.dimRawColumnChunks, this.dimensionColumnPages, this.validRowIds.get(j), this.pageCounter, reUseableDataOutput);
                    byte[][] complexKeyArray = (byte[][])complexTypeArrayList.get(j);
                    complexKeyArray[i] = byteStream.toByteArray();
                    reUseableDataOutput.reset();
                    if (!isExceptionThrown) continue;
                }
                catch (IOException e) {
                    try {
                        isExceptionThrown = true;
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        if (!isExceptionThrown) continue;
                    }
                    catch (Throwable throwable) {
                        if (isExceptionThrown) {
                            CarbonUtil.closeStreams(reUseableDataOutput);
                            CarbonUtil.closeStreams(byteStream);
                        }
                        throw throwable;
                    }
                    CarbonUtil.closeStreams(reUseableDataOutput);
                    CarbonUtil.closeStreams(byteStream);
                    continue;
                }
                CarbonUtil.closeStreams(reUseableDataOutput);
                CarbonUtil.closeStreams(byteStream);
                continue;
            }
        }
        CarbonUtil.closeStreams(reUseableDataOutput);
        CarbonUtil.closeStreams(byteStream);
        return complexTypeArrayList;
    }

    public String getBlockletId() {
        return this.blockletId;
    }

    public void setBlockletId(String blockletId, String blockletNumber) {
        this.blockletId = blockletId + "/" + blockletNumber;
        this.blockletNumber = blockletNumber;
        if (null != this.deletedRecordMap) {
            String key = this.pageIdFiltered != null ? this.blockletNumber + '_' + this.pageIdFiltered[this.pageCounter] : this.blockletNumber + '_' + this.pageCounter;
            this.currentDeleteDeltaVo = this.deletedRecordMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[][] getComplexTypeKeyArray(int rowId) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ReUsableByteArrayDataOutputStream reUsableDataOutput = new ReUsableByteArrayDataOutputStream(byteStream);
        boolean isExceptionThrown = false;
        byte[][] complexTypeData = new byte[this.complexParentBlockIndexes.length][];
        for (int i = 0; i < complexTypeData.length; ++i) {
            GenericQueryType genericQueryType = this.complexParentIndexToQueryMap.get(this.complexParentBlockIndexes[i]);
            try {
                genericQueryType.parseBlocksAndReturnComplexColumnByteArray(this.dimRawColumnChunks, this.dimensionColumnPages, rowId, this.pageCounter, reUsableDataOutput);
                complexTypeData[i] = byteStream.toByteArray();
                reUsableDataOutput.reset();
                if (!isExceptionThrown) continue;
            }
            catch (IOException e) {
                try {
                    isExceptionThrown = true;
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    if (!isExceptionThrown) continue;
                }
                catch (Throwable throwable) {
                    if (isExceptionThrown) {
                        CarbonUtil.closeStreams(reUsableDataOutput);
                        CarbonUtil.closeStreams(byteStream);
                    }
                    throw throwable;
                }
                CarbonUtil.closeStreams(reUsableDataOutput);
                CarbonUtil.closeStreams(byteStream);
                continue;
            }
            CarbonUtil.closeStreams(reUsableDataOutput);
            CarbonUtil.closeStreams(byteStream);
            continue;
        }
        CarbonUtil.closeStreams(reUsableDataOutput);
        CarbonUtil.closeStreams(byteStream);
        return complexTypeData;
    }

    public boolean hasNext() {
        if (this.pageCounter < this.pageFilteredRowCount.length && this.rowCounter < this.pageFilteredRowCount[this.pageCounter]) {
            return true;
        }
        if (this.pageCounter < this.pageFilteredRowCount.length) {
            ++this.pageCounter;
            if (this.pageCounter >= this.pageFilteredRowCount.length) {
                return false;
            }
            if (this.pageFilteredRowCount[this.pageCounter] == 0) {
                return this.hasNext();
            }
            this.fillDataChunks();
            this.rowCounter = 0;
            this.currentRow = -1;
            if (null != this.deletedRecordMap) {
                this.currentDeleteDeltaVo = this.deletedRecordMap.get(this.blockletNumber + "_" + this.pageCounter);
            }
            return this.hasNext();
        }
        return false;
    }

    public void freeMemory() {
        int j;
        int i;
        if (null != this.dimensionColumnPages) {
            for (i = 0; i < this.dimensionColumnPages.length; ++i) {
                if (null == this.dimensionColumnPages[i]) continue;
                for (j = 0; j < this.dimensionColumnPages[i].length; ++j) {
                    if (null == this.dimensionColumnPages[i][j]) continue;
                    this.dimensionColumnPages[i][j].freeMemory();
                    this.dimensionColumnPages[i][j] = null;
                }
            }
        }
        if (null != this.measureColumnPages) {
            for (i = 0; i < this.measureColumnPages.length; ++i) {
                if (null == this.measureColumnPages[i]) continue;
                for (j = 0; j < this.measureColumnPages[i].length; ++j) {
                    if (null == this.measureColumnPages[i][j]) continue;
                    this.measureColumnPages[i][j].freeMemory();
                    this.measureColumnPages[i][j] = null;
                }
            }
        }
        if (null != this.dimRawColumnChunks) {
            for (i = 0; i < this.dimRawColumnChunks.length; ++i) {
                if (null == this.dimRawColumnChunks[i]) continue;
                this.dimRawColumnChunks[i].freeMemory();
                this.dimRawColumnChunks[i] = null;
            }
        }
        this.clearValidRowIdList();
        this.validRowIds = null;
    }

    public void setPageFilteredRowCount(int[] pageFilteredRowCount) {
        this.pageFilteredRowCount = pageFilteredRowCount;
        if (this.pageIdFiltered == null) {
            this.pageIdFiltered = new int[pageFilteredRowCount.length];
            for (int i = 0; i < this.pageIdFiltered.length; ++i) {
                this.pageIdFiltered[i] = i;
            }
        }
    }

    public void setPageFilteredRowId(int[][] pageFilteredRowId) {
        this.pageFilteredRowId = pageFilteredRowId;
    }

    public int getRowCounter() {
        return this.rowCounter;
    }

    public abstract int getCurrentRowId();

    public abstract int[] getDictionaryKeyIntegerArray();

    public List<byte[]> getDictionaryKeyArrayBatch(int batchSize) {
        int i;
        int startRowId = this.currentRow + 1;
        this.fillValidRowIdsBatchFilling(startRowId, batchSize);
        ArrayList<byte[]> dictionaryKeyArrayList = new ArrayList<byte[]>(this.validRowIds.size());
        int[] columnDataOffsets = null;
        byte[] completeKey = null;
        for (i = 0; i < this.validRowIds.size(); ++i) {
            completeKey = new byte[this.fixedLengthKeySize];
            dictionaryKeyArrayList.add(completeKey);
        }
        if (this.dictionaryColumnChunkIndexes.length > 0) {
            columnDataOffsets = new int[this.validRowIds.size()];
        }
        for (i = 0; i < this.dictionaryColumnChunkIndexes.length; ++i) {
            for (int j = 0; j < this.validRowIds.size(); ++j) {
                int n = j;
                columnDataOffsets[n] = columnDataOffsets[n] + this.dimensionColumnPages[this.dictionaryColumnChunkIndexes[i]][this.pageCounter].fillRawData(this.validRowIds.get(j), columnDataOffsets[j], (byte[])dictionaryKeyArrayList.get(j));
            }
        }
        return dictionaryKeyArrayList;
    }

    public abstract byte[][] getComplexTypeKeyArray();

    public abstract List<byte[][]> getComplexTypeKeyArrayBatch(int var1);

    public abstract byte[][] getNoDictionaryKeyArray();

    public List<byte[][]> getNoDictionaryKeyArrayBatch(int batchSize) {
        ArrayList<byte[][]> noDictionaryKeyArrayList = new ArrayList<byte[][]>(this.validRowIds.size());
        Object noDictionaryColumnsKeys = null;
        for (int i = 0; i < this.validRowIds.size(); ++i) {
            noDictionaryColumnsKeys = new byte[this.noDictionaryColumnChunkIndexes.length][];
            noDictionaryKeyArrayList.add((byte[][])noDictionaryColumnsKeys);
        }
        int columnPosition = 0;
        for (int i = 0; i < this.noDictionaryColumnChunkIndexes.length; ++i) {
            for (int j = 0; j < this.validRowIds.size(); ++j) {
                byte[][] noDictionaryArray = (byte[][])noDictionaryKeyArrayList.get(j);
                noDictionaryArray[columnPosition] = this.dimensionColumnPages[this.noDictionaryColumnChunkIndexes[i]][this.pageCounter].getChunkData(this.validRowIds.get(j));
            }
            ++columnPosition;
        }
        return noDictionaryKeyArrayList;
    }

    public int markFilteredRows(CarbonColumnarBatch columnarBatch, int startRow, int size, int vectorOffset) {
        int rowsFiltered = 0;
        if (this.currentDeleteDeltaVo != null) {
            int len = startRow + size;
            for (int i = startRow; i < len; ++i) {
                int rowId;
                int n = rowId = this.pageFilteredRowId != null ? this.pageFilteredRowId[this.pageCounter][i] : i;
                if (this.currentDeleteDeltaVo.containsRow(rowId)) {
                    columnarBatch.markFiltered(vectorOffset);
                    ++rowsFiltered;
                }
                ++vectorOffset;
            }
        }
        return rowsFiltered;
    }

    public DeleteDeltaVo getCurrentDeleteDeltaVo() {
        return this.currentDeleteDeltaVo;
    }

    public boolean containsDeletedRow(int rowId) {
        if (null != this.currentDeleteDeltaVo) {
            return this.currentDeleteDeltaVo.containsRow(rowId);
        }
        return false;
    }

    public int getBlockletNumber() {
        return Integer.parseInt(this.blockletNumber);
    }
}

