/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.impl;

import java.util.List;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.stats.QueryStatisticsModel;

public class FilterQueryScannedResult
extends BlockletScannedResult {
    public FilterQueryScannedResult(BlockExecutionInfo tableBlockExecutionInfos, QueryStatisticsModel queryStatisticsModel) {
        super(tableBlockExecutionInfos, queryStatisticsModel);
    }

    @Override
    public int[] getDictionaryKeyIntegerArray() {
        return this.getDictionaryKeyIntegerArray(this.pageFilteredRowId[this.pageCounter][this.currentRow]);
    }

    @Override
    public void fillValidRowIdsBatchFilling(int rowId, int batchSize) {
        this.clearValidRowIdList();
        int startPosition = rowId;
        int minSize = Math.min(batchSize, this.pageFilteredRowId[this.pageCounter].length);
        for (int j = startPosition; j < startPosition + minSize; ++j) {
            int pos = this.pageFilteredRowId[this.pageCounter][j];
            if (this.containsDeletedRow(pos)) continue;
            this.validRowIds.add(pos);
        }
    }

    @Override
    public byte[][] getComplexTypeKeyArray() {
        return this.getComplexTypeKeyArray(this.pageFilteredRowId[this.pageCounter][this.currentRow]);
    }

    @Override
    public List<byte[][]> getComplexTypeKeyArrayBatch(int batchSize) {
        return this.getComplexTypeKeyArrayBatch();
    }

    @Override
    public byte[][] getNoDictionaryKeyArray() {
        return this.getNoDictionaryKeyArray(this.pageFilteredRowId[this.pageCounter][this.currentRow]);
    }

    @Override
    public int getCurrentRowId() {
        return this.pageFilteredRowId[this.pageCounter][this.currentRow];
    }

    @Override
    public void fillColumnarDictionaryBatch(ColumnVectorInfo[] vectorInfo) {
        int column = 0;
        for (int chunkIndex : this.dictionaryColumnChunkIndexes) {
            column = this.dimensionColumnPages[chunkIndex][this.pageCounter].fillVector(this.pageFilteredRowId[this.pageCounter], vectorInfo, column);
        }
    }

    @Override
    public void fillColumnarNoDictionaryBatch(ColumnVectorInfo[] vectorInfo) {
        for (int index = 0; index < this.noDictionaryColumnChunkIndexes.length; ++index) {
            this.dimensionColumnPages[this.noDictionaryColumnChunkIndexes[index]][this.pageCounter].fillVector(this.pageFilteredRowId[this.pageCounter], vectorInfo, index);
        }
    }

    @Override
    public void fillColumnarMeasureBatch(ColumnVectorInfo[] vectorInfo, int[] measuresOrdinal) {
        for (int i = 0; i < measuresOrdinal.length; ++i) {
            vectorInfo[i].measureVectorFiller.fillMeasureVector(this.pageFilteredRowId[this.pageCounter], this.measureColumnPages[measuresOrdinal[i]][this.pageCounter], vectorInfo[i]);
        }
    }
}

