/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.iterator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.block.AbstractIndex;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletDataRefNode;
import org.apache.carbondata.core.mutate.DeleteDeltaVo;
import org.apache.carbondata.core.reader.CarbonDeleteFilesDataReader;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.executor.infos.DeleteDeltaInfo;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.processor.DataBlockIterator;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsModel;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public abstract class AbstractDetailQueryResultIterator<E>
extends CarbonIterator<E> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)AbstractDetailQueryResultIterator.class.getName());
    private static final Map<DeleteDeltaInfo, Object> deleteDeltaToLockObjectMap = new ConcurrentHashMap<DeleteDeltaInfo, Object>();
    protected ExecutorService execService;
    protected List<BlockExecutionInfo> blockExecutionInfos;
    protected FileReader fileReader;
    DataBlockIterator dataBlockIterator;
    protected QueryStatisticsRecorder recorder;
    protected int batchSize = CarbonProperties.getQueryBatchSize();
    private QueryStatisticsModel queryStatisticsModel;

    AbstractDetailQueryResultIterator(List<BlockExecutionInfo> infos, QueryModel queryModel, ExecutorService execService) {
        this.recorder = queryModel.getStatisticsRecorder();
        this.blockExecutionInfos = infos;
        this.fileReader = FileFactory.getFileHolder(FileFactory.getFileType(queryModel.getAbsoluteTableIdentifier().getTablePath()));
        this.fileReader.setReadPageByPage(queryModel.isReadPageByPage());
        this.execService = execService;
        this.initialiseInfos();
        this.initQueryStatiticsModel();
    }

    private void initialiseInfos() {
        for (BlockExecutionInfo blockInfo : this.blockExecutionInfos) {
            Map<String, DeleteDeltaVo> deletedRowsMap = null;
            if (null != blockInfo.getDeleteDeltaFilePath() && 0 != blockInfo.getDeleteDeltaFilePath().length) {
                DeleteDeltaInfo deleteDeltaInfo = new DeleteDeltaInfo(blockInfo.getDeleteDeltaFilePath());
                deletedRowsMap = this.getDeleteDeltaDetails(blockInfo.getDataBlock(), deleteDeltaInfo);
                blockInfo.setDeletedRecordsMap(deletedRowsMap);
            }
            DataRefNode dataRefNode = blockInfo.getDataBlock().getDataRefNode();
            assert (dataRefNode instanceof BlockletDataRefNode);
            BlockletDataRefNode node = (BlockletDataRefNode)dataRefNode;
            blockInfo.setFirstDataBlock(node);
            blockInfo.setNumberOfBlockToScan(node.numberOfNodes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DeleteDeltaVo> getDeleteDeltaDetails(AbstractIndex dataBlock, DeleteDeltaInfo deleteDeltaInfo) {
        Object object;
        if (dataBlock.getDeleteDeltaTimestamp() >= deleteDeltaInfo.getLatestDeleteDeltaFileTimestamp()) {
            return dataBlock.getDeletedRowsMap();
        }
        CarbonDeleteFilesDataReader carbonDeleteDeltaFileReader = null;
        Object lockObject = deleteDeltaToLockObjectMap.get(deleteDeltaInfo);
        if (null == lockObject) {
            object = deleteDeltaToLockObjectMap;
            synchronized (object) {
                lockObject = deleteDeltaToLockObjectMap.get(deleteDeltaInfo);
                if (null == lockObject) {
                    lockObject = new Object();
                    deleteDeltaToLockObjectMap.put(deleteDeltaInfo, lockObject);
                }
            }
        }
        if (dataBlock.getDeleteDeltaTimestamp() < deleteDeltaInfo.getLatestDeleteDeltaFileTimestamp()) {
            object = lockObject;
            synchronized (object) {
                if (dataBlock.getDeleteDeltaTimestamp() < deleteDeltaInfo.getLatestDeleteDeltaFileTimestamp()) {
                    carbonDeleteDeltaFileReader = new CarbonDeleteFilesDataReader();
                    Map<String, DeleteDeltaVo> deletedRowsMap = carbonDeleteDeltaFileReader.getDeletedRowsDataVo(deleteDeltaInfo.getDeleteDeltaFile());
                    this.setDeletedDeltaBoToDataBlock(deleteDeltaInfo, deletedRowsMap, dataBlock);
                    deleteDeltaToLockObjectMap.remove(deleteDeltaInfo);
                    return deletedRowsMap;
                }
                return dataBlock.getDeletedRowsMap();
            }
        }
        return dataBlock.getDeletedRowsMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDeletedDeltaBoToDataBlock(DeleteDeltaInfo deleteDeltaInfo, Map<String, DeleteDeltaVo> deletedRecordsMap, AbstractIndex dataBlock) {
        if (dataBlock.getDeleteDeltaTimestamp() < deleteDeltaInfo.getLatestDeleteDeltaFileTimestamp()) {
            AbstractIndex abstractIndex = dataBlock;
            synchronized (abstractIndex) {
                if (dataBlock.getDeleteDeltaTimestamp() < deleteDeltaInfo.getLatestDeleteDeltaFileTimestamp()) {
                    dataBlock.setDeletedRowsMap(deletedRecordsMap);
                    dataBlock.setDeleteDeltaTimestamp(deleteDeltaInfo.getLatestDeleteDeltaFileTimestamp());
                }
            }
        }
    }

    public boolean hasNext() {
        if (this.dataBlockIterator != null && this.dataBlockIterator.hasNext()) {
            return true;
        }
        return this.blockExecutionInfos.size() > 0;
    }

    void updateDataBlockIterator() {
        if (this.dataBlockIterator == null || !this.dataBlockIterator.hasNext()) {
            this.dataBlockIterator = this.getDataBlockIterator();
            while (this.dataBlockIterator != null && !this.dataBlockIterator.hasNext()) {
                this.dataBlockIterator = this.getDataBlockIterator();
            }
        }
    }

    private DataBlockIterator getDataBlockIterator() {
        try {
            this.fileReader.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.blockExecutionInfos.size() > 0) {
            BlockExecutionInfo executionInfo = this.blockExecutionInfos.get(0);
            this.blockExecutionInfos.remove(executionInfo);
            return new DataBlockIterator(executionInfo, this.fileReader, this.batchSize, this.queryStatisticsModel, this.execService);
        }
        return null;
    }

    private void initQueryStatiticsModel() {
        this.queryStatisticsModel = new QueryStatisticsModel();
        this.queryStatisticsModel.setRecorder(this.recorder);
        QueryStatistic queryStatisticTotalBlocklet = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("The num of total blocklet", queryStatisticTotalBlocklet);
        this.queryStatisticsModel.getRecorder().recordStatistics(queryStatisticTotalBlocklet);
        QueryStatistic queryStatisticValidScanBlocklet = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("The num of valid scanned blocklet", queryStatisticValidScanBlocklet);
        this.queryStatisticsModel.getRecorder().recordStatistics(queryStatisticValidScanBlocklet);
        QueryStatistic scannedBlocklets = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("The num of blocklet scanned", scannedBlocklets);
        this.queryStatisticsModel.getRecorder().recordStatistics(scannedBlocklets);
        QueryStatistic totalNumberOfPages = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("The number of total page scanned", totalNumberOfPages);
        this.queryStatisticsModel.getRecorder().recordStatistics(totalNumberOfPages);
        QueryStatistic validPages = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("The number of valid page scanned", validPages);
        this.queryStatisticsModel.getRecorder().recordStatistics(validPages);
        QueryStatistic scannedPages = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("The number of page scanned", scannedPages);
        this.queryStatisticsModel.getRecorder().recordStatistics(scannedPages);
        QueryStatistic scanTime = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("Time taken to scan blocks", scanTime);
        this.queryStatisticsModel.getRecorder().recordStatistics(scanTime);
        QueryStatistic readTime = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("Time taken to read blocks", readTime);
        this.queryStatisticsModel.getRecorder().recordStatistics(readTime);
        QueryStatistic keyColumnFilingTime = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("key column filling time", keyColumnFilingTime);
        this.queryStatisticsModel.getRecorder().recordStatistics(keyColumnFilingTime);
        QueryStatistic measureFilingTime = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("measure filling time", measureFilingTime);
        this.queryStatisticsModel.getRecorder().recordStatistics(measureFilingTime);
        QueryStatistic pageUncompressTime = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("page uncompress time", pageUncompressTime);
        this.queryStatisticsModel.getRecorder().recordStatistics(pageUncompressTime);
        QueryStatistic resultPreparationTime = new QueryStatistic();
        this.queryStatisticsModel.getStatisticsTypeAndObjMap().put("result preparation time", resultPreparationTime);
        this.queryStatisticsModel.getRecorder().recordStatistics(resultPreparationTime);
    }

    public void processNextBatch(CarbonColumnarBatch columnarBatch) {
        throw new UnsupportedOperationException("Please use VectorDetailQueryResultIterator");
    }

    public void close() {
        if (null != this.dataBlockIterator) {
            this.dataBlockIterator.close();
        }
        try {
            this.fileReader.finish();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

