/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.iterator;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.result.RowBatch;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.core.scan.wrappers.ByteArrayWrapper;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.log4j.Logger;

public class ColumnDriftRawResultIterator
extends RawResultIterator {
    private int noDictCount;
    private int[] noDictMap;
    private boolean[] isColumnDrift;
    private int measureCount;
    private DataType[] measureDataTypes;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ColumnDriftRawResultIterator.class.getName());

    public ColumnDriftRawResultIterator(CarbonIterator<RowBatch> detailRawQueryResultIterator, SegmentProperties sourceSegProperties, SegmentProperties destinationSegProperties) {
        super(detailRawQueryResultIterator, sourceSegProperties, destinationSegProperties, false);
        this.initForColumnDrift();
        this.init();
    }

    private void initForColumnDrift() {
        ArrayList<CarbonDimension> noDictDims = new ArrayList<CarbonDimension>(this.destinationSegProperties.getDimensions().size());
        for (CarbonDimension dimension : this.destinationSegProperties.getDimensions()) {
            if (dimension.getNumberOfChild() != 0 || dimension.getDataType() == DataTypes.DATE) continue;
            noDictDims.add(dimension);
        }
        this.measureCount = this.destinationSegProperties.getMeasures().size();
        this.noDictCount = noDictDims.size();
        this.isColumnDrift = new boolean[this.noDictCount];
        this.noDictMap = new int[this.noDictCount];
        this.measureDataTypes = new DataType[this.noDictCount];
        List<CarbonMeasure> sourceMeasures = this.sourceSegProperties.getMeasures();
        int tableMeasureCount = sourceMeasures.size();
        block1: for (int i = 0; i < this.noDictCount; ++i) {
            for (int j = 0; j < tableMeasureCount; ++j) {
                if (!RestructureUtil.isColumnMatches(true, (CarbonColumn)noDictDims.get(i), sourceMeasures.get(j))) continue;
                this.isColumnDrift[i] = true;
                this.measureDataTypes[i] = sourceMeasures.get(j).getDataType();
                continue block1;
            }
        }
        int noDictIndex = 0;
        int measureIndex = this.measureCount + 1;
        for (int i = 0; i < this.noDictCount; ++i) {
            this.noDictMap[i] = this.isColumnDrift[i] ? measureIndex++ : noDictIndex++;
        }
    }

    @Override
    protected Object[] convertRow(Object[] rawRow) {
        super.convertRow(rawRow);
        ByteArrayWrapper dimObject = (ByteArrayWrapper)rawRow[0];
        byte[][] noDicts = dimObject.getNoDictionaryKeys();
        byte[][] newNoDicts = new byte[this.noDictCount][];
        for (int i = 0; i < this.noDictCount; ++i) {
            newNoDicts[i] = this.isColumnDrift[i] ? DataTypeUtil.getBytesDataDataTypeForNoDictionaryColumn(rawRow[this.noDictMap[i]], this.measureDataTypes[i]) : noDicts[this.noDictMap[i]];
        }
        ByteArrayWrapper newWrapper = new ByteArrayWrapper();
        newWrapper.setDictionaryKey(dimObject.getDictionaryKey());
        newWrapper.setNoDictionaryKeys(newNoDicts);
        newWrapper.setComplexTypesKeys(dimObject.getComplexTypesKeys());
        newWrapper.setImplicitColumnByteArray(dimObject.getImplicitColumnByteArray());
        Object[] finalRawRow = new Object[1 + this.measureCount];
        finalRawRow[0] = newWrapper;
        System.arraycopy(rawRow, 1, finalRawRow, 1, this.measureCount);
        return finalRawRow;
    }
}

