/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.iterator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.scan.result.RowBatch;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public class RawResultIterator
extends CarbonIterator<Object[]> {
    protected final SegmentProperties sourceSegProperties;
    protected final SegmentProperties destinationSegProperties;
    private CarbonIterator<RowBatch> detailRawQueryResultIterator;
    private boolean prefetchEnabled;
    private List<Object[]> currentBuffer;
    private List<Object[]> backupBuffer;
    private int currentIdxInBuffer;
    private ExecutorService executorService;
    private Future<Void> fetchFuture;
    private Object[] currentRawRow = null;
    private boolean isBackupFilled = false;
    private int batchSize;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)RawResultIterator.class.getName());

    public RawResultIterator(CarbonIterator<RowBatch> detailRawQueryResultIterator, SegmentProperties sourceSegProperties, SegmentProperties destinationSegProperties, boolean init) {
        this.detailRawQueryResultIterator = detailRawQueryResultIterator;
        this.sourceSegProperties = sourceSegProperties;
        this.destinationSegProperties = destinationSegProperties;
        this.executorService = Executors.newFixedThreadPool(1);
        this.batchSize = CarbonProperties.getQueryBatchSize();
        if (init) {
            this.init();
        }
    }

    protected void init() {
        this.prefetchEnabled = CarbonProperties.getInstance().getProperty("carbon.compaction.prefetch.enable", "false").equalsIgnoreCase("true");
        try {
            new RowsFetcher(false).call();
            if (this.prefetchEnabled) {
                this.fetchFuture = this.executorService.submit(new RowsFetcher(true));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurs while fetching records", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<Object[]> fetchRows() {
        ArrayList<Object[]> converted = new ArrayList<Object[]>();
        while (this.detailRawQueryResultIterator.hasNext()) {
            for (Object[] r : ((RowBatch)((Object)this.detailRawQueryResultIterator.next())).getRows()) {
                converted.add(this.convertRow(r));
            }
            if (converted.size() < this.batchSize) continue;
            break;
        }
        return converted;
    }

    private void fillDataFromPrefetch() {
        try {
            if (this.currentIdxInBuffer >= this.currentBuffer.size() && 0 != this.currentIdxInBuffer) {
                if (this.prefetchEnabled) {
                    if (!this.isBackupFilled) {
                        this.fetchFuture.get();
                    }
                    this.currentIdxInBuffer = 0;
                    this.currentBuffer.clear();
                    this.currentBuffer = this.backupBuffer;
                    this.isBackupFilled = false;
                    this.fetchFuture = this.executorService.submit(new RowsFetcher(true));
                } else {
                    this.currentIdxInBuffer = 0;
                    new RowsFetcher(false).call();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void popRow() {
        this.fillDataFromPrefetch();
        this.currentRawRow = this.currentBuffer.get(this.currentIdxInBuffer);
        ++this.currentIdxInBuffer;
    }

    private void pickRow() {
        this.fillDataFromPrefetch();
        this.currentRawRow = this.currentBuffer.get(this.currentIdxInBuffer);
    }

    public boolean hasNext() {
        this.fillDataFromPrefetch();
        return this.currentIdxInBuffer < this.currentBuffer.size();
    }

    public Object[] next() {
        try {
            this.popRow();
            return this.currentRawRow;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object[] fetchConverted() {
        this.pickRow();
        return this.currentRawRow;
    }

    protected Object[] convertRow(Object[] rawRow) {
        return rawRow;
    }

    public void close() {
        if (null != this.executorService) {
            this.executorService.shutdownNow();
        }
    }

    private final class RowsFetcher
    implements Callable<Void> {
        private boolean isBackupFilling;

        private RowsFetcher(boolean isBackupFilling) {
            this.isBackupFilling = isBackupFilling;
        }

        @Override
        public Void call() throws Exception {
            if (this.isBackupFilling) {
                RawResultIterator.this.backupBuffer = RawResultIterator.this.fetchRows();
                RawResultIterator.this.isBackupFilled = true;
            } else {
                RawResultIterator.this.currentBuffer = RawResultIterator.this.fetchRows();
            }
            return null;
        }
    }
}

