/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.vector;

import java.util.Arrays;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;

public class CarbonColumnarBatch {
    public CarbonColumnVector[] columnVectors;
    private int batchSize;
    private int actualSize;
    private int rowCounter;
    private boolean[] filteredRows;
    private int rowsFiltered;

    public CarbonColumnarBatch(CarbonColumnVector[] columnVectors, int batchSize, boolean[] filteredRows) {
        this.columnVectors = columnVectors;
        this.batchSize = batchSize;
        this.filteredRows = filteredRows;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getActualSize() {
        return this.actualSize;
    }

    public void setActualSize(int actualSize) {
        this.actualSize = actualSize;
    }

    public void reset() {
        this.actualSize = 0;
        this.rowCounter = 0;
        this.rowsFiltered = 0;
        if (this.filteredRows != null) {
            Arrays.fill(this.filteredRows, false);
        }
        for (int i = 0; i < this.columnVectors.length; ++i) {
            this.columnVectors[i].reset();
        }
    }

    public int getRowCounter() {
        return this.rowCounter;
    }

    public void setRowCounter(int rowCounter) {
        this.rowCounter = rowCounter;
    }

    public void markFiltered(int rowId) {
        if (!this.filteredRows[rowId]) {
            this.filteredRows[rowId] = true;
            ++this.rowsFiltered;
        }
        if (this.rowsFiltered == 1) {
            for (int i = 0; i < this.columnVectors.length; ++i) {
                this.columnVectors[i].setFilteredRowsExist(true);
            }
        }
    }
}

