/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.vector.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.scanner.LazyPageLoader;

public class CarbonColumnVectorImpl
implements CarbonColumnVector {
    private Object[] data;
    private int[] ints;
    private long[] longs;
    private BigDecimal[] decimals;
    private byte[] byteArr;
    private byte[][] bytes;
    private float[] floats;
    private double[] doubles;
    private short[] shorts;
    protected BitSet nullBytes;
    private DataType dataType;
    private DataType blockDataType;
    private int[] lengths;
    private int[] offsets;
    private int batchSize;
    protected boolean anyNullsSet;
    private CarbonDictionary carbonDictionary;
    private CarbonColumnVector dictionaryVector;
    private LazyPageLoader lazyPage;
    private boolean loaded;

    public CarbonColumnVectorImpl(int batchSize, DataType dataType) {
        this.batchSize = batchSize;
        this.nullBytes = new BitSet(batchSize);
        this.dataType = dataType;
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            this.byteArr = new byte[batchSize];
        } else if (dataType == DataTypes.SHORT) {
            this.shorts = new short[batchSize];
        } else if (dataType == DataTypes.INT || dataType == DataTypes.DATE) {
            this.ints = new int[batchSize];
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            this.longs = new long[batchSize];
        } else if (dataType == DataTypes.FLOAT) {
            this.floats = new float[batchSize];
        } else if (dataType == DataTypes.DOUBLE) {
            this.doubles = new double[batchSize];
        } else if (dataType instanceof DecimalType) {
            this.decimals = new BigDecimal[batchSize];
        } else if (dataType == DataTypes.STRING || dataType == DataTypes.BYTE_ARRAY || dataType == DataTypes.VARCHAR || dataType == DataTypes.BINARY) {
            this.dictionaryVector = new CarbonColumnVectorImpl(batchSize, DataTypes.INT);
            this.bytes = new byte[batchSize][];
        } else {
            this.data = new Object[batchSize];
        }
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        this.byteArr[rowId] = (byte)(value ? 1 : 0);
    }

    @Override
    public void putFloat(int rowId, float value) {
        this.floats[rowId] = value;
    }

    @Override
    public void putShort(int rowId, short value) {
        this.shorts[rowId] = value;
    }

    @Override
    public void putShorts(int rowId, int count, short value) {
        for (int i = 0; i < count; ++i) {
            this.shorts[i + rowId] = value;
        }
    }

    @Override
    public void putInt(int rowId, int value) {
        this.ints[rowId] = value;
    }

    @Override
    public void putInts(int rowId, int count, int value) {
        for (int i = 0; i < count; ++i) {
            this.ints[i + rowId] = value;
        }
    }

    @Override
    public void putLong(int rowId, long value) {
        this.longs[rowId] = value;
    }

    @Override
    public void putLongs(int rowId, int count, long value) {
        for (int i = 0; i < count; ++i) {
            this.longs[i + rowId] = value;
        }
    }

    @Override
    public void putDecimal(int rowId, BigDecimal value, int precision) {
        this.decimals[rowId] = value;
    }

    @Override
    public void putDecimals(int rowId, int count, BigDecimal value, int precision) {
        for (int i = 0; i < count; ++i) {
            this.decimals[i + rowId] = value;
        }
    }

    @Override
    public void putDouble(int rowId, double value) {
        this.doubles[rowId] = value;
    }

    @Override
    public void putDoubles(int rowId, int count, double value) {
        for (int i = 0; i < count; ++i) {
            this.doubles[i + rowId] = value;
        }
    }

    @Override
    public void putByteArray(int rowId, byte[] value) {
        this.bytes[rowId] = value;
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.byteArr[rowId] = value;
    }

    @Override
    public void putByteArray(int rowId, int count, byte[] value) {
        for (int i = 0; i < count; ++i) {
            this.bytes[i + rowId] = value;
        }
    }

    @Override
    public void putByteArray(int rowId, int offset, int length, byte[] value) {
        this.bytes[rowId] = new byte[length];
        System.arraycopy(value, offset, this.bytes[rowId], 0, length);
    }

    @Override
    public void putNull(int rowId) {
        this.nullBytes.set(rowId);
        this.anyNullsSet = true;
    }

    @Override
    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.nullBytes.set(rowId + i);
        }
        this.anyNullsSet = true;
    }

    @Override
    public void putNotNull(int rowId) {
    }

    @Override
    public void putNotNull(int rowId, int count) {
    }

    public boolean isNullAt(int rowId) {
        return this.nullBytes.get(rowId);
    }

    @Override
    public boolean isNull(int rowId) {
        return this.nullBytes.get(rowId);
    }

    @Override
    public void putObject(int rowId, Object obj) {
        this.data[rowId] = obj;
    }

    @Override
    public Object getData(int rowId) {
        if (!this.loaded) {
            this.loadPage();
        }
        if (this.nullBytes.get(rowId)) {
            return null;
        }
        if (this.dataType == DataTypes.BOOLEAN || this.dataType == DataTypes.BYTE) {
            return this.byteArr[rowId];
        }
        if (this.dataType == DataTypes.SHORT) {
            return this.shorts[rowId];
        }
        if (this.dataType == DataTypes.INT || this.dataType == DataTypes.DATE) {
            return this.ints[rowId];
        }
        if (this.dataType == DataTypes.LONG || this.dataType == DataTypes.TIMESTAMP) {
            return this.longs[rowId];
        }
        if (this.dataType == DataTypes.FLOAT) {
            return Float.valueOf(this.floats[rowId]);
        }
        if (this.dataType == DataTypes.DOUBLE) {
            return this.doubles[rowId];
        }
        if (this.dataType instanceof DecimalType) {
            return this.decimals[rowId];
        }
        if (this.dataType == DataTypes.STRING || this.dataType == DataTypes.BYTE_ARRAY || this.dataType == DataTypes.VARCHAR || this.dataType == DataTypes.BINARY) {
            if (null != this.carbonDictionary) {
                int dictKey = (Integer)this.dictionaryVector.getData(rowId);
                return this.carbonDictionary.getDictionaryValue(dictKey);
            }
            if (this.byteArr != null) {
                byte[] bytes = new byte[this.lengths[rowId]];
                System.arraycopy(this.byteArr, this.offsets[rowId], bytes, 0, bytes.length);
                return bytes;
            }
            return this.bytes[rowId];
        }
        return this.data[rowId];
    }

    public Object getDataArray() {
        if (!this.loaded) {
            this.loadPage();
        }
        if (this.dataType == DataTypes.BOOLEAN || this.dataType == DataTypes.BYTE) {
            return this.byteArr;
        }
        if (this.dataType == DataTypes.SHORT) {
            return this.shorts;
        }
        if (this.dataType == DataTypes.INT) {
            return this.ints;
        }
        if (this.dataType == DataTypes.LONG || this.dataType == DataTypes.TIMESTAMP) {
            return this.longs;
        }
        if (this.dataType == DataTypes.FLOAT) {
            return this.floats;
        }
        if (this.dataType == DataTypes.DOUBLE) {
            return this.doubles;
        }
        if (this.dataType instanceof DecimalType) {
            return this.decimals;
        }
        if (this.dataType == DataTypes.STRING || this.dataType == DataTypes.BYTE_ARRAY || this.dataType == DataTypes.VARCHAR) {
            if (null != this.carbonDictionary) {
                return this.ints;
            }
            return this.bytes;
        }
        return this.data;
    }

    @Override
    public void reset() {
        this.nullBytes.clear();
        if (this.dataType == DataTypes.BOOLEAN || this.dataType == DataTypes.BYTE) {
            Arrays.fill(this.byteArr, (byte)0);
        } else if (this.dataType == DataTypes.SHORT) {
            Arrays.fill(this.shorts, (short)0);
        } else if (this.dataType == DataTypes.INT || this.dataType == DataTypes.DATE) {
            Arrays.fill(this.ints, 0);
        } else if (this.dataType == DataTypes.LONG || this.dataType == DataTypes.TIMESTAMP) {
            Arrays.fill(this.longs, 0L);
        } else if (this.dataType == DataTypes.FLOAT) {
            Arrays.fill(this.floats, 0.0f);
        } else if (this.dataType == DataTypes.DOUBLE) {
            Arrays.fill(this.doubles, 0.0);
        } else if (this.dataType instanceof DecimalType) {
            Arrays.fill(this.decimals, null);
        } else if (this.dataType == DataTypes.STRING || this.dataType == DataTypes.BYTE_ARRAY || this.dataType == DataTypes.VARCHAR || this.dataType == DataTypes.BINARY) {
            Arrays.fill((Object[])this.bytes, null);
            this.dictionaryVector.reset();
        } else {
            Arrays.fill(this.data, null);
        }
        this.loaded = false;
    }

    @Override
    public DataType getType() {
        return this.dataType;
    }

    @Override
    public DataType getBlockDataType() {
        return this.blockDataType;
    }

    @Override
    public void setBlockDataType(DataType blockDataType) {
        this.blockDataType = blockDataType;
    }

    @Override
    public void setFilteredRowsExist(boolean filteredRowsExist) {
    }

    @Override
    public void setDictionary(CarbonDictionary dictionary) {
        this.carbonDictionary = dictionary;
    }

    @Override
    public boolean hasDictionary() {
        return null != this.carbonDictionary;
    }

    @Override
    public CarbonColumnVector getDictionaryVector() {
        return this.dictionaryVector;
    }

    public final boolean anyNullsSet() {
        return this.anyNullsSet;
    }

    @Override
    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.floats[rowId++] = src[i];
        }
    }

    @Override
    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.shorts[rowId++] = src[i];
        }
    }

    @Override
    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.ints[rowId++] = src[i];
        }
    }

    @Override
    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.longs[rowId++] = src[i];
        }
    }

    @Override
    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.doubles[rowId++] = src[i];
        }
    }

    @Override
    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.byteArr[rowId++] = src[i];
        }
    }

    @Override
    public void setLazyPage(LazyPageLoader lazyPage) {
        this.lazyPage = lazyPage;
    }

    public void loadPage() {
        if (this.lazyPage != null) {
            this.lazyPage.loadPage();
        }
        this.loaded = true;
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        if (this.offsets == null) {
            this.offsets = new int[this.batchSize];
            this.lengths = new int[this.batchSize];
        }
        this.offsets[rowId] = offset;
        this.lengths[rowId] = length;
    }

    @Override
    public void putAllByteArray(byte[] data, int offset, int length) {
        this.byteArr = data;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public int[] getOffsets() {
        return this.offsets;
    }
}

