/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.vector.impl.directread;

import java.math.BigDecimal;
import java.util.BitSet;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.impl.directread.AbstractCarbonColumnarVector;

class ColumnarVectorWrapperDirectWithDeleteDelta
extends AbstractCarbonColumnarVector {
    private BitSet deletedRows;
    private BitSet nullBits;
    private int counter;

    public ColumnarVectorWrapperDirectWithDeleteDelta(CarbonColumnVector vectorWrapper, BitSet deletedRows, BitSet nullBits) {
        super(vectorWrapper);
        this.deletedRows = deletedRows;
        this.nullBits = nullBits;
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putBoolean(this.counter++, value);
            }
        }
    }

    @Override
    public void putFloat(int rowId, float value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putFloat(this.counter++, value);
            }
        }
    }

    @Override
    public void putShort(int rowId, short value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putShort(this.counter++, value);
            }
        }
    }

    @Override
    public void putInt(int rowId, int value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putInt(this.counter++, value);
            }
        }
    }

    @Override
    public void putLong(int rowId, long value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putLong(this.counter++, value);
            }
        }
    }

    @Override
    public void putDecimal(int rowId, BigDecimal value, int precision) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putDecimal(this.counter++, value, precision);
            }
        }
    }

    @Override
    public void putDouble(int rowId, double value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putDouble(this.counter++, value);
            }
        }
    }

    @Override
    public void putByteArray(int rowId, byte[] value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putByteArray(this.counter++, value);
            }
        }
    }

    @Override
    public void putByteArray(int rowId, int offset, int length, byte[] value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putByteArray(this.counter++, offset, length, value);
            }
        }
    }

    @Override
    public void putByte(int rowId, byte value) {
        if (!this.deletedRows.get(rowId)) {
            if (this.nullBits.get(rowId)) {
                this.columnVector.putNull(this.counter++);
            } else {
                this.columnVector.putByte(this.counter++, value);
            }
        }
    }

    @Override
    public void putNull(int rowId) {
        if (!this.deletedRows.get(rowId)) {
            this.columnVector.putNull(this.counter++);
        }
    }

    @Override
    public void putNotNull(int rowId) {
        if (!this.deletedRows.get(rowId)) {
            ++this.counter;
        }
    }

    @Override
    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            if (this.deletedRows.get(rowId++)) continue;
            this.columnVector.putFloat(this.counter++, src[i]);
        }
    }

    @Override
    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            if (this.deletedRows.get(rowId++)) continue;
            this.columnVector.putShort(this.counter++, src[i]);
        }
    }

    @Override
    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            if (this.deletedRows.get(rowId++)) continue;
            this.columnVector.putInt(this.counter++, src[i]);
        }
    }

    @Override
    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            if (this.deletedRows.get(rowId++)) continue;
            this.columnVector.putLong(this.counter++, src[i]);
        }
    }

    @Override
    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            if (this.deletedRows.get(rowId++)) continue;
            this.columnVector.putDouble(this.counter++, src[i]);
        }
    }

    @Override
    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            if (this.deletedRows.get(rowId++)) continue;
            this.columnVector.putByte(this.counter++, src[i]);
        }
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        if (!this.deletedRows.get(rowId)) {
            this.columnVector.putArray(this.counter++, offset, length);
        }
    }
}

