/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.vector.impl.directread;

import java.math.BigDecimal;
import java.util.BitSet;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectWithInvertedIndex;

public class ColumnarVectorWrapperDirectWithDeleteDeltaAndInvertedIndex
extends ColumnarVectorWrapperDirectWithInvertedIndex {
    private BitSet deletedRows;
    private CarbonColumnVector carbonColumnVector;
    private int precision;
    private BitSet nullBits;

    public ColumnarVectorWrapperDirectWithDeleteDeltaAndInvertedIndex(CarbonColumnVector vectorWrapper, BitSet deletedRows, int[] invertedIndex, BitSet nullBits, boolean isnullBitsExists, boolean isDictVector) {
        super(new CarbonColumnVectorImpl(invertedIndex.length, isDictVector ? DataTypes.INT : vectorWrapper.getType()), invertedIndex, isnullBitsExists);
        this.deletedRows = deletedRows;
        this.carbonColumnVector = vectorWrapper;
        this.nullBits = nullBits;
    }

    @Override
    public void putDecimal(int rowId, BigDecimal value, int precision) {
        this.precision = precision;
        this.carbonColumnVector.putDecimal(this.invertedIndex[rowId], value, precision);
    }

    @Override
    public void putNull(int rowId) {
        if (this.isnullBitsExists) {
            this.nullBits.set(rowId);
        } else {
            this.nullBits.set(this.invertedIndex[rowId]);
        }
    }

    @Override
    public void putAllByteArray(byte[] data, int offset, int length) {
        this.carbonColumnVector.putAllByteArray(data, offset, length);
    }

    @Override
    public void convert() {
        block20: {
            int counter;
            int length;
            DataType dataType;
            CarbonColumnVectorImpl localVector;
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        if (!(this.columnVector instanceof CarbonColumnVectorImpl)) break block20;
                                        localVector = (CarbonColumnVectorImpl)this.columnVector;
                                        dataType = this.columnVector.getType();
                                        length = this.invertedIndex.length;
                                        counter = 0;
                                        if (dataType != DataTypes.BOOLEAN && dataType != DataTypes.BYTE) break block21;
                                        byte[] dataArray = (byte[])localVector.getDataArray();
                                        for (int i = 0; i < length; ++i) {
                                            if (this.deletedRows.get(i)) continue;
                                            if (this.nullBits.get(i)) {
                                                this.carbonColumnVector.putNull(counter++);
                                                continue;
                                            }
                                            this.carbonColumnVector.putByte(counter++, dataArray[i]);
                                        }
                                        break block20;
                                    }
                                    if (dataType != DataTypes.SHORT) break block22;
                                    short[] dataArray = (short[])localVector.getDataArray();
                                    for (int i = 0; i < length; ++i) {
                                        if (this.deletedRows.get(i)) continue;
                                        if (this.nullBits.get(i)) {
                                            this.carbonColumnVector.putNull(counter++);
                                            continue;
                                        }
                                        this.carbonColumnVector.putShort(counter++, dataArray[i]);
                                    }
                                    break block20;
                                }
                                if (dataType != DataTypes.INT) break block23;
                                int[] dataArray = (int[])localVector.getDataArray();
                                for (int i = 0; i < length; ++i) {
                                    if (this.deletedRows.get(i)) continue;
                                    if (this.nullBits.get(i)) {
                                        this.carbonColumnVector.putNull(counter++);
                                        continue;
                                    }
                                    this.carbonColumnVector.putInt(counter++, dataArray[i]);
                                }
                                break block20;
                            }
                            if (dataType != DataTypes.LONG && dataType != DataTypes.TIMESTAMP) break block24;
                            long[] dataArray = (long[])localVector.getDataArray();
                            for (int i = 0; i < length; ++i) {
                                if (this.deletedRows.get(i)) continue;
                                if (this.nullBits.get(i)) {
                                    this.carbonColumnVector.putNull(counter++);
                                    continue;
                                }
                                this.carbonColumnVector.putLong(counter++, dataArray[i]);
                            }
                            break block20;
                        }
                        if (dataType != DataTypes.FLOAT) break block25;
                        float[] dataArray = (float[])localVector.getDataArray();
                        for (int i = 0; i < length; ++i) {
                            if (this.deletedRows.get(i)) continue;
                            if (this.nullBits.get(i)) {
                                this.carbonColumnVector.putNull(counter++);
                                continue;
                            }
                            this.carbonColumnVector.putFloat(counter++, dataArray[i]);
                        }
                        break block20;
                    }
                    if (dataType != DataTypes.DOUBLE) break block26;
                    double[] dataArray = (double[])localVector.getDataArray();
                    for (int i = 0; i < length; ++i) {
                        if (this.deletedRows.get(i)) continue;
                        if (this.nullBits.get(i)) {
                            this.carbonColumnVector.putNull(counter++);
                            continue;
                        }
                        this.carbonColumnVector.putDouble(counter++, dataArray[i]);
                    }
                    break block20;
                }
                if (!(dataType instanceof DecimalType)) break block27;
                BigDecimal[] dataArray = (BigDecimal[])localVector.getDataArray();
                for (int i = 0; i < length; ++i) {
                    if (this.deletedRows.get(i)) continue;
                    if (this.nullBits.get(i)) {
                        this.carbonColumnVector.putNull(counter++);
                        continue;
                    }
                    this.carbonColumnVector.putDecimal(counter++, dataArray[i], this.precision);
                }
                break block20;
            }
            if (dataType != DataTypes.STRING && dataType != DataTypes.BYTE_ARRAY) break block20;
            int[] offsets = localVector.getOffsets();
            int[] lengths = localVector.getLengths();
            if (offsets != null && lengths != null) {
                for (int i = 0; i < length; ++i) {
                    if (this.deletedRows.get(i)) continue;
                    if (this.nullBits.get(i)) {
                        this.carbonColumnVector.putNull(counter++);
                        continue;
                    }
                    this.carbonColumnVector.putArray(counter++, offsets[i], lengths[i]);
                }
            } else {
                byte[][] dataArray = (byte[][])localVector.getDataArray();
                for (int i = 0; i < length; ++i) {
                    if (this.deletedRows.get(i)) continue;
                    if (this.nullBits.get(i)) {
                        this.carbonColumnVector.putNull(counter++);
                        continue;
                    }
                    this.carbonColumnVector.putByteArray(counter++, dataArray[i]);
                }
            }
        }
    }
}

