/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.result.vector.impl.directread;

import java.math.BigDecimal;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.impl.directread.AbstractCarbonColumnarVector;

public class ColumnarVectorWrapperDirectWithInvertedIndex
extends AbstractCarbonColumnarVector {
    protected int[] invertedIndex;
    protected boolean isnullBitsExists;

    public ColumnarVectorWrapperDirectWithInvertedIndex(CarbonColumnVector columnVector, int[] invertedIndex, boolean isnullBitsExists) {
        super(columnVector);
        this.invertedIndex = invertedIndex;
        this.isnullBitsExists = isnullBitsExists;
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        this.columnVector.putBoolean(this.invertedIndex[rowId], value);
    }

    @Override
    public void putFloat(int rowId, float value) {
        this.columnVector.putFloat(this.invertedIndex[rowId], value);
    }

    @Override
    public void putShort(int rowId, short value) {
        this.columnVector.putShort(this.invertedIndex[rowId], value);
    }

    @Override
    public void putInt(int rowId, int value) {
        this.columnVector.putInt(this.invertedIndex[rowId], value);
    }

    @Override
    public void putLong(int rowId, long value) {
        this.columnVector.putLong(this.invertedIndex[rowId], value);
    }

    @Override
    public void putDecimal(int rowId, BigDecimal value, int precision) {
        this.columnVector.putDecimal(this.invertedIndex[rowId], value, precision);
    }

    @Override
    public void putDouble(int rowId, double value) {
        this.columnVector.putDouble(this.invertedIndex[rowId], value);
    }

    @Override
    public void putByteArray(int rowId, byte[] value) {
        this.columnVector.putByteArray(this.invertedIndex[rowId], value);
    }

    @Override
    public void putByteArray(int rowId, int offset, int length, byte[] value) {
        this.columnVector.putByteArray(this.invertedIndex[rowId], offset, length, value);
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.columnVector.putByte(this.invertedIndex[rowId], value);
    }

    @Override
    public void putNull(int rowId) {
        if (this.isnullBitsExists) {
            this.columnVector.putNull(rowId);
        } else {
            this.columnVector.putNull(this.invertedIndex[rowId]);
        }
    }

    @Override
    public void putNotNull(int rowId) {
    }

    @Override
    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.columnVector.putFloat(this.invertedIndex[rowId++], src[i]);
        }
    }

    @Override
    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.columnVector.putShort(this.invertedIndex[rowId++], src[i]);
        }
    }

    @Override
    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.columnVector.putInt(this.invertedIndex[rowId++], src[i]);
        }
    }

    @Override
    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.columnVector.putLong(this.invertedIndex[rowId++], src[i]);
        }
    }

    @Override
    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.columnVector.putDouble(this.invertedIndex[rowId++], src[i]);
        }
    }

    @Override
    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        for (int i = srcIndex; i < count; ++i) {
            this.columnVector.putByte(this.invertedIndex[rowId++], src[i]);
        }
    }

    @Override
    public DataType getBlockDataType() {
        return this.columnVector.getBlockDataType();
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        this.columnVector.putArray(this.invertedIndex[rowId], offset, length);
    }
}

