/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.scanner;

import java.io.IOException;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.chunk.AbstractRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsModel;

public class LazyBlockletLoader {
    private RawBlockletColumnChunks rawBlockletColumnChunks;
    private BlockExecutionInfo blockExecutionInfo;
    private LazyChunkWrapper[] dimLazyWrapperChunks;
    private LazyChunkWrapper[] msrLazyWrapperChunks;
    private boolean isLoaded;
    private QueryStatisticsModel queryStatisticsModel;

    public LazyBlockletLoader(RawBlockletColumnChunks rawBlockletColumnChunks, BlockExecutionInfo blockExecutionInfo, DimensionRawColumnChunk[] dimensionRawColumnChunks, MeasureRawColumnChunk[] measureRawColumnChunks, QueryStatisticsModel queryStatisticsModel) {
        int i;
        this.rawBlockletColumnChunks = rawBlockletColumnChunks;
        this.blockExecutionInfo = blockExecutionInfo;
        this.dimLazyWrapperChunks = new LazyChunkWrapper[dimensionRawColumnChunks.length];
        this.msrLazyWrapperChunks = new LazyChunkWrapper[measureRawColumnChunks.length];
        for (i = 0; i < dimensionRawColumnChunks.length; ++i) {
            this.dimLazyWrapperChunks[i] = new LazyChunkWrapper(dimensionRawColumnChunks[i]);
        }
        for (i = 0; i < measureRawColumnChunks.length; ++i) {
            this.msrLazyWrapperChunks[i] = new LazyChunkWrapper(measureRawColumnChunks[i]);
        }
        this.queryStatisticsModel = queryStatisticsModel;
    }

    public void load() throws IOException {
        if (!this.isLoaded) {
            this.readBlocklet();
        }
    }

    public LazyChunkWrapper getLazyChunkWrapper(int index, boolean isMeasure) {
        if (isMeasure) {
            return this.msrLazyWrapperChunks[index];
        }
        return this.dimLazyWrapperChunks[index];
    }

    private synchronized void readBlocklet() throws IOException {
        int[] projectionListMeasureIndexes;
        int[] projectionListDimensionIndexes;
        FileReader fileReader = this.rawBlockletColumnChunks.getFileReader();
        long readTime = System.currentTimeMillis();
        int[][] allSelectedDimensionColumnIndexRange = this.blockExecutionInfo.getAllSelectedDimensionColumnIndexRange();
        DimensionRawColumnChunk[] projectionListDimensionChunk = this.rawBlockletColumnChunks.getDataBlock().readDimensionChunks(fileReader, allSelectedDimensionColumnIndexRange);
        for (int[] columnIndexRange : allSelectedDimensionColumnIndexRange) {
            for (int i = columnIndexRange[0]; i < columnIndexRange[1] + 1; ++i) {
                this.dimLazyWrapperChunks[i].rawColumnChunk = projectionListDimensionChunk[i];
            }
        }
        for (int projectionListDimensionIndex : projectionListDimensionIndexes = this.blockExecutionInfo.getProjectionListDimensionIndexes()) {
            if (null != this.dimLazyWrapperChunks[projectionListDimensionIndex].rawColumnChunk) continue;
            this.dimLazyWrapperChunks[projectionListDimensionIndex].rawColumnChunk = this.rawBlockletColumnChunks.getDataBlock().readDimensionChunk(fileReader, projectionListDimensionIndex);
        }
        int[][] allSelectedMeasureColumnIndexRange = this.blockExecutionInfo.getAllSelectedMeasureIndexRange();
        MeasureRawColumnChunk[] projectionListMeasureChunk = this.rawBlockletColumnChunks.getDataBlock().readMeasureChunks(fileReader, allSelectedMeasureColumnIndexRange);
        for (int[] columnIndexRange : allSelectedMeasureColumnIndexRange) {
            for (int i = columnIndexRange[0]; i < columnIndexRange[1] + 1; ++i) {
                this.msrLazyWrapperChunks[i].rawColumnChunk = projectionListMeasureChunk[i];
            }
        }
        for (int projectionListMeasureIndex : projectionListMeasureIndexes = this.blockExecutionInfo.getProjectionListMeasureIndexes()) {
            if (null != this.msrLazyWrapperChunks[projectionListMeasureIndex].rawColumnChunk) continue;
            this.msrLazyWrapperChunks[projectionListMeasureIndex].rawColumnChunk = this.rawBlockletColumnChunks.getDataBlock().readMeasureChunk(fileReader, projectionListMeasureIndex);
        }
        readTime = System.currentTimeMillis() - readTime;
        QueryStatistic time = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to read blocks");
        time.addCountStatistic("Time taken to read blocks", time.getCount() + readTime);
        this.isLoaded = true;
    }

    public QueryStatisticsModel getQueryStatisticsModel() {
        return this.queryStatisticsModel;
    }

    public static class LazyChunkWrapper {
        private AbstractRawColumnChunk rawColumnChunk;

        public LazyChunkWrapper(AbstractRawColumnChunk rawColumnChunk) {
            this.rawColumnChunk = rawColumnChunk;
        }

        public AbstractRawColumnChunk getRawColumnChunk() {
            return this.rawColumnChunk;
        }

        public void setRawColumnChunk(AbstractRawColumnChunk rawColumnChunk) {
            this.rawColumnChunk = rawColumnChunk;
        }
    }
}

