/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.scanner;

import java.io.IOException;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.scanner.LazyBlockletLoader;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsModel;

public class LazyPageLoader {
    private LazyBlockletLoader lazyBlockletLoader;
    private LazyBlockletLoader.LazyChunkWrapper lazyChunkWrapper;
    private boolean isMeasure;
    private int pageNumber;
    private ColumnVectorInfo vectorInfo;
    private QueryStatisticsModel queryStatisticsModel;
    private ReusableDataBuffer reusableDataBuffer;

    public LazyPageLoader(LazyBlockletLoader lazyBlockletLoader, int index, boolean isMeasure, int pageNumber, ColumnVectorInfo vectorInfo, ReusableDataBuffer reusableDataBuffer) {
        this.lazyBlockletLoader = lazyBlockletLoader;
        this.lazyChunkWrapper = lazyBlockletLoader.getLazyChunkWrapper(index, isMeasure);
        this.isMeasure = isMeasure;
        this.pageNumber = pageNumber;
        this.vectorInfo = vectorInfo;
        this.queryStatisticsModel = lazyBlockletLoader.getQueryStatisticsModel();
        this.reusableDataBuffer = reusableDataBuffer;
    }

    public void loadPage() {
        if (this.lazyChunkWrapper.getRawColumnChunk() == null) {
            try {
                this.lazyBlockletLoader.load();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        long startTime = System.currentTimeMillis();
        if (this.isMeasure) {
            ((MeasureRawColumnChunk)this.lazyChunkWrapper.getRawColumnChunk()).convertToColumnPageAndFillVector(this.pageNumber, this.vectorInfo, this.reusableDataBuffer);
        } else {
            ((DimensionRawColumnChunk)this.lazyChunkWrapper.getRawColumnChunk()).convertToDimColDataChunkAndFillVector(this.pageNumber, this.vectorInfo, this.reusableDataBuffer);
        }
        if (this.queryStatisticsModel.isEnabled()) {
            QueryStatistic pageUncompressTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("page uncompress time");
            pageUncompressTime.addCountStatistic("page uncompress time", pageUncompressTime.getCount() + (System.currentTimeMillis() - startTime));
        }
    }
}

