/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.scanner.impl;

import java.io.IOException;
import java.util.BitSet;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.ImplicitColumnFilterExecutor;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.result.impl.FilterQueryScannedResult;
import org.apache.carbondata.core.scan.scanner.LazyBlockletLoader;
import org.apache.carbondata.core.scan.scanner.impl.BlockletFullScanner;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsModel;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;

public class BlockletFilterScanner
extends BlockletFullScanner {
    private FilterExecuter filterExecuter;
    private boolean isMinMaxEnabled;
    private QueryStatisticsModel queryStatisticsModel;
    private boolean useBitSetPipeLine;

    public BlockletFilterScanner(BlockExecutionInfo blockExecutionInfo, QueryStatisticsModel queryStatisticsModel) {
        super(blockExecutionInfo, queryStatisticsModel);
        String minMaxEnableValue = CarbonProperties.getInstance().getProperty("carbon.enableMinMax", "true");
        if (null != minMaxEnableValue) {
            this.isMinMaxEnabled = Boolean.parseBoolean(minMaxEnableValue);
        }
        this.filterExecuter = blockExecutionInfo.getFilterExecuterTree();
        this.queryStatisticsModel = queryStatisticsModel;
        String useBitSetPipeLine = CarbonProperties.getInstance().getProperty("carbon.use.bitset.pipe.line", "true");
        if (null != useBitSetPipeLine) {
            this.useBitSetPipeLine = Boolean.parseBoolean(useBitSetPipeLine);
        }
    }

    @Override
    public BlockletScannedResult scanBlocklet(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException, FilterUnsupportedException {
        if (this.blockExecutionInfo.isDirectVectorFill()) {
            return this.executeFilterForPages(rawBlockletColumnChunks);
        }
        return this.executeFilter(rawBlockletColumnChunks);
    }

    @Override
    public boolean isScanRequired(DataRefNode dataBlock) {
        QueryStatistic totalPagesScanned = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of total page scanned");
        totalPagesScanned.addCountStatistic("The number of total page scanned", totalPagesScanned.getCount() + (long)dataBlock.numberOfPages());
        QueryStatistic totalBlockletStatistic = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of total blocklet");
        totalBlockletStatistic.addCountStatistic("The num of total blocklet", totalBlockletStatistic.getCount() + 1L);
        if (this.isMinMaxEnabled) {
            if (null == dataBlock.getColumnsMaxValue() || null == dataBlock.getColumnsMinValue()) {
                return true;
            }
            BitSet bitSet = null;
            if (this.filterExecuter instanceof ImplicitColumnFilterExecutor) {
                String blockletId = this.blockExecutionInfo.getBlockIdString() + "/" + dataBlock.blockletIndex();
                bitSet = ((ImplicitColumnFilterExecutor)((Object)this.filterExecuter)).isFilterValuesPresentInBlockOrBlocklet(dataBlock.getColumnsMaxValue(), dataBlock.getColumnsMinValue(), blockletId, dataBlock.minMaxFlagArray());
            } else {
                bitSet = this.filterExecuter.isScanRequired(dataBlock.getColumnsMaxValue(), dataBlock.getColumnsMinValue(), dataBlock.minMaxFlagArray());
            }
            return !bitSet.isEmpty();
        }
        return true;
    }

    @Override
    public void readBlocklet(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        long startTime = System.currentTimeMillis();
        this.filterExecuter.readColumnChunks(rawBlockletColumnChunks);
        QueryStatistic readTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to read blocks");
        readTime.addCountStatistic("Time taken to read blocks", readTime.getCount() + (System.currentTimeMillis() - startTime));
    }

    private BlockletScannedResult executeFilter(RawBlockletColumnChunks rawBlockletColumnChunks) throws FilterUnsupportedException, IOException {
        long startTime = System.currentTimeMillis();
        BitSetGroup fgBitSetGroup = rawBlockletColumnChunks.getDataBlock().getIndexedData();
        rawBlockletColumnChunks.setBitSetGroup(fgBitSetGroup);
        BitSetGroup bitSetGroup = this.filterExecuter.applyFilter(rawBlockletColumnChunks, this.useBitSetPipeLine);
        if (bitSetGroup.isEmpty()) {
            CarbonUtil.freeMemory(rawBlockletColumnChunks.getDimensionRawColumnChunks(), rawBlockletColumnChunks.getMeasureRawColumnChunks());
            QueryStatistic scanTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to scan blocks");
            scanTime.addCountStatistic("Time taken to scan blocks", scanTime.getCount() + (System.currentTimeMillis() - startTime));
            QueryStatistic scannedBlocklets = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of blocklet scanned");
            scannedBlocklets.addCountStatistic("The num of blocklet scanned", scannedBlocklets.getCount() + 1L);
            QueryStatistic scannedPages = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of page scanned");
            scannedPages.addCountStatistic("The number of page scanned", scannedPages.getCount() + (long)bitSetGroup.getScannedPages());
            return this.createEmptyResult();
        }
        FilterQueryScannedResult scannedResult = new FilterQueryScannedResult(this.blockExecutionInfo, this.queryStatisticsModel);
        scannedResult.setBlockletId(this.blockExecutionInfo.getBlockIdString(), String.valueOf(rawBlockletColumnChunks.getDataBlock().blockletIndex()));
        QueryStatistic validScannedBlockletStatistic = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of valid scanned blocklet");
        validScannedBlockletStatistic.addCountStatistic("The num of valid scanned blocklet", validScannedBlockletStatistic.getCount() + 1L);
        QueryStatistic validPages = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of valid page scanned");
        validPages.addCountStatistic("The number of valid page scanned", validPages.getCount() + (long)bitSetGroup.getValidPages());
        QueryStatistic scannedBlocklets = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of blocklet scanned");
        scannedBlocklets.addCountStatistic("The num of blocklet scanned", scannedBlocklets.getCount() + 1L);
        QueryStatistic scannedPages = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of page scanned");
        scannedPages.addCountStatistic("The number of page scanned", scannedPages.getCount() + (long)bitSetGroup.getScannedPages());
        int[] pageFilteredRowCount = new int[bitSetGroup.getNumberOfPages()];
        int[][] pageFilteredRowId = new int[bitSetGroup.getNumberOfPages()][];
        int numPages = pageFilteredRowId.length;
        for (int pageId = 0; pageId < numPages; ++pageId) {
            BitSet bitSet = bitSetGroup.getBitSet(pageId);
            if (bitSet == null || bitSet.isEmpty()) continue;
            int[] matchedRowId = new int[bitSet.cardinality()];
            int index = 0;
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                matchedRowId[index++] = i;
                i = bitSet.nextSetBit(i + 1);
            }
            pageFilteredRowCount[pageId] = matchedRowId.length;
            pageFilteredRowId[pageId] = matchedRowId;
        }
        FileReader fileReader = rawBlockletColumnChunks.getFileReader();
        DimensionRawColumnChunk[] dimensionRawColumnChunks = new DimensionRawColumnChunk[this.blockExecutionInfo.getTotalNumberDimensionToRead()];
        int numDimensionChunks = dimensionRawColumnChunks.length;
        for (int chunkIndex = 0; chunkIndex < numDimensionChunks; ++chunkIndex) {
            dimensionRawColumnChunks[chunkIndex] = rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex];
        }
        long totalReadTime = System.currentTimeMillis();
        int[][] allSelectedDimensionColumnIndexRange = this.blockExecutionInfo.getAllSelectedDimensionColumnIndexRange();
        DimensionRawColumnChunk[] projectionListDimensionChunk = rawBlockletColumnChunks.getDataBlock().readDimensionChunks(fileReader, allSelectedDimensionColumnIndexRange);
        totalReadTime = System.currentTimeMillis() - totalReadTime;
        for (int[] columnIndexRange : allSelectedDimensionColumnIndexRange) {
            System.arraycopy(projectionListDimensionChunk, columnIndexRange[0], dimensionRawColumnChunks, columnIndexRange[0], columnIndexRange[1] + 1 - columnIndexRange[0]);
        }
        long filterDimensionReadTime = System.currentTimeMillis();
        int[] projectionListDimensionIndexes = this.blockExecutionInfo.getProjectionListDimensionIndexes();
        for (int projectionListDimensionIndex : projectionListDimensionIndexes) {
            if (null != dimensionRawColumnChunks[projectionListDimensionIndex]) continue;
            dimensionRawColumnChunks[projectionListDimensionIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(fileReader, projectionListDimensionIndex);
        }
        totalReadTime += System.currentTimeMillis() - filterDimensionReadTime;
        DimensionColumnPage[][] dimensionColumnPages = new DimensionColumnPage[numDimensionChunks][numPages];
        MeasureRawColumnChunk[] measureRawColumnChunks = new MeasureRawColumnChunk[this.blockExecutionInfo.getTotalNumberOfMeasureToRead()];
        int numMeasureChunks = measureRawColumnChunks.length;
        for (int chunkIndex = 0; chunkIndex < numMeasureChunks; ++chunkIndex) {
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) continue;
            measureRawColumnChunks[chunkIndex] = rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex];
        }
        long measureReadTime = System.currentTimeMillis();
        int[][] allSelectedMeasureColumnIndexRange = this.blockExecutionInfo.getAllSelectedMeasureIndexRange();
        MeasureRawColumnChunk[] projectionListMeasureChunk = rawBlockletColumnChunks.getDataBlock().readMeasureChunks(fileReader, allSelectedMeasureColumnIndexRange);
        measureReadTime = System.currentTimeMillis() - measureReadTime;
        for (int[] columnIndexRange : allSelectedMeasureColumnIndexRange) {
            System.arraycopy(projectionListMeasureChunk, columnIndexRange[0], measureRawColumnChunks, columnIndexRange[0], columnIndexRange[1] + 1 - columnIndexRange[0]);
        }
        long filterMeasureReadTime = System.currentTimeMillis();
        int[] projectionListMeasureIndexes = this.blockExecutionInfo.getProjectionListMeasureIndexes();
        for (int projectionListMeasureIndex : projectionListMeasureIndexes) {
            if (null != measureRawColumnChunks[projectionListMeasureIndex]) continue;
            measureRawColumnChunks[projectionListMeasureIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(fileReader, projectionListMeasureIndex);
        }
        totalReadTime += (measureReadTime += System.currentTimeMillis() - filterMeasureReadTime);
        ColumnPage[][] measureColumnPages = new ColumnPage[numMeasureChunks][numPages];
        scannedResult.setDimensionColumnPages(dimensionColumnPages);
        scannedResult.setPageFilteredRowId(pageFilteredRowId);
        scannedResult.setMeasureColumnPages(measureColumnPages);
        scannedResult.setDimRawColumnChunks(dimensionRawColumnChunks);
        scannedResult.setMsrRawColumnChunks(measureRawColumnChunks);
        scannedResult.setPageFilteredRowCount(pageFilteredRowCount);
        scannedResult.fillDataChunks();
        QueryStatistic scanTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to scan blocks");
        scanTime.addCountStatistic("Time taken to scan blocks", scanTime.getCount() + (System.currentTimeMillis() - startTime - totalReadTime));
        QueryStatistic readTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to read blocks");
        readTime.addCountStatistic("Time taken to read blocks", readTime.getCount() + totalReadTime);
        return scannedResult;
    }

    private BlockletScannedResult executeFilterForPages(RawBlockletColumnChunks rawBlockletColumnChunks) throws FilterUnsupportedException, IOException {
        int chunkIndex;
        long startTime = System.currentTimeMillis();
        BitSet pages = this.filterExecuter.prunePages(rawBlockletColumnChunks);
        if (pages.isEmpty()) {
            CarbonUtil.freeMemory(rawBlockletColumnChunks.getDimensionRawColumnChunks(), rawBlockletColumnChunks.getMeasureRawColumnChunks());
            QueryStatistic scanTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to scan blocks");
            scanTime.addCountStatistic("Time taken to scan blocks", scanTime.getCount() + (System.currentTimeMillis() - startTime));
            QueryStatistic scannedBlocklets = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of blocklet scanned");
            scannedBlocklets.addCountStatistic("The num of blocklet scanned", scannedBlocklets.getCount() + 1L);
            QueryStatistic scannedPages = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of page scanned");
            scannedPages.addCountStatistic("The number of page scanned", scannedPages.getCount());
            return this.createEmptyResult();
        }
        FilterQueryScannedResult scannedResult = new FilterQueryScannedResult(this.blockExecutionInfo, this.queryStatisticsModel);
        QueryStatistic validScannedBlockletStatistic = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of valid scanned blocklet");
        validScannedBlockletStatistic.addCountStatistic("The num of valid scanned blocklet", validScannedBlockletStatistic.getCount() + 1L);
        QueryStatistic validPages = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of valid page scanned");
        validPages.addCountStatistic("The number of valid page scanned", validPages.getCount() + (long)pages.cardinality());
        QueryStatistic scannedBlocklets = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of blocklet scanned");
        scannedBlocklets.addCountStatistic("The num of blocklet scanned", scannedBlocklets.getCount() + 1L);
        QueryStatistic scannedPages = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of page scanned");
        scannedPages.addCountStatistic("The number of page scanned", scannedPages.getCount() + (long)pages.cardinality());
        int[] pageFilteredPages = new int[pages.cardinality()];
        int[] numberOfRows = new int[pages.cardinality()];
        int index = 0;
        int i = pages.nextSetBit(0);
        while (i >= 0) {
            pageFilteredPages[index] = i;
            numberOfRows[index++] = rawBlockletColumnChunks.getDataBlock().getPageRowCount(i);
            i = pages.nextSetBit(i + 1);
        }
        DimensionRawColumnChunk[] dimensionRawColumnChunks = new DimensionRawColumnChunk[this.blockExecutionInfo.getTotalNumberDimensionToRead()];
        MeasureRawColumnChunk[] measureRawColumnChunks = new MeasureRawColumnChunk[this.blockExecutionInfo.getTotalNumberOfMeasureToRead()];
        int numDimensionChunks = dimensionRawColumnChunks.length;
        int numMeasureChunks = measureRawColumnChunks.length;
        for (chunkIndex = 0; chunkIndex < numDimensionChunks; ++chunkIndex) {
            dimensionRawColumnChunks[chunkIndex] = rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex];
        }
        for (chunkIndex = 0; chunkIndex < numMeasureChunks; ++chunkIndex) {
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) continue;
            measureRawColumnChunks[chunkIndex] = rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex];
        }
        LazyBlockletLoader lazyBlocklet = new LazyBlockletLoader(rawBlockletColumnChunks, this.blockExecutionInfo, dimensionRawColumnChunks, measureRawColumnChunks, this.queryStatisticsModel);
        DimensionColumnPage[][] dimensionColumnPages = new DimensionColumnPage[numDimensionChunks][pages.cardinality()];
        ColumnPage[][] measureColumnPages = new ColumnPage[numMeasureChunks][pages.cardinality()];
        scannedResult.setDimensionColumnPages(dimensionColumnPages);
        scannedResult.setMeasureColumnPages(measureColumnPages);
        scannedResult.setDimRawColumnChunks(dimensionRawColumnChunks);
        scannedResult.setMsrRawColumnChunks(measureRawColumnChunks);
        scannedResult.setPageFilteredRowCount(numberOfRows);
        scannedResult.setPageIdFiltered(pageFilteredPages);
        scannedResult.setLazyBlockletLoader(lazyBlocklet);
        scannedResult.setBlockletId(this.blockExecutionInfo.getBlockIdString(), String.valueOf(rawBlockletColumnChunks.getDataBlock().blockletIndex()));
        QueryStatistic scanTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to scan blocks");
        scanTime.addCountStatistic("Time taken to scan blocks", scanTime.getCount() + (System.currentTimeMillis() - startTime));
        return scannedResult;
    }
}

