/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.scanner.impl;

import java.io.IOException;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.result.impl.NonFilterQueryScannedResult;
import org.apache.carbondata.core.scan.scanner.BlockletScanner;
import org.apache.carbondata.core.scan.scanner.LazyBlockletLoader;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsModel;

public class BlockletFullScanner
implements BlockletScanner {
    protected BlockExecutionInfo blockExecutionInfo;
    private QueryStatisticsModel queryStatisticsModel;
    private BlockletScannedResult emptyResult;

    public BlockletFullScanner(BlockExecutionInfo tableBlockExecutionInfos, QueryStatisticsModel queryStatisticsModel) {
        this.blockExecutionInfo = tableBlockExecutionInfos;
        this.queryStatisticsModel = queryStatisticsModel;
    }

    @Override
    public BlockletScannedResult scanBlocklet(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException, FilterUnsupportedException {
        int i;
        long startTime = System.currentTimeMillis();
        NonFilterQueryScannedResult scannedResult = new NonFilterQueryScannedResult(this.blockExecutionInfo, this.queryStatisticsModel);
        QueryStatistic totalBlockletStatistic = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of total blocklet");
        totalBlockletStatistic.addCountStatistic("The num of total blocklet", totalBlockletStatistic.getCount() + 1L);
        QueryStatistic validScannedBlockletStatistic = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The num of valid scanned blocklet");
        validScannedBlockletStatistic.addCountStatistic("The num of valid scanned blocklet", validScannedBlockletStatistic.getCount() + 1L);
        QueryStatistic validPages = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of valid page scanned");
        validPages.addCountStatistic("The number of valid page scanned", validPages.getCount() + (long)rawBlockletColumnChunks.getDataBlock().numberOfPages());
        QueryStatistic totalPagesScanned = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("The number of total page scanned");
        totalPagesScanned.addCountStatistic("The number of total page scanned", totalPagesScanned.getCount() + (long)rawBlockletColumnChunks.getDataBlock().numberOfPages());
        scannedResult.setBlockletId(this.blockExecutionInfo.getBlockIdString(), String.valueOf(rawBlockletColumnChunks.getDataBlock().blockletIndex()));
        DimensionRawColumnChunk[] dimensionRawColumnChunks = rawBlockletColumnChunks.getDimensionRawColumnChunks();
        DimensionColumnPage[][] dimensionColumnDataChunks = new DimensionColumnPage[dimensionRawColumnChunks.length][rawBlockletColumnChunks.getDataBlock().numberOfPages()];
        MeasureRawColumnChunk[] measureRawColumnChunks = rawBlockletColumnChunks.getMeasureRawColumnChunks();
        ColumnPage[][] measureColumnPages = new ColumnPage[measureRawColumnChunks.length][rawBlockletColumnChunks.getDataBlock().numberOfPages()];
        scannedResult.setDimensionColumnPages(dimensionColumnDataChunks);
        scannedResult.setMeasureColumnPages(measureColumnPages);
        scannedResult.setDimRawColumnChunks(dimensionRawColumnChunks);
        scannedResult.setMsrRawColumnChunks(measureRawColumnChunks);
        int[] numberOfRows = null;
        if (this.blockExecutionInfo.getAllSelectedDimensionColumnIndexRange().length > 0) {
            for (i = 0; i < dimensionRawColumnChunks.length; ++i) {
                if (dimensionRawColumnChunks[i] == null) continue;
                numberOfRows = dimensionRawColumnChunks[i].getRowCount();
                break;
            }
        } else if (this.blockExecutionInfo.getAllSelectedMeasureIndexRange().length > 0) {
            for (i = 0; i < measureRawColumnChunks.length; ++i) {
                if (measureRawColumnChunks[i] == null) continue;
                numberOfRows = measureRawColumnChunks[i].getRowCount();
                break;
            }
        }
        scannedResult.setLazyBlockletLoader(new LazyBlockletLoader(rawBlockletColumnChunks, this.blockExecutionInfo, dimensionRawColumnChunks, measureRawColumnChunks, this.queryStatisticsModel));
        if (numberOfRows == null) {
            numberOfRows = new int[rawBlockletColumnChunks.getDataBlock().numberOfPages()];
            for (i = 0; i < numberOfRows.length; ++i) {
                numberOfRows[i] = rawBlockletColumnChunks.getDataBlock().getPageRowCount(i);
            }
        }
        scannedResult.setPageFilteredRowCount(numberOfRows);
        if (!this.blockExecutionInfo.isDirectVectorFill()) {
            scannedResult.fillDataChunks();
        }
        QueryStatistic scanTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to scan blocks");
        scanTime.addCountStatistic("Time taken to scan blocks", scanTime.getCount() + (System.currentTimeMillis() - startTime));
        return scannedResult;
    }

    @Override
    public void readBlocklet(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        long startTime = System.currentTimeMillis();
        DimensionRawColumnChunk[] dimensionRawColumnChunks = rawBlockletColumnChunks.getDataBlock().readDimensionChunks(rawBlockletColumnChunks.getFileReader(), this.blockExecutionInfo.getAllSelectedDimensionColumnIndexRange());
        rawBlockletColumnChunks.setDimensionRawColumnChunks(dimensionRawColumnChunks);
        MeasureRawColumnChunk[] measureRawColumnChunks = rawBlockletColumnChunks.getDataBlock().readMeasureChunks(rawBlockletColumnChunks.getFileReader(), this.blockExecutionInfo.getAllSelectedMeasureIndexRange());
        rawBlockletColumnChunks.setMeasureRawColumnChunks(measureRawColumnChunks);
        QueryStatistic readTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("Time taken to read blocks");
        readTime.addCountStatistic("Time taken to read blocks", readTime.getCount() + (System.currentTimeMillis() - startTime));
    }

    BlockletScannedResult createEmptyResult() {
        if (this.emptyResult == null) {
            this.emptyResult = new NonFilterQueryScannedResult(this.blockExecutionInfo, this.queryStatisticsModel);
            this.emptyResult.setPageFilteredRowCount(new int[0]);
            this.emptyResult.setPageFilteredRowId(new int[0][]);
        }
        return this.emptyResult;
    }

    @Override
    public boolean isScanRequired(DataRefNode dataBlock) {
        return true;
    }
}

