/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.wrappers;

import java.io.Serializable;
import org.apache.carbondata.core.util.ByteUtil;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper>,
Serializable {
    private byte[] dictionaryKey;
    private byte[][] complexTypesKeys;
    private byte[][] noDictionaryKeys;
    protected byte[] implicitColumnByteArray;

    public byte[] getDictionaryKey() {
        return this.dictionaryKey;
    }

    public void setDictionaryKey(byte[] dictionaryKey) {
        this.dictionaryKey = dictionaryKey;
    }

    public void setNoDictionaryKeys(byte[][] noDictionaryKeys) {
        this.noDictionaryKeys = noDictionaryKeys;
    }

    public byte[] getNoDictionaryKeyByIndex(int index) {
        return this.noDictionaryKeys[index];
    }

    public byte[] getComplexKeyByIndex(int index) {
        return this.complexTypesKeys[index];
    }

    public byte[][] getNoDictionaryKeys() {
        return this.noDictionaryKeys;
    }

    public byte[][] getComplexTypesKeys() {
        return this.complexTypesKeys;
    }

    public int hashCode() {
        int i;
        int len = this.dictionaryKey.length;
        int result = 1;
        for (int j = 0; j < len; ++j) {
            result = 31 * result + this.dictionaryKey[j];
        }
        for (byte[] directSurrogateValue : this.noDictionaryKeys) {
            for (i = 0; i < directSurrogateValue.length; ++i) {
                result = 31 * result + directSurrogateValue[i];
            }
        }
        for (byte[] complexTypeKey : this.complexTypesKeys) {
            for (i = 0; i < complexTypeKey.length; ++i) {
                result = 31 * result + complexTypeKey[i];
            }
        }
        return result;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof ByteArrayWrapper)) {
            return false;
        }
        boolean result = false;
        byte[][] noDictionaryKeysOther = ((ByteArrayWrapper)other).noDictionaryKeys;
        if (noDictionaryKeysOther.length != this.noDictionaryKeys.length) {
            return false;
        }
        for (int i = 0; i < this.noDictionaryKeys.length; ++i) {
            result = ByteUtil.UnsafeComparer.INSTANCE.equals(this.noDictionaryKeys[i], noDictionaryKeysOther[i]);
            if (result) continue;
            return false;
        }
        byte[][] complexTypesKeysOther = ((ByteArrayWrapper)other).complexTypesKeys;
        if (complexTypesKeysOther.length != this.complexTypesKeys.length) {
            return false;
        }
        for (int i = 0; i < this.complexTypesKeys.length; ++i) {
            result = ByteUtil.UnsafeComparer.INSTANCE.equals(this.complexTypesKeys[i], complexTypesKeysOther[i]);
            if (result) continue;
            return false;
        }
        return ByteUtil.UnsafeComparer.INSTANCE.equals(this.dictionaryKey, ((ByteArrayWrapper)other).dictionaryKey);
    }

    @Override
    public int compareTo(ByteArrayWrapper other) {
        int i;
        int compareTo = ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.dictionaryKey, other.dictionaryKey);
        if (compareTo == 0) {
            for (i = 0; i < this.noDictionaryKeys.length; ++i) {
                compareTo = ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.noDictionaryKeys[i], other.noDictionaryKeys[i]);
                if (compareTo == 0) continue;
                return compareTo;
            }
        }
        if (compareTo == 0) {
            for (i = 0; i < this.complexTypesKeys.length; ++i) {
                compareTo = ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.complexTypesKeys[i], other.complexTypesKeys[i]);
                if (compareTo == 0) continue;
                return compareTo;
            }
        }
        return compareTo;
    }

    public void setComplexTypesKeys(byte[][] complexTypesKeys) {
        this.complexTypesKeys = complexTypesKeys;
    }

    public void setImplicitColumnByteArray(byte[] implicitColumnByteArray) {
        this.implicitColumnByteArray = implicitColumnByteArray;
    }

    public byte[] getImplicitColumnByteArray() {
        return this.implicitColumnByteArray;
    }
}

