/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.segmentmeta;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.carbondata.core.segmentmeta.BlockColumnMetaDataInfo;
import org.apache.carbondata.core.segmentmeta.SegmentColumnMetaDataInfo;
import org.apache.carbondata.core.segmentmeta.SegmentMetaDataInfo;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.ColumnSchema;

public class SegmentMetaDataInfoStats {
    private Map<String, Map<String, BlockColumnMetaDataInfo>> tableSegmentMetaDataInfoMap = new LinkedHashMap<String, Map<String, BlockColumnMetaDataInfo>>();
    private static SegmentMetaDataInfoStats segmentMetaDataInfoStats;

    private SegmentMetaDataInfoStats() {
    }

    public static synchronized SegmentMetaDataInfoStats getInstance() {
        if (null == segmentMetaDataInfoStats) {
            segmentMetaDataInfoStats = new SegmentMetaDataInfoStats();
            return segmentMetaDataInfoStats;
        }
        return segmentMetaDataInfoStats;
    }

    public synchronized SegmentMetaDataInfo getTableSegmentMetaDataInfo(String tableName, String segmentId) {
        LinkedHashMap<String, SegmentColumnMetaDataInfo> segmentColumnMetaDataInfoMap = new LinkedHashMap<String, SegmentColumnMetaDataInfo>();
        Map<String, BlockColumnMetaDataInfo> segmentMetaDataInfoMap = this.tableSegmentMetaDataInfoMap.get(tableName);
        if (null != segmentMetaDataInfoMap && !segmentMetaDataInfoMap.isEmpty() && null != segmentMetaDataInfoMap.get(segmentId)) {
            BlockColumnMetaDataInfo blockColumnMetaDataInfo = segmentMetaDataInfoMap.get(segmentId);
            for (int i = 0; i < blockColumnMetaDataInfo.getColumnSchemas().size(); ++i) {
                ColumnSchema columnSchema = blockColumnMetaDataInfo.getColumnSchemas().get(i);
                boolean isSortColumn = false;
                boolean isColumnDrift = false;
                if (null != columnSchema.columnProperties && !columnSchema.columnProperties.isEmpty()) {
                    if (null != columnSchema.columnProperties.get("sort_columns")) {
                        isSortColumn = true;
                    }
                    if (null != columnSchema.columnProperties.get("column_drift")) {
                        isColumnDrift = true;
                    }
                }
                segmentColumnMetaDataInfoMap.put(columnSchema.column_id, new SegmentColumnMetaDataInfo(isSortColumn, blockColumnMetaDataInfo.getMin()[i], blockColumnMetaDataInfo.getMax()[i], isColumnDrift));
            }
        }
        return new SegmentMetaDataInfo(segmentColumnMetaDataInfoMap);
    }

    public synchronized void setBlockMetaDataInfo(String tableName, String segmentId, BlockColumnMetaDataInfo currentBlockColumnMetaInfo) {
        if (!this.tableSegmentMetaDataInfoMap.isEmpty() && null != this.tableSegmentMetaDataInfoMap.get(tableName) && null != this.tableSegmentMetaDataInfoMap.get(tableName).get(segmentId)) {
            BlockColumnMetaDataInfo previousBlockColumnMetaInfo = this.tableSegmentMetaDataInfoMap.get(tableName).get(segmentId);
            byte[][] updatedMin = this.compareAndUpdateMinMax(previousBlockColumnMetaInfo.getMin(), currentBlockColumnMetaInfo.getMin(), true);
            byte[][] updatedMax = this.compareAndUpdateMinMax(previousBlockColumnMetaInfo.getMax(), currentBlockColumnMetaInfo.getMax(), false);
            this.tableSegmentMetaDataInfoMap.get(tableName).get(segmentId).setMinMax(updatedMin, updatedMax);
        } else {
            Map<String, BlockColumnMetaDataInfo> segmentMinMaxMap = new HashMap<String, BlockColumnMetaDataInfo>();
            if (null != this.tableSegmentMetaDataInfoMap.get(tableName) && !this.tableSegmentMetaDataInfoMap.get(tableName).isEmpty()) {
                segmentMinMaxMap = this.tableSegmentMetaDataInfoMap.get(tableName);
            }
            segmentMinMaxMap.put(segmentId, currentBlockColumnMetaInfo);
            this.tableSegmentMetaDataInfoMap.put(tableName, segmentMinMaxMap);
        }
    }

    public synchronized void clear(String tableName, String segmentId) {
        if (null != this.tableSegmentMetaDataInfoMap.get(tableName)) {
            if (null != this.tableSegmentMetaDataInfoMap.get(tableName).get(segmentId)) {
                this.tableSegmentMetaDataInfoMap.get(tableName).remove(segmentId);
            }
            if (this.tableSegmentMetaDataInfoMap.get(tableName).isEmpty()) {
                this.tableSegmentMetaDataInfoMap.remove(tableName);
            }
        }
    }

    public synchronized byte[] compareAndUpdateMinMax(byte[] minMaxValueCompare1, byte[] minMaxValueCompare2, boolean isMinValueComparison) {
        byte[] updatedMinMaxValues = new byte[minMaxValueCompare1.length];
        System.arraycopy(minMaxValueCompare1, 0, updatedMinMaxValues, 0, minMaxValueCompare1.length);
        int compare = ByteUtil.UnsafeComparer.INSTANCE.compareTo(minMaxValueCompare2, minMaxValueCompare1);
        if (isMinValueComparison) {
            if (compare < 0) {
                updatedMinMaxValues = minMaxValueCompare2;
            }
        } else if (compare > 0) {
            updatedMinMaxValues = minMaxValueCompare2;
        }
        return updatedMinMaxValues;
    }

    private synchronized byte[][] compareAndUpdateMinMax(byte[][] minMaxValueCompare1, byte[][] minMaxValueCompare2, boolean isMinValueComparison) {
        byte[][] updatedMinMaxValues = new byte[minMaxValueCompare1.length][];
        System.arraycopy(minMaxValueCompare1, 0, updatedMinMaxValues, 0, minMaxValueCompare1.length);
        for (int i = 0; i < minMaxValueCompare1.length; ++i) {
            int compare = ByteUtil.UnsafeComparer.INSTANCE.compareTo(minMaxValueCompare2[i], minMaxValueCompare1[i]);
            if (isMinValueComparison) {
                if (compare >= 0) continue;
                updatedMinMaxValues[i] = minMaxValueCompare2[i];
                continue;
            }
            if (compare <= 0) continue;
            updatedMinMaxValues[i] = minMaxValueCompare2[i];
        }
        return updatedMinMaxValues;
    }
}

