/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.stats;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.common.logging.impl.StatisticLevel;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.stats.TaskStatistics;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DriverQueryStatisticsRecorderImpl
implements QueryStatisticsRecorder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DriverQueryStatisticsRecorderImpl.class.getName());
    private Map<String, List<QueryStatistic>> queryStatisticsMap = new ConcurrentHashMap<String, List<QueryStatistic>>();
    private static final Object lock = new Object();
    private static DriverQueryStatisticsRecorderImpl carbonLoadStatisticsImplInstance = new DriverQueryStatisticsRecorderImpl();

    private DriverQueryStatisticsRecorderImpl() {
    }

    public static DriverQueryStatisticsRecorderImpl getInstance() {
        return carbonLoadStatisticsImplInstance;
    }

    @Override
    public void recordStatistics(QueryStatistic statistic) {
    }

    @Override
    public void logStatistics() {
    }

    @Override
    public TaskStatistics statisticsForTask(long taskId, long startTime) {
        return null;
    }

    @Override
    public void logStatisticsForTask(TaskStatistics task) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordStatisticsForDriver(QueryStatistic statistic, String queryId) {
        if (null != queryId) {
            Object object = lock;
            synchronized (object) {
                if (this.queryStatisticsMap.get(queryId) != null) {
                    this.queryStatisticsMap.get(queryId).add(statistic);
                } else {
                    ArrayList<QueryStatistic> newQueryStatistics = new ArrayList<QueryStatistic>();
                    newQueryStatistics.add(statistic);
                    this.queryStatisticsMap.put(queryId, newQueryStatistics);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logStatisticsAsTableDriver() {
        Object object = lock;
        synchronized (object) {
            Iterator<Map.Entry<String, List<QueryStatistic>>> entries = this.queryStatisticsMap.entrySet().iterator();
            while (entries.hasNext()) {
                String tableInfo;
                Map.Entry<String, List<QueryStatistic>> entry = entries.next();
                String queryId = entry.getKey();
                if (StringUtils.isEmpty((CharSequence)queryId)) {
                    entries.remove();
                    continue;
                }
                long interval = System.nanoTime() - Long.parseLong(queryId);
                if (interval > 60000000000L) {
                    entries.remove();
                    continue;
                }
                if (entry.getValue().size() < 2 || null == (tableInfo = this.collectDriverStatistics(entry.getValue(), queryId))) continue;
                LOGGER.log((Priority)StatisticLevel.STATISTIC, (Object)tableInfo);
                entries.remove();
            }
        }
    }

    public String collectDriverStatistics(List<QueryStatistic> statisticsList, String queryId) {
        String sql_parse_time = "";
        String load_meta_time = "";
        String load_blocks_time = "";
        String block_allocation_time = "";
        String block_identification_time = "";
        long driver_part_time_tmp = 0L;
        long driver_part_time_tmp2 = 0L;
        long load_blocks_time_tmp = 0L;
        String splitChar = " ";
        try {
            for (QueryStatistic statistic : statisticsList) {
                switch (statistic.getMessage()) {
                    case "Time taken to parse sql In Driver Side": {
                        sql_parse_time = sql_parse_time + statistic.getTimeTaken() + splitChar;
                        driver_part_time_tmp += statistic.getTimeTaken();
                        break;
                    }
                    case "Time taken to load meta data In Driver Side": {
                        load_meta_time = load_meta_time + statistic.getTimeTaken() + splitChar;
                        driver_part_time_tmp += statistic.getTimeTaken();
                        break;
                    }
                    case "Time taken to load the Block(s) In Driver Side with Block count ": {
                        load_blocks_time_tmp += statistic.getTimeTaken();
                        driver_part_time_tmp += statistic.getTimeTaken();
                        driver_part_time_tmp2 += statistic.getTimeTaken();
                        break;
                    }
                    case "Total Time taken in block(s) allocation": {
                        block_allocation_time = block_allocation_time + statistic.getTimeTaken() + splitChar;
                        driver_part_time_tmp += statistic.getTimeTaken();
                        driver_part_time_tmp2 += statistic.getTimeTaken();
                        break;
                    }
                    case "Time taken to identify Block(s) to scan": {
                        block_identification_time = block_identification_time + statistic.getTimeTaken() + splitChar;
                        driver_part_time_tmp += statistic.getTimeTaken();
                        driver_part_time_tmp2 += statistic.getTimeTaken();
                        break;
                    }
                }
            }
            load_blocks_time = load_blocks_time_tmp + splitChar;
            String driver_part_time = driver_part_time_tmp + splitChar;
            StringBuilder tableInfo = new StringBuilder();
            int len1 = 8;
            int len2 = 20;
            int len3 = 21;
            int len4 = 24;
            String line = "+" + CarbonUtil.printLine("-", len1) + "+" + CarbonUtil.printLine("-", len2) + "+" + CarbonUtil.printLine("-", len3) + "+" + CarbonUtil.printLine("-", len4) + "+";
            String line2 = "|" + CarbonUtil.printLine(" ", len1) + "+" + CarbonUtil.printLine("-", len2) + "+" + CarbonUtil.printLine(" ", len3) + "+" + CarbonUtil.printLine("-", len4) + "+";
            tableInfo.append(line).append("\n");
            tableInfo.append("|" + CarbonUtil.printLine(" ", len1 - "Module".length()) + "Module|" + CarbonUtil.printLine(" ", len2 - "Operation Step".length()) + "Operation Step|" + CarbonUtil.printLine(" ", len3 - "Total Query Cost".length()) + "Total Query Cost|" + CarbonUtil.printLine(" ", len4 - "Query Cost".length()) + "Query Cost|\n");
            tableInfo.append(line).append("\n");
            if (!(StringUtils.isEmpty((CharSequence)sql_parse_time) || StringUtils.isEmpty((CharSequence)load_meta_time) || StringUtils.isEmpty((CharSequence)block_allocation_time) || StringUtils.isEmpty((CharSequence)block_identification_time))) {
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1) + "|" + CarbonUtil.printLine(" ", len2 - "SQL parse".length()) + "SQL parse|" + CarbonUtil.printLine(" ", len3) + "|" + CarbonUtil.printLine(" ", len4 - sql_parse_time.length()) + sql_parse_time + "|\n");
                tableInfo.append(line2).append("\n");
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1 - "Driver".length()) + "Driver|" + CarbonUtil.printLine(" ", len2 - "Load meta data".length()) + "Load meta data|" + CarbonUtil.printLine(" ", len3 - driver_part_time.length()) + driver_part_time + "|" + CarbonUtil.printLine(" ", len4 - load_meta_time.length()) + load_meta_time + "|\n");
                tableInfo.append(line2).append("\n");
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1 - "Part".length()) + "Part|" + CarbonUtil.printLine(" ", len2 - "Load blocks driver".length()) + "Load blocks driver|" + CarbonUtil.printLine(" ", len3) + "|" + CarbonUtil.printLine(" ", len4 - load_blocks_time.length()) + load_blocks_time + "|\n");
                tableInfo.append(line2).append("\n");
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1) + "|" + CarbonUtil.printLine(" ", len2 - "Block allocation".length()) + "Block allocation|" + CarbonUtil.printLine(" ", len3) + "|" + CarbonUtil.printLine(" ", len4 - block_allocation_time.length()) + block_allocation_time + "|\n");
                tableInfo.append(line2).append("\n");
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1) + "|" + CarbonUtil.printLine(" ", len2 - "Block identification".length()) + "Block identification|" + CarbonUtil.printLine(" ", len3) + "|" + CarbonUtil.printLine(" ", len4 - block_identification_time.length()) + block_identification_time + "|\n");
                tableInfo.append(line).append("\n");
                return "Print query statistic for query id: " + queryId + "\n" + tableInfo.toString();
            }
            if (!StringUtils.isEmpty((CharSequence)block_allocation_time) && !StringUtils.isEmpty((CharSequence)block_identification_time)) {
                driver_part_time = driver_part_time_tmp2 + splitChar;
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1 - "Driver".length()) + "Driver|" + CarbonUtil.printLine(" ", len2 - "Load blocks driver".length()) + "Load blocks driver|" + CarbonUtil.printLine(" ", len3) + "|" + CarbonUtil.printLine(" ", len4 - load_blocks_time.length()) + load_blocks_time + "|\n");
                tableInfo.append(line2).append("\n");
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1 - "Part".length()) + "Part|" + CarbonUtil.printLine(" ", len2 - "Block allocation".length()) + "Block allocation|" + CarbonUtil.printLine(" ", len3 - driver_part_time.length()) + driver_part_time + "|" + CarbonUtil.printLine(" ", len4 - block_allocation_time.length()) + block_allocation_time + "|\n");
                tableInfo.append(line2).append("\n");
                tableInfo.append("|" + CarbonUtil.printLine(" ", len1) + "|" + CarbonUtil.printLine(" ", len2 - "Block identification".length()) + "Block identification|" + CarbonUtil.printLine(" ", len3) + "|" + CarbonUtil.printLine(" ", len4 - block_identification_time.length()) + block_identification_time + "|\n");
                tableInfo.append(line).append("\n");
                return "Print query statistic for query id: " + queryId + "\n" + tableInfo.toString();
            }
            return null;
        }
        catch (Exception ex) {
            return "Put statistics into table failed, catch exception: " + ex.getMessage();
        }
    }
}

