/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.stats;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class QueryStatistic
implements Serializable {
    private static final long serialVersionUID = -5667106646135905848L;
    private String message;
    private long timeTaken;
    private long startTime = System.currentTimeMillis();
    private long count;

    public void addStatistics(String message, long currentTime) {
        this.timeTaken = currentTime - this.startTime;
        this.message = message;
    }

    public void addFixedTimeStatistic(String message, long timetaken) {
        this.timeTaken = timetaken;
        this.message = message;
    }

    public void addCountStatistic(String message, long count) {
        this.timeTaken = -1L;
        this.count = count;
        this.message = message;
    }

    public String getStatistics(String queryWithTaskId) {
        if (StringUtils.isEmpty((CharSequence)queryWithTaskId)) {
            return this.message + this.timeTaken;
        }
        return this.message + " for the taskid : " + queryWithTaskId + " Is : " + this.timeTaken;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getCount() {
        return this.count;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

