/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.stats;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.common.logging.impl.StatisticLevel;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.stats.TaskStatistics;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class QueryStatisticsRecorderImpl
implements QueryStatisticsRecorder,
Serializable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)QueryStatisticsRecorderImpl.class.getName());
    private static final long serialVersionUID = -5719752001674467864L;
    private List<QueryStatistic> queryStatistics = new ArrayList<QueryStatistic>();
    private String queryId;

    public QueryStatisticsRecorderImpl(String queryId) {
        this.queryId = queryId;
    }

    @Override
    public synchronized void recordStatistics(QueryStatistic statistic) {
        this.queryStatistics.add(statistic);
    }

    @Override
    public void logStatistics() {
        for (QueryStatistic statistic : this.queryStatistics) {
            LOGGER.log((Priority)StatisticLevel.STATISTIC, (Object)statistic.getStatistics(this.queryId));
        }
    }

    @Override
    public void logStatisticsForTask(TaskStatistics result) {
        if (null != result) {
            LOGGER.log((Priority)StatisticLevel.STATISTIC, (Object)("Print query statistic for each task id:\n" + result.toString()));
        }
    }

    @Override
    public TaskStatistics statisticsForTask(long taskId, long startTime) {
        try {
            return new TaskStatistics(this.queryId, taskId).build(startTime, this.queryStatistics);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
            return null;
        }
    }

    @Override
    public void recordStatisticsForDriver(QueryStatistic statistic, String queryId) {
    }

    @Override
    public void logStatisticsAsTableDriver() {
    }
}

