/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.stats;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.util.CarbonUtil;

@InterfaceAudience.Developer(value={"stats"})
@InterfaceStability.Evolving
public class TaskStatistics
implements Serializable {
    private static final Column[] columns = new Column[]{new Column("query_id", "query id"), new Column("task_id", "spark task id"), new Column("start_time", "start time"), new Column("total_time", "Total Time taken to execute the query in executor Side", true), new Column("load_blocks_time", "Time taken to load the Block(s) In Executor", true), new Column("load_dictionary_time", "Time taken to load the Dictionary In Executor", true), new Column("carbon_scan_time", "Time taken to scan blocks"), new Column("carbon_IO_time", "Time taken to read blocks"), new Column("scan_blocks_num", "The num of blocks scanned"), new Column("total_blocklets", "The num of total blocklet"), new Column("scanned_blocklets", "The num of blocklet scanned"), new Column("valid_blocklets", "The num of valid scanned blocklet"), new Column("total_pages", "The number of total page scanned"), new Column("scanned_pages", "The number of page scanned"), new Column("valid_pages", "The number of valid page scanned"), new Column("result_size", "The size of query result"), new Column("key_column_filling_time", "key column filling time"), new Column("measure_filling_time", "measure filling time"), new Column("page_uncompress_time", "page uncompress time"), new Column("result_preparation_time", "result preparation time")};
    private static final int numOfColumns = columns.length;
    private String queryId;
    private long[] values = new long[numOfColumns];
    private long fileSize;
    private String[] files;

    TaskStatistics(String queryId, long taskId) {
        this.queryId = queryId;
        this.values[1] = taskId;
    }

    public TaskStatistics(String queryId, long[] values, long fileSize, String[] files) {
        this.queryId = queryId;
        this.values = values;
        this.fileSize = fileSize;
        this.files = files;
    }

    public TaskStatistics build(long startTime, List<QueryStatistic> queryStatistics) {
        this.values[2] = startTime;
        block0: for (QueryStatistic statistic : queryStatistics) {
            if (statistic.getMessage() == null) continue;
            for (int columnIndex = 3; columnIndex <= numOfColumns - 1; ++columnIndex) {
                if (!TaskStatistics.columns[columnIndex].comment.equals(statistic.getMessage())) continue;
                if (TaskStatistics.columns[columnIndex].isDuration) {
                    int n = columnIndex;
                    this.values[n] = this.values[n] + statistic.getTimeTaken();
                    continue block0;
                }
                int n = columnIndex;
                this.values[n] = this.values[n] + statistic.getCount();
                continue block0;
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        TaskStatistics.printStatisticTable(Arrays.asList(this), builder, "");
        return builder.toString();
    }

    public static void printStatisticTable(List<TaskStatistics> stats, StringBuilder builder, String indent) {
        int numOfRows = stats.size();
        int numOfColumns = columns.length;
        String[] header = new String[numOfColumns];
        for (int columnIndex = 0; columnIndex < numOfColumns; ++columnIndex) {
            header[columnIndex] = TaskStatistics.columns[columnIndex].name;
        }
        String[][] rows = new String[numOfRows][];
        for (int rowIndex = 0; rowIndex < numOfRows; ++rowIndex) {
            rows[rowIndex] = stats.get(rowIndex).convertValueToString();
        }
        CarbonUtil.logTable(builder, header, rows, indent);
    }

    private String[] convertValueToString() {
        String[] valueStrings = new String[numOfColumns];
        valueStrings[0] = this.queryId;
        for (int i = 1; i < numOfColumns; ++i) {
            valueStrings[i] = TaskStatistics.columns[i].isDuration ? String.valueOf(this.values[i]) + "ms" : String.valueOf(this.values[i]);
        }
        valueStrings[2] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.values[2]);
        return valueStrings;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public long[] getValues() {
        return this.values;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String[] getFiles() {
        return this.files;
    }

    private static class Column {
        String name;
        String comment;
        boolean isDuration;

        Column(String name, String comment) {
            this.name = name;
            this.comment = comment;
            this.isDuration = false;
        }

        Column(String name, String comment, boolean isDuration) {
            this(name, comment);
            this.isDuration = isDuration;
        }
    }
}

