/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.statusmanager;

import java.io.Serializable;
import java.util.Objects;

public class FileFormat
implements Serializable {
    public static final FileFormat COLUMNAR_V3 = new FileFormat("COLUMNAR_V3", 0);
    public static final FileFormat ROW_V1 = new FileFormat("ROW_V1", 1);
    private String format;
    private int ordinal;

    public FileFormat(String format) {
        this.format = format.toLowerCase();
    }

    public FileFormat(String format, int ordinal) {
        this.format = format.toLowerCase();
        this.ordinal = ordinal;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public static FileFormat getByOrdinal(int ordinal) {
        if (ordinal < 0) {
            throw new IllegalArgumentException("Argument [ordinal] is less than 0.");
        }
        switch (ordinal) {
            case 0: {
                return COLUMNAR_V3;
            }
            case 1: {
                return ROW_V1;
            }
        }
        return COLUMNAR_V3;
    }

    public boolean isCarbonFormat() {
        return this.format.equalsIgnoreCase("COLUMNAR_V3") || this.format.equalsIgnoreCase("ROW_V1");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileFormat that = (FileFormat)o;
        return Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public String toString() {
        return this.format;
    }
}

