/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.statusmanager;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LoadMetadataDetails
implements Serializable {
    private static final long serialVersionUID = 1106104914918491724L;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LoadMetadataDetails.class.getName());
    private static final SimpleDateFormat parser = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:SSS");
    private String timestamp;
    private SegmentStatus loadStatus;
    private String loadName;
    private String dataSize;
    private String indexSize;
    private String updateDeltaEndTimestamp;
    private String updateDeltaStartTimestamp;
    private String updateStatusFileName;
    private String modificationOrdeletionTimesStamp;
    private String loadStartTime;
    private String mergedLoadName;
    private String visibility;
    private String majorCompacted;
    private String fileFormat;
    private String path;
    private String segmentFile;
    private String extraInfo;

    public String getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(String dataSize) {
        this.dataSize = dataSize;
    }

    public String getIndexSize() {
        return this.indexSize;
    }

    public void setIndexSize(String indexSize) {
        this.indexSize = indexSize;
    }

    public long getLoadEndTime() {
        if (this.timestamp == null) {
            return -1L;
        }
        return this.convertTimeStampToLong(this.timestamp);
    }

    public void setLoadEndTime(long timestamp) {
        this.timestamp = Long.toString(timestamp);
    }

    public SegmentStatus getSegmentStatus() {
        return this.loadStatus;
    }

    public void setSegmentStatus(SegmentStatus segmentStatus) {
        this.loadStatus = segmentStatus;
    }

    public String getLoadName() {
        return this.loadName;
    }

    public void setLoadName(String loadName) {
        this.loadName = loadName;
    }

    public long getModificationOrdeletionTimesStamp() {
        if (null == this.modificationOrdeletionTimesStamp) {
            return 0L;
        }
        return this.convertTimeStampToLong(this.modificationOrdeletionTimesStamp);
    }

    public void setModificationOrdeletionTimesStamp(long modificationOrdeletionTimesStamp) {
        this.modificationOrdeletionTimesStamp = Long.toString(modificationOrdeletionTimesStamp);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loadName == null ? 0 : this.loadName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadMetadataDetails)) {
            return false;
        }
        LoadMetadataDetails other = (LoadMetadataDetails)obj;
        return !(this.loadName == null ? other.loadName != null : !this.loadName.equals(other.loadName));
    }

    public long getLoadStartTime() {
        if (this.loadStartTime == null) {
            return -1L;
        }
        return this.convertTimeStampToLong(this.loadStartTime);
    }

    public long getLoadStartTimeAsLong() {
        Long time;
        if (!this.loadStartTime.isEmpty() && null != (time = this.getTimeStamp(this.loadStartTime))) {
            return time;
        }
        return 0L;
    }

    private long convertTimeStampToLong(String factTimeStamp) {
        try {
            return Long.parseLong(factTimeStamp);
        }
        catch (NumberFormatException nf) {
            SimpleDateFormat parser = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:SSS");
            Date dateToStr = null;
            try {
                dateToStr = parser.parse(factTimeStamp);
                return dateToStr.getTime();
            }
            catch (ParseException e) {
                LOGGER.error((Object)("Cannot convert" + factTimeStamp + " to Time/Long type value" + e.getMessage()), (Throwable)e);
                parser = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                try {
                    if (null == factTimeStamp) {
                        return System.currentTimeMillis();
                    }
                    dateToStr = parser.parse(factTimeStamp);
                    return dateToStr.getTime();
                }
                catch (ParseException e1) {
                    LOGGER.error((Object)("Cannot convert" + factTimeStamp + " to Time/Long type value" + e1.getMessage()));
                    return 0L;
                }
            }
        }
    }

    public Long getTimeStamp(String loadStartTime) {
        try {
            return Long.parseLong(loadStartTime) * 1000L;
        }
        catch (NumberFormatException nf) {
            Date dateToStr = null;
            try {
                dateToStr = parser.parse(loadStartTime);
                return dateToStr.getTime() * 1000L;
            }
            catch (ParseException e) {
                LOGGER.error((Object)("Cannot convert" + loadStartTime + " to Time/Long type value" + e.getMessage()), (Throwable)e);
                return null;
            }
        }
    }

    public void setLoadStartTime(long loadStartTime) {
        this.loadStartTime = Long.toString(loadStartTime);
    }

    public String getMergedLoadName() {
        return this.mergedLoadName;
    }

    public void setMergedLoadName(String mergedLoadName) {
        this.mergedLoadName = mergedLoadName;
    }

    public String getVisibility() {
        if (this.visibility == null) {
            return "true";
        }
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String isMajorCompacted() {
        return this.majorCompacted;
    }

    public void setMajorCompacted(String majorCompacted) {
        this.majorCompacted = majorCompacted;
    }

    public String getUpdateDeltaEndTimestamp() {
        if (this.updateDeltaEndTimestamp == null) {
            return "";
        }
        return this.updateDeltaEndTimestamp;
    }

    public void setUpdateDeltaEndTimestamp(String updateDeltaEndTimestamp) {
        this.updateDeltaEndTimestamp = updateDeltaEndTimestamp;
    }

    public String getUpdateDeltaStartTimestamp() {
        if (this.updateDeltaStartTimestamp == null) {
            return "";
        }
        return this.updateDeltaStartTimestamp;
    }

    public void setUpdateDeltaStartTimestamp(String updateDeltaStartTimestamp) {
        this.updateDeltaStartTimestamp = updateDeltaStartTimestamp;
    }

    public String getUpdateStatusFileName() {
        if (this.updateStatusFileName == null) {
            return "";
        }
        return this.updateStatusFileName;
    }

    public void setUpdateStatusFileName(String updateStatusFileName) {
        this.updateStatusFileName = updateStatusFileName;
    }

    public FileFormat getFileFormat() {
        if (this.fileFormat == null) {
            return FileFormat.COLUMNAR_V3;
        }
        return new FileFormat(this.fileFormat);
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat.toString();
    }

    public String getSegmentFile() {
        return this.segmentFile;
    }

    public void setSegmentFile(String segmentFile) {
        this.segmentFile = segmentFile;
    }

    public String toString() {
        return "LoadMetadataDetails{loadStatus=" + (Object)((Object)this.loadStatus) + ", loadName='" + this.loadName + '\'' + ", loadStartTime='" + this.loadStartTime + '\'' + ", segmentFile='" + this.segmentFile + '\'' + '}';
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isCarbonFormat() {
        return this.getFileFormat().equals(FileFormat.COLUMNAR_V3) || this.getFileFormat().equals(FileFormat.ROW_V1);
    }

    void removeUnnecessaryField() {
        if (StringUtils.isEmpty((CharSequence)this.updateDeltaEndTimestamp)) {
            this.updateDeltaEndTimestamp = null;
        }
        if (StringUtils.isEmpty((CharSequence)this.updateDeltaStartTimestamp)) {
            this.updateDeltaStartTimestamp = null;
        }
        if (StringUtils.isEmpty((CharSequence)this.updateStatusFileName)) {
            this.updateStatusFileName = null;
        }
        if (StringUtils.isEmpty((CharSequence)this.visibility) || this.visibility.equals("true")) {
            this.visibility = null;
        }
        if (StringUtils.isEmpty((CharSequence)this.fileFormat) || this.fileFormat.equals(FileFormat.COLUMNAR_V3.toString())) {
            this.fileFormat = null;
        }
    }
}

