/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.statusmanager;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.exception.ConcurrentOperationException;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.readcommitter.TableStatusReadCommittedScope;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DeleteLoadFolders;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class SegmentStatusManager {
    private static final Logger LOG = LogServiceFactory.getLogService((String)SegmentStatusManager.class.getName());
    private AbsoluteTableIdentifier identifier;
    private Configuration configuration;
    private static final int READ_TABLE_STATUS_RETRY_COUNT = 3;

    public SegmentStatusManager(AbsoluteTableIdentifier identifier) {
        this.identifier = identifier;
        this.configuration = FileFactory.getConfiguration();
    }

    public SegmentStatusManager(AbsoluteTableIdentifier identifier, Configuration configuration) {
        this.identifier = identifier;
        this.configuration = configuration;
    }

    public ICarbonLock getTableStatusLock() {
        return CarbonLockFactory.getCarbonLockObj(this.identifier, "tablestatus.lock");
    }

    public static long getTableStatusLastModifiedTime(AbsoluteTableIdentifier identifier) throws IOException {
        String tableStatusPath = CarbonTablePath.getTableStatusFilePath(identifier.getTablePath());
        if (!FileFactory.isFileExist(tableStatusPath)) {
            return 0L;
        }
        return FileFactory.getCarbonFile(tableStatusPath).getLastModifiedTime();
    }

    public ValidAndInvalidSegmentsInfo getValidAndInvalidSegments() throws IOException {
        return this.getValidAndInvalidSegments(false, null, null);
    }

    public ValidAndInvalidSegmentsInfo getValidAndInvalidSegments(Boolean isChildTable) throws IOException {
        return this.getValidAndInvalidSegments(isChildTable, null, null);
    }

    public ValidAndInvalidSegmentsInfo getValidAndInvalidSegments(Boolean isChildTable, LoadMetadataDetails[] loadMetadataDetails, ReadCommittedScope readCommittedScope) throws IOException {
        ArrayList<Segment> listOfValidSegments = new ArrayList<Segment>(10);
        ArrayList<Segment> listOfValidUpdatedSegments = new ArrayList<Segment>(10);
        ArrayList<Segment> listOfInvalidSegments = new ArrayList<Segment>(10);
        ArrayList<Segment> listOfStreamSegments = new ArrayList<Segment>(10);
        ArrayList<Segment> listOfInProgressSegments = new ArrayList<Segment>(10);
        try {
            if (loadMetadataDetails == null) {
                loadMetadataDetails = SegmentStatusManager.readTableStatusFile(CarbonTablePath.getTableStatusFilePath(this.identifier.getTablePath()));
            }
            if (readCommittedScope == null) {
                readCommittedScope = new TableStatusReadCommittedScope(this.identifier, loadMetadataDetails, this.configuration);
            }
            for (LoadMetadataDetails segment : loadMetadataDetails) {
                if (SegmentStatus.SUCCESS == segment.getSegmentStatus() || SegmentStatus.MARKED_FOR_UPDATE == segment.getSegmentStatus() || SegmentStatus.LOAD_PARTIAL_SUCCESS == segment.getSegmentStatus() || SegmentStatus.STREAMING == segment.getSegmentStatus() || SegmentStatus.STREAMING_FINISH == segment.getSegmentStatus()) {
                    if (null != segment.getMergedLoadName()) {
                        Segment seg = new Segment(segment.getMergedLoadName(), segment.getSegmentFile(), readCommittedScope, segment);
                        if (!listOfValidSegments.contains(seg)) {
                            listOfValidSegments.add(seg);
                        }
                        if (SegmentStatus.MARKED_FOR_UPDATE != segment.getSegmentStatus()) continue;
                        listOfValidUpdatedSegments.add(seg);
                        continue;
                    }
                    if (SegmentStatus.MARKED_FOR_UPDATE == segment.getSegmentStatus()) {
                        listOfValidUpdatedSegments.add(new Segment(segment.getLoadName(), segment.getSegmentFile(), readCommittedScope));
                    }
                    if (SegmentStatus.STREAMING == segment.getSegmentStatus() || SegmentStatus.STREAMING_FINISH == segment.getSegmentStatus()) {
                        listOfStreamSegments.add(new Segment(segment.getLoadName(), segment.getSegmentFile(), readCommittedScope));
                        continue;
                    }
                    if (isChildTable.booleanValue()) {
                        if (segment.getDataSize().equalsIgnoreCase("0") || segment.getIndexSize().equalsIgnoreCase("0")) continue;
                        listOfValidSegments.add(new Segment(segment.getLoadName(), segment.getSegmentFile(), readCommittedScope, segment));
                        continue;
                    }
                    listOfValidSegments.add(new Segment(segment.getLoadName(), segment.getSegmentFile(), readCommittedScope, segment));
                    continue;
                }
                if (SegmentStatus.LOAD_FAILURE == segment.getSegmentStatus() || SegmentStatus.COMPACTED == segment.getSegmentStatus() || SegmentStatus.MARKED_FOR_DELETE == segment.getSegmentStatus()) {
                    listOfInvalidSegments.add(new Segment(segment.getLoadName(), segment.getSegmentFile()));
                    continue;
                }
                if (SegmentStatus.INSERT_IN_PROGRESS != segment.getSegmentStatus() && SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS != segment.getSegmentStatus()) continue;
                listOfInProgressSegments.add(new Segment(segment.getLoadName(), segment.getSegmentFile(), readCommittedScope));
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return new ValidAndInvalidSegmentsInfo(listOfValidSegments, listOfValidUpdatedSegments, listOfInvalidSegments, listOfStreamSegments, listOfInProgressSegments);
    }

    public static LoadMetadataDetails[] readLoadMetadata(String metadataFolderPath) {
        String metadataFileName = metadataFolderPath + "/" + "tablestatus";
        try {
            return SegmentStatusManager.readTableStatusFile(metadataFileName);
        }
        catch (IOException e) {
            return new LoadMetadataDetails[0];
        }
    }

    public static List<String> getValidSegmentList(RelationIdentifier relationIdentifier) throws IOException {
        ArrayList<String> segmentList = new ArrayList<String>();
        List<Segment> validSegments = new SegmentStatusManager(AbsoluteTableIdentifier.from(relationIdentifier.getTablePath(), relationIdentifier.getDatabaseName(), relationIdentifier.getTableName())).getValidAndInvalidSegments().getValidSegments();
        for (Segment segment : validSegments) {
            segmentList.add(segment.getSegmentNo());
        }
        return segmentList;
    }

    public static LoadMetadataDetails[] readLoadMetadata(String metaDataFolderPath, String uuid) throws IOException {
        String tableStatusFileName = uuid.isEmpty() ? metaDataFolderPath + "/" + "tablestatus" : metaDataFolderPath + "/" + "tablestatus" + "_" + uuid;
        return SegmentStatusManager.readTableStatusFile(tableStatusFileName);
    }

    public static LoadMetadataDetails[] readLoadHistoryMetadata(String metadataFolderPath) {
        String metadataFileName = metadataFolderPath + "/" + "tablestatus.history";
        try {
            return SegmentStatusManager.readTableStatusFile(metadataFileName);
        }
        catch (IOException e) {
            return new LoadMetadataDetails[0];
        }
    }

    /*
     * Loose catch block
     */
    private static String readFileAsString(String tableStatusPath) throws IOException {
        DataInputStream dataInputStream = null;
        BufferedReader buffReader = null;
        InputStreamReader inStream = null;
        AtomicFileOperations fileOperation = AtomicFileOperationFactory.getAtomicFileOperations(tableStatusPath);
        if (!FileFactory.isFileExist(tableStatusPath)) {
            return null;
        }
        int retry = 3;
        while (retry > 0) {
            String string;
            try {
                dataInputStream = fileOperation.openForRead();
                inStream = new InputStreamReader((InputStream)dataInputStream, Charset.forName("UTF-8"));
                buffReader = new BufferedReader(inStream);
                string = buffReader.readLine();
            }
            catch (EOFException ex) {
                if (--retry == 0) {
                    LOG.error((Object)"Failed to read table status file after retry", (Throwable)ex);
                    throw ex;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SegmentStatusManager.closeStreams(buffReader, inStream, dataInputStream);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to read table status file", (Throwable)e);
                throw e;
                {
                    catch (Throwable throwable) {
                        SegmentStatusManager.closeStreams(buffReader, inStream, dataInputStream);
                        throw throwable;
                    }
                }
            }
            SegmentStatusManager.closeStreams(buffReader, inStream, dataInputStream);
            return string;
        }
        return null;
    }

    public static LoadMetadataDetails[] readTableStatusFile(String tableStatusPath) throws IOException {
        String content = SegmentStatusManager.readFileAsString(tableStatusPath);
        if (content == null) {
            return new LoadMetadataDetails[0];
        }
        return (LoadMetadataDetails[])new Gson().fromJson(content, LoadMetadataDetails[].class);
    }

    private static int getMaxSegmentId(LoadMetadataDetails[] loadMetadataDetails) {
        int newSegmentId = -1;
        for (int i = 0; i < loadMetadataDetails.length; ++i) {
            try {
                int loadCount = Integer.parseInt(loadMetadataDetails[i].getLoadName());
                if (newSegmentId >= loadCount) continue;
                newSegmentId = loadCount;
                continue;
            }
            catch (NumberFormatException ne) {
                int loadCount;
                String loadName = loadMetadataDetails[i].getLoadName();
                if (!loadName.contains(".") || newSegmentId >= (loadCount = Integer.parseInt(loadName.split("\\.")[0]))) continue;
                newSegmentId = loadCount;
            }
        }
        return newSegmentId;
    }

    public static int createNewSegmentId(LoadMetadataDetails[] loadMetadataDetails) {
        int newSegmentId = SegmentStatusManager.getMaxSegmentId(loadMetadataDetails);
        return ++newSegmentId;
    }

    private static Integer compareDateValues(Long loadValue, Long userValue) {
        return loadValue.compareTo(userValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> updateDeletionStatus(AbsoluteTableIdentifier identifier, List<String> loadIds, String tableFolderPath) throws Exception {
        CarbonTableIdentifier carbonTableIdentifier = identifier.getCarbonTableIdentifier();
        ICarbonLock carbonDeleteSegmentLock = CarbonLockFactory.getCarbonLockObj(identifier, "delete_segment.lock");
        ICarbonLock carbonTableStatusLock = CarbonLockFactory.getCarbonLockObj(identifier, "tablestatus.lock");
        String tableDetails = carbonTableIdentifier.getDatabaseName() + "." + carbonTableIdentifier.getTableName();
        ArrayList<String> invalidLoadIds = new ArrayList<String>(0);
        try {
            if (carbonDeleteSegmentLock.lockWithRetries()) {
                LOG.info((Object)"Delete segment lock has been successfully acquired");
                String dataLoadLocation = CarbonTablePath.getTableStatusFilePath(identifier.getTablePath());
                LoadMetadataDetails[] listOfLoadFolderDetailsArray = null;
                if (!FileFactory.isFileExist(dataLoadLocation)) {
                    LOG.error((Object)"Load metadata file is not present.");
                    List<String> list = loadIds;
                    return list;
                }
                listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata(tableFolderPath);
                if (listOfLoadFolderDetailsArray.length == 0) {
                    LOG.error((Object)"Delete segment by Id is failed. No matching segment id found.");
                    List<String> list = loadIds;
                    return list;
                }
                SegmentStatusManager.updateDeletionStatus(identifier, loadIds, listOfLoadFolderDetailsArray, invalidLoadIds);
                if (!invalidLoadIds.isEmpty()) {
                    ArrayList<String> arrayList = invalidLoadIds;
                    return arrayList;
                }
                if (carbonTableStatusLock.lockWithRetries()) {
                    LOG.info((Object)"Table status lock has been successfully acquired");
                    LoadMetadataDetails[] latestLoadMetadataDetails = SegmentStatusManager.readLoadMetadata(tableFolderPath);
                    SegmentStatusManager.updateLatestTableStatusDetails(listOfLoadFolderDetailsArray, latestLoadMetadataDetails);
                    SegmentStatusManager.writeLoadDetailsIntoFile(dataLoadLocation, listOfLoadFolderDetailsArray);
                    return invalidLoadIds;
                }
                String errorMsg = "Delete segment by id is failed for " + tableDetails + ". Not able to acquire the table status lock due to other operation running in the background.";
                LOG.error((Object)errorMsg);
                throw new Exception(errorMsg + " Please try after some time.");
            }
            String errorMsg = "Delete segment by id is failed for " + tableDetails + ". Not able to acquire the delete segment lock due to another delete operation is running in the background.";
            LOG.error((Object)errorMsg);
            throw new Exception(errorMsg + " Please try after some time.");
        }
        catch (IOException e) {
            LOG.error((Object)("IOException" + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            CarbonLockUtil.fileUnlock(carbonTableStatusLock, "tablestatus.lock");
            CarbonLockUtil.fileUnlock(carbonDeleteSegmentLock, "delete_segment.lock");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> updateDeletionStatus(AbsoluteTableIdentifier identifier, String loadDate, String tableFolderPath, Long loadStartTime) throws Exception {
        CarbonTableIdentifier carbonTableIdentifier = identifier.getCarbonTableIdentifier();
        ICarbonLock carbonDeleteSegmentLock = CarbonLockFactory.getCarbonLockObj(identifier, "delete_segment.lock");
        ICarbonLock carbonTableStatusLock = CarbonLockFactory.getCarbonLockObj(identifier, "tablestatus.lock");
        String tableDetails = carbonTableIdentifier.getDatabaseName() + "." + carbonTableIdentifier.getTableName();
        ArrayList<String> invalidLoadTimestamps = new ArrayList<String>(0);
        try {
            if (carbonDeleteSegmentLock.lockWithRetries()) {
                LOG.info((Object)"Delete segment lock has been successfully acquired");
                String dataLoadLocation = CarbonTablePath.getTableStatusFilePath(identifier.getTablePath());
                LoadMetadataDetails[] listOfLoadFolderDetailsArray = null;
                if (!FileFactory.isFileExist(dataLoadLocation)) {
                    LOG.warn((Object)"Trying to update table metadata file which is not present.");
                    ArrayList<String> arrayList = invalidLoadTimestamps;
                    return arrayList;
                }
                listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata(tableFolderPath);
                if (listOfLoadFolderDetailsArray.length == 0) {
                    LOG.error((Object)"Delete segment by date is failed. No matching segment found.");
                    invalidLoadTimestamps.add(loadDate);
                    ArrayList<String> arrayList = invalidLoadTimestamps;
                    return arrayList;
                }
                SegmentStatusManager.updateDeletionStatus(identifier, loadDate, listOfLoadFolderDetailsArray, invalidLoadTimestamps, loadStartTime);
                if (!invalidLoadTimestamps.isEmpty()) {
                    ArrayList<String> arrayList = invalidLoadTimestamps;
                    return arrayList;
                }
                if (carbonTableStatusLock.lockWithRetries()) {
                    LOG.info((Object)"Table status lock has been successfully acquired.");
                    LoadMetadataDetails[] latestLoadMetadataDetails = SegmentStatusManager.readLoadMetadata(tableFolderPath);
                    SegmentStatusManager.updateLatestTableStatusDetails(listOfLoadFolderDetailsArray, latestLoadMetadataDetails);
                    SegmentStatusManager.writeLoadDetailsIntoFile(dataLoadLocation, listOfLoadFolderDetailsArray);
                    return invalidLoadTimestamps;
                }
                String errorMsg = "Delete segment by date is failed for " + tableDetails + ". Not able to acquire the table status lock due to other operation running in the background.";
                LOG.error((Object)errorMsg);
                throw new Exception(errorMsg + " Please try after some time.");
            }
            String errorMsg = "Delete segment by date is failed for " + tableDetails + ". Not able to acquire the delete segment lock due to another delete operation is running in the background.";
            LOG.error((Object)errorMsg);
            throw new Exception(errorMsg + " Please try after some time.");
        }
        catch (IOException e) {
            LOG.error((Object)("Error message: IOException" + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            CarbonLockUtil.fileUnlock(carbonTableStatusLock, "tablestatus.lock");
            CarbonLockUtil.fileUnlock(carbonDeleteSegmentLock, "delete_segment.lock");
        }
    }

    private static void backupTableStatus(String tableStatusPath) throws IOException {
        CarbonFile file = FileFactory.getCarbonFile(tableStatusPath);
        if (file.exists()) {
            String backupPath = tableStatusPath + ".backup";
            String currentContent = SegmentStatusManager.readFileAsString(tableStatusPath);
            if (currentContent != null) {
                SegmentStatusManager.writeStringIntoFile(backupPath, currentContent);
            }
        }
    }

    public static void writeLoadDetailsIntoFile(String tableStatusPath, LoadMetadataDetails[] listOfLoadFolderDetailsArray) throws IOException {
        if (tableStatusPath.endsWith("tablestatus") && CarbonProperties.isEnableTableStatusBackup()) {
            SegmentStatusManager.backupTableStatus(tableStatusPath);
        }
        String content = new Gson().toJson((Object)listOfLoadFolderDetailsArray);
        SegmentStatusManager.mockForTest();
        for (LoadMetadataDetails loadMetadataDetails : listOfLoadFolderDetailsArray) {
            loadMetadataDetails.removeUnnecessaryField();
        }
        SegmentStatusManager.writeStringIntoFile(FileFactory.getUpdatedFilePath(tableStatusPath), content);
    }

    private static void mockForTest() {
    }

    private static void writeStringIntoFile(String filePath, String content) throws IOException {
        AtomicFileOperations fileWrite = AtomicFileOperationFactory.getAtomicFileOperations(filePath);
        BufferedWriter brWriter = null;
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = fileWrite.openForWrite(FileWriteOperation.OVERWRITE);
            brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, Charset.forName("UTF-8")));
            brWriter.write(content);
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Write file failed: " + ioe.getLocalizedMessage()));
                fileWrite.setFailed();
                throw ioe;
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(brWriter);
                fileWrite.close();
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(brWriter);
        fileWrite.close();
    }

    private static List<String> updateDeletionStatus(AbsoluteTableIdentifier absoluteTableIdentifier, List<String> loadIds, LoadMetadataDetails[] listOfLoadFolderDetailsArray, List<String> invalidLoadIds) {
        SegmentStatus segmentStatus = null;
        for (String loadId : loadIds) {
            boolean loadFound = false;
            for (LoadMetadataDetails loadMetadata : listOfLoadFolderDetailsArray) {
                if (!loadId.equalsIgnoreCase(loadMetadata.getLoadName())) continue;
                segmentStatus = loadMetadata.getSegmentStatus();
                if (SegmentStatus.COMPACTED == segmentStatus) {
                    LOG.error((Object)("Cannot delete the Segment which is compacted. Segment is " + loadId));
                    invalidLoadIds.add(loadId);
                    return invalidLoadIds;
                }
                if (SegmentStatus.INSERT_IN_PROGRESS == segmentStatus && SegmentStatusManager.isLoadInProgress(absoluteTableIdentifier, loadId).booleanValue()) {
                    LOG.error((Object)("Cannot delete the segment " + loadId + " which is load in progress"));
                    invalidLoadIds.add(loadId);
                    return invalidLoadIds;
                }
                if (SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS == segmentStatus && SegmentStatusManager.isLoadInProgress(absoluteTableIdentifier, loadId).booleanValue()) {
                    LOG.error((Object)("Cannot delete the segment " + loadId + " which is load overwrite in progress"));
                    invalidLoadIds.add(loadId);
                    return invalidLoadIds;
                }
                if (SegmentStatus.STREAMING == segmentStatus) {
                    LOG.error((Object)("Cannot delete the segment " + loadId + " which is streaming in progress"));
                    invalidLoadIds.add(loadId);
                    return invalidLoadIds;
                }
                if (SegmentStatus.MARKED_FOR_DELETE == segmentStatus) break;
                loadFound = true;
                loadMetadata.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                loadMetadata.setModificationOrdeletionTimesStamp(CarbonUpdateUtil.readCurrentTime());
                LOG.info((Object)("Segment ID " + loadId + " Marked for Delete"));
                break;
            }
            if (loadFound) continue;
            LOG.error((Object)("Delete segment by ID is failed. No matching segment id found :" + loadId));
            invalidLoadIds.add(loadId);
            return invalidLoadIds;
        }
        return invalidLoadIds;
    }

    private static List<String> updateDeletionStatus(AbsoluteTableIdentifier absoluteTableIdentifier, String loadDate, LoadMetadataDetails[] listOfLoadFolderDetailsArray, List<String> invalidLoadTimestamps, Long loadStartTime) {
        boolean loadFound = false;
        String loadStartTimeString = "Load Start Time: ";
        SegmentStatus segmentStatus = null;
        for (LoadMetadataDetails loadMetadata : listOfLoadFolderDetailsArray) {
            Integer result = SegmentStatusManager.compareDateValues(loadMetadata.getLoadStartTimeAsLong(), loadStartTime);
            if (result >= 0) continue;
            segmentStatus = loadMetadata.getSegmentStatus();
            if (SegmentStatus.COMPACTED == segmentStatus) {
                LOG.info((Object)("Ignoring the segment : " + loadMetadata.getLoadName() + "as the segment has been compacted."));
                continue;
            }
            if (SegmentStatus.STREAMING == segmentStatus) {
                LOG.info((Object)("Ignoring the segment : " + loadMetadata.getLoadName() + "as the segment is streaming in progress."));
                continue;
            }
            if (SegmentStatus.INSERT_IN_PROGRESS == segmentStatus && SegmentStatusManager.isLoadInProgress(absoluteTableIdentifier, loadMetadata.getLoadName()).booleanValue()) {
                LOG.info((Object)("Ignoring the segment : " + loadMetadata.getLoadName() + "as the segment is insert in progress."));
                continue;
            }
            if (SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS == segmentStatus && SegmentStatusManager.isLoadInProgress(absoluteTableIdentifier, loadMetadata.getLoadName()).booleanValue()) {
                LOG.info((Object)("Ignoring the segment : " + loadMetadata.getLoadName() + "as the segment is insert overwrite in progress."));
                continue;
            }
            if (SegmentStatus.MARKED_FOR_DELETE == segmentStatus) continue;
            loadFound = true;
            SegmentStatusManager.updateSegmentMetadataDetails(loadMetadata);
            LOG.info((Object)("Info: " + loadStartTimeString + loadMetadata.getLoadStartTime() + " Marked for Delete"));
        }
        if (!loadFound) {
            invalidLoadTimestamps.add(loadDate);
            LOG.error((Object)"Delete segment by date is failed. No matching segment found.");
            return invalidLoadTimestamps;
        }
        return invalidLoadTimestamps;
    }

    private static void closeStreams(Closeable ... streams) {
        if (null != streams) {
            for (Closeable stream : streams) {
                if (null == stream) continue;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("Error while closing stream" + stream));
                }
            }
        }
    }

    private static List<LoadMetadataDetails> updateLatestTableStatusDetails(LoadMetadataDetails[] oldMetadata, LoadMetadataDetails[] newMetadata) {
        ArrayList<LoadMetadataDetails> newListMetadata = new ArrayList<LoadMetadataDetails>(Arrays.asList(newMetadata));
        for (LoadMetadataDetails oldSegment : oldMetadata) {
            if (SegmentStatus.MARKED_FOR_DELETE != oldSegment.getSegmentStatus()) continue;
            SegmentStatusManager.updateSegmentMetadataDetails((LoadMetadataDetails)newListMetadata.get(newListMetadata.indexOf(oldSegment)));
        }
        return newListMetadata;
    }

    private static void updateSegmentMetadataDetails(LoadMetadataDetails loadMetadata) {
        if (SegmentStatus.MARKED_FOR_DELETE != loadMetadata.getSegmentStatus()) {
            loadMetadata.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
            loadMetadata.setModificationOrdeletionTimesStamp(CarbonUpdateUtil.readCurrentTime());
        }
    }

    public String getUpdateStatusFileName(LoadMetadataDetails[] segmentList) {
        if (segmentList.length == 0) {
            return "";
        }
        for (LoadMetadataDetails eachSeg : segmentList) {
            if (!eachSeg.getLoadName().equalsIgnoreCase("0")) continue;
            return eachSeg.getUpdateStatusFileName();
        }
        return "";
    }

    public static Boolean isLoadInProgressInTable(CarbonTable carbonTable) {
        if (carbonTable == null) {
            return false;
        }
        boolean loadInProgress = false;
        String metaPath = carbonTable.getMetadataPath();
        LoadMetadataDetails[] listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata(metaPath);
        if (listOfLoadFolderDetailsArray.length != 0) {
            for (LoadMetadataDetails loaddetail : listOfLoadFolderDetailsArray) {
                SegmentStatus segmentStatus = loaddetail.getSegmentStatus();
                if (segmentStatus != SegmentStatus.INSERT_IN_PROGRESS && segmentStatus != SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS) continue;
                loadInProgress = SegmentStatusManager.isLoadInProgress(carbonTable.getAbsoluteTableIdentifier(), loaddetail.getLoadName());
            }
        }
        return loadInProgress;
    }

    public static Boolean isCompactionInProgress(CarbonTable carbonTable) {
        boolean compactionInProgress;
        if (carbonTable == null) {
            return false;
        }
        ICarbonLock lock = CarbonLockFactory.getCarbonLockObj(carbonTable.getAbsoluteTableIdentifier(), "compaction.lock");
        try {
            compactionInProgress = !lock.lockWithRetries(1, 0);
        }
        finally {
            lock.unlock();
        }
        return compactionInProgress;
    }

    public static Boolean isOverwriteInProgressInTable(CarbonTable carbonTable) {
        if (carbonTable == null) {
            return false;
        }
        boolean loadInProgress = false;
        String metaPath = carbonTable.getMetadataPath();
        LoadMetadataDetails[] listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata(metaPath);
        if (listOfLoadFolderDetailsArray.length != 0) {
            for (LoadMetadataDetails loaddetail : listOfLoadFolderDetailsArray) {
                SegmentStatus segmentStatus = loaddetail.getSegmentStatus();
                if (segmentStatus != SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS) continue;
                loadInProgress = SegmentStatusManager.isLoadInProgress(carbonTable.getAbsoluteTableIdentifier(), loaddetail.getLoadName());
            }
        }
        return loadInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isLoadInProgress(AbsoluteTableIdentifier absoluteTableIdentifier, String loadName) {
        ICarbonLock segmentLock = CarbonLockFactory.getCarbonLockObj(absoluteTableIdentifier, CarbonTablePath.addSegmentPrefix(loadName) + ".lock");
        try {
            Boolean bl = !segmentLock.lockWithRetries(1, 0);
            return bl;
        }
        finally {
            segmentLock.unlock();
        }
    }

    private static boolean isLoadDeletionRequired(LoadMetadataDetails[] details) {
        if (details != null && details.length > 0) {
            for (LoadMetadataDetails oneRow : details) {
                if (SegmentStatus.MARKED_FOR_DELETE != oneRow.getSegmentStatus() && SegmentStatus.COMPACTED != oneRow.getSegmentStatus() && SegmentStatus.INSERT_IN_PROGRESS != oneRow.getSegmentStatus() && SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS != oneRow.getSegmentStatus() || !oneRow.getVisibility().equalsIgnoreCase("true")) continue;
                return true;
            }
        }
        return false;
    }

    private static List<LoadMetadataDetails> updateLoadMetadataFromOldToNew(LoadMetadataDetails[] oldList, LoadMetadataDetails[] newList) {
        ArrayList<LoadMetadataDetails> newListMetadata = new ArrayList<LoadMetadataDetails>(Arrays.asList(newList));
        for (LoadMetadataDetails oldSegment : oldList) {
            if (!"false".equalsIgnoreCase(oldSegment.getVisibility())) continue;
            ((LoadMetadataDetails)newListMetadata.get(newListMetadata.indexOf(oldSegment))).setVisibility("false");
        }
        return newListMetadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeLoadMetadata(AbsoluteTableIdentifier identifier, List<LoadMetadataDetails> listOfLoadFolderDetails) throws IOException {
        String dataLoadLocation = CarbonTablePath.getTableStatusFilePath(identifier.getTablePath());
        Gson gsonObjectToWrite = new Gson();
        BufferedWriter brWriter = null;
        AtomicFileOperations writeOperation = AtomicFileOperationFactory.getAtomicFileOperations(dataLoadLocation);
        try {
            DataOutputStream dataOutputStream = writeOperation.openForWrite(FileWriteOperation.OVERWRITE);
            brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, Charset.forName("UTF-8")));
            listOfLoadFolderDetails.forEach(LoadMetadataDetails::removeUnnecessaryField);
            String metadataInstance = gsonObjectToWrite.toJson((Object)listOfLoadFolderDetails.toArray());
            brWriter.write(metadataInstance);
        }
        catch (IOException ie) {
            try {
                LOG.error((Object)("Error message: " + ie.getLocalizedMessage()));
                writeOperation.setFailed();
                throw ie;
            }
            catch (Throwable throwable) {
                try {
                    if (null != brWriter) {
                        brWriter.flush();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"error in  flushing ");
                }
                CarbonUtil.closeStreams(brWriter);
                writeOperation.close();
                throw throwable;
            }
        }
        try {
            if (null != brWriter) {
                brWriter.flush();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error in  flushing ");
        }
        CarbonUtil.closeStreams(brWriter);
        writeOperation.close();
    }

    private static ReturnTuple isUpdationRequired(boolean isForceDeletion, CarbonTable carbonTable, AbsoluteTableIdentifier absoluteTableIdentifier, LoadMetadataDetails[] details) {
        boolean isUpdationRequired = DeleteLoadFolders.deleteLoadFoldersFromFileSystem(absoluteTableIdentifier, isForceDeletion, details, carbonTable.getMetadataPath());
        return new ReturnTuple(details, isUpdationRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLoadsAndUpdateMetadata(CarbonTable carbonTable, boolean isForceDeletion, List<PartitionSpec> partitionSpecs) throws IOException {
        block12: {
            LoadMetadataDetails[] metadataDetails = SegmentStatusManager.readLoadMetadata(carbonTable.getMetadataPath());
            CarbonLockUtil.deleteExpiredSegmentLockFiles(carbonTable);
            if (SegmentStatusManager.isLoadDeletionRequired(metadataDetails)) {
                AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
                boolean updationCompletionStatus = false;
                LoadMetadataDetails[] newAddedLoadHistoryList = null;
                ReturnTuple tuple = SegmentStatusManager.isUpdationRequired(isForceDeletion, carbonTable, identifier, metadataDetails);
                if (tuple.isUpdateRequired) {
                    ICarbonLock carbonTableStatusLock = CarbonLockFactory.getCarbonLockObj(identifier, "tablestatus.lock");
                    boolean locked = false;
                    try {
                        locked = carbonTableStatusLock.lockWithRetries();
                        if (locked) {
                            LOG.info((Object)"Table status lock has been successfully acquired.");
                            LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata(carbonTable.getMetadataPath());
                            ReturnTuple tuple2 = SegmentStatusManager.isUpdationRequired(isForceDeletion, carbonTable, identifier, details);
                            if (!tuple2.isUpdateRequired) {
                                return;
                            }
                            LoadMetadataDetails[] latestMetadata = SegmentStatusManager.readLoadMetadata(carbonTable.getMetadataPath());
                            int invisibleSegmentPreserveCnt = CarbonProperties.getInstance().getInvisibleSegmentPreserveCount();
                            int maxSegmentId = SegmentStatusManager.getMaxSegmentId(tuple2.details);
                            int invisibleSegmentCnt = SegmentStatusManager.countInvisibleSegments(tuple2.details, maxSegmentId);
                            if (isForceDeletion || invisibleSegmentCnt > invisibleSegmentPreserveCnt) {
                                TableStatusReturnTuple tableStatusReturn = SegmentStatusManager.separateVisibleAndInvisibleSegments(tuple2.details, latestMetadata, invisibleSegmentCnt, maxSegmentId);
                                LoadMetadataDetails[] oldLoadHistoryList = SegmentStatusManager.readLoadHistoryMetadata(carbonTable.getMetadataPath());
                                LoadMetadataDetails[] newLoadHistoryList = SegmentStatusManager.appendLoadHistoryList(oldLoadHistoryList, tableStatusReturn.arrayOfLoadHistoryDetails);
                                SegmentStatusManager.writeLoadDetailsIntoFile(CarbonTablePath.getTableStatusFilePath(carbonTable.getTablePath()), tableStatusReturn.arrayOfLoadDetails);
                                SegmentStatusManager.writeLoadDetailsIntoFile(CarbonTablePath.getTableStatusHistoryFilePath(carbonTable.getTablePath()), newLoadHistoryList);
                                newAddedLoadHistoryList = tableStatusReturn.arrayOfLoadHistoryDetails;
                            } else {
                                List<LoadMetadataDetails> latestStatus = SegmentStatusManager.updateLoadMetadataFromOldToNew(tuple2.details, latestMetadata);
                                SegmentStatusManager.writeLoadDetailsIntoFile(CarbonTablePath.getTableStatusFilePath(identifier.getTablePath()), latestStatus.toArray(new LoadMetadataDetails[0]));
                            }
                            updationCompletionStatus = true;
                            break block12;
                        }
                        String dbName = identifier.getCarbonTableIdentifier().getDatabaseName();
                        String tableName = identifier.getCarbonTableIdentifier().getTableName();
                        String errorMsg = "Clean files request is failed for " + dbName + "." + tableName + ". Not able to acquire the table status lock due to other operation running in the background.";
                        LOG.error((Object)errorMsg);
                        throw new IOException(errorMsg + " Please try after some time.");
                    }
                    finally {
                        if (locked) {
                            CarbonLockUtil.fileUnlock(carbonTableStatusLock, "tablestatus.lock");
                        }
                        if (updationCompletionStatus) {
                            DeleteLoadFolders.physicalFactAndMeasureMetadataDeletion(carbonTable, newAddedLoadHistoryList, isForceDeletion, partitionSpecs);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateTable(CarbonTable carbonTable) throws ConcurrentOperationException, IOException {
        block10: {
            ICarbonLock carbonTableStatusLock = CarbonLockFactory.getCarbonLockObj(carbonTable.getAbsoluteTableIdentifier(), "tablestatus.lock");
            boolean locked = false;
            try {
                locked = carbonTableStatusLock.lockWithRetries();
                if (locked) {
                    LoadMetadataDetails[] listOfLoadFolderDetailsArray;
                    LOG.info((Object)"Table status lock has been successfully acquired.");
                    for (LoadMetadataDetails listOfLoadFolderDetails : listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata(CarbonTablePath.getMetadataPath(carbonTable.getTablePath()))) {
                        boolean writing;
                        switch (listOfLoadFolderDetails.getSegmentStatus()) {
                            case INSERT_IN_PROGRESS: 
                            case INSERT_OVERWRITE_IN_PROGRESS: 
                            case STREAMING: {
                                writing = true;
                                break;
                            }
                            default: {
                                writing = false;
                            }
                        }
                        if (!writing) continue;
                        throw new ConcurrentOperationException(carbonTable, "insert", "truncate");
                    }
                    for (LoadMetadataDetails listOfLoadFolderDetails : listOfLoadFolderDetailsArray) {
                        listOfLoadFolderDetails.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                    }
                    SegmentStatusManager.writeLoadDetailsIntoFile(CarbonTablePath.getTableStatusFilePath(carbonTable.getTablePath()), listOfLoadFolderDetailsArray);
                    break block10;
                }
                String dbName = carbonTable.getDatabaseName();
                String tableName = carbonTable.getTableName();
                String errorMsg = "truncate table request is failed for " + dbName + "." + tableName + ". Not able to acquire the table status lock due to other operation running in the background.";
                LOG.error((Object)errorMsg);
                throw new IOException(errorMsg + " Please try after some time.");
            }
            finally {
                if (locked) {
                    CarbonLockUtil.fileUnlock(carbonTableStatusLock, "tablestatus.lock");
                }
            }
        }
    }

    public static int countInvisibleSegments(LoadMetadataDetails[] segmentList, int maxSegmentId) {
        int invisibleSegmentCnt = 0;
        if (segmentList.length != 0) {
            for (LoadMetadataDetails eachSeg : segmentList) {
                if (eachSeg.getLoadName().equalsIgnoreCase("0") || eachSeg.getLoadName().equalsIgnoreCase(String.valueOf(maxSegmentId)) || !eachSeg.getVisibility().equalsIgnoreCase("false")) continue;
                ++invisibleSegmentCnt;
            }
        }
        return invisibleSegmentCnt;
    }

    public static TableStatusReturnTuple separateVisibleAndInvisibleSegments(LoadMetadataDetails[] oldList, LoadMetadataDetails[] newList, int invisibleSegmentCnt, int maxSegmentId) {
        int newSegmentsLength = newList.length;
        int visibleSegmentCnt = newSegmentsLength - invisibleSegmentCnt;
        LoadMetadataDetails[] arrayOfVisibleSegments = new LoadMetadataDetails[visibleSegmentCnt];
        LoadMetadataDetails[] arrayOfInvisibleSegments = new LoadMetadataDetails[invisibleSegmentCnt];
        int oldSegmentsLength = oldList.length;
        int visibleIdx = 0;
        int invisibleIdx = 0;
        for (int i = 0; i < newSegmentsLength; ++i) {
            LoadMetadataDetails newSegment = newList[i];
            if (i < oldSegmentsLength) {
                LoadMetadataDetails oldSegment = oldList[i];
                if (newSegment.getLoadName().equalsIgnoreCase("0") || newSegment.getLoadName().equalsIgnoreCase(String.valueOf(maxSegmentId))) {
                    newSegment.setVisibility(oldSegment.getVisibility());
                    arrayOfVisibleSegments[visibleIdx] = newSegment;
                    ++visibleIdx;
                    continue;
                }
                if ("false".equalsIgnoreCase(oldSegment.getVisibility())) {
                    newSegment.setVisibility("false");
                    arrayOfInvisibleSegments[invisibleIdx] = newSegment;
                    ++invisibleIdx;
                    continue;
                }
                arrayOfVisibleSegments[visibleIdx] = newSegment;
                ++visibleIdx;
                continue;
            }
            arrayOfVisibleSegments[visibleIdx] = newSegment;
            ++visibleIdx;
        }
        return new TableStatusReturnTuple(arrayOfVisibleSegments, arrayOfInvisibleSegments);
    }

    public static LoadMetadataDetails[] appendLoadHistoryList(LoadMetadataDetails[] historyList, LoadMetadataDetails[] appendList) {
        int i;
        int historyListLen = historyList.length;
        int appendListLen = appendList.length;
        int newListLen = historyListLen + appendListLen;
        LoadMetadataDetails[] newList = new LoadMetadataDetails[newListLen];
        int newListIdx = 0;
        for (i = 0; i < historyListLen; ++i) {
            newList[newListIdx] = historyList[i];
            ++newListIdx;
        }
        for (i = 0; i < appendListLen; ++i) {
            newList[newListIdx] = appendList[i];
            ++newListIdx;
        }
        return newList;
    }

    public static LoadMetadataDetails[] readCarbonMetaData(String metadataFolderPath) {
        String metadataFileName = metadataFolderPath + "/" + "tablestatus";
        try {
            LoadMetadataDetails[] allSegments = SegmentStatusManager.readTableStatusFile(metadataFileName);
            ArrayList<LoadMetadataDetails> carbonSegments = new ArrayList<LoadMetadataDetails>();
            for (LoadMetadataDetails currSegment : allSegments) {
                if (!currSegment.isCarbonFormat()) continue;
                carbonSegments.add(currSegment);
            }
            return carbonSegments.toArray(new LoadMetadataDetails[carbonSegments.size()]);
        }
        catch (IOException e) {
            return new LoadMetadataDetails[0];
        }
    }

    private static class TableStatusReturnTuple {
        LoadMetadataDetails[] arrayOfLoadDetails;
        LoadMetadataDetails[] arrayOfLoadHistoryDetails;

        TableStatusReturnTuple(LoadMetadataDetails[] arrayOfLoadDetails, LoadMetadataDetails[] arrayOfLoadHistoryDetails) {
            this.arrayOfLoadDetails = arrayOfLoadDetails;
            this.arrayOfLoadHistoryDetails = arrayOfLoadHistoryDetails;
        }
    }

    private static class ReturnTuple {
        LoadMetadataDetails[] details;
        boolean isUpdateRequired;

        ReturnTuple(LoadMetadataDetails[] details, boolean isUpdateRequired) {
            this.details = details;
            this.isUpdateRequired = isUpdateRequired;
        }
    }

    public static class ValidAndInvalidSegmentsInfo {
        private final List<Segment> listOfValidSegments;
        private final List<Segment> listOfValidUpdatedSegments;
        private final List<Segment> listOfInvalidSegments;
        private final List<Segment> listOfStreamSegments;
        private final List<Segment> listOfInProgressSegments;

        private ValidAndInvalidSegmentsInfo(List<Segment> listOfValidSegments, List<Segment> listOfValidUpdatedSegments, List<Segment> listOfInvalidUpdatedSegments, List<Segment> listOfStreamSegments, List<Segment> listOfInProgressSegments) {
            this.listOfValidSegments = listOfValidSegments;
            this.listOfValidUpdatedSegments = listOfValidUpdatedSegments;
            this.listOfInvalidSegments = listOfInvalidUpdatedSegments;
            this.listOfStreamSegments = listOfStreamSegments;
            this.listOfInProgressSegments = listOfInProgressSegments;
        }

        public List<Segment> getInvalidSegments() {
            return this.listOfInvalidSegments;
        }

        public List<Segment> getValidSegments() {
            return this.listOfValidSegments;
        }

        public List<Segment> getStreamSegments() {
            return this.listOfStreamSegments;
        }

        public List<Segment> getListOfInProgressSegments() {
            return this.listOfInProgressSegments;
        }
    }
}

