/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.statusmanager;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class SegmentUpdateStatusManager {
    private static final Logger LOG = LogServiceFactory.getLogService((String)SegmentUpdateStatusManager.class.getName());
    private final AbsoluteTableIdentifier identifier;
    private LoadMetadataDetails[] segmentDetails;
    private SegmentUpdateDetails[] updateDetails;
    private Map<String, SegmentUpdateDetails> blockAndDetailsMap;
    private boolean isPartitionTable;
    private Map<String, List<String>> segmentDeleteDeltaListMap = new HashMap<String, List<String>>();

    public SegmentUpdateStatusManager(CarbonTable table, LoadMetadataDetails[] segmentDetails) {
        this(table, segmentDetails, null);
    }

    public SegmentUpdateStatusManager(CarbonTable table, LoadMetadataDetails[] segmentDetails, String updateVersion) {
        this.identifier = table.getAbsoluteTableIdentifier();
        this.isPartitionTable = table.isHivePartitionTable();
        this.segmentDetails = segmentDetails;
        this.updateDetails = this.readLoadMetadata();
        this.updateUpdateDetails(updateVersion);
        this.populateMap();
    }

    public SegmentUpdateStatusManager(CarbonTable table) {
        this(table, (String)null);
    }

    public SegmentUpdateStatusManager(CarbonTable table, String updateVersion) {
        this.identifier = table.getAbsoluteTableIdentifier();
        this.segmentDetails = !table.getTableInfo().isTransactionalTable() ? new LoadMetadataDetails[0] : SegmentStatusManager.readLoadMetadata(CarbonTablePath.getMetadataPath(this.identifier.getTablePath()));
        this.isPartitionTable = table.isHivePartitionTable();
        this.updateDetails = this.segmentDetails.length != 0 ? this.readLoadMetadata() : new SegmentUpdateDetails[0];
        this.updateUpdateDetails(updateVersion);
        this.populateMap();
    }

    private void updateUpdateDetails(String updateVersion) {
        if (updateVersion != null) {
            ArrayList<SegmentUpdateDetails> newupdateDetails = new ArrayList<SegmentUpdateDetails>();
            for (SegmentUpdateDetails updateDetail : this.updateDetails) {
                if (updateDetail.getDeltaFileStamps() != null) {
                    if (!updateDetail.getDeltaFileStamps().contains(updateVersion)) continue;
                    HashSet<String> set = new HashSet<String>();
                    set.add(updateVersion);
                    updateDetail.setDeltaFileStamps(set);
                    updateDetail.setSegmentStatus(SegmentStatus.SUCCESS);
                    newupdateDetails.add(updateDetail);
                    continue;
                }
                if (!updateDetail.getDeleteDeltaStartTimestamp().equalsIgnoreCase(updateVersion)) continue;
                updateDetail.setSegmentStatus(SegmentStatus.SUCCESS);
                newupdateDetails.add(updateDetail);
            }
            this.updateDetails = newupdateDetails.toArray(new SegmentUpdateDetails[0]);
        }
    }

    private void populateMap() {
        this.blockAndDetailsMap = new HashMap<String, SegmentUpdateDetails>(16);
        for (SegmentUpdateDetails blockDetails : this.updateDetails) {
            String blockIdentifier = CarbonUpdateUtil.getSegmentBlockNameKey(blockDetails.getSegmentName(), blockDetails.getActualBlockName(), this.isPartitionTable);
            this.blockAndDetailsMap.put(blockIdentifier, blockDetails);
        }
    }

    private SegmentUpdateDetails getDetailsForABlock(String segID, String actualBlockName) {
        String blockIdentifier = CarbonUpdateUtil.getSegmentBlockNameKey(segID, actualBlockName, this.isPartitionTable);
        return this.blockAndDetailsMap.get(blockIdentifier);
    }

    public SegmentUpdateDetails getDetailsForABlock(String key) {
        return this.blockAndDetailsMap.get(key);
    }

    public LoadMetadataDetails[] getLoadMetadataDetails() {
        return this.segmentDetails;
    }

    public SegmentUpdateDetails[] getUpdateStatusDetails() {
        return this.updateDetails;
    }

    public void setUpdateStatusDetails(SegmentUpdateDetails[] segmentUpdateDetails) {
        this.updateDetails = segmentUpdateDetails;
    }

    public ICarbonLock getTableUpdateStatusLock() {
        return CarbonLockFactory.getCarbonLockObj(this.identifier, "tableupdatestatus.lock");
    }

    public List<String> getUpdateDeltaFiles(final String segmentId) {
        CarbonFile[] files;
        ArrayList<String> updatedDeltaFilesList = new ArrayList<String>(16);
        String endTimeStamp = "";
        String startTimeStamp = "";
        String segmentPath = CarbonTablePath.getSegmentPath(this.identifier.getTablePath(), segmentId);
        CarbonFile segDir = FileFactory.getCarbonFile(segmentPath);
        for (LoadMetadataDetails eachSeg : this.segmentDetails) {
            if (!eachSeg.getLoadName().equalsIgnoreCase(segmentId)) continue;
            startTimeStamp = eachSeg.getUpdateDeltaStartTimestamp();
            endTimeStamp = eachSeg.getUpdateDeltaEndTimestamp();
        }
        if (startTimeStamp.isEmpty()) {
            return updatedDeltaFilesList;
        }
        final Long endTimeStampFinal = CarbonUpdateUtil.getTimeStampAsLong(endTimeStamp);
        final Long startTimeStampFinal = CarbonUpdateUtil.getTimeStampAsLong(startTimeStamp);
        for (CarbonFile cfile : files = segDir.listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile pathName) {
                String firstPart;
                long timestamp;
                String fileName = pathName.getName();
                if (fileName.endsWith(".carbondata") && Long.compare(timestamp = Long.parseLong((firstPart = fileName.substring(0, fileName.indexOf(46))).substring(firstPart.lastIndexOf("-") + 1, firstPart.length())), endTimeStampFinal) <= 0 && Long.compare(timestamp, startTimeStampFinal) >= 0) {
                    return SegmentUpdateStatusManager.this.isBlockValid(segmentId, fileName);
                }
                return false;
            }
        })) {
            updatedDeltaFilesList.add(cfile.getCanonicalPath());
        }
        return updatedDeltaFilesList;
    }

    public String[] getDeleteDeltaFilePath(String blockFilePath, String segmentId) {
        return this.getDeltaFiles(blockFilePath, segmentId, ".deletedelta").toArray(new String[0]);
    }

    private List<String> getDeltaFiles(String blockPath, String segment, String extension) {
        Path path = new Path(blockPath);
        String completeBlockName = path.getName();
        String blockNameWithoutExtn = completeBlockName.substring(0, completeBlockName.lastIndexOf(46));
        String blockNameFromTuple = blockNameWithoutExtn.substring(0, blockNameWithoutExtn.lastIndexOf("-"));
        return this.getDeltaFiles(path.getParent().toString(), blockNameFromTuple, extension, segment);
    }

    public List<String> getBlockNameFromSegment(String segmentName) {
        ArrayList<String> blockNames = new ArrayList<String>();
        for (SegmentUpdateDetails block : this.updateDetails) {
            if (!block.getSegmentName().equalsIgnoreCase(segmentName) || CarbonUpdateUtil.isBlockInvalid(block.getSegmentStatus())) continue;
            blockNames.add(block.getBlockName());
        }
        return blockNames;
    }

    public boolean isBlockValid(String segName, String blockName) {
        SegmentUpdateDetails details = this.getDetailsForABlock(segName, blockName);
        return details == null || !CarbonUpdateUtil.isBlockInvalid(details.getSegmentStatus());
    }

    private List<String> getDeltaFiles(String blockDir, String blockNameFromTuple, String extension, String segment) {
        ArrayList<String> deleteFileList = new ArrayList<String>();
        for (SegmentUpdateDetails block : this.updateDetails) {
            if (!block.getBlockName().equalsIgnoreCase(blockNameFromTuple) || !block.getSegmentName().equalsIgnoreCase(segment) || CarbonUpdateUtil.isBlockInvalid(block.getSegmentStatus())) continue;
            long deltaStartTimestamp = this.getStartTimeOfDeltaFile(extension, block);
            if (deltaStartTimestamp == 0L) {
                return deleteFileList;
            }
            long deltaEndTimeStamp = this.getEndTimeOfDeltaFile(extension, block);
            if (block.getDeleteDeltaStartTimestamp().equals(block.getDeleteDeltaEndTimestamp())) {
                deleteFileList.add(blockDir + "/" + block.getBlockName() + "-" + block.getDeleteDeltaStartTimestamp() + extension);
                continue;
            }
            if (block.getDeltaFileStamps() != null && block.getDeltaFileStamps().size() > 0) {
                for (String delta : block.getDeltaFileStamps()) {
                    deleteFileList.add(blockDir + "/" + block.getBlockName() + "-" + delta + extension);
                }
                continue;
            }
            return this.getFilePaths(blockDir, blockNameFromTuple, extension, deleteFileList, deltaStartTimestamp, deltaEndTimeStamp);
        }
        return deleteFileList;
    }

    private List<String> getFilePaths(String blockDir, String blockNameFromTuple, final String extension, List<String> deleteFileList, long deltaStartTimestamp, long deltaEndTimeStamp) {
        List<String> deltaList = this.segmentDeleteDeltaListMap.get(blockDir);
        if (deltaList == null) {
            CarbonFile[] files = FileFactory.getCarbonFile(blockDir).listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile pathName) {
                    String fileName = pathName.getName();
                    return fileName.endsWith(extension) && pathName.getSize() > 0L;
                }
            });
            deltaList = new ArrayList<String>(files.length);
            for (CarbonFile cfile : files) {
                deltaList.add(cfile.getCanonicalPath());
            }
            this.segmentDeleteDeltaListMap.put(blockDir, deltaList);
        }
        for (String deltaFile : deltaList) {
            String deltaFilePathName = new Path(deltaFile).getName();
            String firstPart = deltaFilePathName.substring(0, deltaFilePathName.lastIndexOf(46));
            String blockName = firstPart.substring(0, firstPart.lastIndexOf("-"));
            long timestamp = Long.parseLong(CarbonTablePath.DataFileUtil.getTimeStampFromFileName(deltaFilePathName));
            if (!blockNameFromTuple.equals(blockName) || Long.compare(timestamp, deltaEndTimeStamp) > 0 || Long.compare(timestamp, deltaStartTimestamp) < 0) continue;
            if (null == deleteFileList) {
                deleteFileList = new ArrayList<String>();
            }
            deleteFileList.add(deltaFile);
        }
        return deleteFileList;
    }

    public CarbonFile[] getDeleteDeltaFilesList(Segment segmentId, final String blockName) {
        String segmentPath = CarbonTablePath.getSegmentPath(this.identifier.getTablePath(), segmentId.getSegmentNo());
        CarbonFile segDir = FileFactory.getCarbonFile(segmentPath);
        for (SegmentUpdateDetails block : this.updateDetails) {
            if (!block.getBlockName().equalsIgnoreCase(blockName) || !block.getSegmentName().equalsIgnoreCase(segmentId.getSegmentNo()) || CarbonUpdateUtil.isBlockInvalid(block.getSegmentStatus())) continue;
            final long deltaStartTimestamp = this.getStartTimeOfDeltaFile(".deletedelta", block);
            final long deltaEndTimeStamp = this.getEndTimeOfDeltaFile(".deletedelta", block);
            return segDir.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile pathName) {
                    String fileName = pathName.getName();
                    if (fileName.endsWith(".deletedelta") && pathName.getSize() > 0L) {
                        String firstPart = fileName.substring(0, fileName.indexOf(46));
                        String blkName = firstPart.substring(0, firstPart.lastIndexOf("-"));
                        long timestamp = Long.parseLong(CarbonTablePath.DataFileUtil.getTimeStampFromFileName(fileName));
                        if (blockName.equals(blkName) && Long.compare(timestamp, deltaEndTimeStamp) <= 0 && Long.compare(timestamp, deltaStartTimestamp) >= 0) {
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        return null;
    }

    public CarbonFile[] getUpdateDeltaFilesList(LoadMetadataDetails loadMetadataDetail, boolean validUpdateFiles, String fileExtension, boolean excludeOriginalFact, CarbonFile[] allFilesOfSegment, boolean isAbortedFile) {
        String endTimeStamp = "";
        String startTimeStamp = "";
        long factTimeStamp = 0L;
        startTimeStamp = loadMetadataDetail.getUpdateDeltaStartTimestamp();
        endTimeStamp = loadMetadataDetail.getUpdateDeltaEndTimestamp();
        factTimeStamp = loadMetadataDetail.getLoadStartTime();
        if (startTimeStamp.isEmpty()) {
            return new CarbonFile[0];
        }
        Long endTimeStampFinal = CarbonUpdateUtil.getTimeStampAsLong(endTimeStamp);
        Long startTimeStampFinal = CarbonUpdateUtil.getTimeStampAsLong(startTimeStamp);
        long factTimeStampFinal = factTimeStamp;
        ArrayList<CarbonFile> listOfCarbonFiles = new ArrayList<CarbonFile>(16);
        for (CarbonFile eachFile : allFilesOfSegment) {
            String fileName = eachFile.getName();
            if (!fileName.endsWith(fileExtension)) continue;
            long timestamp = Long.parseLong(CarbonTablePath.DataFileUtil.getTimeStampFromFileName(fileName));
            if (excludeOriginalFact && Long.compare(factTimeStampFinal, timestamp) == 0) continue;
            if (validUpdateFiles) {
                if (Long.compare(timestamp, endTimeStampFinal) > 0 || Long.compare(timestamp, startTimeStampFinal) < 0) continue;
                listOfCarbonFiles.add(eachFile);
                continue;
            }
            if (isAbortedFile) {
                if (Long.compare(timestamp, endTimeStampFinal) <= 0) continue;
                listOfCarbonFiles.add(eachFile);
                continue;
            }
            if (Long.compare(timestamp, startTimeStampFinal) >= 0 && Long.compare(timestamp, endTimeStampFinal) <= 0) continue;
            listOfCarbonFiles.add(eachFile);
        }
        return listOfCarbonFiles.toArray(new CarbonFile[listOfCarbonFiles.size()]);
    }

    public CarbonFile[] getUpdateDeltaFilesForSegment(String segmentId, boolean validUpdateFiles, String fileExtension, boolean excludeOriginalFact, CarbonFile[] allFilesOfSegment) {
        String endTimeStamp = "";
        String startTimeStamp = "";
        long factTimeStamp = 0L;
        for (LoadMetadataDetails eachSeg : this.segmentDetails) {
            if (!eachSeg.getLoadName().equalsIgnoreCase(segmentId)) continue;
            startTimeStamp = eachSeg.getUpdateDeltaStartTimestamp();
            endTimeStamp = eachSeg.getUpdateDeltaEndTimestamp();
            factTimeStamp = eachSeg.getLoadStartTime();
        }
        if (startTimeStamp.isEmpty()) {
            return new CarbonFile[0];
        }
        Long endTimeStampFinal = CarbonUpdateUtil.getTimeStampAsLong(endTimeStamp);
        Long startTimeStampFinal = CarbonUpdateUtil.getTimeStampAsLong(startTimeStamp);
        long factTimeStampFinal = factTimeStamp;
        ArrayList<CarbonFile> listOfCarbonFiles = new ArrayList<CarbonFile>(16);
        for (CarbonFile eachFile : allFilesOfSegment) {
            String fileName = eachFile.getName();
            if (!fileName.endsWith(fileExtension)) continue;
            String firstPart = fileName.substring(0, fileName.indexOf(46));
            long timestamp = Long.parseLong(firstPart.substring(firstPart.lastIndexOf("-") + 1, firstPart.length()));
            if (excludeOriginalFact && Long.compare(factTimeStampFinal, timestamp) == 0) continue;
            if (validUpdateFiles) {
                if (Long.compare(timestamp, endTimeStampFinal) > 0 || Long.compare(timestamp, startTimeStampFinal) < 0) continue;
                boolean validBlock = true;
                for (SegmentUpdateDetails blockDetails : this.getUpdateStatusDetails()) {
                    if (!blockDetails.getActualBlockName().equalsIgnoreCase(eachFile.getName()) || !CarbonUpdateUtil.isBlockInvalid(blockDetails.getSegmentStatus())) continue;
                    validBlock = false;
                }
                if (!validBlock) continue;
                listOfCarbonFiles.add(eachFile);
                continue;
            }
            if (Long.compare(timestamp, startTimeStampFinal) >= 0) continue;
            listOfCarbonFiles.add(eachFile);
        }
        return listOfCarbonFiles.toArray(new CarbonFile[listOfCarbonFiles.size()]);
    }

    private long getStartTimeOfDeltaFile(String extension, SegmentUpdateDetails block) {
        long startTimestamp;
        switch (extension) {
            case ".deletedelta": {
                startTimestamp = block.getDeleteDeltaStartTimeAsLong();
                break;
            }
            default: {
                startTimestamp = 0L;
            }
        }
        return startTimestamp;
    }

    private long getEndTimeOfDeltaFile(String extension, SegmentUpdateDetails block) {
        long endTimestamp;
        switch (extension) {
            case ".deletedelta": {
                endTimestamp = block.getDeleteDeltaEndTimeAsLong();
                break;
            }
            default: {
                endTimestamp = 0L;
            }
        }
        return endTimestamp;
    }

    public SegmentUpdateDetails[] readLoadMetadata() {
        String tableUpdateStatusIdentifier = this.getUpdatedStatusIdentifier();
        return SegmentUpdateStatusManager.readLoadMetadata(tableUpdateStatusIdentifier, this.identifier.getTablePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SegmentUpdateDetails[] readLoadMetadata(String tableUpdateStatusIdentifier, String tablePath) {
        SegmentUpdateDetails[] listOfSegmentUpdateDetailsArray;
        AtomicFileOperations fileOperation;
        InputStreamReader inStream;
        BufferedReader buffReader;
        DataInputStream dataInputStream;
        Gson gsonObjectToRead;
        block6: {
            gsonObjectToRead = new Gson();
            dataInputStream = null;
            buffReader = null;
            inStream = null;
            if (StringUtils.isEmpty((CharSequence)tableUpdateStatusIdentifier)) {
                return new SegmentUpdateDetails[0];
            }
            String tableUpdateStatusPath = CarbonTablePath.getMetadataPath(tablePath) + "/" + tableUpdateStatusIdentifier;
            fileOperation = AtomicFileOperationFactory.getAtomicFileOperations(tableUpdateStatusPath);
            if (FileFactory.isFileExist(tableUpdateStatusPath)) break block6;
            SegmentUpdateDetails[] segmentUpdateDetailsArray = new SegmentUpdateDetails[]{};
            SegmentUpdateStatusManager.closeStreams(buffReader, inStream, dataInputStream);
            return segmentUpdateDetailsArray;
        }
        try {
            dataInputStream = fileOperation.openForRead();
            inStream = new InputStreamReader((InputStream)dataInputStream, "UTF-8");
            buffReader = new BufferedReader(inStream);
            listOfSegmentUpdateDetailsArray = (SegmentUpdateDetails[])gsonObjectToRead.fromJson((Reader)buffReader, SegmentUpdateDetails[].class);
        }
        catch (IOException e) {
            SegmentUpdateDetails[] segmentUpdateDetailsArray;
            try {
                segmentUpdateDetailsArray = new SegmentUpdateDetails[]{};
            }
            catch (Throwable throwable) {
                SegmentUpdateStatusManager.closeStreams(buffReader, inStream, dataInputStream);
                throw throwable;
            }
            SegmentUpdateStatusManager.closeStreams(buffReader, inStream, dataInputStream);
            return segmentUpdateDetailsArray;
        }
        SegmentUpdateStatusManager.closeStreams(buffReader, inStream, dataInputStream);
        return listOfSegmentUpdateDetailsArray;
    }

    private String getUpdatedStatusIdentifier() {
        if (this.segmentDetails.length == 0) {
            return null;
        }
        return this.segmentDetails[0].getUpdateStatusFileName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeLoadDetailsIntoFile(List<SegmentUpdateDetails> listOfSegmentUpdateDetailsArray, String updateStatusFileIdentifier) throws IOException {
        BufferedWriter brWriter;
        AtomicFileOperations fileWrite;
        block5: {
            String fileLocation = CarbonTablePath.getMetadataPath(this.identifier.getTablePath()) + "/" + CarbonUpdateUtil.getUpdateStatusFileName(updateStatusFileIdentifier);
            fileWrite = AtomicFileOperationFactory.getAtomicFileOperations(fileLocation);
            brWriter = null;
            DataOutputStream dataOutputStream = null;
            Gson gsonObjectToWrite = new Gson();
            try {
                dataOutputStream = fileWrite.openForWrite(FileWriteOperation.OVERWRITE);
                brWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dataOutputStream, "UTF-8"));
                String metadataInstance = gsonObjectToWrite.toJson(listOfSegmentUpdateDetailsArray);
                brWriter.write(metadataInstance);
                if (null == brWriter) break block5;
            }
            catch (IOException ioe) {
                try {
                    LOG.error((Object)("Error message: " + ioe.getLocalizedMessage()));
                    fileWrite.setFailed();
                    throw ioe;
                }
                catch (Throwable throwable) {
                    if (null != brWriter) {
                        brWriter.flush();
                    }
                    CarbonUtil.closeStreams(brWriter);
                    fileWrite.close();
                    throw throwable;
                }
            }
            brWriter.flush();
        }
        CarbonUtil.closeStreams(brWriter);
        fileWrite.close();
    }

    private static void closeStreams(Closeable ... streams) {
        if (null != streams) {
            for (Closeable stream : streams) {
                if (null == stream) continue;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("Error while closing stream" + stream));
                }
            }
        }
    }

    public static UpdateVO getInvalidTimestampRange(LoadMetadataDetails loadMetadataDetails) {
        UpdateVO range = new UpdateVO();
        if (loadMetadataDetails != null) {
            range.setSegmentId(loadMetadataDetails.getLoadName());
            range.setFactTimestamp(loadMetadataDetails.getLoadStartTime());
            if (!loadMetadataDetails.getUpdateDeltaStartTimestamp().isEmpty() && !loadMetadataDetails.getUpdateDeltaEndTimestamp().isEmpty()) {
                range.setUpdateDeltaStartTimestamp(CarbonUpdateUtil.getTimeStampAsLong(loadMetadataDetails.getUpdateDeltaStartTimestamp()));
                range.setLatestUpdateTimestamp(CarbonUpdateUtil.getTimeStampAsLong(loadMetadataDetails.getUpdateDeltaEndTimestamp()));
            }
        }
        return range;
    }

    public CarbonFile[] getDeleteDeltaInvalidFilesList(SegmentUpdateDetails block, boolean needCompleteList, CarbonFile[] allSegmentFiles, boolean isAbortedFile) {
        long deltaStartTimestamp = this.getStartTimeOfDeltaFile(".deletedelta", block);
        long deltaEndTimestamp = this.getEndTimeOfDeltaFile(".deletedelta", block);
        HashSet<CarbonFile> files = new HashSet<CarbonFile>(16);
        for (CarbonFile eachFile : allSegmentFiles) {
            String fileName = eachFile.getName();
            if (!fileName.endsWith(".deletedelta")) continue;
            String blkName = CarbonTablePath.DataFileUtil.getBlockNameFromDeleteDeltaFile(fileName);
            if (needCompleteList && block.getBlockName().equalsIgnoreCase(blkName)) {
                files.add(eachFile);
            }
            long timestamp = CarbonUpdateUtil.getTimeStampAsLong(CarbonTablePath.DataFileUtil.getTimeStampFromDeleteDeltaFile(fileName));
            if (!block.getBlockName().equalsIgnoreCase(blkName)) continue;
            if (isAbortedFile) {
                if (Long.compare(timestamp, deltaEndTimestamp) <= 0) continue;
                files.add(eachFile);
                continue;
            }
            if (Long.compare(timestamp, deltaStartTimestamp) >= 0 && Long.compare(timestamp, deltaEndTimestamp) <= 0) continue;
            files.add(eachFile);
        }
        return files.toArray(new CarbonFile[files.size()]);
    }
}

