/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.statusmanager;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.hadoop.mapreduce.InputSplit;

public class StageInput {
    private String base;
    private Map<String, Long> files;
    private List<PartitionLocation> locations;

    public StageInput() {
    }

    public StageInput(String base, Map<String, Long> files) {
        this.base = base;
        this.files = files;
    }

    public StageInput(String base, List<PartitionLocation> locations) {
        this.base = base;
        this.locations = locations;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public Map<String, Long> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, Long> files) {
        this.files = files;
    }

    public List<PartitionLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(List<PartitionLocation> locations) {
        this.locations = locations;
    }

    public List<InputSplit> createSplits() {
        return this.files.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(".carbondata")).map(entry -> CarbonInputSplit.from("-1", "0", this.base + "/" + (String)entry.getKey(), 0L, (Long)entry.getValue(), ColumnarFormatVersion.V3, null)).collect(Collectors.toList());
    }

    public static final class PartitionLocation {
        private Map<String, String> partitions;
        private Map<String, Long> files;

        public PartitionLocation() {
        }

        public PartitionLocation(Map<String, String> partitions, Map<String, Long> files) {
            this.partitions = partitions;
            this.files = files;
        }

        public Map<String, String> getPartitions() {
            return this.partitions;
        }

        public void setPartitions(Map<String, String> partitions) {
            this.partitions = partitions;
        }

        public Map<String, Long> getFiles() {
            return this.files;
        }

        public void setFiles(Map<String, Long> files) {
            this.files = files;
        }
    }
}

