/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.statusmanager;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.statusmanager.StageInput;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.log4j.Logger;

public class StageInputCollector {
    private static Logger LOGGER = LogServiceFactory.getLogService((String)StageInputCollector.class.getCanonicalName());

    public static List<InputSplit> createInputSplits(CarbonTable table, Configuration hadoopConf) throws ExecutionException, InterruptedException {
        LinkedList<CarbonFile> stageInputFiles = new LinkedList<CarbonFile>();
        LinkedList<CarbonFile> successFiles = new LinkedList<CarbonFile>();
        StageInputCollector.collectStageFiles(table, hadoopConf, stageInputFiles, successFiles);
        if (stageInputFiles.size() > 0) {
            int numThreads = Math.min(Math.max(stageInputFiles.size(), 1), 10);
            ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
            return StageInputCollector.createInputSplits(executorService, stageInputFiles);
        }
        return new ArrayList<InputSplit>(0);
    }

    public static void collectStageFiles(CarbonTable table, Configuration hadoopConf, List<CarbonFile> stageInputList, List<CarbonFile> successFileList) {
        Objects.requireNonNull(table);
        Objects.requireNonNull(hadoopConf);
        Objects.requireNonNull(stageInputList);
        Objects.requireNonNull(successFileList);
        CarbonFile dir = FileFactory.getCarbonFile(table.getStagePath(), hadoopConf);
        if (dir.exists()) {
            CarbonFile[] allFiles = dir.listFiles();
            HashMap map = new HashMap();
            Arrays.stream(allFiles).filter(file -> file.getName().endsWith(".success")).forEach(file -> map.put(file.getName().substring(0, file.getName().indexOf(".")), file));
            Arrays.stream(allFiles).filter(file -> !file.getName().endsWith(".success")).filter(file -> map.containsKey(file.getName())).forEach(carbonFile -> {
                stageInputList.add((CarbonFile)carbonFile);
                successFileList.add((CarbonFile)map.get(carbonFile.getName()));
            });
        }
    }

    public static List<InputSplit> createInputSplits(ExecutorService executorService, List<CarbonFile> stageFiles) throws ExecutionException, InterruptedException {
        Objects.requireNonNull(executorService);
        Objects.requireNonNull(stageFiles);
        long startTime = System.currentTimeMillis();
        List<InputSplit> output = Collections.synchronizedList(new ArrayList());
        Gson gson = new Gson();
        List futures = stageFiles.stream().map(stageFile -> executorService.submit(() -> {
            Boolean bl;
            String filePath = stageFile.getAbsolutePath();
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(FileFactory.getDataInputStream(filePath));
                StageInput stageInput = (StageInput)gson.fromJson((Reader)reader, StageInput.class);
                output.addAll(stageInput.createSplits());
                bl = true;
            }
            catch (IOException e) {
                Boolean bl2;
                try {
                    LOGGER.error((Object)("failed to read stage file " + filePath));
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
                return bl2;
            }
            IOUtils.closeQuietly((Reader)reader);
            return bl;
        })).collect(Collectors.toList());
        for (Future future : futures) {
            future.get();
        }
        LOGGER.info((Object)("read stage files taken " + (System.currentTimeMillis() - startTime) + "ms"));
        return output;
    }
}

