/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.stream;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.stream.StreamFile;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.BlockIndex;

@InterfaceAudience.Internal
public class StreamPruner {
    private CarbonTable carbonTable;
    private FilterExecuter filterExecuter;
    private int totalFileNums = 0;

    public StreamPruner(CarbonTable carbonTable) {
        this.carbonTable = carbonTable;
    }

    public void init(FilterResolverIntf filterExp) {
        if (filterExp != null) {
            ArrayList<CarbonColumn> minMaxCacheColumns = new ArrayList<CarbonColumn>();
            for (CarbonDimension dimension : this.carbonTable.getVisibleDimensions()) {
                if (dimension.isComplex().booleanValue()) continue;
                minMaxCacheColumns.add(dimension);
            }
            minMaxCacheColumns.addAll(this.carbonTable.getVisibleMeasures());
            List<ColumnSchema> listOfColumns = this.carbonTable.getTableInfo().getFactTable().getListOfColumns();
            SegmentProperties segmentProperties = new SegmentProperties(listOfColumns);
            this.filterExecuter = FilterUtil.getFilterExecuterTree(filterExp, segmentProperties, null, minMaxCacheColumns, false);
        }
    }

    public List<StreamFile> prune(List<Segment> segments) throws IOException {
        if (this.filterExecuter == null) {
            return this.listAllStreamFiles(segments, false);
        }
        ArrayList<StreamFile> streamFileList = new ArrayList<StreamFile>();
        for (StreamFile streamFile : this.listAllStreamFiles(segments, true)) {
            if (!this.isScanRequire(streamFile)) continue;
            streamFileList.add(streamFile);
            streamFile.setMinMaxIndex(null);
        }
        return streamFileList;
    }

    private boolean isScanRequire(StreamFile streamFile) {
        byte[][] minValue;
        if (streamFile.getMinMaxIndex() == null) {
            return true;
        }
        byte[][] maxValue = streamFile.getMinMaxIndex().getMaxValues();
        BitSet bitSet = this.filterExecuter.isScanRequired(maxValue, minValue = streamFile.getMinMaxIndex().getMinValues(), streamFile.getMinMaxIndex().getIsMinMaxSet());
        return !bitSet.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StreamFile> listAllStreamFiles(List<Segment> segments, boolean withMinMax) throws IOException {
        ArrayList<StreamFile> streamFileList = new ArrayList<StreamFile>();
        for (Segment segment : segments) {
            String segmentDir = CarbonTablePath.getSegmentPath(this.carbonTable.getAbsoluteTableIdentifier().getTablePath(), segment.getSegmentNo());
            String indexFile = CarbonTablePath.getCarbonStreamIndexFilePath(segmentDir);
            if (!FileFactory.isFileExist(indexFile)) continue;
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            indexReader.openThriftReader(indexFile);
            try {
                while (indexReader.hasNext()) {
                    BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                    String filePath = segmentDir + File.separator + blockIndex.getFile_name();
                    long length = blockIndex.getFile_size();
                    StreamFile streamFile = new StreamFile(segment.getSegmentNo(), filePath, length);
                    streamFileList.add(streamFile);
                    if (!withMinMax || blockIndex.getBlock_index() == null || blockIndex.getBlock_index().getMin_max_index() == null) continue;
                    streamFile.setMinMaxIndex(CarbonMetadataUtil.convertExternalMinMaxIndex(blockIndex.getBlock_index().getMin_max_index()));
                }
            }
            finally {
                indexReader.closeThriftReader();
            }
        }
        this.totalFileNums = streamFileList.size();
        return streamFileList;
    }

    public int getTotalFileNums() {
        return this.totalFileNums;
    }
}

