/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataFileFooterConverterV3;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.format.BlockletBTreeIndex;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.Encoding;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.format.ParentColumnTableRelation;
import org.apache.hadoop.conf.Configuration;

public abstract class AbstractDataFileFooterConverter {
    protected Configuration configuration;

    AbstractDataFileFooterConverter(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataFileFooter> getIndexInfo(String filePath, List<TableBlockInfo> tableBlockInfoList) throws IOException {
        CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
        ArrayList<DataFileFooter> dataFileFooters = new ArrayList<DataFileFooter>();
        try {
            indexReader.openThriftReader(filePath);
            IndexHeader readIndexHeader = indexReader.readIndexHeader();
            ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
            List table_columns = readIndexHeader.getTable_columns();
            for (int i = 0; i < table_columns.size(); ++i) {
                columnSchemaList.add(this.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)table_columns.get(i)));
            }
            org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex blockletIndex = null;
            int counter = 0;
            int index = 0;
            DataFileFooter dataFileFooter = null;
            while (indexReader.hasNext()) {
                BlockIndex readBlockIndexInfo = indexReader.readBlockIndexInfo();
                blockletIndex = this.getBlockletIndex(readBlockIndexInfo.getBlock_index());
                dataFileFooter = new DataFileFooter();
                TableBlockInfo tableBlockInfo = tableBlockInfoList.get(index);
                if (Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo(tableBlockInfo.getFilePath())) != counter++) continue;
                tableBlockInfo.setBlockOffset(readBlockIndexInfo.getOffset());
                tableBlockInfo.setVersion(ColumnarFormatVersion.valueOf((short)readIndexHeader.getVersion()));
                dataFileFooter.setBlockletIndex(blockletIndex);
                dataFileFooter.setColumnInTable(columnSchemaList);
                dataFileFooter.setNumberOfRows(readBlockIndexInfo.getNum_rows());
                dataFileFooter.setBlockInfo(tableBlockInfo);
                if (readIndexHeader.isSetIs_sort()) {
                    dataFileFooter.setSorted(readIndexHeader.isIs_sort());
                } else if (tableBlockInfo.getVersion() == ColumnarFormatVersion.V3) {
                    dataFileFooter.setSorted(null);
                }
                dataFileFooters.add(dataFileFooter);
                if (++index != tableBlockInfoList.size()) continue;
                break;
            }
        }
        finally {
            indexReader.closeThriftReader();
        }
        return dataFileFooters;
    }

    public List<DataFileFooter> getIndexInfo(String filePath, byte[] fileData) throws IOException {
        return this.getIndexInfo(filePath, fileData, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataFileFooter> getIndexInfo(String filePath, byte[] fileData, boolean isTransactionalTable) throws IOException {
        CarbonIndexFileReader indexReader = new CarbonIndexFileReader(this.configuration);
        ArrayList<DataFileFooter> dataFileFooters = new ArrayList<DataFileFooter>();
        String formattedPath = filePath.replace("\\", "/");
        String parentPath = formattedPath.substring(0, formattedPath.lastIndexOf("/"));
        try {
            if (fileData != null) {
                indexReader.openThriftReader(fileData);
            } else {
                indexReader.openThriftReader(filePath);
            }
            IndexHeader readIndexHeader = indexReader.readIndexHeader();
            ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
            List table_columns = readIndexHeader.getTable_columns();
            for (int i = 0; i < table_columns.size(); ++i) {
                columnSchemaList.add(this.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)table_columns.get(i)));
            }
            if (!isTransactionalTable) {
                QueryUtil.updateColumnUniqueIdForNonTransactionTable(columnSchemaList);
            }
            org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex blockletIndex = null;
            DataFileFooter dataFileFooter = null;
            while (indexReader.hasNext()) {
                BlockIndex readBlockIndexInfo = indexReader.readBlockIndexInfo();
                blockletIndex = this.getBlockletIndex(readBlockIndexInfo.getBlock_index());
                dataFileFooter = new DataFileFooter();
                TableBlockInfo tableBlockInfo = this.getTableBlockInfo(readBlockIndexInfo, readIndexHeader, parentPath);
                dataFileFooter.setBlockletIndex(blockletIndex);
                dataFileFooter.setColumnInTable(columnSchemaList);
                dataFileFooter.setNumberOfRows(readBlockIndexInfo.getNum_rows());
                dataFileFooter.setBlockInfo(tableBlockInfo);
                dataFileFooter.setVersionId(tableBlockInfo.getVersion());
                if (readIndexHeader.isSetSchema_time_stamp()) {
                    dataFileFooter.setSchemaUpdatedTimeStamp(readIndexHeader.getSchema_time_stamp());
                }
                if (readBlockIndexInfo.isSetBlocklet_info()) {
                    ArrayList<BlockletInfo> blockletInfoList = new ArrayList<BlockletInfo>();
                    BlockletInfo blockletInfo = new DataFileFooterConverterV3(this.configuration).getBlockletInfo(readBlockIndexInfo.getBlocklet_info(), CarbonUtil.getNumberOfDimensionColumns(columnSchemaList));
                    blockletInfo.setBlockletIndex(blockletIndex);
                    blockletInfoList.add(blockletInfo);
                    dataFileFooter.setBlockletList(blockletInfoList);
                }
                dataFileFooters.add(dataFileFooter);
            }
        }
        finally {
            indexReader.closeThriftReader();
        }
        return dataFileFooters;
    }

    public TableBlockInfo getTableBlockInfo(BlockIndex readBlockIndexInfo, IndexHeader readIndexHeader, String parentPath) {
        TableBlockInfo tableBlockInfo = new TableBlockInfo();
        tableBlockInfo.setBlockOffset(readBlockIndexInfo.getOffset());
        ColumnarFormatVersion version = ColumnarFormatVersion.valueOf((short)readIndexHeader.getVersion());
        tableBlockInfo.setVersion(version);
        String fileName = readBlockIndexInfo.file_name;
        if (fileName.lastIndexOf("/") > 0) {
            fileName = fileName.substring(fileName.lastIndexOf("/"));
        }
        fileName = ("/" + fileName).replaceAll("//", "/");
        tableBlockInfo.setFilePath(parentPath + fileName);
        if (readBlockIndexInfo.isSetFile_size()) {
            tableBlockInfo.setFileSize(readBlockIndexInfo.getFile_size());
        }
        return tableBlockInfo;
    }

    public abstract DataFileFooter readDataFileFooter(TableBlockInfo var1) throws IOException;

    public abstract List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> getSchema(TableBlockInfo var1) throws IOException;

    protected org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex getBlockletIndexForDataFileFooter(List<org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex> blockletIndexList) {
        org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex blockletIndex = new org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex();
        org.apache.carbondata.core.metadata.blocklet.index.BlockletBTreeIndex blockletBTreeIndex = new org.apache.carbondata.core.metadata.blocklet.index.BlockletBTreeIndex();
        blockletBTreeIndex.setStartKey(blockletIndexList.get(0).getBtreeIndex().getStartKey());
        blockletBTreeIndex.setEndKey(blockletIndexList.get(blockletIndexList.size() - 1).getBtreeIndex().getEndKey());
        blockletIndex.setBtreeIndex(blockletBTreeIndex);
        byte[][] currentMinValue = (byte[][])blockletIndexList.get(0).getMinMaxIndex().getMinValues().clone();
        byte[][] currentMaxValue = (byte[][])blockletIndexList.get(0).getMinMaxIndex().getMaxValues().clone();
        byte[][] minValue = null;
        byte[][] maxValue = null;
        boolean[] blockletMinMaxFlag = null;
        boolean[] blockMinMaxFlag = blockletIndexList.get(0).getMinMaxIndex().getIsMinMaxSet();
        for (int i = 1; i < blockletIndexList.size(); ++i) {
            minValue = blockletIndexList.get(i).getMinMaxIndex().getMinValues();
            maxValue = blockletIndexList.get(i).getMinMaxIndex().getMaxValues();
            blockletMinMaxFlag = blockletIndexList.get(i).getMinMaxIndex().getIsMinMaxSet();
            for (int j = 0; j < maxValue.length; ++j) {
                if (null != blockletMinMaxFlag && !blockletMinMaxFlag[j]) {
                    blockMinMaxFlag[j] = blockletMinMaxFlag[j];
                    currentMaxValue[j] = new byte[0];
                    currentMinValue[j] = new byte[0];
                    continue;
                }
                if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(currentMinValue[j], minValue[j]) > 0) {
                    currentMinValue[j] = (byte[])minValue[j].clone();
                }
                if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(currentMaxValue[j], maxValue[j]) >= 0) continue;
                currentMaxValue[j] = (byte[])maxValue[j].clone();
            }
        }
        if (null == blockMinMaxFlag) {
            blockMinMaxFlag = new boolean[currentMaxValue.length];
            Arrays.fill(blockMinMaxFlag, true);
        }
        BlockletMinMaxIndex minMax = new BlockletMinMaxIndex();
        minMax.setMaxValues(currentMaxValue);
        minMax.setMinValues(currentMinValue);
        minMax.setIsMinMaxSet(blockMinMaxFlag);
        blockletIndex.setMinMaxIndex(minMax);
        return blockletIndex;
    }

    protected org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema thriftColumnSchemaToWrapperColumnSchema(ColumnSchema externalColumnSchema) {
        org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema = new org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema();
        wrapperColumnSchema.setColumnUniqueId(externalColumnSchema.getColumn_id());
        wrapperColumnSchema.setColumnName(externalColumnSchema.getColumn_name());
        DataType dataType = CarbonUtil.thriftDataTypeToWrapperDataType(externalColumnSchema.data_type);
        if (DataTypes.isDecimal(dataType)) {
            DecimalType decimalType = (DecimalType)dataType;
            decimalType.setPrecision(externalColumnSchema.getPrecision());
            decimalType.setScale(externalColumnSchema.getScale());
        }
        wrapperColumnSchema.setDataType(dataType);
        wrapperColumnSchema.setDimensionColumn(externalColumnSchema.isDimension());
        ArrayList<org.apache.carbondata.core.metadata.encoder.Encoding> encoders = new ArrayList<org.apache.carbondata.core.metadata.encoder.Encoding>();
        for (Encoding encoder : externalColumnSchema.getEncoders()) {
            encoders.add(this.fromExternalToWrapperEncoding(encoder));
        }
        wrapperColumnSchema.setEncodingList(encoders);
        wrapperColumnSchema.setNumberOfChild(externalColumnSchema.getNum_child());
        wrapperColumnSchema.setPrecision(externalColumnSchema.getPrecision());
        wrapperColumnSchema.setScale(externalColumnSchema.getScale());
        wrapperColumnSchema.setDefaultValue(externalColumnSchema.getDefault_value());
        Map properties = externalColumnSchema.getColumnProperties();
        if (properties != null && properties.get("sort_columns") != null) {
            wrapperColumnSchema.setSortColumn(true);
        }
        wrapperColumnSchema.setSpatialColumn(externalColumnSchema.isSpatialColumn());
        wrapperColumnSchema.setFunction(externalColumnSchema.getAggregate_function());
        List parentColumnTableRelation = externalColumnSchema.getParentColumnTableRelations();
        if (null != parentColumnTableRelation) {
            wrapperColumnSchema.setParentColumnTableRelations(this.fromThriftToWrapperParentTableColumnRelations(parentColumnTableRelation));
        }
        return wrapperColumnSchema;
    }

    private List<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> fromThriftToWrapperParentTableColumnRelations(List<ParentColumnTableRelation> thirftParentColumnRelation) {
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> parentColumnTableRelationList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation>();
        for (ParentColumnTableRelation carbonTableRelation : thirftParentColumnRelation) {
            RelationIdentifier relationIdentifier = new RelationIdentifier(carbonTableRelation.getRelationIdentifier().getDatabaseName(), carbonTableRelation.getRelationIdentifier().getTableName(), carbonTableRelation.getRelationIdentifier().getTableId());
            org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation parentColumnTableRelation = new org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation(relationIdentifier, carbonTableRelation.getColumnId(), carbonTableRelation.getColumnName());
            parentColumnTableRelationList.add(parentColumnTableRelation);
        }
        return parentColumnTableRelationList;
    }

    protected org.apache.carbondata.core.metadata.encoder.Encoding fromExternalToWrapperEncoding(Encoding encoderThrift) {
        switch (encoderThrift) {
            case DICTIONARY: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DICTIONARY;
            }
            case DELTA: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DELTA;
            }
            case RLE: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.RLE;
            }
            case INVERTED_INDEX: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.INVERTED_INDEX;
            }
            case BIT_PACKED: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.BIT_PACKED;
            }
            case DIRECT_DICTIONARY: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DIRECT_DICTIONARY;
            }
        }
        throw new IllegalArgumentException(encoderThrift.toString() + " is not supported");
    }

    protected org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex getBlockletIndex(BlockletIndex blockletIndexThrift) {
        BlockletBTreeIndex btreeIndex = blockletIndexThrift.getB_tree_index();
        org.apache.carbondata.format.BlockletMinMaxIndex minMaxIndex = blockletIndexThrift.getMin_max_index();
        List<Object> isMinMaxSet = null;
        if (minMaxIndex.isSetMin_max_presence()) {
            isMinMaxSet = minMaxIndex.getMin_max_presence();
        } else {
            Object[] minMaxFlag = new Boolean[minMaxIndex.getMax_values().size()];
            Arrays.fill(minMaxFlag, (Object)true);
            isMinMaxSet = Arrays.asList(minMaxFlag);
        }
        return new org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex(new org.apache.carbondata.core.metadata.blocklet.index.BlockletBTreeIndex(btreeIndex.getStart_key(), btreeIndex.getEnd_key()), new BlockletMinMaxIndex(minMaxIndex.getMin_values(), minMaxIndex.getMax_values(), isMinMaxSet));
    }
}

