/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.util.BitSet;

public class BitSetGroup {
    private BitSet[] bitSets;

    public BitSetGroup(int groupSize) {
        this.bitSets = new BitSet[groupSize];
    }

    public void setBitSet(BitSet bitSet, int index) {
        assert (index < this.bitSets.length);
        this.bitSets[index] = bitSet;
    }

    public BitSet getBitSet(int index) {
        assert (index < this.bitSets.length);
        return this.bitSets[index];
    }

    public boolean isEmpty() {
        for (BitSet bitSet : this.bitSets) {
            if (bitSet == null || bitSet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void and(BitSetGroup group) {
        int i = 0;
        for (BitSet bitSet : this.bitSets) {
            BitSet otherSet = group.getBitSet(i);
            if (bitSet != null && otherSet != null) {
                bitSet.and(otherSet);
            } else {
                this.bitSets[i] = null;
            }
            ++i;
        }
    }

    public void or(BitSetGroup group) {
        int i = 0;
        for (BitSet bitSet : this.bitSets) {
            BitSet otherSet = group.getBitSet(i);
            if (bitSet != null && otherSet != null) {
                bitSet.or(otherSet);
            }
            if (bitSet == null && otherSet != null) {
                this.bitSets[i] = otherSet;
            }
            ++i;
        }
    }

    public int getNumberOfPages() {
        return this.bitSets.length;
    }

    public int getValidPages() {
        int numberOfPages = 0;
        for (int i = 0; i < this.bitSets.length; ++i) {
            numberOfPages += this.bitSets[i] != null && !this.bitSets[i].isEmpty() ? 1 : 0;
        }
        return numberOfPages;
    }

    public int getScannedPages() {
        int numberOfPages = 0;
        for (int i = 0; i < this.bitSets.length; ++i) {
            numberOfPages += this.bitSets[i] == null ? 0 : 1;
        }
        return numberOfPages;
    }
}

