/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.filesystem.AbstractDFSCarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.S3CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.BlockMetaInfo;
import org.apache.carbondata.core.indexstore.TableBlockIndexUniqueIdentifier;
import org.apache.carbondata.core.indexstore.TableBlockIndexUniqueIdentifierWrapper;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexInputSplit;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.DataFileFooterConverter;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class BlockletIndexUtil {
    private static final Logger LOG = LogServiceFactory.getLogService((String)BlockletIndexUtil.class.getName());

    public static Set<TableBlockIndexUniqueIdentifier> getSegmentUniqueIdentifiers(Segment segment) throws IOException {
        HashSet<TableBlockIndexUniqueIdentifier> set = new HashSet<TableBlockIndexUniqueIdentifier>();
        set.add(new TableBlockIndexUniqueIdentifier(segment.getSegmentNo()));
        return set;
    }

    public static Map<String, BlockMetaInfo> getBlockMetaInfoMap(TableBlockIndexUniqueIdentifierWrapper identifierWrapper, SegmentIndexFileStore indexFileStore, Set<String> filesRead, Map<String, BlockMetaInfo> fileNameToMetaInfoMapping, List<DataFileFooter> indexInfos) throws IOException {
        CarbonFile indexMergeFile;
        boolean isTransactionalTable = true;
        TableBlockIndexUniqueIdentifier identifier = identifierWrapper.getTableBlockIndexUniqueIdentifier();
        List<ColumnSchema> tableColumnList = null;
        if (identifier.getMergeIndexFileName() != null && indexFileStore.getFileData(identifier.getIndexFileName()) == null && (indexMergeFile = FileFactory.getCarbonFile(identifier.getIndexFilePath() + "/" + identifier.getMergeIndexFileName(), identifierWrapper.getConfiguration())).exists() && !filesRead.contains(indexMergeFile.getPath())) {
            indexFileStore.readAllIIndexOfSegment(new CarbonFile[]{indexMergeFile});
            filesRead.add(indexMergeFile.getPath());
        }
        if (indexFileStore.getFileData(identifier.getIndexFileName()) == null) {
            indexFileStore.readAllIIndexOfSegment(new CarbonFile[]{FileFactory.getCarbonFile(identifier.getIndexFilePath() + "/" + identifier.getIndexFileName(), identifierWrapper.getConfiguration())});
        }
        HashMap<String, BlockMetaInfo> blockMetaInfoMap = new HashMap<String, BlockMetaInfo>();
        CarbonTable carbonTable = identifierWrapper.getCarbonTable();
        if (carbonTable != null) {
            isTransactionalTable = carbonTable.getTableInfo().isTransactionalTable();
            tableColumnList = carbonTable.getTableInfo().getFactTable().getListOfColumns();
        }
        DataFileFooterConverter fileFooterConverter = new DataFileFooterConverter(identifierWrapper.getConfiguration());
        List<DataFileFooter> indexInfo = fileFooterConverter.getIndexInfo(identifier.getIndexFilePath() + "/" + identifier.getIndexFileName(), indexFileStore.getFileData(identifier.getIndexFileName()), isTransactionalTable);
        indexInfos.addAll(indexInfo);
        for (DataFileFooter footer : indexInfo) {
            BlockMetaInfo blockMetaInfo;
            String blockPath;
            if (!isTransactionalTable && tableColumnList.size() != 0 && !BlockletIndexUtil.isSameColumnAndDifferentDatatypeInSchema(footer.getColumnInTable(), tableColumnList)) {
                LOG.error((Object)("Datatype of the common columns present in " + identifier.getIndexFileName() + " doesn't match with the column's datatype in table schema"));
                throw new IOException("All common columns present in the files doesn't have same datatype. Unsupported operation on nonTransactional table. Check logs.");
            }
            if (tableColumnList != null && tableColumnList.size() == 0) {
                carbonTable.getTableInfo().getFactTable().setListOfColumns(footer.getColumnInTable());
                CarbonTable.updateTableByTableInfo(carbonTable, carbonTable.getTableInfo());
            }
            if (null != blockMetaInfoMap.get(blockPath = footer.getBlockInfo().getFilePath()) || null == (blockMetaInfo = BlockletIndexUtil.createBlockMetaInfo(fileNameToMetaInfoMapping, footer.getBlockInfo()))) continue;
            blockMetaInfoMap.put(blockPath, blockMetaInfo);
        }
        return blockMetaInfoMap;
    }

    public static Map<String, BlockMetaInfo> createCarbonDataFileBlockMetaInfoMapping(String segmentFilePath, Configuration configuration) throws IOException {
        TreeMap<String, BlockMetaInfo> fileNameToMetaInfoMapping = new TreeMap<String, BlockMetaInfo>();
        CarbonFile carbonFile = FileFactory.getCarbonFile(segmentFilePath, configuration);
        if (carbonFile instanceof AbstractDFSCarbonFile && !(carbonFile instanceof S3CarbonFile)) {
            CarbonFile[] carbonFiles;
            PathFilter pathFilter = new PathFilter(){

                public boolean accept(Path path) {
                    return CarbonTablePath.isCarbonDataFile(path.getName());
                }
            };
            for (CarbonFile file : carbonFiles = carbonFile.locationAwareListFiles(pathFilter)) {
                String[] location = file.getLocations();
                long len = file.getSize();
                BlockMetaInfo blockMetaInfo = new BlockMetaInfo(location, len);
                fileNameToMetaInfoMapping.put(file.getPath(), blockMetaInfo);
            }
        }
        return fileNameToMetaInfoMapping;
    }

    private static BlockMetaInfo createBlockMetaInfo(Map<String, BlockMetaInfo> fileNameToMetaInfoMapping, TableBlockInfo blockInfo) throws IOException {
        String carbonDataFile = blockInfo.getFilePath();
        FileFactory.FileType fileType = FileFactory.getFileType(carbonDataFile);
        switch (fileType) {
            case S3: 
            case LOCAL: {
                if (blockInfo.getFileSize() != 0L) {
                    return new BlockMetaInfo(new String[]{"localhost"}, blockInfo.getFileSize());
                }
                if (!FileFactory.isFileExist(carbonDataFile)) {
                    return null;
                }
                CarbonFile carbonFile = FileFactory.getCarbonFile(carbonDataFile);
                return new BlockMetaInfo(new String[]{"localhost"}, carbonFile.getSize());
            }
        }
        return fileNameToMetaInfoMapping.get(FileFactory.getFormattedPath(carbonDataFile));
    }

    public static Set<TableBlockIndexUniqueIdentifier> getTableBlockUniqueIdentifiers(Segment segment) throws IOException {
        HashSet<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers = new HashSet<TableBlockIndexUniqueIdentifier>();
        Map<String, String> indexFiles = segment.getCommittedIndexFile();
        for (Map.Entry<String, String> indexFileEntry : indexFiles.entrySet()) {
            String indexFile = indexFileEntry.getKey();
            tableBlockIndexUniqueIdentifiers.add(new TableBlockIndexUniqueIdentifier(FilenameUtils.getFullPathNoEndSeparator((String)indexFile), FilenameUtils.getName((String)indexFile), indexFileEntry.getValue(), segment.getSegmentNo()));
        }
        return tableBlockIndexUniqueIdentifiers;
    }

    public static TableBlockIndexUniqueIdentifier filterIdentifiersBasedOnDistributable(Set<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers, BlockletIndexInputSplit distributable) {
        TableBlockIndexUniqueIdentifier validIdentifier = null;
        String fileName = CarbonTablePath.DataFileUtil.getFileName(distributable.getFilePath());
        for (TableBlockIndexUniqueIdentifier tableBlockIndexUniqueIdentifier : tableBlockIndexUniqueIdentifiers) {
            if (!fileName.equals(tableBlockIndexUniqueIdentifier.getIndexFileName())) continue;
            validIdentifier = tableBlockIndexUniqueIdentifier;
            break;
        }
        return validIdentifier;
    }

    public static List<TableBlockIndexUniqueIdentifier> getIndexFileIdentifiersFromMergeFile(TableBlockIndexUniqueIdentifier identifier, SegmentIndexFileStore segmentIndexFileStore) throws IOException {
        ArrayList<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers = new ArrayList<TableBlockIndexUniqueIdentifier>();
        String mergeFilePath = identifier.getIndexFilePath() + "/" + identifier.getIndexFileName();
        segmentIndexFileStore.readMergeFile(mergeFilePath);
        List<String> indexFiles = segmentIndexFileStore.getCarbonMergeFileToIndexFilesMap().get(mergeFilePath);
        for (String indexFile : indexFiles) {
            tableBlockIndexUniqueIdentifiers.add(new TableBlockIndexUniqueIdentifier(identifier.getIndexFilePath(), indexFile, identifier.getIndexFileName(), identifier.getSegmentId()));
        }
        return tableBlockIndexUniqueIdentifiers;
    }

    public static boolean isCacheLevelBlock(CarbonTable carbonTable) {
        String cacheLevel = carbonTable.getTableInfo().getFactTable().getTableProperties().get("cache_level");
        return !"BLOCKLET".equals(cacheLevel);
    }

    public static boolean isSameColumnAndDifferentDatatypeInSchema(List<ColumnSchema> indexFileColumnList, List<ColumnSchema> tableColumnList) throws IOException {
        for (int i = 0; i < tableColumnList.size(); ++i) {
            for (int j = 0; j < indexFileColumnList.size(); ++j) {
                if (!indexFileColumnList.get(j).getColumnName().equalsIgnoreCase(tableColumnList.get(i).getColumnName()) || indexFileColumnList.get(j).getDataType().getName().equalsIgnoreCase(tableColumnList.get(i).getDataType().getName())) continue;
                if ("varchar".equalsIgnoreCase(indexFileColumnList.get(j).getDataType().getName()) && "string".equalsIgnoreCase(tableColumnList.get(i).getDataType().getName())) {
                    throw new IOException("Datatype of the Column " + indexFileColumnList.get(j).getDataType().getName() + " present in index file, is varchar and not same as datatype of the column with same name present in table, because carbon convert varchar of carbon to string of spark, please set long_string_columns for varchar column: " + tableColumnList.get(i).getColumnName());
                }
                LOG.error((Object)("Datatype of the Column " + indexFileColumnList.get(j).getColumnName() + " present in index file, is not same as datatype of the column with same namepresent in table"));
                return false;
            }
        }
        return true;
    }

    public static byte[] convertSchemaToBinary(List<ColumnSchema> columnSchemas) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(stream);
        dataOutput.writeShort(columnSchemas.size());
        for (ColumnSchema columnSchema : columnSchemas) {
            if (columnSchema.getColumnReferenceId() == null) {
                columnSchema.setColumnReferenceId(columnSchema.getColumnUniqueId());
            }
            columnSchema.write(dataOutput);
        }
        byte[] byteArray = stream.toByteArray();
        ByteBuffer byteBuffer = CompressorFactory.NativeSupportedCompressor.SNAPPY.getCompressor().compressByte(byteArray);
        return byteBuffer.array();
    }

    public static List<ColumnSchema> readColumnSchema(byte[] schemaArray) throws IOException {
        schemaArray = CompressorFactory.NativeSupportedCompressor.SNAPPY.getCompressor().unCompressByte(schemaArray);
        ByteArrayInputStream schemaStream = new ByteArrayInputStream(schemaArray);
        DataInputStream schemaInput = new DataInputStream(schemaStream);
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        int size = schemaInput.readShort();
        for (int i = 0; i < size; ++i) {
            ColumnSchema columnSchema = new ColumnSchema();
            columnSchema.readFields(schemaInput);
            columnSchemas.add(columnSchema);
        }
        return columnSchemas;
    }

    public static byte[][] getMinMaxForColumnsToBeCached(SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, byte[][] minMaxValuesForAllColumns) {
        Object minMaxValuesForColumnsToBeCached = minMaxValuesForAllColumns;
        if (null != minMaxCacheColumns) {
            minMaxValuesForColumnsToBeCached = new byte[minMaxCacheColumns.size()][];
            int counter = 0;
            for (CarbonColumn column : minMaxCacheColumns) {
                minMaxValuesForColumnsToBeCached[counter++] = minMaxValuesForAllColumns[BlockletIndexUtil.getColumnOrdinal(segmentProperties, column)];
            }
        }
        return minMaxValuesForColumnsToBeCached;
    }

    public static boolean[] getMinMaxFlagValuesForColumnsToBeCached(SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, boolean[] minMaxFlag) {
        boolean[] minMaxFlagValuesForColumnsToBeCached = minMaxFlag;
        if (null != minMaxCacheColumns) {
            minMaxFlagValuesForColumnsToBeCached = new boolean[minMaxCacheColumns.size()];
            int counter = 0;
            for (CarbonColumn column : minMaxCacheColumns) {
                minMaxFlagValuesForColumnsToBeCached[counter++] = minMaxFlag[BlockletIndexUtil.getColumnOrdinal(segmentProperties, column)];
            }
        }
        return minMaxFlagValuesForColumnsToBeCached;
    }

    public static int getColumnOrdinal(SegmentProperties segmentProperties, CarbonColumn column) {
        if (column.isMeasure().booleanValue()) {
            return segmentProperties.getLastDimensionColOrdinal() + column.getOrdinal();
        }
        return column.getOrdinal();
    }

    public static boolean useMinMaxForBlockletPruning(FilterResolverIntf filterResolverTree, List<CarbonColumn> minMaxCacheColumns) {
        boolean serializeMinMax = false;
        if (null != minMaxCacheColumns) {
            HashSet<CarbonDimension> filterDimensions = new HashSet<CarbonDimension>();
            HashSet<CarbonMeasure> filterMeasures = new HashSet<CarbonMeasure>();
            QueryUtil.getAllFilterDimensionsAndMeasures(filterResolverTree, filterDimensions, filterMeasures);
            if (minMaxCacheColumns.size() < filterDimensions.size() + filterMeasures.size()) {
                serializeMinMax = true;
            } else {
                for (CarbonDimension filterDimension : filterDimensions) {
                    if (filterDimension.isComplex().booleanValue() || BlockletIndexUtil.filterColumnExistsInMinMaxColumnList(minMaxCacheColumns, filterDimension)) continue;
                    serializeMinMax = true;
                    break;
                }
                if (!serializeMinMax) {
                    for (CarbonMeasure filterMeasure : filterMeasures) {
                        if (BlockletIndexUtil.filterColumnExistsInMinMaxColumnList(minMaxCacheColumns, filterMeasure)) continue;
                        serializeMinMax = true;
                        break;
                    }
                }
            }
        }
        return serializeMinMax;
    }

    private static boolean filterColumnExistsInMinMaxColumnList(List<CarbonColumn> minMaxCacheColumns, CarbonColumn filterColumn) {
        for (CarbonColumn column : minMaxCacheColumns) {
            if (!filterColumn.getColumnId().equalsIgnoreCase(column.getColumnId())) continue;
            return true;
        }
        return false;
    }

    public static void updateMinMaxFlag(BlockletMinMaxIndex minMaxIndex, boolean[] minMaxFlag) {
        boolean[] isMinMaxSet = minMaxIndex.getIsMinMaxSet();
        if (null != isMinMaxSet) {
            for (int i = 0; i < minMaxFlag.length; ++i) {
                if (isMinMaxSet[i]) continue;
                minMaxFlag[i] = isMinMaxSet[i];
            }
        }
    }

    public static boolean loadIndexesParallel(CarbonTable carbonTable) {
        String parentTableName = carbonTable.getParentTableName();
        String tableName = !parentTableName.isEmpty() ? parentTableName : carbonTable.getTableName();
        String dbName = carbonTable.getDatabaseName();
        return CarbonProperties.getInstance().isIndexParallelLoadingEnabled(dbName, tableName);
    }
}

