/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.LoadStatistics;
import org.apache.log4j.Logger;

public class CarbonLoadStatisticsImpl
implements LoadStatistics {
    private static CarbonLoadStatisticsImpl carbonLoadStatisticsImplInstance = new CarbonLoadStatisticsImpl();
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonLoadStatisticsImpl.class.getName());
    private long loadCsvfilesToDfStartTime = 0L;
    private long loadCsvfilesToDfCostTime = 0L;
    private long dicShuffleAndWriteFileTotalStartTime = 0L;
    private double lruCacheLoadTime = 0.0;
    private ConcurrentHashMap<String, Long[]> parDictionaryValuesTotalTimeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long[]> parCsvInputStepTimeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long[]> parGeneratingDictionaryValuesTimeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long[]> parSortRowsStepTotalTimeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long[]> parMdkGenerateTotalTimeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long[]> parDictionaryValue2MdkAdd2FileTime = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> hostBlockMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> partitionBlockMap = new ConcurrentHashMap();
    private long totalRecords = 0L;
    private double totalTime = 0.0;

    private CarbonLoadStatisticsImpl() {
    }

    public static CarbonLoadStatisticsImpl getInstance() {
        return carbonLoadStatisticsImplInstance;
    }

    @Override
    public void initPartitionInfo(String PartitionId) {
        this.parDictionaryValuesTotalTimeMap.put(PartitionId, new Long[2]);
        this.parCsvInputStepTimeMap.put(PartitionId, new Long[2]);
        this.parSortRowsStepTotalTimeMap.put(PartitionId, new Long[2]);
        this.parGeneratingDictionaryValuesTimeMap.put(PartitionId, new Long[2]);
        this.parMdkGenerateTotalTimeMap.put(PartitionId, new Long[2]);
        this.parDictionaryValue2MdkAdd2FileTime.put(PartitionId, new Long[2]);
    }

    @Override
    public void recordDicShuffleAndWriteTime() {
        long dicShuffleAndWriteTimePoint = System.currentTimeMillis();
        if (0L == this.dicShuffleAndWriteFileTotalStartTime) {
            this.dicShuffleAndWriteFileTotalStartTime = dicShuffleAndWriteTimePoint;
        }
    }

    @Override
    public void recordLoadCsvfilesToDfTime() {
        long loadCsvfilesToDfTimePoint = System.currentTimeMillis();
        if (0L == this.loadCsvfilesToDfStartTime) {
            this.loadCsvfilesToDfStartTime = loadCsvfilesToDfTimePoint;
        }
        if (loadCsvfilesToDfTimePoint - this.loadCsvfilesToDfStartTime > this.loadCsvfilesToDfCostTime) {
            this.loadCsvfilesToDfCostTime = loadCsvfilesToDfTimePoint - this.loadCsvfilesToDfStartTime;
        }
    }

    public double getLruCacheLoadTime() {
        return this.lruCacheLoadTime;
    }

    @Override
    public void recordDictionaryValuesTotalTime(String partitionID, Long dictionaryValuesTotalTimeTimePoint) {
        if (null != this.parDictionaryValuesTotalTimeMap.get(partitionID)) {
            if (null == this.parDictionaryValuesTotalTimeMap.get(partitionID)[0]) {
                this.parDictionaryValuesTotalTimeMap.get((Object)partitionID)[0] = dictionaryValuesTotalTimeTimePoint;
            }
            if (null == this.parDictionaryValuesTotalTimeMap.get(partitionID)[1] || dictionaryValuesTotalTimeTimePoint - this.parDictionaryValuesTotalTimeMap.get(partitionID)[0] > this.parDictionaryValuesTotalTimeMap.get(partitionID)[1]) {
                this.parDictionaryValuesTotalTimeMap.get((Object)partitionID)[1] = dictionaryValuesTotalTimeTimePoint - this.parDictionaryValuesTotalTimeMap.get(partitionID)[0];
            }
        }
    }

    @Override
    public void recordCsvInputStepTime(String partitionID, Long csvInputStepTimePoint) {
        if (null != this.parCsvInputStepTimeMap.get(partitionID)) {
            if (null == this.parCsvInputStepTimeMap.get(partitionID)[0]) {
                this.parCsvInputStepTimeMap.get((Object)partitionID)[0] = csvInputStepTimePoint;
            }
            if (null == this.parCsvInputStepTimeMap.get(partitionID)[1] || csvInputStepTimePoint - this.parCsvInputStepTimeMap.get(partitionID)[0] > this.parCsvInputStepTimeMap.get(partitionID)[1]) {
                this.parCsvInputStepTimeMap.get((Object)partitionID)[1] = csvInputStepTimePoint - this.parCsvInputStepTimeMap.get(partitionID)[0];
            }
        }
    }

    @Override
    public void recordLruCacheLoadTime(double lruCacheLoadTime) {
        this.lruCacheLoadTime = lruCacheLoadTime;
    }

    @Override
    public void recordGeneratingDictionaryValuesTime(String partitionID, Long generatingDictionaryValuesTimePoint) {
        if (null != this.parGeneratingDictionaryValuesTimeMap.get(partitionID)) {
            if (null == this.parGeneratingDictionaryValuesTimeMap.get(partitionID)[0]) {
                this.parGeneratingDictionaryValuesTimeMap.get((Object)partitionID)[0] = generatingDictionaryValuesTimePoint;
            }
            if (null == this.parGeneratingDictionaryValuesTimeMap.get(partitionID)[1] || generatingDictionaryValuesTimePoint - this.parGeneratingDictionaryValuesTimeMap.get(partitionID)[0] > this.parGeneratingDictionaryValuesTimeMap.get(partitionID)[1]) {
                this.parGeneratingDictionaryValuesTimeMap.get((Object)partitionID)[1] = generatingDictionaryValuesTimePoint - this.parGeneratingDictionaryValuesTimeMap.get(partitionID)[0];
            }
        }
    }

    @Override
    public void recordSortRowsStepTotalTime(String partitionID, Long sortRowsStepTotalTimePoint) {
        if (null != this.parSortRowsStepTotalTimeMap.get(partitionID)) {
            if (null == this.parSortRowsStepTotalTimeMap.get(partitionID)[0]) {
                this.parSortRowsStepTotalTimeMap.get((Object)partitionID)[0] = sortRowsStepTotalTimePoint;
            }
            if (null == this.parSortRowsStepTotalTimeMap.get(partitionID)[1] || sortRowsStepTotalTimePoint - this.parSortRowsStepTotalTimeMap.get(partitionID)[0] > this.parSortRowsStepTotalTimeMap.get(partitionID)[1]) {
                this.parSortRowsStepTotalTimeMap.get((Object)partitionID)[1] = sortRowsStepTotalTimePoint - this.parSortRowsStepTotalTimeMap.get(partitionID)[0];
            }
        }
    }

    @Override
    public void recordMdkGenerateTotalTime(String partitionID, Long mdkGenerateTotalTimePoint) {
        if (null != this.parMdkGenerateTotalTimeMap.get(partitionID)) {
            if (null == this.parMdkGenerateTotalTimeMap.get(partitionID)[0]) {
                this.parMdkGenerateTotalTimeMap.get((Object)partitionID)[0] = mdkGenerateTotalTimePoint;
            }
            if (null == this.parMdkGenerateTotalTimeMap.get(partitionID)[1] || mdkGenerateTotalTimePoint - this.parMdkGenerateTotalTimeMap.get(partitionID)[0] > this.parMdkGenerateTotalTimeMap.get(partitionID)[1]) {
                this.parMdkGenerateTotalTimeMap.get((Object)partitionID)[1] = mdkGenerateTotalTimePoint - this.parMdkGenerateTotalTimeMap.get(partitionID)[0];
            }
        }
    }

    @Override
    public void recordDictionaryValue2MdkAdd2FileTime(String partitionID, Long dictionaryValue2MdkAdd2FileTimePoint) {
        if (null != this.parDictionaryValue2MdkAdd2FileTime.get(partitionID)) {
            if (null == this.parDictionaryValue2MdkAdd2FileTime.get(partitionID)[0]) {
                this.parDictionaryValue2MdkAdd2FileTime.get((Object)partitionID)[0] = dictionaryValue2MdkAdd2FileTimePoint;
            }
            if (null == this.parDictionaryValue2MdkAdd2FileTime.get(partitionID)[1] || dictionaryValue2MdkAdd2FileTimePoint - this.parDictionaryValue2MdkAdd2FileTime.get(partitionID)[0] > this.parDictionaryValue2MdkAdd2FileTime.get(partitionID)[1]) {
                this.parDictionaryValue2MdkAdd2FileTime.get((Object)partitionID)[1] = dictionaryValue2MdkAdd2FileTimePoint - this.parDictionaryValue2MdkAdd2FileTime.get(partitionID)[0];
            }
        }
    }

    @Override
    public void recordHostBlockMap(String host, Integer numBlocks) {
        this.hostBlockMap.put(host, numBlocks);
    }

    @Override
    public void recordPartitionBlockMap(String partitionID, Integer numBlocks) {
        this.partitionBlockMap.put(partitionID, numBlocks);
    }

    @Override
    public void recordTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    private double getLoadCsvfilesToDfTime() {
        return (double)this.loadCsvfilesToDfCostTime / 1000.0;
    }

    private double getDictionaryValuesTotalTime(String partitionID) {
        return (double)this.parDictionaryValuesTotalTimeMap.get(partitionID)[1].longValue() / 1000.0;
    }

    private double getCsvInputStepTime(String partitionID) {
        return (double)this.parCsvInputStepTimeMap.get(partitionID)[1].longValue() / 1000.0;
    }

    private double getGeneratingDictionaryValuesTime(String partitionID) {
        return (double)this.parGeneratingDictionaryValuesTimeMap.get(partitionID)[1].longValue() / 1000.0;
    }

    private double getSortRowsStepTotalTime(String partitionID) {
        return (double)this.parSortRowsStepTotalTimeMap.get(partitionID)[1].longValue() / 1000.0;
    }

    private double getDictionaryValue2MdkAdd2FileTime(String partitionID) {
        return (double)this.parDictionaryValue2MdkAdd2FileTime.get(partitionID)[1].longValue() / 1000.0;
    }

    private ConcurrentHashMap<String, Integer> getHostBlockMap() {
        return this.hostBlockMap;
    }

    private ConcurrentHashMap<String, Integer> getPartitionBlockMap() {
        return this.partitionBlockMap;
    }

    private long getTotalRecords() {
        return this.totalRecords;
    }

    private int getLoadSpeed() {
        return (int)((double)this.totalRecords / this.totalTime);
    }

    private int getReadCSVSpeed(String partitionID) {
        return (int)((double)this.totalRecords / this.getCsvInputStepTime(partitionID));
    }

    private int getGenSurKeySpeed(String partitionID) {
        return (int)((double)this.totalRecords / this.getGeneratingDictionaryValuesTime(partitionID));
    }

    private int getSortKeySpeed(String partitionID) {
        return (int)((double)this.totalRecords / this.getSortRowsStepTotalTime(partitionID));
    }

    private int getMDKSpeed(String partitionID) {
        return (int)((double)this.totalRecords / this.getDictionaryValue2MdkAdd2FileTime(partitionID));
    }

    private double getTotalTime(String partitionID) {
        this.totalTime = this.getLoadCsvfilesToDfTime() + this.getLruCacheLoadTime() + this.getDictionaryValuesTotalTime(partitionID) + this.getDictionaryValue2MdkAdd2FileTime(partitionID);
        return this.totalTime;
    }

    private void printDicGenStatisticsInfo() {
        double loadCsvfilesToDfTime = this.getLoadCsvfilesToDfTime();
        LOGGER.info((Object)("STAGE 1 ->Load csv to DataFrame and generate block distinct values: " + loadCsvfilesToDfTime + "(s)"));
    }

    private void printLruCacheLoadTimeInfo() {
        LOGGER.info((Object)("STAGE 2 ->LRU cache load: " + this.getLruCacheLoadTime() + "(s)"));
    }

    private void printDictionaryValuesGenStatisticsInfo(String partitionID) {
        double dictionaryValuesTotalTime = this.getDictionaryValuesTotalTime(partitionID);
        LOGGER.info((Object)("STAGE 3 ->Total cost of gen dictionary values, sort and write to temp files: " + dictionaryValuesTotalTime + "(s)"));
        double csvInputStepTime = this.getCsvInputStepTime(partitionID);
        double generatingDictionaryValuesTime = this.getGeneratingDictionaryValuesTime(partitionID);
        LOGGER.info((Object)("STAGE 3.1 ->  |_read csv file: " + csvInputStepTime + "(s)"));
        LOGGER.info((Object)("STAGE 3.2 ->  |_transform to surrogate key: " + generatingDictionaryValuesTime + "(s)"));
    }

    private void printSortRowsStepStatisticsInfo(String partitionID) {
        double sortRowsStepTotalTime = this.getSortRowsStepTotalTime(partitionID);
        LOGGER.info((Object)("STAGE 3.3 ->  |_sort rows and write to temp file: " + sortRowsStepTotalTime + "(s)"));
    }

    private void printGenMdkStatisticsInfo(String partitionID) {
        double dictionaryValue2MdkAdd2FileTime = this.getDictionaryValue2MdkAdd2FileTime(partitionID);
        LOGGER.info((Object)("STAGE 4 ->Transform to MDK, compress and write fact files: " + dictionaryValue2MdkAdd2FileTime + "(s)"));
    }

    private void printHostBlockMapInfo() {
        block3: {
            block2: {
                LOGGER.info((Object)"========== BLOCK_INFO ==========");
                if (this.getHostBlockMap().size() <= 0) break block2;
                for (String host : this.getHostBlockMap().keySet()) {
                    LOGGER.info((Object)("BLOCK_INFO ->Node host: " + host));
                    LOGGER.info((Object)("BLOCK_INFO ->The block count in this node: " + this.getHostBlockMap().get(host)));
                }
                break block3;
            }
            if (this.getPartitionBlockMap().size() <= 0) break block3;
            for (String parID : this.getPartitionBlockMap().keySet()) {
                LOGGER.info((Object)("BLOCK_INFO ->Partition ID: " + parID));
                LOGGER.info((Object)("BLOCK_INFO ->The block count in this partition: " + this.getPartitionBlockMap().get(parID)));
            }
        }
    }

    private void printLoadSpeedInfo(String partitionID) {
        LOGGER.info((Object)"===============Load_Speed_Info===============");
        LOGGER.info((Object)("Total Num of Records Processed: " + this.getTotalRecords()));
        LOGGER.info((Object)("Total Time Cost: " + this.getTotalTime(partitionID) + "(s)"));
        LOGGER.info((Object)("Total Load Speed: " + this.getLoadSpeed() + "records/s"));
        LOGGER.info((Object)("Read CSV Speed: " + this.getReadCSVSpeed(partitionID) + " records/s"));
        LOGGER.info((Object)("Generate Surrogate Key Speed: " + this.getGenSurKeySpeed(partitionID) + " records/s"));
        LOGGER.info((Object)("Sort Key/Write Temp Files Speed: " + this.getSortKeySpeed(partitionID) + " records/s"));
        LOGGER.info((Object)("MDK Step Speed: " + this.getMDKSpeed(partitionID) + " records/s"));
        LOGGER.info((Object)"=============================================");
    }

    @Override
    public void printStatisticsInfo(String partitionID) {
        try {
            LOGGER.info((Object)("========== TIME_STATISTICS PartitionID: " + partitionID + "=========="));
            this.printDicGenStatisticsInfo();
            this.printLruCacheLoadTimeInfo();
            this.printDictionaryValuesGenStatisticsInfo(partitionID);
            this.printSortRowsStepStatisticsInfo(partitionID);
            this.printGenMdkStatisticsInfo(partitionID);
            this.printHostBlockMapInfo();
            this.printLoadSpeedInfo(partitionID);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Can't print Statistics Information");
        }
        finally {
            this.resetLoadStatistics();
        }
    }

    private void resetLoadStatistics() {
        this.loadCsvfilesToDfStartTime = 0L;
        this.loadCsvfilesToDfCostTime = 0L;
        this.dicShuffleAndWriteFileTotalStartTime = 0L;
        this.lruCacheLoadTime = 0.0;
        this.totalRecords = 0L;
        this.totalTime = 0.0;
        this.parDictionaryValuesTotalTimeMap.clear();
        this.parCsvInputStepTimeMap.clear();
        this.parSortRowsStepTotalTimeMap.clear();
        this.parGeneratingDictionaryValuesTimeMap.clear();
        this.parMdkGenerateTotalTimeMap.clear();
        this.parDictionaryValue2MdkAdd2FileTime.clear();
    }
}

