/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.blocklet.BlockletEncodedColumnPage;
import org.apache.carbondata.core.datastore.blocklet.EncodedBlocklet;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.datastore.page.statistics.TablePageStatistics;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.index.BlockIndexInfo;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.format.BlockletBTreeIndex;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.BlockletInfo3;
import org.apache.carbondata.format.ChunkCompressionMeta;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.CompressionCodec;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.DataChunk3;
import org.apache.carbondata.format.FileFooter3;
import org.apache.carbondata.format.FileHeader;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.format.LocalDictionaryChunk;
import org.apache.carbondata.format.SegmentInfo;
import org.apache.log4j.Logger;

public class CarbonMetadataUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonMetadataUtil.class.getName());
    private static final List<Integer> dummyCardinality = new ArrayList<Integer>(0);
    private static final byte[] startKey = new byte[0];
    private static final byte[] noDictStartKey = new byte[0];
    private static final byte[] DEPRECATED_MDK;

    private CarbonMetadataUtil() {
    }

    public static FileFooter3 convertFileFooterVersion3(List<BlockletInfo3> infoList, List<BlockletIndex> blockletIndexs, int numberOfColumns) {
        FileFooter3 footer = CarbonMetadataUtil.getFileFooter3(infoList, blockletIndexs, numberOfColumns);
        for (BlockletInfo3 info : infoList) {
            footer.addToBlocklet_info_list3(info);
        }
        return footer;
    }

    private static FileFooter3 getFileFooter3(List<BlockletInfo3> infoList, List<BlockletIndex> blockletIndexs, int numberOfColumns) {
        SegmentInfo segmentInfo = new SegmentInfo();
        segmentInfo.setNum_cols(numberOfColumns);
        segmentInfo.setColumn_cardinalities(dummyCardinality);
        FileFooter3 footer = new FileFooter3();
        footer.setNum_rows(CarbonMetadataUtil.getNumberOfRowForFooter(infoList));
        footer.setSegment_info(segmentInfo);
        for (BlockletIndex info : blockletIndexs) {
            footer.addToBlocklet_index_list(info);
        }
        return footer;
    }

    public static BlockletMinMaxIndex convertExternalMinMaxIndex(org.apache.carbondata.format.BlockletMinMaxIndex minMaxIndex) {
        if (minMaxIndex == null) {
            return null;
        }
        List<Object> isMinMaxSet = null;
        if (minMaxIndex.isSetMin_max_presence()) {
            isMinMaxSet = minMaxIndex.getMin_max_presence();
        } else {
            Object[] minMaxFlag = new Boolean[minMaxIndex.getMax_values().size()];
            Arrays.fill(minMaxFlag, (Object)true);
            isMinMaxSet = Arrays.asList(minMaxFlag);
        }
        return new BlockletMinMaxIndex(minMaxIndex.getMin_values(), minMaxIndex.getMax_values(), (List<Boolean>)isMinMaxSet);
    }

    public static org.apache.carbondata.format.BlockletMinMaxIndex convertMinMaxIndex(BlockletMinMaxIndex minMaxIndex) {
        if (minMaxIndex == null) {
            return null;
        }
        org.apache.carbondata.format.BlockletMinMaxIndex blockletMinMaxIndex = new org.apache.carbondata.format.BlockletMinMaxIndex();
        for (int i = 0; i < minMaxIndex.getMaxValues().length; ++i) {
            blockletMinMaxIndex.addToMax_values(ByteBuffer.wrap(minMaxIndex.getMaxValues()[i]));
            blockletMinMaxIndex.addToMin_values(ByteBuffer.wrap(minMaxIndex.getMinValues()[i]));
            blockletMinMaxIndex.addToMin_max_presence(minMaxIndex.getIsMinMaxSet()[i]);
        }
        return blockletMinMaxIndex;
    }

    public static BlockletIndex getBlockletIndex(org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex info) {
        org.apache.carbondata.format.BlockletMinMaxIndex blockletMinMaxIndex = CarbonMetadataUtil.convertMinMaxIndex(info.getMinMaxIndex());
        BlockletBTreeIndex blockletBTreeIndex = new BlockletBTreeIndex();
        blockletBTreeIndex.setStart_key(info.getBtreeIndex().getStartKey());
        blockletBTreeIndex.setEnd_key(info.getBtreeIndex().getEndKey());
        BlockletIndex blockletIndex = new BlockletIndex();
        blockletIndex.setMin_max_index(blockletMinMaxIndex);
        blockletIndex.setB_tree_index(blockletBTreeIndex);
        return blockletIndex;
    }

    private static long getNumberOfRowForFooter(List<BlockletInfo3> infoList) {
        long numberOfRows = 0L;
        for (BlockletInfo3 info : infoList) {
            numberOfRows += (long)info.num_rows;
        }
        return numberOfRows;
    }

    private static EncodedColumnPage[] getEncodedColumnPages(EncodedBlocklet encodedBlocklet, boolean isDimension, int pageIndex) {
        int size = isDimension ? encodedBlocklet.getNumberOfDimension() : encodedBlocklet.getNumberOfMeasure();
        EncodedColumnPage[] encodedPages = new EncodedColumnPage[size];
        for (int i = 0; i < size; ++i) {
            encodedPages[i] = isDimension ? encodedBlocklet.getEncodedDimensionColumnPages().get(i).getEncodedColumnPageList().get(pageIndex) : encodedBlocklet.getEncodedMeasureColumnPages().get(i).getEncodedColumnPageList().get(pageIndex);
        }
        return encodedPages;
    }

    public static BlockletIndex getBlockletIndex(EncodedBlocklet encodedBlocklet, List<CarbonMeasure> carbonMeasureList) {
        org.apache.carbondata.format.BlockletMinMaxIndex blockletMinMaxIndex = new org.apache.carbondata.format.BlockletMinMaxIndex();
        List<Boolean> writeMinMaxFlag = CarbonMetadataUtil.mergeWriteMinMaxFlagForAllPages(blockletMinMaxIndex, encodedBlocklet);
        TablePageStatistics stats = new TablePageStatistics(CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, true, 0), CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, false, 0));
        byte[][] minCol = (byte[][])stats.getDimensionMinValue().clone();
        byte[][] maxCol = (byte[][])stats.getDimensionMaxValue().clone();
        for (int pageIndex = 0; pageIndex < encodedBlocklet.getNumberOfPages(); ++pageIndex) {
            stats = new TablePageStatistics(CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, true, pageIndex), CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, false, pageIndex));
            byte[][] columnMaxData = stats.getDimensionMaxValue();
            byte[][] columnMinData = stats.getDimensionMinValue();
            for (int i = 0; i < maxCol.length; ++i) {
                if (!writeMinMaxFlag.get(i).booleanValue()) {
                    maxCol[i] = new byte[0];
                    minCol[i] = new byte[0];
                    continue;
                }
                if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(columnMaxData[i], maxCol[i]) > 0) {
                    maxCol[i] = columnMaxData[i];
                }
                if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(columnMinData[i], minCol[i]) >= 0) continue;
                minCol[i] = columnMinData[i];
            }
        }
        for (byte[] max : maxCol) {
            blockletMinMaxIndex.addToMax_values(ByteBuffer.wrap(max));
        }
        for (byte[] min : minCol) {
            blockletMinMaxIndex.addToMin_values(ByteBuffer.wrap(min));
        }
        stats = new TablePageStatistics(CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, true, 0), CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, false, 0));
        byte[][] measureMaxValue = (byte[][])stats.getMeasureMaxValue().clone();
        byte[][] measureMinValue = (byte[][])stats.getMeasureMinValue().clone();
        byte[] minVal = null;
        byte[] maxVal = null;
        for (int i = 1; i < encodedBlocklet.getNumberOfPages(); ++i) {
            for (int j = 0; j < measureMinValue.length; ++j) {
                stats = new TablePageStatistics(CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, true, i), CarbonMetadataUtil.getEncodedColumnPages(encodedBlocklet, false, i));
                minVal = stats.getMeasureMinValue()[j];
                maxVal = stats.getMeasureMaxValue()[j];
                if (CarbonMetadataUtil.compareMeasureData(measureMaxValue[j], maxVal, carbonMeasureList.get(j).getDataType()) < 0) {
                    measureMaxValue[j] = (byte[])maxVal.clone();
                }
                if (CarbonMetadataUtil.compareMeasureData(measureMinValue[j], minVal, carbonMeasureList.get(j).getDataType()) <= 0) continue;
                measureMinValue[j] = (byte[])minVal.clone();
            }
        }
        for (byte[] max : measureMaxValue) {
            blockletMinMaxIndex.addToMax_values(ByteBuffer.wrap(max));
        }
        for (byte[] min : measureMinValue) {
            blockletMinMaxIndex.addToMin_values(ByteBuffer.wrap(min));
        }
        BlockletBTreeIndex blockletBTreeIndex = new BlockletBTreeIndex();
        blockletBTreeIndex.setStart_key(DEPRECATED_MDK);
        blockletBTreeIndex.setEnd_key(DEPRECATED_MDK);
        BlockletIndex blockletIndex = new BlockletIndex();
        blockletIndex.setMin_max_index(blockletMinMaxIndex);
        blockletIndex.setB_tree_index(blockletBTreeIndex);
        return blockletIndex;
    }

    private static List<Boolean> mergeWriteMinMaxFlagForAllPages(org.apache.carbondata.format.BlockletMinMaxIndex blockletMinMaxIndex, EncodedBlocklet encodedBlocklet) {
        Object[] mergedWriteMinMaxFlag = new Boolean[encodedBlocklet.getNumberOfDimension() + encodedBlocklet.getNumberOfMeasure()];
        Arrays.fill(mergedWriteMinMaxFlag, (Object)true);
        block0: for (int i = 0; i < encodedBlocklet.getNumberOfDimension(); ++i) {
            for (int pageIndex = 0; pageIndex < encodedBlocklet.getNumberOfPages(); ++pageIndex) {
                EncodedColumnPage encodedColumnPage = encodedBlocklet.getEncodedDimensionColumnPages().get(i).getEncodedColumnPageList().get(pageIndex);
                SimpleStatsResult stats = encodedColumnPage.getStats();
                if (stats.writeMinMax()) continue;
                mergedWriteMinMaxFlag[i] = stats.writeMinMax();
                String columnName = encodedColumnPage.getActualPage().getColumnSpec().getFieldName();
                LOGGER.info((Object)("Min Max writing of blocklet ignored for column with name " + columnName));
                continue block0;
            }
        }
        List<Object> min_max_presence = Arrays.asList(mergedWriteMinMaxFlag);
        blockletMinMaxIndex.setMin_max_presence(min_max_presence);
        return min_max_presence;
    }

    public static ChunkCompressionMeta getChunkCompressorMeta(ColumnPage inputPage, long encodedDataLength) throws IOException {
        ChunkCompressionMeta chunkCompressionMeta = new ChunkCompressionMeta();
        chunkCompressionMeta.setCompression_codec(CompressionCodec.DEPRECATED);
        chunkCompressionMeta.setCompressor_name(inputPage.getColumnCompressorName());
        chunkCompressionMeta.setTotal_compressed_size(encodedDataLength);
        chunkCompressionMeta.setTotal_uncompressed_size(inputPage.getPageLengthInBytes());
        return chunkCompressionMeta;
    }

    public static String getCompressorNameFromChunkMeta(ChunkCompressionMeta chunkCompressionMeta) {
        if (chunkCompressionMeta.isSetCompressor_name()) {
            return chunkCompressionMeta.getCompressor_name();
        }
        return CompressorFactory.NativeSupportedCompressor.SNAPPY.getName();
    }

    public static IndexHeader getIndexHeader(List<ColumnSchema> columnSchemaList, int bucketNumber, long schemaTimeStamp) {
        SegmentInfo segmentInfo = new SegmentInfo();
        segmentInfo.setNum_cols(columnSchemaList.size());
        segmentInfo.setColumn_cardinalities(dummyCardinality);
        IndexHeader indexHeader = new IndexHeader();
        ColumnarFormatVersion version = CarbonProperties.getInstance().getFormatVersion();
        indexHeader.setVersion((int)version.number());
        indexHeader.setSegment_info(segmentInfo);
        indexHeader.setTable_columns(columnSchemaList);
        indexHeader.setBucket_id(bucketNumber);
        indexHeader.setSchema_time_stamp(schemaTimeStamp);
        return indexHeader;
    }

    public static List<BlockIndex> getBlockIndexInfo(List<BlockIndexInfo> blockIndexInfoList) {
        ArrayList<BlockIndex> thriftBlockIndexList = new ArrayList<BlockIndex>();
        BlockIndex blockIndex = null;
        for (BlockIndexInfo blockIndexInfo : blockIndexInfoList) {
            blockIndex = new BlockIndex();
            blockIndex.setNum_rows(blockIndexInfo.getNumberOfRows());
            blockIndex.setOffset(blockIndexInfo.getOffset());
            blockIndex.setFile_name(blockIndexInfo.getFileName());
            blockIndex.setBlock_index(CarbonMetadataUtil.getBlockletIndex(blockIndexInfo.getBlockletIndex()));
            if (blockIndexInfo.getBlockletInfo() != null) {
                blockIndex.setBlocklet_info(CarbonMetadataUtil.getBlocletInfo3(blockIndexInfo.getBlockletInfo()));
            }
            blockIndex.setFile_size(blockIndexInfo.getFileSize());
            thriftBlockIndexList.add(blockIndex);
        }
        return thriftBlockIndexList;
    }

    public static BlockletInfo3 getBlocletInfo3(BlockletInfo blockletInfo) {
        List<Long> dimensionChunkOffsets = blockletInfo.getDimensionChunkOffsets();
        dimensionChunkOffsets.addAll(blockletInfo.getMeasureChunkOffsets());
        List<Integer> dimensionChunksLength = blockletInfo.getDimensionChunksLength();
        dimensionChunksLength.addAll(blockletInfo.getMeasureChunksLength());
        BlockletInfo3 blockletInfo3 = new BlockletInfo3(blockletInfo.getNumberOfRows(), dimensionChunkOffsets, dimensionChunksLength, blockletInfo.getDimensionOffset(), blockletInfo.getMeasureOffsets(), blockletInfo.getNumberOfPages());
        ArrayList<Integer> rowsPerPage = new ArrayList<Integer>();
        if (null != blockletInfo.getNumberOfRowsPerPage()) {
            for (int i = 0; i < blockletInfo.getNumberOfRowsPerPage().length; ++i) {
                rowsPerPage.add(blockletInfo.getNumberOfRowsPerPage()[i]);
            }
            blockletInfo3.setRow_count_in_page(rowsPerPage);
        }
        return blockletInfo3;
    }

    public static DataChunk3 getDataChunk3(List<DataChunk2> dataChunksList, LocalDictionaryChunk encodedDictionary) {
        int offset = 0;
        DataChunk3 dataChunk = new DataChunk3();
        ArrayList<Integer> pageOffsets = new ArrayList<Integer>();
        ArrayList<Integer> pageLengths = new ArrayList<Integer>();
        int length = 0;
        for (DataChunk2 dataChunk2 : dataChunksList) {
            pageOffsets.add(offset);
            length = dataChunk2.getData_page_length() + dataChunk2.getRle_page_length() + dataChunk2.getRowid_page_length();
            pageLengths.add(length);
            offset += length;
        }
        dataChunk.setLocal_dictionary(encodedDictionary);
        dataChunk.setData_chunk_list(dataChunksList);
        dataChunk.setPage_length(pageLengths);
        dataChunk.setPage_offset(pageOffsets);
        return dataChunk;
    }

    public static DataChunk3 getDimensionDataChunk3(EncodedBlocklet encodedBlocklet, int columnIndex) {
        ArrayList<DataChunk2> dataChunksList = new ArrayList<DataChunk2>();
        BlockletEncodedColumnPage blockletEncodedColumnPage = encodedBlocklet.getEncodedDimensionColumnPages().get(columnIndex);
        for (EncodedColumnPage encodedColumnPage : blockletEncodedColumnPage.getEncodedColumnPageList()) {
            dataChunksList.add(encodedColumnPage.getPageMetadata());
        }
        return CarbonMetadataUtil.getDataChunk3(dataChunksList, blockletEncodedColumnPage.getEncodedDictionary());
    }

    public static DataChunk3 getMeasureDataChunk3(EncodedBlocklet encodedBlocklet, int columnIndex) {
        ArrayList<DataChunk2> dataChunksList = new ArrayList<DataChunk2>();
        BlockletEncodedColumnPage blockletEncodedColumnPage = encodedBlocklet.getEncodedMeasureColumnPages().get(columnIndex);
        for (EncodedColumnPage encodedColumnPage : blockletEncodedColumnPage.getEncodedColumnPageList()) {
            dataChunksList.add(encodedColumnPage.getPageMetadata());
        }
        return CarbonMetadataUtil.getDataChunk3(dataChunksList, null);
    }

    private static int compareMeasureData(byte[] first, byte[] second, DataType dataType) {
        Object firstBuffer = null;
        Object secondBuffer = null;
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            if (first[0] > second[0]) {
                return 1;
            }
            if (first[0] < second[0]) {
                return -1;
            }
            return 0;
        }
        if (dataType == DataTypes.DOUBLE) {
            double secondValue;
            double firstValue = ((ByteBuffer)ByteBuffer.allocate(8).put(first).flip()).getDouble();
            if (firstValue > (secondValue = ((ByteBuffer)ByteBuffer.allocate(8).put(second).flip()).getDouble())) {
                return 1;
            }
            if (firstValue < secondValue) {
                return -1;
            }
            return 0;
        }
        if (dataType == DataTypes.FLOAT) {
            float secondValue;
            float firstValue = ((ByteBuffer)ByteBuffer.allocate(8).put(first).flip()).getFloat();
            if (firstValue > (secondValue = ((ByteBuffer)ByteBuffer.allocate(8).put(second).flip()).getFloat())) {
                return 1;
            }
            if (firstValue < secondValue) {
                return -1;
            }
            return 0;
        }
        if (dataType == DataTypes.LONG || dataType == DataTypes.INT || dataType == DataTypes.SHORT) {
            long secondValue;
            long firstValue = ((ByteBuffer)ByteBuffer.allocate(8).put(first).flip()).getLong();
            if (firstValue > (secondValue = ((ByteBuffer)ByteBuffer.allocate(8).put(second).flip()).getLong())) {
                return 1;
            }
            if (firstValue < secondValue) {
                return -1;
            }
            return 0;
        }
        if (DataTypes.isDecimal(dataType)) {
            return DataTypeUtil.byteToBigDecimal(first).compareTo(DataTypeUtil.byteToBigDecimal(second));
        }
        throw new IllegalArgumentException("Invalid data type:" + dataType);
    }

    public static FileHeader getFileHeader(boolean isFooterPresent, List<ColumnSchema> columnSchemaList, long schemaUpdatedTimeStamp) {
        FileHeader fileHeader = new FileHeader();
        ColumnarFormatVersion version = CarbonProperties.getInstance().getFormatVersion();
        fileHeader.setIs_footer_present(isFooterPresent);
        fileHeader.setColumn_schema(columnSchemaList);
        fileHeader.setVersion((int)version.number());
        fileHeader.setTime_stamp(schemaUpdatedTimeStamp);
        return fileHeader;
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocate(8 + startKey.length + noDictStartKey.length);
        buffer.putInt(startKey.length);
        buffer.putInt(noDictStartKey.length);
        buffer.put(startKey);
        buffer.put(noDictStartKey);
        buffer.rewind();
        DEPRECATED_MDK = buffer.array();
    }
}

