/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.constants.CarbonLoadOptionConstants;
import org.apache.carbondata.core.constants.CarbonV3DataFormatConstants;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.SessionParams;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.core.util.annotations.CarbonProperty;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public final class CarbonProperties {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonProperties.class.getName());
    private static final CarbonProperties CARBONPROPERTIESINSTANCE = new CarbonProperties();
    private Properties carbonProperties;
    private Set<String> propertySet = new HashSet<String>();
    private Map<String, String> addedProperty = new ConcurrentHashMap<String, String>();

    private CarbonProperties() {
        this.carbonProperties = new Properties();
        this.loadProperties();
        this.validateAndLoadDefaultProperties();
    }

    public static CarbonProperties getInstance() {
        return CARBONPROPERTIESINSTANCE;
    }

    private void validateAndLoadDefaultProperties(String key) {
        switch (key) {
            case "carbon.blocklet.size": {
                this.validateBlockletSize();
                break;
            }
            case "carbon.sort.size": {
                this.validateSortSize();
                break;
            }
            case "carbon.data.file.version": {
                this.validateCarbonDataFileVersion();
                break;
            }
            case "carbon.dynamical.location.scheduler.timeout": {
                this.validateDynamicSchedulerTimeOut();
                break;
            }
            case "carbon.prefetch.buffersize": {
                this.validatePrefetchBufferSize();
                break;
            }
            case "carbon.blockletgroup.size.in.mb": {
                this.validateBlockletGroupSizeInMB();
                break;
            }
            case "number.of.column.to.read.in.io": {
                this.validateNumberOfColumnPerIORead();
                break;
            }
            case "enable.unsafe.sort": {
                this.validateEnableUnsafeSort();
                break;
            }
            case "enable.offheap.sort": {
                this.validateEnableOffHeapSort();
                break;
            }
            case "carbon.custom.block.distribution": {
                this.validateCustomBlockDistribution();
                break;
            }
            case "carbon.enable.vector.reader": {
                this.validateEnableVectorReader();
                break;
            }
            case "carbon.csv.read.buffersize.byte": {
                this.validateCarbonCSVReadBufferSizeByte();
                break;
            }
            case "carbon.streaming.segment.max.size": {
                this.validateHandoffSize();
                break;
            }
            case "carbon.task.distribution": {
                this.validateCarbonTaskDistribution();
                break;
            }
            case "carbon.timestamp.format": {
                this.validateTimeFormatKey("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
                break;
            }
            case "carbon.date.format": {
                this.validateTimeFormatKey("carbon.date.format", "yyyy-MM-dd");
                break;
            }
            case "carbon.sort.file.write.buffer.size": {
                this.validateSortFileWriteBufferSize();
                break;
            }
            case "carbon.sort.intermediate.files.limit": {
                this.validateSortIntermediateFilesLimit();
                break;
            }
            case "carbon.streaming.auto.handoff.enabled": {
                this.validateHandoffSize();
                break;
            }
            case "carbon.scheduler.min.registered.resources.ratio": {
                this.validateSchedulerMinRegisteredRatio();
                break;
            }
            case "carbon.load.sortmemory.spill.percentage": {
                this.validateSortMemorySpillPercentage();
                break;
            }
            case "carbon.minmax.allowed.byte.count": {
                this.validateStringCharacterLimit();
                break;
            }
            case "carbon.detail.batch.size": {
                this.validateDetailQueryBatchSize();
                break;
            }
            case "carbon.index.server.inmemory.serialization.threshold.inKB": {
                this.validateIndexServerSerializationThreshold();
                break;
            }
            case "carbon.local.dictionary.size.threshold.inmb": {
                this.validateAndGetLocalDictionarySizeThresholdInMB();
                break;
            }
            case "carbon.index.schema.storage": {
                this.validateDMSchemaStorageProvider();
                break;
            }
        }
    }

    private void validatePositiveInteger(String propertyName) {
        String value = CarbonProperties.getInstance().getProperty(propertyName);
        try {
            int intValue = Integer.parseInt(value);
            if (intValue <= 0) {
                CarbonProperties.getInstance().removeProperty(propertyName);
                LOGGER.warn((Object)String.format("The value \"%s\" configured for key \"%s\" is invalid. Ignoring it", value, propertyName));
                throw new IllegalArgumentException();
            }
        }
        catch (NumberFormatException e) {
            CarbonProperties.getInstance().removeProperty(propertyName);
            LOGGER.warn((Object)String.format("The value \"%s\" configured for key \"%s\" is invalid. Ignoring it", value, propertyName));
            throw e;
        }
    }

    private void validateAndLoadDefaultProperties() {
        this.validateBlockletSize();
        this.validateSortSize();
        this.validateCarbonDataFileVersion();
        this.validateDynamicSchedulerTimeOut();
        this.validatePrefetchBufferSize();
        this.validateBlockletGroupSizeInMB();
        this.validateNumberOfColumnPerIORead();
        this.validateEnableUnsafeSort();
        this.validateEnableOffHeapSort();
        this.validateCustomBlockDistribution();
        this.validateEnableVectorReader();
        this.validateLockType();
        this.validateCarbonCSVReadBufferSizeByte();
        this.validateHandoffSize();
        this.validateCarbonTaskDistribution();
        this.validateTimeFormatKey("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        this.validateTimeFormatKey("carbon.date.format", "yyyy-MM-dd");
        this.validateSortFileWriteBufferSize();
        this.validateSortIntermediateFilesLimit();
        this.validateEnableAutoHandoff();
        this.validateSchedulerMinRegisteredRatio();
        this.validateWorkingMemory();
        this.validateSortStorageMemory();
        this.validateEnableQueryStatistics();
        this.validateSortMemorySpillPercentage();
        this.validateStringCharacterLimit();
        this.validateDetailQueryBatchSize();
        this.validateIndexServerSerializationThreshold();
        this.validateAndGetLocalDictionarySizeThresholdInMB();
    }

    private void validateSortIntermediateFilesLimit() {
        this.validateRange("carbon.sort.intermediate.files.limit", "20", 2, 50);
    }

    private void validateRange(String key, String defaultValue, int minValue, int maxValue) {
        String fileBufferSize = this.carbonProperties.getProperty(key, defaultValue);
        if (null != fileBufferSize) {
            try {
                int bufferSize = Integer.parseInt(fileBufferSize);
                if (bufferSize < minValue || bufferSize > maxValue) {
                    LOGGER.warn((Object)("The value \"" + fileBufferSize + "\" configured for key " + key + "\" is not in range. Valid range is (byte) \"" + minValue + " to \"" + maxValue + ". Using the default value \"" + defaultValue));
                    this.carbonProperties.setProperty(key, defaultValue);
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn((Object)("The value \"" + fileBufferSize + "\" configured for key " + key + "\" is invalid. Using the default value \"" + defaultValue));
                this.carbonProperties.setProperty(key, defaultValue);
            }
        }
    }

    private void validateSortFileWriteBufferSize() {
        this.validateRange("carbon.sort.file.write.buffer.size", "16384", 10240, 0xA00000);
    }

    private void validateSchedulerMinRegisteredRatio() {
        String value = this.carbonProperties.getProperty("carbon.scheduler.min.registered.resources.ratio", "0.8d");
        try {
            double minRegisteredResourceRatio = Double.parseDouble(value);
            if (minRegisteredResourceRatio < 0.1 || minRegisteredResourceRatio > 1.0) {
                LOGGER.warn((Object)("The value \"" + value + "\" configured for key " + "carbon.scheduler.min.registered.resources.ratio" + "\" is not in range. Valid range is (byte) \"" + 0.1 + " to \"" + 1.0 + ". Using the default value \"" + "0.8d"));
                this.carbonProperties.setProperty("carbon.scheduler.min.registered.resources.ratio", "0.8d");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)String.format("The value \"%s\" configured for key  \"%s\" is invalid. Using the default value \"%s\"", value, "carbon.scheduler.min.registered.resources.ratio", "0.8d"));
            this.carbonProperties.setProperty("carbon.scheduler.min.registered.resources.ratio", "0.8d");
        }
    }

    private void validateTimeFormatKey(String key, String defaultValue) {
        String dateFormat = this.carbonProperties.getProperty(key, defaultValue);
        try {
            new SimpleDateFormat(dateFormat);
        }
        catch (Exception e) {
            LOGGER.warn((Object)String.format("The value \"%s\" configured for key \"%s\" is invalid. Using the default value \"%s\"", dateFormat, key, key));
            this.carbonProperties.setProperty(key, defaultValue);
        }
    }

    private void validateCarbonCSVReadBufferSizeByte() {
        this.validateRange("carbon.csv.read.buffersize.byte", "1048576", 10240, 0xA00000);
    }

    private void validateLockType() {
        String lockTypeConfigured = this.carbonProperties.getProperty("carbon.lock.type", "LOCALLOCK");
        if (lockTypeConfigured != null) {
            switch (lockTypeConfigured.toUpperCase()) {
                case "ZOOKEEPERLOCK": {
                    break;
                }
                case "CUSTOM": {
                    break;
                }
                default: {
                    this.validateAndConfigureLockType(lockTypeConfigured);
                    break;
                }
            }
        } else {
            this.validateAndConfigureLockType(null);
        }
    }

    private void validateAndConfigureLockType(String lockTypeConfigured) {
        String lockTypeByFS = null;
        Configuration configuration = FileFactory.getConfiguration();
        String defaultFs = configuration.get("fs.defaultFS");
        if (null != defaultFs && (defaultFs.startsWith("hdfs://") || defaultFs.startsWith("viewfs://") || defaultFs.startsWith("alluxio://") || defaultFs.startsWith("s3a://"))) {
            lockTypeByFS = "HDFSLOCK";
        } else if (null != defaultFs && defaultFs.startsWith("file://")) {
            lockTypeByFS = "LOCALLOCK";
        }
        if (lockTypeByFS != null && lockTypeConfigured != null && !lockTypeConfigured.equalsIgnoreCase(lockTypeByFS)) {
            LOGGER.warn((Object)("The value \"" + lockTypeConfigured + "\" configured for key " + "carbon.lock.type" + " is invalid for current file system. Use the default value " + lockTypeByFS + " instead."));
        }
        if (lockTypeByFS != null) {
            this.carbonProperties.setProperty("carbon.lock.type", lockTypeByFS);
        } else {
            this.carbonProperties.setProperty("carbon.lock.type", "LOCALLOCK");
        }
    }

    private void validateEnableVectorReader() {
        boolean isValidBooleanValue;
        String vectorReaderStr = this.carbonProperties.getProperty("carbon.enable.vector.reader");
        if (vectorReaderStr == null) {
            this.carbonProperties.setProperty("carbon.enable.vector.reader", "true");
            vectorReaderStr = this.carbonProperties.getProperty("carbon.enable.vector.reader");
        }
        if (!(isValidBooleanValue = CarbonUtil.validateBoolean(vectorReaderStr))) {
            LOGGER.warn((Object)String.format("The enable vector reader value \"%s\" is invalid. Using the default value \"%s\"", vectorReaderStr, "true"));
            this.carbonProperties.setProperty("carbon.enable.vector.reader", "true");
        }
    }

    private void validateCustomBlockDistribution() {
        boolean isValidBooleanValue;
        String customBlockDistributionStr = this.carbonProperties.getProperty("carbon.custom.block.distribution");
        if (customBlockDistributionStr == null) {
            this.carbonProperties.setProperty("carbon.custom.block.distribution", "false");
            customBlockDistributionStr = this.carbonProperties.getProperty("carbon.custom.block.distribution");
        }
        if (!(isValidBooleanValue = CarbonUtil.validateBoolean(customBlockDistributionStr))) {
            LOGGER.warn((Object)String.format("The custom block distribution value \"%s\" is invalid. Using the default value \"false\"", customBlockDistributionStr));
            this.carbonProperties.setProperty("carbon.custom.block.distribution", "false");
        }
    }

    private void validateCarbonTaskDistribution() {
        boolean isValid;
        String carbonTaskDistribution = this.carbonProperties.getProperty("carbon.task.distribution");
        if (carbonTaskDistribution == null) {
            this.carbonProperties.setProperty("carbon.task.distribution", "block");
            carbonTaskDistribution = this.carbonProperties.getProperty("carbon.task.distribution");
        }
        boolean bl = isValid = carbonTaskDistribution.equalsIgnoreCase("merge_small_files") || carbonTaskDistribution.equalsIgnoreCase("blocklet") || carbonTaskDistribution.equalsIgnoreCase("block") || carbonTaskDistribution.equalsIgnoreCase("custom");
        if (!isValid) {
            LOGGER.warn((Object)String.format("The carbon task distribution value \"%s\" is invalid. Using the default value \"%s\"", carbonTaskDistribution, "block"));
            this.carbonProperties.setProperty("carbon.task.distribution", "block");
        }
    }

    private void validateEnableUnsafeSort() {
        boolean isValidBooleanValue;
        String unSafeSortStr = this.carbonProperties.getProperty("enable.unsafe.sort");
        if (unSafeSortStr == null) {
            this.carbonProperties.setProperty("enable.unsafe.sort", "true");
            unSafeSortStr = this.carbonProperties.getProperty("enable.unsafe.sort");
        }
        if (!(isValidBooleanValue = CarbonUtil.validateBoolean(unSafeSortStr))) {
            LOGGER.warn((Object)String.format("The enable unsafe sort value \"%s\" is invalid. Using the default value \"%s\"", unSafeSortStr, "true"));
            this.carbonProperties.setProperty("enable.unsafe.sort", "true");
        }
    }

    private void validateEnableOffHeapSort() {
        boolean isValidBooleanValue;
        String offHeapSortStr = this.carbonProperties.getProperty("enable.offheap.sort");
        if (offHeapSortStr == null) {
            this.carbonProperties.setProperty("enable.offheap.sort", "true");
            offHeapSortStr = this.carbonProperties.getProperty("enable.offheap.sort");
        }
        if (!(isValidBooleanValue = CarbonUtil.validateBoolean(offHeapSortStr))) {
            LOGGER.warn((Object)String.format("The enable off heap sort value \"%s\" is invalid. Using the default value \"%s\"", offHeapSortStr, "true"));
            this.carbonProperties.setProperty("enable.offheap.sort", "true");
        }
    }

    private void initPropertySet() throws IllegalAccessException {
        Field[] declaredFields;
        for (Field field : declaredFields = CarbonCommonConstants.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CarbonProperty.class)) continue;
            this.propertySet.add(field.get(field.getName()).toString());
        }
        for (Field field : declaredFields = CarbonV3DataFormatConstants.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CarbonProperty.class)) continue;
            this.propertySet.add(field.get(field.getName()).toString());
        }
        for (Field field : declaredFields = CarbonLoadOptionConstants.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CarbonProperty.class)) continue;
            this.propertySet.add(field.get(field.getName()).toString());
        }
    }

    private void validatePrefetchBufferSize() {
        String prefetchBufferSizeStr = this.carbonProperties.getProperty("carbon.prefetch.buffersize");
        if (null == prefetchBufferSizeStr || prefetchBufferSizeStr.length() == 0) {
            this.carbonProperties.setProperty("carbon.prefetch.buffersize", "1000");
        } else {
            try {
                Integer.parseInt(prefetchBufferSizeStr);
            }
            catch (NumberFormatException e) {
                LOGGER.info((Object)("The prefetch buffer size value \"" + prefetchBufferSizeStr + "\" is invalid. Using the default value \"" + "1000" + "\""));
                this.carbonProperties.setProperty("carbon.prefetch.buffersize", "1000");
            }
        }
    }

    private void validateHandoffSize() {
        String handoffSizeStr = this.carbonProperties.getProperty("carbon.streaming.segment.max.size");
        if (null == handoffSizeStr || handoffSizeStr.length() == 0) {
            this.carbonProperties.setProperty("carbon.streaming.segment.max.size", "1073741824");
        } else {
            try {
                long handoffSize = Long.parseLong(handoffSizeStr);
                if (handoffSize < 0x4000000L) {
                    LOGGER.info((Object)("The streaming segment max size configured value " + handoffSizeStr + " is invalid. Using the default value " + 0x40000000L));
                    this.carbonProperties.setProperty("carbon.streaming.segment.max.size", "1073741824");
                }
            }
            catch (NumberFormatException e) {
                LOGGER.info((Object)("The streaming segment max size value \"" + handoffSizeStr + "\" is invalid. Using the default value \"" + 0x40000000L + "\""));
                this.carbonProperties.setProperty("carbon.streaming.segment.max.size", "1073741824");
            }
        }
    }

    private void validateEnableAutoHandoff() {
        boolean isValidBooleanValue;
        String offHeapSortStr = this.carbonProperties.getProperty("enable.offheap.sort");
        if (offHeapSortStr == null) {
            this.carbonProperties.setProperty("enable.offheap.sort", "true");
            offHeapSortStr = this.carbonProperties.getProperty("enable.offheap.sort");
        }
        if (!(isValidBooleanValue = CarbonUtil.validateBoolean(offHeapSortStr))) {
            LOGGER.warn((Object)String.format("The enable off heap sort value \"%s\" is invalid. Using the default value \"%s\"", offHeapSortStr, "true"));
            this.carbonProperties.setProperty("enable.offheap.sort", "true");
        }
    }

    public boolean isIndexParallelLoadingEnabled(String databaseName, String tableName) {
        boolean configuredValue;
        String loadIndexParallel = this.getSessionPropertyValue("carbon.load.indexes.parallel." + databaseName + "." + tableName);
        if (loadIndexParallel == null) {
            loadIndexParallel = this.getProperty("carbon.load.indexes.parallel.", "false");
        }
        if (configuredValue = Boolean.parseBoolean(loadIndexParallel)) {
            LOGGER.info((Object)("Loading indexes in parallel for " + databaseName + "." + tableName));
        }
        return configuredValue;
    }

    private void validateBlockletGroupSizeInMB() {
        String numberOfPagePerBlockletColumnString = this.carbonProperties.getProperty("carbon.blockletgroup.size.in.mb", "64");
        try {
            short numberOfPagePerBlockletColumn = Short.parseShort(numberOfPagePerBlockletColumnString);
            if (numberOfPagePerBlockletColumn < 1) {
                LOGGER.info((Object)String.format("Blocklet Size Configured value \"%s\" is invalid. Using the default value \"%s\"", numberOfPagePerBlockletColumnString, "64"));
                this.carbonProperties.setProperty("carbon.blockletgroup.size.in.mb", "64");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)String.format("Blocklet Size Configured value \"%s\" is invalid. Using the default value \"%s\"", numberOfPagePerBlockletColumnString, "64"));
            this.carbonProperties.setProperty("carbon.blockletgroup.size.in.mb", "64");
        }
        LOGGER.info((Object)String.format("Blocklet Size Configured value is \"%s\"", this.carbonProperties.getProperty("carbon.blockletgroup.size.in.mb", "64")));
    }

    private void validateNumberOfColumnPerIORead() {
        String numberOfColumnPerIOString = this.carbonProperties.getProperty("number.of.column.to.read.in.io", "10");
        try {
            short numberOfColumnPerIO = Short.parseShort(numberOfColumnPerIOString);
            if (numberOfColumnPerIO < 1 || numberOfColumnPerIO > 20) {
                LOGGER.info((Object)("The Number Of pages per blocklet column value \"" + numberOfColumnPerIOString + "\" is invalid. Using the default value \"" + "10"));
                this.carbonProperties.setProperty("number.of.column.to.read.in.io", "10");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)("The Number Of pages per blocklet column value \"" + numberOfColumnPerIOString + "\" is invalid. Using the default value \"" + "10"));
            this.carbonProperties.setProperty("number.of.column.to.read.in.io", "10");
        }
    }

    private void validateBlockletSize() {
        String blockletSizeStr = this.carbonProperties.getProperty("carbon.blocklet.size", "120000");
        try {
            int blockletSize = Integer.parseInt(blockletSizeStr);
            if (blockletSize < 2000 || blockletSize > 12000000) {
                LOGGER.info((Object)("The blocklet size value \"" + blockletSizeStr + "\" is invalid. Using the default value \"" + "120000"));
                this.carbonProperties.setProperty("carbon.blocklet.size", "120000");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)("The blocklet size value \"" + blockletSizeStr + "\" is invalid. Using the default value \"" + "120000"));
            this.carbonProperties.setProperty("carbon.blocklet.size", "120000");
        }
    }

    private void validateIndexServerSerializationThreshold() {
        String serializationSizeString = this.carbonProperties.getProperty("carbon.index.server.inmemory.serialization.threshold.inKB", "300");
        try {
            int serializationSize = Integer.parseInt(serializationSizeString);
            if (serializationSize < 0 || serializationSize > 102400) {
                LOGGER.info((Object)("The carbon.index.server.inmemory.serialization.threshold.inKB value \"" + serializationSize + "\" is invalid. Using the default value \"" + "300"));
                this.carbonProperties.setProperty("carbon.index.server.inmemory.serialization.threshold.inKB", "300");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)("The carbon.index.server.inmemory.serialization.threshold.inKB value \"" + serializationSizeString + "\" is invalid. Using the default value \"" + "300"));
            this.carbonProperties.setProperty("carbon.index.server.inmemory.serialization.threshold.inKB", "300");
        }
    }

    private void validateSortSize() {
        String sortSizeStr = this.carbonProperties.getProperty("carbon.sort.size", "100000");
        try {
            int sortSize = Integer.parseInt(sortSizeStr);
            if (sortSize < 1000) {
                LOGGER.info((Object)String.format("The batch size value \"%s\" is invalid. Using the default value \"%s\"", sortSizeStr, "100000"));
                this.carbonProperties.setProperty("carbon.sort.size", "100000");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)String.format("The batch size value \"%s\" is invalid. Using the default value \"%s\"", sortSizeStr, "100000"));
            this.carbonProperties.setProperty("carbon.sort.size", "100000");
        }
    }

    private void validateCarbonDataFileVersion() {
        String carbondataFileVersionString = this.carbonProperties.getProperty("carbon.data.file.version");
        if (carbondataFileVersionString == null) {
            this.carbonProperties.setProperty("carbon.data.file.version", "V3");
        } else {
            try {
                this.carbonProperties.setProperty("carbon.data.file.version", ColumnarFormatVersion.valueOf(carbondataFileVersionString).name());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn((Object)("Specified file version property is invalid: " + carbondataFileVersionString + ". Using " + "V3" + " as default file version"));
                this.carbonProperties.setProperty("carbon.data.file.version", "V3");
            }
        }
        LOGGER.info((Object)("Considered file format is: " + this.carbonProperties.getProperty("carbon.data.file.version")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        String propertyPath = System.getProperty("carbon.properties.filepath", "../../../conf/carbon.properties");
        File propertyFile = new File(propertyPath);
        LOGGER.info((Object)("Property file path: " + propertyFile.getAbsolutePath()));
        FileInputStream fis = null;
        try {
            if (propertyFile.exists()) {
                fis = new FileInputStream(propertyFile);
                this.carbonProperties.load(fis);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("The file: " + propertyFile.getAbsolutePath() + " does not exist"));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error while reading the file: " + propertyFile.getAbsolutePath()));
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error while closing the file stream for file: " + propertyFile.getAbsolutePath()));
                }
            }
        }
        this.print();
        try {
            this.initPropertySet();
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("Illegal access to declared field" + e.getMessage()), (Throwable)e);
        }
    }

    public static String getStorePath() {
        String storePath = CarbonProperties.getInstance().getProperty("carbon.storelocation");
        if (storePath == null) {
            storePath = FileFactory.getConfiguration().get("hive.metastore.warehouse.dir");
        }
        return storePath;
    }

    public String getProperty(String key) {
        String sessionPropertyValue = this.getSessionPropertyValue(key);
        if (null != sessionPropertyValue) {
            return sessionPropertyValue;
        }
        return this.carbonProperties.getProperty(key);
    }

    private String getSessionPropertyValue(String key) {
        SessionParams sessionParams;
        String value = null;
        CarbonSessionInfo carbonSessionInfo = ThreadLocalSessionInfo.getCarbonSessionInfo();
        if (null != carbonSessionInfo && null != (sessionParams = ThreadLocalSessionInfo.getCarbonSessionInfo().getSessionParams())) {
            value = sessionParams.getProperty(key);
        }
        return value;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public CarbonProperties addProperty(String key, String value) {
        this.carbonProperties.setProperty(key, value);
        this.addedProperty.put(key, value);
        this.validateAndLoadDefaultProperties(key.toLowerCase());
        return this;
    }

    public void addNonSerializableProperty(String key, String value) {
        this.carbonProperties.setProperty(key, value);
    }

    public CarbonProperties removeProperty(String key) {
        this.carbonProperties.remove(key);
        this.addedProperty.remove(key);
        return this;
    }

    private ColumnarFormatVersion getDefaultFormatVersion() {
        return ColumnarFormatVersion.valueOf("V3");
    }

    public ColumnarFormatVersion getFormatVersion() {
        String versionStr = CarbonProperties.getInstance().getProperty("carbon.data.file.version");
        if (versionStr == null) {
            return this.getDefaultFormatVersion();
        }
        try {
            return ColumnarFormatVersion.valueOf(versionStr);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultFormatVersion();
        }
    }

    public long getMajorCompactionSize() {
        long compactionSize;
        try {
            compactionSize = Long.parseLong(this.getProperty("carbon.major.compaction.size", "1024"));
        }
        catch (NumberFormatException e) {
            compactionSize = Long.parseLong("1024");
        }
        return compactionSize;
    }

    public int getNumberOfSegmentsToBePreserved() {
        int numberOfSegmentsToBePreserved;
        try {
            numberOfSegmentsToBePreserved = Integer.parseInt(this.getProperty("carbon.numberof.preserve.segments", "0"));
            if (numberOfSegmentsToBePreserved < 0 || numberOfSegmentsToBePreserved > 100) {
                LOGGER.warn((Object)"The specified value for property carbon.numberof.preserve.segments is incorrect. Correct value should be in range of 0 -100. Taking the default value.");
                numberOfSegmentsToBePreserved = Integer.parseInt("0");
            }
        }
        catch (NumberFormatException e) {
            numberOfSegmentsToBePreserved = Integer.parseInt("0");
        }
        return numberOfSegmentsToBePreserved;
    }

    public void print() {
        LOGGER.info((Object)"------Using Carbon.properties --------");
        LOGGER.info((Object)this.carbonProperties.toString());
    }

    public int[] getCompactionSegmentLevelCount() {
        String commaSeparatedLevels = this.getProperty("carbon.compaction.level.threshold", "4,3");
        int[] compactionSize = this.getIntArray(commaSeparatedLevels);
        if (0 == compactionSize.length) {
            compactionSize = this.getIntArray("4,3");
        }
        return compactionSize;
    }

    public int[] getIntArray(String commaSeparatedLevels) {
        String[] levels = commaSeparatedLevels.split(",");
        int[] compactionSize = new int[levels.length];
        int i = 0;
        for (String levelSize : levels) {
            try {
                int size = Integer.parseInt(levelSize.trim());
                if (this.validate(size, 10000, 0, -1) < 0) {
                    LOGGER.warn((Object)("Given value for property" + size + " is not proper. Taking the default value " + "4,3"));
                    return new int[0];
                }
                compactionSize[i++] = size;
            }
            catch (NumberFormatException e) {
                LOGGER.warn((Object)"Given value for propertycarbon.compaction.level.threshold is not proper. Taking the default value 4,3");
                return new int[0];
            }
        }
        return compactionSize;
    }

    private int getNumberOfCores(String key) {
        int numberOfCores;
        try {
            numberOfCores = Integer.parseInt(CarbonProperties.getInstance().getProperty(key, "2"));
        }
        catch (NumberFormatException exc) {
            LOGGER.warn((Object)("Configured value for property " + key + " is wrong. Falling back to the default value " + "2"));
            numberOfCores = Integer.parseInt("2");
        }
        return numberOfCores;
    }

    public int getNumberOfLoadingCores() {
        return this.getNumberOfCores("carbon.number.of.cores.while.loading");
    }

    public int getNumberOfCompactingCores() {
        return this.getNumberOfCores("carbon.number.of.cores.while.compacting");
    }

    public int getNumberOfAltPartitionCores() {
        return this.getNumberOfCores("carbon.number.of.cores.while.altPartition");
    }

    public int getSortMemoryChunkSizeInMB() {
        int inMemoryChunkSizeInMB;
        try {
            inMemoryChunkSizeInMB = Integer.parseInt(CarbonProperties.getInstance().getProperty("offheap.sort.chunk.size.inmb", "64"));
        }
        catch (Exception e) {
            inMemoryChunkSizeInMB = Integer.parseInt("64");
            LOGGER.warn((Object)("Problem in parsing the sort memory chunk size, setting with default value" + inMemoryChunkSizeInMB));
        }
        if (inMemoryChunkSizeInMB > 1024) {
            inMemoryChunkSizeInMB = 1024;
            LOGGER.warn((Object)("It is not recommended to increase the sort memory chunk size more than 1024MB, so setting the value to " + inMemoryChunkSizeInMB));
        } else if (inMemoryChunkSizeInMB < 1) {
            inMemoryChunkSizeInMB = 1;
            LOGGER.warn((Object)("It is not recommended to decrease the sort memory chunk size less than 1MB, so setting the value to " + inMemoryChunkSizeInMB));
        }
        return inMemoryChunkSizeInMB;
    }

    public int getBatchSize() {
        int batchSize;
        try {
            batchSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("DATA_LOAD_BATCH_SIZE", "1000"));
        }
        catch (NumberFormatException exc) {
            batchSize = Integer.parseInt("1000");
        }
        return batchSize;
    }

    public static int getQueryBatchSize() {
        int batchSize;
        String batchSizeString = CarbonProperties.getInstance().getProperty("carbon.detail.batch.size");
        if (null != batchSizeString) {
            try {
                batchSize = Integer.parseInt(batchSizeString);
            }
            catch (NumberFormatException ne) {
                LOGGER.error((Object)"Invalid inmemory records size. Using default value");
                batchSize = 100;
            }
        } else {
            batchSize = 100;
        }
        return batchSize;
    }

    public long getHandoffSize() {
        Long handoffSize;
        try {
            handoffSize = Long.parseLong(CarbonProperties.getInstance().getProperty("carbon.streaming.segment.max.size", "1073741824"));
        }
        catch (NumberFormatException exc) {
            handoffSize = 0x40000000L;
        }
        return handoffSize;
    }

    public boolean isEnableAutoHandoff() {
        String enableAutoHandoffStr = CarbonProperties.getInstance().getProperty("carbon.streaming.auto.handoff.enabled", "true");
        return enableAutoHandoffStr.equalsIgnoreCase("true");
    }

    public boolean isEnableVectorReader() {
        return CarbonProperties.getInstance().getProperty("carbon.enable.vector.reader", "true").equalsIgnoreCase("true");
    }

    public static boolean isEnableTableStatusBackup() {
        return CarbonProperties.getInstance().getProperty("carbon.enable.tablestatus.backup", "false").equalsIgnoreCase("true");
    }

    public int validate(int actual, int max, int min, int defaultVal) {
        if (actual <= max && actual >= min) {
            return actual;
        }
        return defaultVal;
    }

    private void validateDynamicSchedulerTimeOut() {
        this.validateRange("carbon.dynamical.location.scheduler.timeout", "5", 5, 15);
    }

    public int getNoUpdateDeltaFilesThresholdForIUDCompaction() {
        int numberOfDeltaFilesThreshold;
        try {
            numberOfDeltaFilesThreshold = Integer.parseInt(this.getProperty("carbon.horizontal.update.compaction.threshold", "1"));
            if (numberOfDeltaFilesThreshold < 0 || numberOfDeltaFilesThreshold > 10000) {
                LOGGER.warn((Object)"The specified value for property carbon.horizontal.update.compaction.thresholdis incorrect. Correct value should be in range of 0 -10000. Taking the default value.");
                numberOfDeltaFilesThreshold = Integer.parseInt("1");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)"The specified value for property carbon.horizontal.update.compaction.thresholdis incorrect. Correct value should be in range of 0 -10000. Taking the default value.");
            numberOfDeltaFilesThreshold = Integer.parseInt("1");
        }
        return numberOfDeltaFilesThreshold;
    }

    public int getNoDeleteDeltaFilesThresholdForIUDCompaction() {
        int numberOfDeltaFilesThreshold;
        try {
            numberOfDeltaFilesThreshold = Integer.parseInt(this.getProperty("carbon.horizontal.delete.compaction.threshold", "1"));
            if (numberOfDeltaFilesThreshold < 0 || numberOfDeltaFilesThreshold > 10000) {
                LOGGER.warn((Object)"The specified value for property carbon.horizontal.delete.compaction.thresholdis incorrect. Correct value should be in range of 0 -10000. Taking the default value.");
                numberOfDeltaFilesThreshold = Integer.parseInt("1");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)"The specified value for property carbon.horizontal.delete.compaction.thresholdis incorrect. Correct value should be in range of 0 -10000. Taking the default value.");
            numberOfDeltaFilesThreshold = Integer.parseInt("1");
        }
        return numberOfDeltaFilesThreshold;
    }

    public String getGlobalSortRddStorageLevel() {
        String storageLevel = this.getProperty("carbon.global.sort.rdd.storage.level", "MEMORY_ONLY");
        boolean validateStorageLevel = CarbonUtil.isValidStorageLevel(storageLevel);
        if (!validateStorageLevel) {
            LOGGER.warn((Object)"The carbon.global.sort.rdd.storage.level configuration value is invalid. It will use default storage level(MEMORY_ONLY) to persist rdd.");
            storageLevel = "MEMORY_ONLY";
        }
        return storageLevel.toUpperCase();
    }

    public int getParallelismForSegmentUpdate() {
        int parallelism = Integer.parseInt("1");
        boolean isInvalidValue = false;
        try {
            String strParallelism = this.getProperty("carbon.update.segment.parallelism", "1");
            parallelism = Integer.parseInt(strParallelism);
            if (parallelism <= 0 || parallelism > 1000) {
                isInvalidValue = true;
            }
        }
        catch (NumberFormatException e) {
            isInvalidValue = true;
        }
        if (isInvalidValue) {
            LOGGER.warn((Object)"The specified value for property carbon.update.segment.parallelism is incorrect. Correct value should be in range of 0 - 1000. Taking the default value: 1");
            parallelism = Integer.parseInt("1");
        }
        return parallelism;
    }

    public boolean isPersistUpdateDataset() {
        String isPersistEnabled = this.getProperty("carbon.update.persist.enable", "true");
        boolean validatePersistEnabled = CarbonUtil.validateBoolean(isPersistEnabled);
        if (!validatePersistEnabled) {
            LOGGER.warn((Object)"The carbon.update.persist.enable configuration value is invalid. It will use default value(true).");
            isPersistEnabled = "true";
        }
        return isPersistEnabled.equalsIgnoreCase("true");
    }

    public String getUpdateDatasetStorageLevel() {
        String storageLevel = this.getProperty("carbon.update.storage.level", "MEMORY_AND_DISK");
        boolean validateStorageLevel = CarbonUtil.isValidStorageLevel(storageLevel);
        if (!validateStorageLevel) {
            LOGGER.warn((Object)"The carbon.update.storage.level configuration value is invalid. It will use default storage level(MEMORY_AND_DISK) to persist dataset.");
            storageLevel = "MEMORY_AND_DISK";
        }
        return storageLevel.toUpperCase();
    }

    public String getSortTempCompressor() {
        String compressor = this.getProperty("carbon.sort.temp.compressor", "SNAPPY").toUpperCase();
        if (compressor.isEmpty() || "SNAPPY".equals(compressor) || "GZIP".equals(compressor) || "BZIP2".equals(compressor) || "LZ4".equals(compressor) || "ZSTD".equals(compressor)) {
            return compressor;
        }
        LOGGER.warn((Object)"The ".concat("carbon.sort.temp.compressor").concat(" configuration value is invalid. Only snappy, gzip, bip2, lz4, zstd and").concat(" empty are allowed. It will not compress the sort temp files by default"));
        return "SNAPPY";
    }

    public boolean isLoadSkewedDataOptimizationEnabled() {
        String skewedEnabled = this.getProperty("carbon.load.skewedDataOptimization.enabled", "false");
        return skewedEnabled.equalsIgnoreCase("true");
    }

    public boolean isCarbonProperty(String key) {
        return this.propertySet.contains(key);
    }

    public Map<String, String> getAddedProperty() {
        return this.addedProperty;
    }

    public void addPropertyToPropertySet(Set<String> externalPropertySet) {
        this.propertySet.addAll(externalPropertySet);
    }

    private void validateWorkingMemory() {
        try {
            String unsafeWorkingMemoryStr = this.carbonProperties.getProperty("carbon.unsafe.working.memory.in.mb");
            if (unsafeWorkingMemoryStr == null) {
                return;
            }
            int unsafeWorkingMemory = Integer.parseInt(unsafeWorkingMemoryStr);
            this.carbonProperties.setProperty("carbon.unsafe.working.memory.in.mb", unsafeWorkingMemory + "");
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)"The specified value for property carbon.unsafe.working.memory.in.mb is invalid.");
        }
    }

    private void validateSortStorageMemory() {
        int unsafeSortStorageMemory;
        try {
            String unsafeSortStorageMemoryStr = this.carbonProperties.getProperty("carbon.sort.storage.inmemory.size.inmb");
            unsafeSortStorageMemory = unsafeSortStorageMemoryStr != null ? Integer.parseInt(unsafeSortStorageMemoryStr) : 512;
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)String.format("The specified value for property %s is invalid. Taking the default value.%s", "carbon.sort.storage.inmemory.size.inmb", 512));
            unsafeSortStorageMemory = 512;
        }
        if (unsafeSortStorageMemory < 512) {
            LOGGER.warn((Object)"The specified value for property carbon.sort.storage.inmemory.size.inmb is less than the default value. Taking the default value: 512.");
            unsafeSortStorageMemory = 512;
        }
        this.carbonProperties.setProperty("carbon.sort.storage.inmemory.size.inmb", unsafeSortStorageMemory + "");
    }

    private void validateEnableQueryStatistics() {
        String enableQueryStatistics = this.carbonProperties.getProperty("enable.query.statistics", "false");
        boolean isValidBooleanValue = CarbonUtil.validateBoolean(enableQueryStatistics);
        if (!isValidBooleanValue) {
            LOGGER.warn((Object)String.format("The enable query statistics value \"%s\" is invalid. Using the default value \"%s\"", enableQueryStatistics, "false"));
            this.carbonProperties.setProperty("enable.query.statistics", "false");
        }
    }

    public boolean isEnableQueryStatistics() {
        String enableQueryStatistics = this.carbonProperties.getProperty("enable.query.statistics", "false");
        return enableQueryStatistics.equalsIgnoreCase("true");
    }

    public int getHeapMemoryPoolingThresholdBytes() {
        int thresholdSize;
        try {
            thresholdSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.heap.memory.pooling.threshold.bytes", "1048576"));
        }
        catch (NumberFormatException exc) {
            LOGGER.warn((Object)"The heap memory pooling threshold bytes is invalid. Using the default value 1048576");
            thresholdSize = Integer.parseInt("1048576");
        }
        return thresholdSize;
    }

    public int getRangeColumnScaleFactor() {
        boolean isValid = true;
        int scaleFactor = 1;
        try {
            scaleFactor = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.range.column.scale.factor", "3"));
            if (scaleFactor < 1 || scaleFactor > 300) {
                isValid = false;
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.warn((Object)"Range column scala factor isn't number format");
            isValid = false;
        }
        if (isValid) {
            return scaleFactor;
        }
        LOGGER.warn((Object)"The scale factor is invalid. Using the default value 3");
        return Integer.parseInt("3");
    }

    public long getSegmentLockFilesPreserveHours() {
        long preserveSeconds;
        try {
            int preserveHours = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.segment.lock.files.preserve.hours", "48"));
            preserveSeconds = (long)(preserveHours * 3600) * 1000L;
        }
        catch (NumberFormatException exc) {
            LOGGER.warn((Object)"The value of 'carbon.segment.lock.files.preserve.hours' is invalid. Using the default value 48");
            preserveSeconds = (long)(Integer.parseInt("48") * 3600) * 1000L;
        }
        return preserveSeconds;
    }

    public int getInvisibleSegmentPreserveCount() {
        int preserveCnt;
        try {
            preserveCnt = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.invisible.segments.preserve.count", "200"));
        }
        catch (NumberFormatException exc) {
            LOGGER.warn((Object)"The value of 'carbon.invisible.segments.preserve.count' is invalid. Using the default value 200");
            preserveCnt = Integer.parseInt("200");
        }
        return preserveCnt;
    }

    public String getSystemFolderLocationPerDatabase(String databaseLocation) {
        return databaseLocation + "/" + "_system";
    }

    public int getSortMemorySpillPercentage() {
        int spillPercentage = 0;
        try {
            String spillPercentageStr = this.getProperty("carbon.load.sortmemory.spill.percentage", "0");
            spillPercentage = Integer.parseInt(spillPercentageStr);
        }
        catch (NumberFormatException e) {
            spillPercentage = Integer.parseInt("0");
        }
        return spillPercentage;
    }

    public boolean isPushRowFiltersForVector() {
        String pushFilters = this.getProperty("carbon.push.rowfilters.for.vector", "false");
        return Boolean.parseBoolean(pushFilters);
    }

    public boolean isRangeCompactionAllowed() {
        String isRangeCompact = this.getProperty("carbon.enable.range.compaction", "true");
        return Boolean.parseBoolean(isRangeCompact);
    }

    private void validateSortMemorySpillPercentage() {
        String spillPercentageStr = this.carbonProperties.getProperty("carbon.load.sortmemory.spill.percentage", "0");
        try {
            int spillPercentage = Integer.parseInt(spillPercentageStr);
            if (spillPercentage > 100 || spillPercentage < 0) {
                LOGGER.info((Object)String.format("The sort memory spill percentage value \"%s\" is invalid. Using the default value \"%s\"", spillPercentageStr, "0"));
                this.carbonProperties.setProperty("carbon.load.sortmemory.spill.percentage", "0");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)String.format("The sort memory spill percentage value \"%s\" is invalid. Using the default value \"%s\"", spillPercentageStr, "0"));
            this.carbonProperties.setProperty("carbon.load.sortmemory.spill.percentage", "0");
        }
    }

    private void validateStringCharacterLimit() {
        int allowedCharactersLimit = 0;
        try {
            allowedCharactersLimit = Integer.parseInt(this.carbonProperties.getProperty("carbon.minmax.allowed.byte.count", "200"));
            if (allowedCharactersLimit < 10 || allowedCharactersLimit > 1000) {
                LOGGER.info((Object)String.format("The min max byte limit for string type value \"%s\" is invalid. Using the default value \"%s\"", allowedCharactersLimit, "200"));
                this.carbonProperties.setProperty("carbon.minmax.allowed.byte.count", "200");
            } else {
                LOGGER.info((Object)("Considered value for min max byte limit for string is: " + allowedCharactersLimit));
                this.carbonProperties.setProperty("carbon.minmax.allowed.byte.count", allowedCharactersLimit + "");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)String.format("The min max byte limit for string type value \"%s\" is invalid. Using the default value \"%s\"", allowedCharactersLimit, "200"));
            this.carbonProperties.setProperty("carbon.minmax.allowed.byte.count", "200");
        }
    }

    private void validateDetailQueryBatchSize() {
        String batchSizeString = this.carbonProperties.getProperty("carbon.detail.batch.size");
        if (batchSizeString == null) {
            this.carbonProperties.setProperty("carbon.detail.batch.size", Integer.toString(100));
            LOGGER.info((Object)"Using default value for carbon.detail.batch.size 100");
        } else {
            try {
                int batchSize = Integer.parseInt(batchSizeString);
                if (batchSize < 100 || batchSize > 1000) {
                    LOGGER.warn((Object)"Invalid carbon.detail.batch.size.Using default value 100");
                    this.carbonProperties.setProperty("carbon.detail.batch.size", Integer.toString(100));
                }
            }
            catch (NumberFormatException ne) {
                LOGGER.info((Object)"Invalid carbon.detail.batch.size.Using default value 100");
                this.carbonProperties.setProperty("carbon.detail.batch.size", Integer.toString(100));
            }
        }
    }

    private void validateDMSchemaStorageProvider() {
        String provider = this.carbonProperties.getProperty("carbon.index.schema.storage");
        if (provider == null) {
            this.carbonProperties.setProperty("carbon.index.schema.storage", "DISK");
        } else {
            switch (provider.toUpperCase()) {
                case "DISK": {
                    break;
                }
                case "DATABASE": {
                    break;
                }
                default: {
                    LOGGER.warn((Object)("The value \"" + provider + "\" configured for key " + "carbon.index.schema.storage" + " is invalid for current file system. Use the default value " + "DISK" + " instead."));
                    this.carbonProperties.setProperty("carbon.index.schema.storage", "DISK");
                }
            }
        }
    }

    public boolean isDistributedPruningEnabled(String dbName, String tableName) {
        boolean isServerEnabledByUser;
        String configuredValue = this.getSessionPropertyValue("carbon.enable.index.server." + dbName + "." + tableName);
        if (configuredValue == null) {
            configuredValue = this.getProperty("carbon.enable.index.server");
        }
        if (isServerEnabledByUser = Boolean.parseBoolean(configuredValue)) {
            LOGGER.info((Object)("Distributed Index server is enabled for " + dbName + "." + tableName));
        }
        return isServerEnabledByUser;
    }

    public boolean isIndexServerPrePrimingEnabled() {
        String configuredValue = this.carbonProperties.getProperty("carbon.indexserver.enable.prepriming");
        return Boolean.parseBoolean(configuredValue);
    }

    public String getIndexServerIP() {
        return this.carbonProperties.getProperty("carbon.index.server.ip", "");
    }

    public int getIndexServerPort() {
        String configuredPort = this.carbonProperties.getProperty("carbon.index.server.port");
        try {
            return Integer.parseInt(configuredPort);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Configured port for index server is not a valid number", (Throwable)e);
            throw e;
        }
    }

    public boolean isFallBackDisabled() {
        return Boolean.parseBoolean(this.carbonProperties.getProperty("carbon.disable.index.server.fallback", "false"));
    }

    public int getNumberOfHandlersForIndexServer() {
        String configuredValue = this.carbonProperties.getProperty("carbon.index.server.max.worker.threads");
        if (configuredValue != null) {
            return Integer.parseInt(configuredValue);
        }
        return 500;
    }

    public int getNumOfThreadsForExecutorPruning() {
        String configuredValue = CarbonProperties.getInstance().getProperty("carbon.max.executor.threads.for.block.pruning");
        if (configuredValue == null || configuredValue.equalsIgnoreCase("0")) {
            configuredValue = "4";
        }
        try {
            int numOfThreads = Integer.parseInt(configuredValue);
            LOGGER.info((Object)("Value for carbon.max.executor.threads.for.block.pruning is " + numOfThreads));
            return numOfThreads;
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)(configuredValue + " is not a valid input for " + "carbon.max.executor.threads.for.block.pruning" + ", taking " + "4" + " as default value"));
            return Integer.parseInt("4");
        }
    }

    public static int getNumOfThreadsForPruning() {
        int numOfThreadsForPruning;
        String maxDriverThreadsForBockPruning = "carbon.max.driver.threads.for.block.pruning";
        int defaultNumberOfThreads = Integer.parseInt("4");
        String logMessage = " is not a valid input for " + maxDriverThreadsForBockPruning + ". Using the default number of threads : " + defaultNumberOfThreads;
        try {
            numOfThreadsForPruning = Integer.parseInt(CarbonProperties.getInstance().getProperty(maxDriverThreadsForBockPruning, String.valueOf(defaultNumberOfThreads)));
            if (numOfThreadsForPruning > defaultNumberOfThreads || numOfThreadsForPruning < 1) {
                LOGGER.info((Object)(numOfThreadsForPruning + logMessage));
                numOfThreadsForPruning = defaultNumberOfThreads;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)CarbonProperties.getInstance().getProperty(maxDriverThreadsForBockPruning + logMessage));
            numOfThreadsForPruning = defaultNumberOfThreads;
        }
        return numOfThreadsForPruning;
    }

    public static int getDriverPruningMultiThreadEnableFilesCount() {
        int driverPruningMultiThreadEnableFilesCount = 0;
        try {
            driverPruningMultiThreadEnableFilesCount = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.driver.pruning.multi.thread.enable.files.count", "100000"));
            if (driverPruningMultiThreadEnableFilesCount <= 0) {
                LOGGER.info((Object)("The driver prunning multithread enable files count value \"" + driverPruningMultiThreadEnableFilesCount + "\" is invalid. Using the default value \"" + "100000"));
                driverPruningMultiThreadEnableFilesCount = Integer.parseInt("100000");
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)"The driver prunning multithread enable files count value is invalid. Using the default value \"100000");
            driverPruningMultiThreadEnableFilesCount = Integer.parseInt("100000");
        }
        return driverPruningMultiThreadEnableFilesCount;
    }

    public static Long getInputMetricsInterval() {
        String metrics = CarbonProperties.getInstance().getProperty("carbon.input.metrics.update.interval");
        if (metrics == null) {
            return CarbonCommonConstants.INPUT_METRICS_UPDATE_INTERVAL_DEFAULT;
        }
        try {
            long configuredValue = Long.parseLong(metrics);
            if (configuredValue < 0L) {
                return CarbonCommonConstants.INPUT_METRICS_UPDATE_INTERVAL_DEFAULT;
            }
            return configuredValue;
        }
        catch (Exception ex) {
            return CarbonCommonConstants.INPUT_METRICS_UPDATE_INTERVAL_DEFAULT;
        }
    }

    public static Boolean getQueryPrefetchEnable() {
        String prefetchEnable = CarbonProperties.getInstance().getProperty("carbon.query.prefetch.enable");
        if (prefetchEnable == null) {
            return Boolean.parseBoolean("true");
        }
        return !prefetchEnable.equalsIgnoreCase("false");
    }

    public static Boolean isUniqueValueCheckEnabled() {
        String needValidate = CarbonProperties.getInstance().getProperty("carbon.update.check.unique.value");
        if (needValidate == null) {
            return Boolean.parseBoolean("true");
        }
        return !needValidate.equalsIgnoreCase("false");
    }

    private void validateAndGetLocalDictionarySizeThresholdInMB() {
        String sizeStr = this.carbonProperties.getProperty("carbon.local.dictionary.size.threshold.inmb");
        String defaultValue = Integer.toString(4);
        if (sizeStr == null) {
            this.carbonProperties.setProperty("carbon.local.dictionary.size.threshold.inmb", defaultValue);
        } else {
            try {
                int size = Integer.parseInt(sizeStr);
                if (size < 0 || size == 0 || size > 16) {
                    LOGGER.info((Object)("using default value of carbon.local.dictionary.size.threshold.inmb = " + defaultValue));
                    this.carbonProperties.setProperty("carbon.local.dictionary.size.threshold.inmb", defaultValue);
                } else {
                    LOGGER.info((Object)("using carbon.local.dictionary.size.threshold.inmb = " + size));
                    this.carbonProperties.setProperty("carbon.local.dictionary.size.threshold.inmb", Integer.toString(size));
                }
            }
            catch (Exception ex) {
                LOGGER.info((Object)("using default value of carbon.local.dictionary.size.threshold.inmb = " + defaultValue));
                this.carbonProperties.setProperty("carbon.local.dictionary.size.threshold.inmb", defaultValue);
            }
        }
    }

    public static String getIndexStorageProvider() {
        String provider = CarbonProperties.getInstance().getProperty("carbon.index.schema.storage");
        if (provider == null) {
            return "DISK";
        }
        return provider.toUpperCase();
    }

    public static Boolean isBadRecordHandlingEnabledForInsert() {
        String badRecordHandling = CarbonProperties.getInstance().getProperty("carbon.enable.bad.record.handling.for.insert");
        if (badRecordHandling == null) {
            return Boolean.parseBoolean("false");
        }
        return badRecordHandling.equalsIgnoreCase("true");
    }

    public String getDefaultCompressor() {
        return this.getProperty("carbon.column.compressor", "snappy");
    }

    public static boolean isQueryStageInputEnabled() {
        return Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.query.stage.input.enable", "false"));
    }

    public static boolean isAuditEnabled() {
        return Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.audit.enabled", "true"));
    }

    public static void setAuditEnabled(boolean enabled) {
        CarbonProperties.getInstance().addProperty("carbon.audit.enabled", String.valueOf(enabled));
    }
}

