/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class CarbonThreadFactory
implements ThreadFactory {
    private ThreadFactory defaultFactory = Executors.defaultThreadFactory();
    private String name;
    private boolean withTime = false;

    public CarbonThreadFactory(String name) {
        this.name = name;
    }

    public CarbonThreadFactory(String name, boolean withTime) {
        this(name);
        this.withTime = withTime;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.defaultFactory.newThread(r);
        if (this.withTime) {
            thread.setName(this.name + "_" + System.currentTimeMillis());
        } else {
            thread.setName(this.name);
        }
        return thread;
    }
}

