/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import org.apache.carbondata.core.stats.DriverQueryStatisticsRecorderDummy;
import org.apache.carbondata.core.stats.DriverQueryStatisticsRecorderImpl;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.stats.QueryStatisticsRecorderDummy;
import org.apache.carbondata.core.stats.QueryStatisticsRecorderImpl;
import org.apache.carbondata.core.util.CarbonLoadStatisticsDummy;
import org.apache.carbondata.core.util.CarbonLoadStatisticsImpl;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.LoadStatistics;

public class CarbonTimeStatisticsFactory {
    private static String loadStatisticsInstanceType;
    private static LoadStatistics loadStatisticsInstance;
    private static String driverRecorderType;
    private static QueryStatisticsRecorder driverRecorder;

    private static void updateTimeStatisticsUtilStatus() {
        loadStatisticsInstanceType = CarbonProperties.getInstance().getProperty("enable.data.loading.statistics", "false");
        driverRecorderType = CarbonProperties.getInstance().getProperty("enable.query.statistics", "false");
    }

    private static LoadStatistics genLoadStatisticsInstance() {
        if (loadStatisticsInstanceType.equalsIgnoreCase("true")) {
            return CarbonLoadStatisticsImpl.getInstance();
        }
        return CarbonLoadStatisticsDummy.getInstance();
    }

    public static LoadStatistics getLoadStatisticsInstance() {
        return loadStatisticsInstance;
    }

    private static QueryStatisticsRecorder genDriverRecorder() {
        if (driverRecorderType.equalsIgnoreCase("true")) {
            return DriverQueryStatisticsRecorderImpl.getInstance();
        }
        return DriverQueryStatisticsRecorderDummy.getInstance();
    }

    public static QueryStatisticsRecorder createDriverRecorder() {
        return driverRecorder;
    }

    public static QueryStatisticsRecorder createExecutorRecorder(String queryId) {
        String queryStatisticsRecorderType = CarbonProperties.getInstance().getProperty("enable.query.statistics", "false");
        if (queryStatisticsRecorderType.equalsIgnoreCase("true")) {
            return new QueryStatisticsRecorderImpl(queryId);
        }
        return new QueryStatisticsRecorderDummy();
    }

    static {
        CarbonTimeStatisticsFactory.updateTimeStatisticsUtilStatus();
        loadStatisticsInstance = CarbonTimeStatisticsFactory.genLoadStatisticsInstance();
        driverRecorder = CarbonTimeStatisticsFactory.genDriverRecorder();
    }
}

