/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.DataTypeUtil;

public class CarbonUnsafeUtil {
    public static void putDataToUnsafe(DataType dataType, Object data, Object baseObject, long address, int size, int sizeInBytes) {
        if ((dataType = DataTypeUtil.valueOf(dataType.getName())) == DataTypes.BOOLEAN) {
            CarbonUnsafe.getUnsafe().putBoolean(baseObject, address + (long)size, (Boolean)data);
        } else if (dataType == DataTypes.BYTE) {
            CarbonUnsafe.getUnsafe().putByte(baseObject, address + (long)size, (Byte)data);
        } else if (dataType == DataTypes.SHORT) {
            CarbonUnsafe.getUnsafe().putShort(baseObject, address + (long)size, (Short)data);
        } else if (dataType == DataTypes.INT) {
            CarbonUnsafe.getUnsafe().putInt(baseObject, address + (long)size, (Integer)data);
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            CarbonUnsafe.getUnsafe().putLong(baseObject, address + (long)size, (Long)data);
        } else if (DataTypes.isDecimal(dataType) || dataType == DataTypes.DOUBLE) {
            CarbonUnsafe.getUnsafe().putDouble(baseObject, address + (long)size, (Double)data);
        } else if (dataType == DataTypes.FLOAT) {
            CarbonUnsafe.getUnsafe().putFloat(baseObject, address + (long)size, ((Float)data).floatValue());
        } else if (dataType == DataTypes.BYTE_ARRAY) {
            CarbonUnsafe.getUnsafe().copyMemory(data, CarbonUnsafe.BYTE_ARRAY_OFFSET, baseObject, address + (long)size, sizeInBytes);
        }
    }

    public static Object getDataFromUnsafe(DataType dataType, Object baseObject, long address, int size, int sizeInBytes) {
        dataType = DataTypeUtil.valueOf(dataType.getName());
        Object data = new Object();
        if (dataType == DataTypes.BOOLEAN) {
            data = CarbonUnsafe.getUnsafe().getBoolean(baseObject, address + (long)size);
        } else if (dataType == DataTypes.BYTE) {
            data = CarbonUnsafe.getUnsafe().getByte(baseObject, address + (long)size);
        } else if (dataType == DataTypes.SHORT) {
            data = CarbonUnsafe.getUnsafe().getShort(baseObject, address + (long)size);
        } else if (dataType == DataTypes.INT) {
            data = CarbonUnsafe.getUnsafe().getInt(baseObject, address + (long)size);
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            data = CarbonUnsafe.getUnsafe().getLong(baseObject, address + (long)size);
        } else if (DataTypes.isDecimal(dataType) || dataType == DataTypes.DOUBLE) {
            data = CarbonUnsafe.getUnsafe().getDouble(baseObject, address + (long)size);
        } else if (dataType == DataTypes.FLOAT) {
            data = Float.valueOf(CarbonUnsafe.getUnsafe().getFloat(baseObject, address + (long)size));
        } else if (dataType == DataTypes.BYTE_ARRAY) {
            CarbonUnsafe.getUnsafe().copyMemory(baseObject, address + (long)size, data, CarbonUnsafe.BYTE_ARRAY_OFFSET, sizeInBytes);
        }
        return data;
    }
}

