/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.block.AbstractIndex;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.columnar.UnBlockIndexer;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.FallbackEncodedColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.DefaultEncodingFactory;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.localdictionary.generator.ColumnLocalDictionaryGenerator;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.ValueEncoderMeta;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypeAdapter;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.schema.SchemaEvolution;
import org.apache.carbondata.core.metadata.schema.SchemaEvolutionEntry;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.reader.CarbonHeaderReader;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.AbstractDataFileFooterConverter;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.DataFileFooterConverterFactory;
import org.apache.carbondata.core.util.DataLoadMetrics;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.BlockletHeader;
import org.apache.carbondata.format.DataChunk3;
import org.apache.carbondata.format.Encoding;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.format.ParentColumnTableRelation;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.format.TableSchema;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public final class CarbonUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonUtil.class.getName());
    private static final int CONST_EIGHT = 8;
    private static final int CONST_SEVEN = 7;
    private static final int CONST_HUNDRED = 100;
    private static final int HDFS_CHECKSUM_LENGTH = 512;

    private CarbonUtil() {
    }

    public static void closeStreams(Closeable ... streams) {
        if (null != streams) {
            for (Closeable stream : streams) {
                try {
                    CarbonUtil.closeStream(stream);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error while closing stream:" + e), (Throwable)e);
                }
            }
        }
    }

    public static void closeStream(Closeable stream) throws IOException {
        if (null != stream) {
            stream.close();
        }
    }

    public static int[] getIncrementedCardinality(int[] dimCardinality) {
        int i;
        int incrValue = 10;
        int perIncr = 0;
        int remainder = 0;
        int[] newDimsC = new int[dimCardinality.length];
        for (i = 0; i < dimCardinality.length; ++i) {
            perIncr = dimCardinality[i] * 10 / 100;
            newDimsC[i] = perIncr > 0 ? dimCardinality[i] + perIncr : dimCardinality[i] + 1;
            remainder = newDimsC[i] % 8;
            if (remainder != 7) continue;
            newDimsC[i] = dimCardinality[i] + 1;
        }
        for (i = 0; i < newDimsC.length; ++i) {
            newDimsC[i] = Long.toBinaryString(newDimsC[i]).length();
        }
        return newDimsC;
    }

    public static int getIncrementedCardinality(int dimCardinality) {
        int incrValue = 10;
        int perIncr = 0;
        int remainder = 0;
        int newDimsC = 0;
        perIncr = dimCardinality * 10 / 100;
        newDimsC = perIncr > 0 ? dimCardinality + perIncr : dimCardinality + 1;
        remainder = newDimsC % 8;
        if (remainder == 7) {
            newDimsC = dimCardinality + 1;
        }
        newDimsC = Long.toBinaryString(newDimsC).length();
        return newDimsC;
    }

    public static int[] getIncrementedCardinalityFullyFilled(int[] dimCardinality) {
        int[] newDimsC = new int[dimCardinality.length];
        for (int i = 0; i < dimCardinality.length; ++i) {
            if (dimCardinality[i] == 0) {
                newDimsC[i] = 64;
                continue;
            }
            int bitsLength = Long.toBinaryString(dimCardinality[i]).length();
            int div = bitsLength / 8;
            int mod = bitsLength % 8;
            newDimsC[i] = mod > 0 ? 8 * (div + 1) : bitsLength;
        }
        return newDimsC;
    }

    private static int getBitLengthFullyFilled(int dimlens) {
        int bitsLength = Long.toBinaryString(dimlens).length();
        int div = bitsLength / 8;
        int mod = bitsLength % 8;
        if (mod > 0) {
            return 8 * (div + 1);
        }
        return bitsLength;
    }

    public static void deleteFoldersAndFiles(final File ... path) throws IOException, InterruptedException {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                for (int i = 0; i < path.length; ++i) {
                    CarbonFile carbonFile = FileFactory.getCarbonFile(path[i].getAbsolutePath());
                    boolean delete = carbonFile.delete();
                    if (delete) continue;
                    throw new IOException("Error while deleting file: " + carbonFile.getAbsolutePath());
                }
                return null;
            }
        });
    }

    public static void deleteFoldersAndFiles(final CarbonFile ... file) throws IOException, InterruptedException {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                for (int i = 0; i < file.length; ++i) {
                    boolean delete;
                    if (!file[i].exists() || (delete = file[i].delete())) continue;
                    throw new IOException("Error while deleting file: " + file[i].getAbsolutePath());
                }
                return null;
            }
        });
    }

    public static void deleteFoldersAndFilesSilent(final CarbonFile ... file) throws IOException, InterruptedException {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() {
                for (int i = 0; i < file.length; ++i) {
                    boolean delete;
                    if (!file[i].exists() || (delete = file[i].delete())) continue;
                    LOGGER.warn((Object)("Unable to delete file: " + file[i].getCanonicalPath()));
                }
                return null;
            }
        });
    }

    public static void deleteFiles(File[] intermediateFiles) throws IOException {
        for (int i = 0; i < intermediateFiles.length; ++i) {
            if (intermediateFiles[i].delete() || intermediateFiles[i].getName().endsWith(".carbonindex")) continue;
            throw new IOException("Problem while deleting intermediate file");
        }
    }

    public static int getFirstIndexUsingBinarySearch(DimensionColumnPage dimColumnDataChunk, int low, int high, byte[] compareValue, boolean matchUpLimit) {
        int cmpResult = 0;
        while (high >= low) {
            int mid = (low + high) / 2;
            cmpResult = dimColumnDataChunk.compareTo(mid, compareValue);
            if (cmpResult < 0) {
                low = mid + 1;
                continue;
            }
            if (cmpResult > 0) {
                high = mid - 1;
                continue;
            }
            int currentIndex = mid;
            if (!matchUpLimit) {
                while (currentIndex - 1 >= 0 && dimColumnDataChunk.compareTo(currentIndex - 1, compareValue) == 0) {
                    --currentIndex;
                }
            } else {
                while (currentIndex + 1 <= high && dimColumnDataChunk.compareTo(currentIndex + 1, compareValue) == 0) {
                    ++currentIndex;
                }
            }
            return currentIndex;
        }
        return -(low + 1);
    }

    public static int[] getRangeIndexUsingBinarySearch(DimensionColumnPage dimColumnDataChunk, int low, int high, byte[] compareValue) {
        int[] rangeIndex = new int[2];
        int cmpResult = 0;
        while (high >= low) {
            int mid = (low + high) / 2;
            cmpResult = dimColumnDataChunk.compareTo(mid, compareValue);
            if (cmpResult < 0) {
                low = mid + 1;
                continue;
            }
            if (cmpResult > 0) {
                high = mid - 1;
                continue;
            }
            int currentIndex = mid;
            while (currentIndex - 1 >= 0 && dimColumnDataChunk.compareTo(currentIndex - 1, compareValue) == 0) {
                --currentIndex;
            }
            rangeIndex[0] = currentIndex;
            currentIndex = mid;
            while (currentIndex + 1 <= high && dimColumnDataChunk.compareTo(currentIndex + 1, compareValue) == 0) {
                ++currentIndex;
            }
            rangeIndex[1] = currentIndex;
            return rangeIndex;
        }
        rangeIndex[1] = -1;
        return rangeIndex;
    }

    private static void rangeCheck(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
    }

    public static int binarySearch(byte[][] filterValues, int low, int high, DimensionColumnPage dimensionColumnPage, int rowId) {
        CarbonUtil.rangeCheck(low, high);
        while (low <= high) {
            int mid = low + high >>> 1;
            int result = dimensionColumnPage.compareTo(rowId, filterValues[mid]);
            if (result < 0) {
                high = mid - 1;
                continue;
            }
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int nextLesserValueToTarget(int currentIndex, DimensionColumnPage dimColumnDataChunk, byte[] compareValue) {
        while (currentIndex - 1 >= 0 && dimColumnDataChunk.compareTo(currentIndex - 1, compareValue) >= 0) {
            --currentIndex;
        }
        return --currentIndex;
    }

    public static int nextGreaterValueToTarget(int currentIndex, DimensionColumnPage dimColumnDataChunk, byte[] compareValue, int numerOfRows) {
        while (currentIndex + 1 < numerOfRows && dimColumnDataChunk.compareTo(currentIndex + 1, compareValue) <= 0) {
            ++currentIndex;
        }
        return ++currentIndex;
    }

    public static int[] getUnCompressColumnIndex(int totalLength, ByteBuffer buffer, int offset) {
        buffer.position(offset);
        int indexDataLength = buffer.getInt();
        int indexMapLength = totalLength - indexDataLength - 4;
        int[] indexData = CarbonUtil.getIntArray(buffer, buffer.position(), indexDataLength);
        int[] indexMap = CarbonUtil.getIntArray(buffer, buffer.position(), indexMapLength);
        return UnBlockIndexer.uncompressIndex(indexData, indexMap);
    }

    public static int[] getIntArray(ByteBuffer data, int offset, int length) {
        if (length == 0) {
            return new int[0];
        }
        data.position(offset);
        int[] intArray = new int[length / 2];
        int index = 0;
        while (index < intArray.length) {
            intArray[index++] = data.getShort();
        }
        return intArray;
    }

    public static List<Integer> convertToIntegerList(int[] array) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            integers.add(array[i]);
        }
        return integers;
    }

    public static String unescapeChar(String parseStr) {
        return StringEscapeUtils.unescapeJava((String)parseStr);
    }

    public static String unquoteChar(String parseStr) {
        if (parseStr == null) {
            return null;
        }
        if (parseStr.startsWith("'") && parseStr.endsWith("'")) {
            return parseStr.substring(1, parseStr.length() - 1);
        }
        if (parseStr.startsWith("\"") && parseStr.endsWith("\"")) {
            return parseStr.substring(1, parseStr.length() - 1);
        }
        return parseStr;
    }

    public static String delimiterConverter(String delimiter) {
        switch (delimiter) {
            case "\\001": 
            case "\\002": 
            case "\\003": 
            case "\\004": 
            case "|": 
            case "*": 
            case ".": 
            case ":": 
            case "^": 
            case "\\": 
            case "$": 
            case "+": 
            case "?": 
            case "(": 
            case ")": 
            case "{": 
            case "}": 
            case "[": 
            case "]": {
                return "\\" + delimiter;
            }
        }
        return delimiter;
    }

    public static String checkAndAppendHDFSUrl(String filePath) {
        String currentPath = filePath;
        String defaultFsUrl = FileFactory.getConfiguration().get("fs.defaultFS");
        String baseDFSUrl = CarbonProperties.getInstance().getProperty("carbon.ddl.base.hdfs.url", "");
        if (FileFactory.checkIfPrefixExists(filePath)) {
            return currentPath;
        }
        if (baseDFSUrl.endsWith("/")) {
            baseDFSUrl = baseDFSUrl.substring(0, baseDFSUrl.length() - 1);
        }
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        if (FileFactory.checkIfPrefixExists(currentPath = baseDFSUrl + filePath)) {
            return currentPath;
        }
        if (defaultFsUrl == null) {
            return currentPath;
        }
        return defaultFsUrl + currentPath;
    }

    public static String checkAndAppendFileSystemURIScheme(String filePath) {
        String currentPath = filePath;
        if (FileFactory.checkIfPrefixExists(filePath)) {
            return currentPath;
        }
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        currentPath = filePath;
        String defaultFsUrl = FileFactory.getConfiguration().get("fs.defaultFS");
        if (defaultFsUrl == null) {
            return currentPath;
        }
        return defaultFsUrl + currentPath;
    }

    public static String inferCompressorFromFileName(String path) {
        if (path.endsWith(".gz")) {
            return "GZIP";
        }
        if (path.endsWith("bz2")) {
            return "BZIP2";
        }
        return "";
    }

    public static String removeAKSK(String filePath) {
        if (null == filePath) {
            return "";
        }
        String lowerPath = filePath.toLowerCase(Locale.getDefault());
        if (lowerPath.startsWith("s3n://") || lowerPath.startsWith("s3a://") || lowerPath.startsWith("s3://")) {
            int prefixLength = filePath.indexOf(":", 0) + 3;
            int pathOffset = filePath.indexOf("@");
            if (pathOffset > 0) {
                return filePath.substring(0, prefixLength) + filePath.substring(pathOffset + 1);
            }
        }
        return filePath;
    }

    public static boolean isFileExists(String fileName) {
        try {
            if (FileFactory.isFileExist(fileName)) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("@@@@@@  File not found at a given location @@@@@@ : " + CarbonUtil.removeAKSK(fileName)));
        }
        return false;
    }

    public static boolean checkAndCreateFolder(String path) {
        boolean created = false;
        try {
            created = FileFactory.isFileExist(path) ? true : FileFactory.mkdirs(path);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return created;
    }

    public static boolean checkAndCreateFolderWithPermission(String path) {
        boolean created = false;
        try {
            if (FileFactory.isFileExist(path)) {
                created = true;
            } else {
                FileFactory.createDirectoryAndSetPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
                created = true;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return created;
    }

    public static long getFileSize(String filePath) {
        CarbonFile carbonFile = FileFactory.getCarbonFile(filePath);
        return carbonFile.getSize();
    }

    public static int[] getDimensionBitLength(int[] dimCardinality, int[] dimPartitioner) {
        int[] bitLength = new int[dimCardinality.length];
        int dimCounter = 0;
        for (int i = 0; i < dimPartitioner.length; ++i) {
            if (dimPartitioner[i] == 1) {
                bitLength[dimCounter] = CarbonUtil.getBitLengthFullyFilled(dimCardinality[dimCounter]);
                ++dimCounter;
                continue;
            }
            int totalSize = 0;
            for (int j = 0; j < dimPartitioner[i]; ++j) {
                bitLength[dimCounter] = CarbonUtil.getIncrementedCardinality(dimCardinality[dimCounter]);
                totalSize += bitLength[dimCounter];
                ++dimCounter;
            }
            int mod = totalSize % 8;
            if (mod <= 0) continue;
            bitLength[dimCounter - 1] = bitLength[dimCounter - 1] + (8 - mod);
        }
        return bitLength;
    }

    public static boolean hasEncoding(List<org.apache.carbondata.core.metadata.encoder.Encoding> encodings, org.apache.carbondata.core.metadata.encoder.Encoding encoding) {
        return encodings.contains((Object)encoding);
    }

    public static boolean hasDataType(DataType dataType, DataType[] dataTypes) {
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataType.equals(dataTypes[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean[] getImplicitColumnArray(ProjectionDimension[] queryDimensions) {
        boolean[] implicitColumnArray = new boolean[queryDimensions.length];
        for (int i = 0; i < queryDimensions.length; ++i) {
            implicitColumnArray[i] = queryDimensions[i].getDimension().hasEncoding(org.apache.carbondata.core.metadata.encoder.Encoding.IMPLICIT);
        }
        return implicitColumnArray;
    }

    public static boolean[] getComplexDataTypeArray(ProjectionDimension[] queryDimensions) {
        boolean[] dictionaryEncodingArray = new boolean[queryDimensions.length];
        for (int i = 0; i < queryDimensions.length; ++i) {
            dictionaryEncodingArray[i] = queryDimensions[i].getDimension().getDataType().isComplexType();
        }
        return dictionaryEncodingArray;
    }

    public static DataFileFooter readMetadataFile(TableBlockInfo tableBlockInfo) throws IOException {
        return CarbonUtil.getDataFileFooter(tableBlockInfo, false);
    }

    public static DataFileFooter readMetadataFile(TableBlockInfo tableBlockInfo, boolean forceReadDataFileFooter) throws IOException {
        return CarbonUtil.getDataFileFooter(tableBlockInfo, forceReadDataFileFooter);
    }

    private static DataFileFooter getDataFileFooter(TableBlockInfo tableBlockInfo, boolean forceReadDataFileFooter) throws IOException {
        BlockletDetailInfo detailInfo = tableBlockInfo.getDetailInfo();
        if (detailInfo == null || forceReadDataFileFooter) {
            if (tableBlockInfo.getBlockOffset() == 0L) {
                return CarbonUtil.getDataFileFooterFromIndexFile(tableBlockInfo);
            }
            AbstractDataFileFooterConverter fileFooterConverter = DataFileFooterConverterFactory.getInstance().getDataFileFooterConverter(tableBlockInfo.getVersion());
            return fileFooterConverter.readDataFileFooter(tableBlockInfo);
        }
        DataFileFooter fileFooter = new DataFileFooter();
        fileFooter.setSchemaUpdatedTimeStamp(detailInfo.getSchemaUpdatedTimeStamp());
        ColumnarFormatVersion version = ColumnarFormatVersion.valueOf(detailInfo.getVersionNumber());
        AbstractDataFileFooterConverter dataFileFooterConverter = DataFileFooterConverterFactory.getInstance().getDataFileFooterConverter(version);
        List<ColumnSchema> schema = dataFileFooterConverter.getSchema(tableBlockInfo);
        fileFooter.setColumnInTable(schema);
        return fileFooter;
    }

    private static DataFileFooter getDataFileFooterFromIndexFile(TableBlockInfo tableBlockInfo) throws IOException {
        String filePath = tableBlockInfo.getFilePath();
        String dataFilePath = tableBlockInfo.getFilePath();
        String shardName = CarbonTablePath.getShardName(filePath);
        String indexFilePath = String.format("%s/%s%s", CarbonTablePath.getParentPath(filePath), shardName, ".carbonindex");
        ColumnarFormatVersion version = ColumnarFormatVersion.valueOf((short)3);
        AbstractDataFileFooterConverter footerConverter = DataFileFooterConverterFactory.getInstance().getDataFileFooterConverter(version);
        List<DataFileFooter> footers = footerConverter.getIndexInfo(indexFilePath, null, true);
        DataFileFooter blockFooter = null;
        for (DataFileFooter blockletFooter : footers) {
            if (!blockletFooter.getBlockInfo().getFilePath().equals(dataFilePath)) continue;
            if (blockFooter == null) {
                blockFooter = blockletFooter;
                continue;
            }
            blockFooter.getBlockletList().addAll(blockletFooter.getBlockletList());
        }
        if (blockFooter == null) {
            throw new RuntimeException("Footer not found in index file");
        }
        return blockFooter;
    }

    public static int getNumberOfDimensionColumns(List<ColumnSchema> columnSchemaList) {
        int numberOfDimensionColumns = 0;
        ColumnSchema columnSchema = null;
        for (int i = 0; i < columnSchemaList.size() && (columnSchema = columnSchemaList.get(i)).isDimensionColumn(); ++i) {
            ++numberOfDimensionColumns;
        }
        return numberOfDimensionColumns;
    }

    public static int getSurrogateKey(byte[] data, ByteBuffer buffer) {
        int length = 4 - data.length;
        for (int i = 0; i < length; ++i) {
            buffer.put((byte)0);
        }
        buffer.put(data);
        buffer.rewind();
        int surrogate = buffer.getInt();
        buffer.clear();
        return surrogate;
    }

    public static void clearBlockCache(List<AbstractIndex> dataBlocks) {
        if (null != dataBlocks) {
            for (AbstractIndex blocks : dataBlocks) {
                blocks.clear();
            }
        }
    }

    public static boolean[] identifyDimensionType(List<CarbonDimension> tableDimensionList) {
        CarbonDimension carbonDimension;
        List<CarbonDimension> childs;
        ArrayList<Boolean> isDictionaryDimensions = new ArrayList<Boolean>();
        Iterator<CarbonDimension> iterator = tableDimensionList.iterator();
        while (iterator.hasNext() && (null == (childs = (carbonDimension = iterator.next()).getListOfChildDimensions()) || childs.size() <= 0)) {
            if (carbonDimension.getDataType() == DataTypes.DATE) {
                isDictionaryDimensions.add(true);
                continue;
            }
            isDictionaryDimensions.add(false);
        }
        return ArrayUtils.toPrimitive((Boolean[])isDictionaryDimensions.toArray(new Boolean[isDictionaryDimensions.size()]));
    }

    public static byte[] packByteBufferIntoSingleByteArray(ByteBuffer[] byteBufferArr) {
        ByteBuffer individualCol;
        int index;
        if (null == byteBufferArr || byteBufferArr.length == 0) {
            return null;
        }
        int noOfCol = byteBufferArr.length;
        short offsetLen = (short)(noOfCol * 2);
        int totalBytes = CarbonUtil.calculateTotalBytes(byteBufferArr) + offsetLen;
        ByteBuffer buffer = ByteBuffer.allocate(totalBytes);
        buffer.putShort(offsetLen);
        for (index = 0; index < byteBufferArr.length - 1; ++index) {
            individualCol = byteBufferArr[index];
            int noOfBytes = individualCol.capacity();
            buffer.putShort((short)(offsetLen + noOfBytes));
            offsetLen = (short)(offsetLen + noOfBytes);
            individualCol.rewind();
        }
        for (index = 0; index < byteBufferArr.length; ++index) {
            individualCol = byteBufferArr[index];
            buffer.put(individualCol.array());
        }
        buffer.rewind();
        return buffer.array();
    }

    private static int calculateTotalBytes(ByteBuffer[] byteBufferArr) {
        int total = 0;
        for (int index = 0; index < byteBufferArr.length; ++index) {
            total += byteBufferArr[index].capacity();
        }
        return total;
    }

    public static CarbonDimension findDimension(List<CarbonDimension> dimensions, String carbonDim) {
        CarbonDimension findDim = null;
        for (CarbonDimension dimension : dimensions) {
            if (!dimension.getColName().equalsIgnoreCase(carbonDim)) continue;
            findDim = dimension;
            break;
        }
        return findDim;
    }

    public static CarbonDimension getDimensionFromCurrentBlock(List<CarbonDimension> blockDimensions, CarbonDimension dimensionToBeSearched) {
        CarbonDimension currentBlockDimension = null;
        for (CarbonDimension blockDimension : blockDimensions) {
            if (!dimensionToBeSearched.getColumnId().equalsIgnoreCase(blockDimension.getColumnId()) && !blockDimension.isColmatchBasedOnId(dimensionToBeSearched)) continue;
            currentBlockDimension = blockDimension;
            break;
        }
        return currentBlockDimension;
    }

    public static CarbonMeasure getMeasureFromCurrentBlock(List<CarbonMeasure> blockMeasures, CarbonMeasure measureToBeSearched) {
        CarbonMeasure currentBlockMeasure = null;
        for (CarbonMeasure blockMeasure : blockMeasures) {
            if (!measureToBeSearched.getColumnId().equalsIgnoreCase(blockMeasure.getColumnId()) && !blockMeasure.isColmatchBasedOnId(measureToBeSearched)) continue;
            currentBlockMeasure = blockMeasure;
            break;
        }
        return currentBlockMeasure;
    }

    public static List<ColumnSchema> getColumnSchemaList(List<CarbonDimension> carbonDimensionsList, List<CarbonMeasure> carbonMeasureList) {
        ArrayList<ColumnSchema> wrapperColumnSchemaList = new ArrayList<ColumnSchema>();
        CarbonUtil.fillCollumnSchemaListForComplexDims(carbonDimensionsList, wrapperColumnSchemaList);
        for (CarbonMeasure carbonMeasure : carbonMeasureList) {
            wrapperColumnSchemaList.add(carbonMeasure.getColumnSchema());
        }
        return wrapperColumnSchemaList;
    }

    private static void fillCollumnSchemaListForComplexDims(List<CarbonDimension> carbonDimensionsList, List<ColumnSchema> wrapperColumnSchemaList) {
        for (CarbonDimension carbonDimension : carbonDimensionsList) {
            wrapperColumnSchemaList.add(carbonDimension.getColumnSchema());
            List<CarbonDimension> childDims = carbonDimension.getListOfChildDimensions();
            if (null == childDims || childDims.size() <= 0) continue;
            CarbonUtil.fillCollumnSchemaListForComplexDims(childDims, wrapperColumnSchemaList);
        }
    }

    public static int getDictionaryChunkSize() {
        int dictionaryOneChunkSize = 0;
        try {
            dictionaryOneChunkSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.dictionary.chunk.size", "10000"));
        }
        catch (NumberFormatException e) {
            dictionaryOneChunkSize = Integer.parseInt("10000");
            LOGGER.error((Object)("Dictionary chunk size not configured properly. Taking default size " + dictionaryOneChunkSize));
        }
        return dictionaryOneChunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readHeader(String csvFilePath) throws IOException {
        DataInputStream fileReader = null;
        BufferedReader bufferedReader = null;
        String readLine = null;
        try {
            fileReader = FileFactory.getDataInputStream(csvFilePath);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileReader, Charset.forName("UTF-8")));
            readLine = bufferedReader.readLine();
        }
        catch (Throwable throwable) {
            CarbonUtil.closeStreams(fileReader, bufferedReader);
            throw throwable;
        }
        CarbonUtil.closeStreams(fileReader, bufferedReader);
        return readLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readHeader(String csvFilePath, Configuration hadoopConf) throws IOException {
        DataInputStream fileReader = null;
        BufferedReader bufferedReader = null;
        String readLine = null;
        try {
            fileReader = FileFactory.getDataInputStream(csvFilePath, -1, hadoopConf);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileReader, Charset.forName("UTF-8")));
            readLine = bufferedReader.readLine();
        }
        catch (Throwable throwable) {
            CarbonUtil.closeStreams(fileReader, bufferedReader);
            throw throwable;
        }
        CarbonUtil.closeStreams(fileReader, bufferedReader);
        return readLine;
    }

    public static String printLine(String a, int num) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            builder.append(a);
        }
        return builder.toString();
    }

    public static void leftPad(StringBuilder builder, String a, int length, char pad) {
        if (builder == null || a == null) {
            return;
        }
        int padLength = length - a.length();
        if (padLength > 0) {
            for (int i = 0; i < padLength; ++i) {
                builder.append(pad);
            }
        }
        if (a.length() > 0) {
            builder.append(a);
        }
    }

    public static void rightPad(StringBuilder builder, String a, int length, char pad) {
        if (builder == null || a == null) {
            return;
        }
        int padLength = length - a.length();
        if (a.length() > 0) {
            builder.append(a);
        }
        if (padLength > 0) {
            for (int i = 0; i < padLength; ++i) {
                builder.append(pad);
            }
        }
    }

    public static void logTable(StringBuilder builder, String[] header, String[][] rows, String indent) {
        int columnIndex;
        int numOfRows = rows.length;
        int numOfColumns = header.length;
        int[] maxLengths = new int[numOfColumns];
        for (int columnIndex2 = 0; columnIndex2 < numOfColumns; ++columnIndex2) {
            maxLengths[columnIndex2] = header[columnIndex2].length();
        }
        for (int rowIndex = 0; rowIndex < numOfRows; ++rowIndex) {
            for (columnIndex = 0; columnIndex < numOfColumns; ++columnIndex) {
                maxLengths[columnIndex] = Math.max(maxLengths[columnIndex], rows[rowIndex][columnIndex].length());
            }
        }
        StringBuilder line = new StringBuilder("+");
        for (columnIndex = 0; columnIndex < numOfColumns; ++columnIndex) {
            CarbonUtil.leftPad(line, "", maxLengths[columnIndex], '-');
            line.append("+");
        }
        builder.append(indent).append((CharSequence)line).append("\n").append(indent).append("|");
        for (columnIndex = 0; columnIndex < numOfColumns; ++columnIndex) {
            CarbonUtil.rightPad(builder, header[columnIndex], maxLengths[columnIndex], ' ');
            builder.append("|");
        }
        builder.append("\n").append(indent).append((CharSequence)line);
        for (int rowIndex = 0; rowIndex < numOfRows; ++rowIndex) {
            builder.append("\n").append(indent).append("|");
            for (int columnIndex3 = 0; columnIndex3 < numOfColumns; ++columnIndex3) {
                CarbonUtil.leftPad(builder, rows[rowIndex][columnIndex3], maxLengths[columnIndex3], ' ');
                builder.append("|");
            }
            builder.append("\n").append(indent).append((CharSequence)line);
        }
    }

    public static void logTable(StringBuilder builder, String context, String indent) {
        String[] rows = context.split("\n");
        int maxLength = 0;
        for (String row : rows) {
            maxLength = Math.max(maxLength, row.length());
        }
        StringBuilder line = new StringBuilder("+");
        CarbonUtil.rightPad(line, "", maxLength, '-');
        line.append("+");
        builder.append(indent).append((CharSequence)line);
        for (String row : rows) {
            builder.append("\n").append(indent).append("|");
            CarbonUtil.rightPad(builder, row, maxLength, ' ');
            builder.append("|");
        }
        builder.append("\n").append(indent).append((CharSequence)line);
    }

    public static String convertToString(List<Segment> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder segmentStringbuilder = new StringBuilder();
        for (int i = 0; i < values.size() - 1; ++i) {
            segmentStringbuilder.append(values.get(i));
            segmentStringbuilder.append(",");
        }
        segmentStringbuilder.append(values.get(values.size() - 1));
        return segmentStringbuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteArray(TBase t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] thriftByteArray = null;
        TCompactProtocol binaryOut = new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)stream));
        try {
            t.write((TProtocol)binaryOut);
            stream.flush();
            thriftByteArray = stream.toByteArray();
        }
        catch (IOException | TException e) {
            try {
                LOGGER.error((Object)("Error while converting to byte array from thrift object: " + e.getMessage()), e);
                CarbonUtil.closeStreams(stream);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(stream);
                throw throwable;
            }
            CarbonUtil.closeStreams(stream);
        }
        CarbonUtil.closeStreams(stream);
        return thriftByteArray;
    }

    public static BlockletHeader readBlockletHeader(byte[] data) throws IOException {
        return (BlockletHeader)CarbonUtil.read(data, new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new BlockletHeader();
            }
        }, 0, data.length);
    }

    public static DataChunk3 readDataChunk3(ByteBuffer dataChunkBuffer, int offset, int length) throws IOException {
        byte[] data = dataChunkBuffer.array();
        return (DataChunk3)CarbonUtil.read(data, new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new DataChunk3();
            }
        }, offset, length);
    }

    public static DataChunk3 readDataChunk3(InputStream stream) throws IOException {
        ThriftReader.TBaseCreator creator = new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new DataChunk3();
            }
        };
        TCompactProtocol binaryIn = new TCompactProtocol((TTransport)new TIOStreamTransport(stream));
        TBase t = creator.create();
        try {
            t.read((TProtocol)binaryIn);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return (DataChunk3)t;
    }

    private static TBase read(byte[] data, ThriftReader.TBaseCreator creator, int offset, int length) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data, offset, length);
        TCompactProtocol binaryIn = new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)stream));
        TBase t = creator.create();
        try {
            t.read((TProtocol)binaryIn);
        }
        catch (TException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(stream);
                throw throwable;
            }
        }
        CarbonUtil.closeStreams(stream);
        return t;
    }

    public static ValueEncoderMeta deserializeEncoderMetaV2(byte[] encoderMeta) {
        ByteArrayInputStream aos = null;
        ClassLoaderObjectInputStream objStream = null;
        ValueEncoderMeta meta = null;
        try {
            aos = new ByteArrayInputStream(encoderMeta);
            objStream = new ClassLoaderObjectInputStream(Thread.currentThread().getContextClassLoader(), (InputStream)aos);
            meta = (ValueEncoderMeta)objStream.readObject();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            CarbonUtil.closeStreams(new Closeable[]{objStream});
        }
        return meta;
    }

    public static ValueEncoderMeta deserializeEncoderMetaV3(byte[] encodeMeta) {
        ByteBuffer buffer = ByteBuffer.wrap(encodeMeta);
        char measureType = buffer.getChar();
        ValueEncoderMeta valueEncoderMeta = new ValueEncoderMeta();
        valueEncoderMeta.setType(measureType);
        switch (measureType) {
            case 'n': {
                valueEncoderMeta.setMaxValue(buffer.getDouble());
                valueEncoderMeta.setMinValue(buffer.getDouble());
                valueEncoderMeta.setUniqueValue(buffer.getDouble());
                break;
            }
            case 'b': {
                valueEncoderMeta.setMaxValue(BigDecimal.valueOf(Long.MAX_VALUE));
                valueEncoderMeta.setMinValue(BigDecimal.valueOf(Long.MIN_VALUE));
                valueEncoderMeta.setUniqueValue(BigDecimal.valueOf(Long.MIN_VALUE));
                break;
            }
            case 'd': {
                valueEncoderMeta.setMaxValue(buffer.getLong());
                valueEncoderMeta.setMinValue(buffer.getLong());
                valueEncoderMeta.setUniqueValue(buffer.getLong());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid measure type: " + measureType);
            }
        }
        valueEncoderMeta.setDecimal(buffer.getInt());
        valueEncoderMeta.setDataTypeSelected(buffer.get());
        return valueEncoderMeta;
    }

    public static int[][] getRangeIndex(int[] indexes, int length, int numberOfElementInGroup) {
        ArrayList<Integer> range;
        int index;
        ArrayList rangeList = new ArrayList();
        int[][] outputArray = null;
        int k = 0;
        if (indexes.length == 1) {
            outputArray = new int[1][2];
            outputArray[0][0] = indexes[0];
            outputArray[0][1] = indexes[0];
            return outputArray;
        }
        for (index = 1; index < length; ++index) {
            if (indexes[index] - indexes[index - 1] == 1 && k < numberOfElementInGroup - 1) {
                ++k;
                continue;
            }
            if (k > 0) {
                range = new ArrayList();
                rangeList.add(range);
                range.add(indexes[index - k - 1]);
                range.add(indexes[index - 1]);
            } else {
                range = new ArrayList();
                rangeList.add(range);
                range.add(indexes[index - 1]);
            }
            k = 0;
        }
        if (k > 0) {
            range = new ArrayList<Integer>();
            rangeList.add(range);
            range.add(indexes[index - k - 1]);
            range.add(indexes[index - 1]);
        } else {
            range = new ArrayList();
            rangeList.add(range);
            range.add(indexes[index - 1]);
        }
        if (length != indexes.length) {
            range = new ArrayList();
            rangeList.add(range);
            range.add(indexes[indexes.length - 1]);
        }
        outputArray = new int[rangeList.size()][2];
        for (int i = 0; i < outputArray.length; ++i) {
            if (((List)rangeList.get(i)).size() == 1) {
                outputArray[i][0] = (Integer)((List)rangeList.get(i)).get(0);
                outputArray[i][1] = (Integer)((List)rangeList.get(i)).get(0);
                continue;
            }
            outputArray[i][0] = (Integer)((List)rangeList.get(i)).get(0);
            outputArray[i][1] = (Integer)((List)rangeList.get(i)).get(1);
        }
        return outputArray;
    }

    public static void freeMemory(DimensionRawColumnChunk[] dimensionRawColumnChunks, MeasureRawColumnChunk[] measureRawColumnChunks) {
        int i;
        if (null != measureRawColumnChunks) {
            for (i = 0; i < measureRawColumnChunks.length; ++i) {
                if (null == measureRawColumnChunks[i]) continue;
                measureRawColumnChunks[i].freeMemory();
            }
        }
        if (null != dimensionRawColumnChunks) {
            for (i = 0; i < dimensionRawColumnChunks.length; ++i) {
                if (null == dimensionRawColumnChunks[i]) continue;
                dimensionRawColumnChunks[i].freeMemory();
            }
        }
    }

    public static boolean isInvalidTableBlock(String segmentId, String filePath, UpdateVO invalidBlockVOForSegmentId, SegmentUpdateStatusManager updateStatusMngr) {
        if (!updateStatusMngr.isBlockValid(segmentId, CarbonTablePath.getCarbonDataFileName(filePath) + CarbonTablePath.getCarbonDataExtension())) {
            return true;
        }
        if (null != invalidBlockVOForSegmentId && null != invalidBlockVOForSegmentId.getFactTimestamp()) {
            long blockTimeStamp = Long.parseLong(CarbonTablePath.DataFileUtil.getTimeStampFromFileName(filePath));
            if (blockTimeStamp > invalidBlockVOForSegmentId.getFactTimestamp() && invalidBlockVOForSegmentId.getUpdateDeltaStartTimestamp() != null && blockTimeStamp < invalidBlockVOForSegmentId.getUpdateDeltaStartTimestamp()) {
                return true;
            }
            if (invalidBlockVOForSegmentId.getLatestUpdateTimestamp() != null && blockTimeStamp > invalidBlockVOForSegmentId.getLatestUpdateTimestamp()) {
                return true;
            }
            if (null == invalidBlockVOForSegmentId.getUpdateDeltaStartTimestamp() && blockTimeStamp > invalidBlockVOForSegmentId.getFactTimestamp()) {
                return true;
            }
        }
        return false;
    }

    public static String getFormatFromProperty(DataType dataType) {
        if (dataType.equals(DataTypes.DATE)) {
            return CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd");
        }
        if (dataType.equals(DataTypes.TIMESTAMP)) {
            return CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        }
        return null;
    }

    public static int getSurrogateInternal(byte[] data, int startOffsetOfData, int eachColumnValueSize) {
        int surrogate = 0;
        switch (eachColumnValueSize) {
            case 1: {
                surrogate <<= 8;
                return surrogate ^= data[startOffsetOfData] & 0xFF;
            }
            case 2: {
                surrogate <<= 8;
                surrogate ^= data[startOffsetOfData] & 0xFF;
                surrogate <<= 8;
                return surrogate ^= data[startOffsetOfData + 1] & 0xFF;
            }
            case 3: {
                surrogate <<= 8;
                surrogate ^= data[startOffsetOfData] & 0xFF;
                surrogate <<= 8;
                surrogate ^= data[startOffsetOfData + 1] & 0xFF;
                surrogate <<= 8;
                return surrogate ^= data[startOffsetOfData + 2] & 0xFF;
            }
            case 4: {
                surrogate <<= 8;
                surrogate ^= data[startOffsetOfData] & 0xFF;
                surrogate <<= 8;
                surrogate ^= data[startOffsetOfData + 1] & 0xFF;
                surrogate <<= 8;
                surrogate ^= data[startOffsetOfData + 2] & 0xFF;
                surrogate <<= 8;
                return surrogate ^= data[startOffsetOfData + 3] & 0xFF;
            }
        }
        throw new IllegalArgumentException("Int cannot be more than 4 bytes: " + eachColumnValueSize);
    }

    public static boolean validateBoolean(String value) {
        if (null == value) {
            return false;
        }
        return "false".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    public static boolean isValidSortOption(String sortScope) {
        if (sortScope == null) {
            return false;
        }
        switch (sortScope.toUpperCase()) {
            case "LOCAL_SORT": 
            case "NO_SORT": 
            case "GLOBAL_SORT": {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidStorageLevel(String storageLevel) {
        if (null == storageLevel || storageLevel.trim().equals("")) {
            return false;
        }
        switch (storageLevel.toUpperCase()) {
            case "DISK_ONLY": 
            case "DISK_ONLY_2": 
            case "MEMORY_ONLY": 
            case "MEMORY_ONLY_2": 
            case "MEMORY_ONLY_SER": 
            case "MEMORY_ONLY_SER_2": 
            case "MEMORY_AND_DISK": 
            case "MEMORY_AND_DISK_2": 
            case "MEMORY_AND_DISK_SER": 
            case "MEMORY_AND_DISK_SER_2": 
            case "OFF_HEAP": 
            case "NONE": {
                return true;
            }
        }
        return false;
    }

    public static boolean validateValidIntType(String value) {
        if (null == value) {
            return false;
        }
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isValidBadStorePath(String badRecordsLocation) {
        if (StringUtils.isEmpty((String)badRecordsLocation)) {
            return false;
        }
        return CarbonUtil.isFileExists(CarbonUtil.checkAndAppendHDFSUrl(badRecordsLocation));
    }

    public static String convertToMultiGsonStrings(org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo, String seperator, String quote, String prefix) {
        Gson gson = new Gson();
        String schemaString = gson.toJson((Object)tableInfo);
        return CarbonUtil.splitSchemaStringToMultiString(seperator, quote, prefix, schemaString);
    }

    public static String splitSchemaStringToMultiString(String seperator, String quote, String prefix, String schemaString) {
        int schemaLen = schemaString.length();
        int splitLen = 4000;
        int parts = schemaLen / splitLen;
        if (schemaLen % splitLen > 0) {
            ++parts;
        }
        StringBuilder builder = new StringBuilder(prefix).append(quote).append("carbonSchemaPartsNo").append(quote).append(seperator).append("'").append(parts).append("',");
        int runningLen = 0;
        int endLen = schemaLen > splitLen ? splitLen : schemaLen;
        for (int i = 0; i < parts; ++i) {
            if (i == parts - 1 && schemaLen % splitLen > 0) {
                endLen = schemaLen % splitLen;
            }
            builder.append(quote).append("carbonSchema").append(i).append(quote).append(seperator);
            builder.append("'").append(schemaString.substring(runningLen, runningLen + endLen)).append("'");
            if (i < parts - 1) {
                builder.append(",");
            }
            runningLen += splitLen;
        }
        return builder.toString();
    }

    public static Map<String, String> convertToMultiStringMap(org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo) {
        Gson gson = new Gson();
        String schemaString = gson.toJson((Object)tableInfo);
        return CarbonUtil.splitSchemaStringToMap(schemaString);
    }

    public static Map<String, String> splitSchemaStringToMap(String schemaString) {
        HashMap<String, String> map = new HashMap<String, String>();
        int schemaLen = schemaString.length();
        int splitLen = 4000;
        int parts = schemaLen / splitLen;
        if (schemaLen % splitLen > 0) {
            ++parts;
        }
        map.put("carbonSchemaPartsNo", parts + "");
        int runningLen = 0;
        int endLen = schemaLen > splitLen ? splitLen : schemaLen;
        for (int i = 0; i < parts; ++i) {
            if (i == parts - 1 && schemaLen % splitLen > 0) {
                endLen = schemaLen % splitLen;
            }
            map.put("carbonSchema" + i, schemaString.substring(runningLen, runningLen + endLen));
            runningLen += splitLen;
        }
        return map;
    }

    public static org.apache.carbondata.core.metadata.schema.table.TableInfo convertGsonToTableInfo(Map<String, String> properties) {
        String partsNo = properties.get("carbonSchemaPartsNo");
        if (partsNo == null) {
            return null;
        }
        int no = Integer.parseInt(partsNo);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < no; ++i) {
            String part = properties.get("carbonSchema" + i);
            if (part == null) {
                throw new RuntimeException("Some thing wrong in getting schema from hive metastore");
            }
            builder.append(part);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(DataType.class, (Object)new DataTypeAdapter());
        Gson gson = gsonBuilder.create();
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = (org.apache.carbondata.core.metadata.schema.table.TableInfo)gson.fromJson(builder.toString(), org.apache.carbondata.core.metadata.schema.table.TableInfo.class);
        CarbonUtil.updateDecimalType(tableInfo);
        return tableInfo;
    }

    private static void updateDecimalType(org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo) {
        List<ColumnSchema> deserializedColumns = tableInfo.getFactTable().getListOfColumns();
        for (ColumnSchema column : deserializedColumns) {
            DataType dataType = column.getDataType();
            if (!DataTypes.isDecimal(dataType)) continue;
            column.setDataType(DataTypes.createDecimalType(column.getPrecision(), column.getScale()));
        }
    }

    public static Map<String, String> removeSchemaFromMap(Map<String, String> properties) {
        HashMap<String, String> newMap = new HashMap<String, String>(properties);
        String partsNo = (String)newMap.get("carbonSchemaPartsNo");
        if (partsNo == null) {
            return newMap;
        }
        int no = Integer.parseInt(partsNo);
        for (int i = 0; i < no; ++i) {
            newMap.remove("carbonSchema" + i);
        }
        return newMap;
    }

    public static TableInfo readSchemaFile(String schemaFilePath) throws IOException {
        return CarbonUtil.readSchemaFile(schemaFilePath, FileFactory.getConfiguration());
    }

    public static TableInfo readSchemaFile(String schemaFilePath, Configuration conf) throws IOException {
        ThriftReader.TBaseCreator createTBase = new ThriftReader.TBaseCreator(){

            public TBase<TableInfo, TableInfo._Fields> create() {
                return new TableInfo();
            }
        };
        ThriftReader thriftReader = new ThriftReader(schemaFilePath, createTBase, conf);
        thriftReader.open();
        TableInfo tableInfo = (TableInfo)thriftReader.read();
        thriftReader.close();
        return tableInfo;
    }

    public static ColumnSchema thriftColumnSchemaToWrapperColumnSchema(org.apache.carbondata.format.ColumnSchema externalColumnSchema) {
        ColumnSchema wrapperColumnSchema = new ColumnSchema();
        wrapperColumnSchema.setColumnUniqueId(externalColumnSchema.getColumn_id());
        wrapperColumnSchema.setColumnReferenceId(externalColumnSchema.getColumnReferenceId());
        wrapperColumnSchema.setColumnName(externalColumnSchema.getColumn_name());
        DataType dataType = CarbonUtil.thriftDataTypeToWrapperDataType(externalColumnSchema.data_type);
        if (DataTypes.isDecimal(dataType)) {
            DecimalType decimalType = (DecimalType)dataType;
            decimalType.setPrecision(externalColumnSchema.getPrecision());
            decimalType.setScale(externalColumnSchema.getScale());
        }
        wrapperColumnSchema.setDataType(dataType);
        wrapperColumnSchema.setDimensionColumn(externalColumnSchema.isDimension());
        ArrayList<org.apache.carbondata.core.metadata.encoder.Encoding> encoders = new ArrayList<org.apache.carbondata.core.metadata.encoder.Encoding>();
        for (Encoding encoder : externalColumnSchema.getEncoders()) {
            encoders.add(CarbonUtil.fromExternalToWrapperEncoding(encoder));
        }
        wrapperColumnSchema.setEncodingList(encoders);
        wrapperColumnSchema.setNumberOfChild(externalColumnSchema.getNum_child());
        wrapperColumnSchema.setPrecision(externalColumnSchema.getPrecision());
        wrapperColumnSchema.setScale(externalColumnSchema.getScale());
        wrapperColumnSchema.setDefaultValue(externalColumnSchema.getDefault_value());
        wrapperColumnSchema.setSchemaOrdinal(externalColumnSchema.getSchemaOrdinal());
        wrapperColumnSchema.setSpatialColumn(externalColumnSchema.isSpatialColumn());
        Map properties = externalColumnSchema.getColumnProperties();
        if (properties != null && properties.get("sort_columns") != null) {
            wrapperColumnSchema.setSortColumn(true);
        }
        wrapperColumnSchema.setColumnProperties(properties);
        wrapperColumnSchema.setFunction(externalColumnSchema.getAggregate_function());
        List parentColumnTableRelation = externalColumnSchema.getParentColumnTableRelations();
        if (null != parentColumnTableRelation) {
            wrapperColumnSchema.setParentColumnTableRelations(CarbonUtil.fromThriftToWrapperParentTableColumnRelations(parentColumnTableRelation));
        }
        return wrapperColumnSchema;
    }

    static List<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> fromThriftToWrapperParentTableColumnRelations(List<ParentColumnTableRelation> thirftParentColumnRelation) {
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> parentColumnTableRelationList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation>();
        for (ParentColumnTableRelation carbonTableRelation : thirftParentColumnRelation) {
            RelationIdentifier relationIdentifier = new RelationIdentifier(carbonTableRelation.getRelationIdentifier().getDatabaseName(), carbonTableRelation.getRelationIdentifier().getTableName(), carbonTableRelation.getRelationIdentifier().getTableId());
            org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation parentColumnTableRelation = new org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation(relationIdentifier, carbonTableRelation.getColumnId(), carbonTableRelation.getColumnName());
            parentColumnTableRelationList.add(parentColumnTableRelation);
        }
        return parentColumnTableRelationList;
    }

    static org.apache.carbondata.core.metadata.encoder.Encoding fromExternalToWrapperEncoding(Encoding encoderThrift) {
        switch (encoderThrift) {
            case DICTIONARY: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DICTIONARY;
            }
            case DELTA: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DELTA;
            }
            case RLE: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.RLE;
            }
            case INVERTED_INDEX: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.INVERTED_INDEX;
            }
            case BIT_PACKED: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.BIT_PACKED;
            }
            case DIRECT_DICTIONARY: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DIRECT_DICTIONARY;
            }
        }
        throw new IllegalArgumentException(encoderThrift.toString() + " is not supported");
    }

    static DataType thriftDataTypeToWrapperDataType(org.apache.carbondata.format.DataType dataTypeThrift) {
        switch (dataTypeThrift) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN;
            }
            case STRING: {
                return DataTypes.STRING;
            }
            case SHORT: {
                return DataTypes.SHORT;
            }
            case INT: {
                return DataTypes.INT;
            }
            case LONG: {
                return DataTypes.LONG;
            }
            case DOUBLE: {
                return DataTypes.DOUBLE;
            }
            case DECIMAL: {
                return DataTypes.createDefaultDecimalType();
            }
            case DATE: {
                return DataTypes.DATE;
            }
            case TIMESTAMP: {
                return DataTypes.TIMESTAMP;
            }
            case ARRAY: {
                return DataTypes.createDefaultArrayType();
            }
            case STRUCT: {
                return DataTypes.createDefaultStructType();
            }
            case MAP: {
                return DataTypes.createDefaultMapType();
            }
            case VARCHAR: {
                return DataTypes.VARCHAR;
            }
            case FLOAT: {
                return DataTypes.FLOAT;
            }
            case BYTE: {
                return DataTypes.BYTE;
            }
            case BINARY: {
                return DataTypes.BINARY;
            }
        }
        LOGGER.warn((Object)String.format("Cannot match the data type, using default String data type: %s", DataTypes.STRING.getName()));
        return DataTypes.STRING;
    }

    public static String getFilePathExternalFilePath(String path, Configuration configuration) {
        CarbonFile segment = FileFactory.getCarbonFile(path, configuration);
        CarbonFile[] dataFiles = segment.listFiles();
        CarbonFile latestCarbonFile = null;
        long latestDatafileTimestamp = 0L;
        for (CarbonFile dataFile : dataFiles) {
            if (dataFile.getName().endsWith(".carbondata") && dataFile.getLastModifiedTime() > latestDatafileTimestamp) {
                latestCarbonFile = dataFile;
                latestDatafileTimestamp = dataFile.getLastModifiedTime();
                continue;
            }
            if (!dataFile.isDirectory() || CarbonUtil.getFilePathExternalFilePath(dataFile.getAbsolutePath(), configuration) == null) continue;
            return CarbonUtil.getFilePathExternalFilePath(dataFile.getAbsolutePath(), configuration);
        }
        if (latestCarbonFile != null) {
            return latestCarbonFile.getAbsolutePath();
        }
        return null;
    }

    public static TableInfo inferSchema(String carbonDataFilePath, String tableName, boolean isCarbonFileProvider, Configuration configuration) throws IOException {
        String fistFilePath = null;
        fistFilePath = isCarbonFileProvider ? CarbonUtil.getFilePathExternalFilePath(carbonDataFilePath + "/Fact/Part0/Segment_null", configuration) : CarbonUtil.getFilePathExternalFilePath(carbonDataFilePath, configuration);
        if (fistFilePath == null) {
            LOGGER.error((Object)"CarbonData file is not present in the table location");
            throw new IOException("CarbonData file is not present in the table location");
        }
        CarbonHeaderReader carbonHeaderReader = new CarbonHeaderReader(fistFilePath, configuration);
        List<ColumnSchema> columnSchemaList = carbonHeaderReader.readSchema();
        org.apache.carbondata.core.metadata.schema.table.TableSchema tableSchema = CarbonUtil.getDummyTableSchema(tableName, columnSchemaList);
        ThriftWrapperSchemaConverterImpl thriftWrapperSchemaConverter = new ThriftWrapperSchemaConverterImpl();
        TableSchema thriftFactTable = thriftWrapperSchemaConverter.fromWrapperToExternalTableSchema(tableSchema);
        TableInfo tableInfo = new TableInfo(thriftFactTable, new ArrayList());
        return tableInfo;
    }

    public static org.apache.carbondata.core.metadata.schema.table.TableInfo buildDummyTableInfo(String carbonDataFilePath, String tableName, String dbName) {
        ArrayList<ColumnSchema> columnSchemaList = new ArrayList<ColumnSchema>();
        org.apache.carbondata.core.metadata.schema.table.TableSchema tableSchema = CarbonUtil.getDummyTableSchema(tableName, columnSchemaList);
        ThriftWrapperSchemaConverterImpl thriftWrapperSchemaConverter = new ThriftWrapperSchemaConverterImpl();
        TableSchema thriftFactTable = thriftWrapperSchemaConverter.fromWrapperToExternalTableSchema(tableSchema);
        TableInfo tableInfo = new TableInfo(thriftFactTable, new ArrayList());
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, dbName, tableName, carbonDataFilePath);
        wrapperTableInfo.setTransactionalTable(false);
        return wrapperTableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableInfo inferSchemaFromIndexFile(String indexFilePath, String tableName) throws IOException {
        CarbonIndexFileReader indexFileReader = new CarbonIndexFileReader();
        try {
            TableInfo tableInfo;
            indexFileReader.openThriftReader(indexFilePath);
            IndexHeader readIndexHeader = indexFileReader.readIndexHeader();
            ArrayList<ColumnSchema> columnSchemaList = new ArrayList<ColumnSchema>();
            List table_columns = readIndexHeader.getTable_columns();
            for (int i = 0; i < table_columns.size(); ++i) {
                columnSchemaList.add(CarbonUtil.thriftColumnSchemaToWrapperColumnSchema((org.apache.carbondata.format.ColumnSchema)table_columns.get(i)));
            }
            org.apache.carbondata.core.metadata.schema.table.TableSchema tableSchema = CarbonUtil.getDummyTableSchema(tableName, columnSchemaList);
            ThriftWrapperSchemaConverterImpl thriftWrapperSchemaConverter = new ThriftWrapperSchemaConverterImpl();
            TableSchema thriftFactTable = thriftWrapperSchemaConverter.fromWrapperToExternalTableSchema(tableSchema);
            TableInfo tableInfo2 = tableInfo = new TableInfo(thriftFactTable, new ArrayList());
            return tableInfo2;
        }
        finally {
            indexFileReader.closeThriftReader();
        }
    }

    private static org.apache.carbondata.core.metadata.schema.table.TableSchema getDummyTableSchema(String tableName, List<ColumnSchema> columnSchemaList) {
        org.apache.carbondata.core.metadata.schema.table.TableSchema tableSchema = new org.apache.carbondata.core.metadata.schema.table.TableSchema();
        tableSchema.setTableName(tableName);
        tableSchema.setBucketingInfo(null);
        tableSchema.setSchemaEvolution(null);
        tableSchema.setTableId(UUID.randomUUID().toString());
        tableSchema.setListOfColumns(columnSchemaList);
        SchemaEvolutionEntry schemaEvolutionEntry = new SchemaEvolutionEntry();
        schemaEvolutionEntry.setTimeStamp(System.currentTimeMillis());
        SchemaEvolution schemaEvol = new SchemaEvolution();
        ArrayList<SchemaEvolutionEntry> schEntryList = new ArrayList<SchemaEvolutionEntry>();
        schEntryList.add(schemaEvolutionEntry);
        schemaEvol.setSchemaEvolutionEntryList(schEntryList);
        tableSchema.setSchemaEvolution(schemaEvol);
        return tableSchema;
    }

    public static void dropDatabaseDirectory(String databasePath) throws IOException, InterruptedException {
        if (FileFactory.isFileExist(databasePath)) {
            CarbonFile dbPath = FileFactory.getCarbonFile(databasePath);
            CarbonUtil.deleteFoldersAndFiles(dbPath);
        }
    }

    public static byte[] getValueAsBytes(DataType dataType, Object value) {
        if (dataType == DataTypes.BYTE || dataType == DataTypes.BOOLEAN) {
            byte[] bytes = new byte[]{(Byte)value};
            return bytes;
        }
        if (dataType == DataTypes.SHORT) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong(((Short)value).shortValue());
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.INT) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong(((Integer)value).intValue());
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong((Long)value);
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.DOUBLE) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putDouble((Double)value);
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.FLOAT) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putFloat(((Float)value).floatValue());
            b.flip();
            return b.array();
        }
        if (DataTypes.isDecimal(dataType)) {
            return DataTypeUtil.bigDecimalToByte((BigDecimal)value);
        }
        if (dataType == DataTypes.BYTE_ARRAY || dataType == DataTypes.BINARY || dataType == DataTypes.STRING || dataType == DataTypes.DATE || dataType == DataTypes.VARCHAR) {
            return (byte[])value;
        }
        throw new IllegalArgumentException("Invalid data type: " + dataType);
    }

    public static boolean validateRangeOfSegmentList(String segmentId) throws InvalidConfigurationException {
        String[] values = segmentId.split(",");
        try {
            if (values.length == 0) {
                throw new InvalidConfigurationException("carbon.input.segments.<database_name>.<table_name> value can't be empty.");
            }
            for (String value : values) {
                Segment segment;
                Float aFloatValue;
                if (value.equalsIgnoreCase("*") || !((aFloatValue = Float.valueOf(Float.parseFloat((segment = Segment.toSegment(value, null)).getSegmentNo()))).floatValue() < 0.0f) && !(aFloatValue.floatValue() > Float.MAX_VALUE)) continue;
                throw new InvalidConfigurationException("carbon.input.segments.<database_name>.<table_name> value range should be greater than 0 and less than 3.4028235E38");
            }
        }
        catch (NumberFormatException nfe) {
            throw new InvalidConfigurationException("carbon.input.segments.<database_name>.<table_name> value range is not valid");
        }
        return true;
    }

    public static boolean usePreviousFilterBitsetGroup(boolean usePrvBitSetGroup, BitSetGroup prvBitsetGroup, int pageNumber, int numberOfFilterValues) {
        if (!usePrvBitSetGroup || null == prvBitsetGroup || null == prvBitsetGroup.getBitSet(pageNumber) || prvBitsetGroup.getBitSet(pageNumber).isEmpty()) {
            return false;
        }
        int numberOfRowSelected = prvBitsetGroup.getBitSet(pageNumber).cardinality();
        return numberOfFilterValues > numberOfRowSelected;
    }

    public static int isFilterPresent(byte[][] filterValues, DimensionColumnPage dimensionColumnPage, int low, int high, int chunkRowIndex) {
        int compareResult = 0;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            compareResult = dimensionColumnPage.compareTo(chunkRowIndex, filterValues[mid]);
            if (compareResult < 0) {
                high = mid - 1;
                continue;
            }
            if (compareResult > 0) {
                low = mid + 1;
                continue;
            }
            return compareResult;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Long> calculateDataIndexSize(CarbonTable carbonTable, Boolean updateSize) throws IOException {
        HashMap<String, Long> dataIndexSizeMap = new HashMap<String, Long>();
        long dataSize = 0L;
        long indexSize = 0L;
        long lastUpdateTime = 0L;
        boolean needUpdate = false;
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        String isCalculated = CarbonProperties.getInstance().getProperty("carbon.enable.calculate.size", "true");
        if (isCalculated.equalsIgnoreCase("true")) {
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
            ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
            try {
                boolean lockAcquired = true;
                if (updateSize.booleanValue()) {
                    lockAcquired = carbonLock.lockWithRetries();
                }
                if (lockAcquired) {
                    String tableStatusPath;
                    LoadMetadataDetails[] loadMetadataDetails;
                    LOGGER.debug((Object)"Acquired lock for table for table status updation");
                    String metadataPath = carbonTable.getMetadataPath();
                    for (LoadMetadataDetails loadMetadataDetail : loadMetadataDetails = SegmentStatusManager.readLoadMetadata(metadataPath)) {
                        SegmentStatus loadStatus = loadMetadataDetail.getSegmentStatus();
                        if (loadStatus != SegmentStatus.SUCCESS && loadStatus != SegmentStatus.LOAD_PARTIAL_SUCCESS) continue;
                        String dsize = loadMetadataDetail.getDataSize();
                        String isize = loadMetadataDetail.getIndexSize();
                        if (null == dsize || null == isize) {
                            needUpdate = true;
                            LOGGER.debug((Object)"It is an old segment, need calculate data size and index size again");
                            HashMap<String, Long> map = CarbonUtil.getDataSizeAndIndexSize(identifier.getTablePath(), loadMetadataDetail.getLoadName());
                            dsize = String.valueOf(map.get("datasize"));
                            isize = String.valueOf(map.get("indexsize"));
                            loadMetadataDetail.setDataSize(dsize);
                            loadMetadataDetail.setIndexSize(isize);
                        }
                        dataSize += Long.parseLong(dsize);
                        indexSize += Long.parseLong(isize);
                    }
                    if (needUpdate && updateSize.booleanValue()) {
                        SegmentStatusManager.writeLoadDetailsIntoFile(CarbonTablePath.getTableStatusFilePath(identifier.getTablePath()), loadMetadataDetails);
                    }
                    if (FileFactory.isFileExist(tableStatusPath = CarbonTablePath.getTableStatusFilePath(identifier.getTablePath()))) {
                        lastUpdateTime = FileFactory.getCarbonFile(tableStatusPath).getLastModifiedTime();
                    }
                    if (!FileFactory.isFileExist(metadataPath)) {
                        dataSize = FileFactory.getDirectorySize(carbonTable.getTablePath());
                    }
                    dataIndexSizeMap.put(String.valueOf("datasize"), dataSize);
                    dataIndexSizeMap.put(String.valueOf("indexsize"), indexSize);
                    dataIndexSizeMap.put(String.valueOf("Last Update Time"), lastUpdateTime);
                } else {
                    LOGGER.error((Object)"Not able to acquire the lock for Table status updation for table");
                }
            }
            finally {
                if (carbonLock.unlock()) {
                    LOGGER.debug((Object)"Table unlocked successfully after table status updation");
                } else {
                    LOGGER.error((Object)"Unable to unlock Table lock for table during table status updation");
                }
            }
        }
        return dataIndexSizeMap;
    }

    public static HashMap<String, Long> getDataSizeAndIndexSize(String segmentPath) throws IOException {
        if (segmentPath == null) {
            throw new IllegalArgumentException("Argument [segmentPath] is null.");
        }
        long carbonDataSize = 0L;
        long carbonIndexSize = 0L;
        HashMap<String, Long> dataAndIndexSize = new HashMap<String, Long>();
        FileFactory.FileType fileType = FileFactory.getFileType(segmentPath);
        switch (fileType) {
            case HDFS: 
            case ALLUXIO: 
            case VIEWFS: 
            case S3: 
            case CUSTOM: {
                FileStatus[] fileStatuses;
                Path path = new Path(segmentPath);
                FileSystem fs = path.getFileSystem(FileFactory.getConfiguration());
                if (!fs.exists(path) || null == (fileStatuses = fs.listStatus(path))) break;
                for (FileStatus dataAndIndexStatus : fileStatuses) {
                    String pathName = dataAndIndexStatus.getPath().getName();
                    if (pathName.endsWith(CarbonTablePath.getCarbonIndexExtension()) || pathName.endsWith(CarbonTablePath.getCarbonMergeIndexExtension())) {
                        carbonIndexSize += dataAndIndexStatus.getLen();
                        continue;
                    }
                    if (!pathName.endsWith(CarbonTablePath.getCarbonDataExtension())) continue;
                    carbonDataSize += dataAndIndexStatus.getLen();
                }
                break;
            }
            default: {
                segmentPath = FileFactory.getUpdatedFilePath(segmentPath);
                File file = new File(segmentPath);
                File[] segmentFiles = file.listFiles();
                if (null == segmentFiles) break;
                for (File dataAndIndexFile : segmentFiles) {
                    if (dataAndIndexFile.getCanonicalPath().endsWith(CarbonTablePath.getCarbonIndexExtension()) || dataAndIndexFile.getCanonicalPath().endsWith(CarbonTablePath.getCarbonMergeIndexExtension())) {
                        carbonIndexSize += FileUtils.sizeOf((File)dataAndIndexFile);
                        continue;
                    }
                    if (!dataAndIndexFile.getCanonicalPath().endsWith(CarbonTablePath.getCarbonDataExtension())) continue;
                    carbonDataSize += FileUtils.sizeOf((File)dataAndIndexFile);
                }
            }
        }
        dataAndIndexSize.put("datasize", carbonDataSize);
        dataAndIndexSize.put("indexsize", carbonIndexSize);
        return dataAndIndexSize;
    }

    private static HashMap<String, Long> getDataSizeAndIndexSize(String tablePath, String segmentId) throws IOException {
        return CarbonUtil.getDataSizeAndIndexSize(CarbonTablePath.getSegmentPath(tablePath, segmentId));
    }

    public static HashMap<String, Long> getDataSizeAndIndexSize(SegmentFileStore fileStore, boolean isCarbonSegment) throws IOException {
        long carbonDataSize = 0L;
        long carbonIndexSize = 0L;
        HashMap<String, Long> dataAndIndexSize = new HashMap<String, Long>();
        Map<String, SegmentFileStore.FolderDetails> locationMap = fileStore.getLocationMap();
        if (locationMap != null) {
            fileStore.readIndexFiles(FileFactory.getConfiguration());
            Map<String, List<String>> indexFilesMap = fileStore.getIndexFilesMap();
            carbonIndexSize = CarbonUtil.getCarbonIndexSize(fileStore, locationMap);
            for (Map.Entry<String, List<String>> entry : indexFilesMap.entrySet()) {
                for (String blockFile : entry.getValue()) {
                    carbonDataSize += FileFactory.getCarbonFile(blockFile).getSize();
                }
            }
        }
        if (isCarbonSegment) {
            dataAndIndexSize.put("datasize", carbonDataSize);
            dataAndIndexSize.put("indexsize", carbonIndexSize);
        } else {
            dataAndIndexSize.put("datasize", carbonIndexSize);
            dataAndIndexSize.put("indexsize", 0L);
        }
        return dataAndIndexSize;
    }

    public static long getCarbonIndexSize(SegmentFileStore fileStore, Map<String, SegmentFileStore.FolderDetails> locationMap) {
        long carbonIndexSize = 0L;
        for (Map.Entry<String, SegmentFileStore.FolderDetails> entry : locationMap.entrySet()) {
            SegmentFileStore.FolderDetails folderDetails = entry.getValue();
            Set<String> carbonindexFiles = folderDetails.getFiles();
            String mergeFileName = folderDetails.getMergeFileName();
            if (null != mergeFileName) {
                String mergeIndexPath = entry.getValue().isRelative() ? fileStore.getTablePath() + entry.getKey() + "/" + mergeFileName : entry.getKey() + "/" + mergeFileName;
                carbonIndexSize += FileFactory.getCarbonFile(mergeIndexPath).getSize();
            }
            for (String indexFile : carbonindexFiles) {
                String indexPath = entry.getValue().isRelative() ? fileStore.getTablePath() + entry.getKey() + "/" + indexFile : entry.getKey() + "/" + indexFile;
                carbonIndexSize += FileFactory.getCarbonFile(indexPath).getSize();
            }
        }
        return carbonIndexSize;
    }

    public static HashMap<String, Long> getDataSizeAndIndexSize(String tablePath, Segment segment) throws IOException {
        if (segment.getSegmentFileName() != null) {
            SegmentFileStore fileStore = new SegmentFileStore(tablePath, segment.getSegmentFileName());
            return CarbonUtil.getDataSizeAndIndexSize(fileStore, segment.isCarbonSegment());
        }
        return CarbonUtil.getDataSizeAndIndexSize(tablePath, segment.getSegmentNo());
    }

    public static long getSizeOfSegment(String tablePath, Segment segment) throws IOException {
        HashMap<String, Long> dataSizeAndIndexSize = CarbonUtil.getDataSizeAndIndexSize(tablePath, segment);
        long size = 0L;
        for (Long eachSize : dataSizeAndIndexSize.values()) {
            size += eachSize.longValue();
        }
        return size;
    }

    public static String encodeToString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
    }

    public static byte[] decodeStringToBytes(String objectString) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])objectString.getBytes("UTF-8"));
    }

    public static void copyCarbonDataFileToCarbonStorePath(String localFilePath, String targetPath, long fileSizeInBytes, DataLoadMetrics metrics) throws CarbonDataWriterException {
        if (targetPath.endsWith(".tmp") && localFilePath.endsWith(".carbondata")) {
            targetPath = targetPath.substring(0, targetPath.lastIndexOf("/"));
            if (metrics != null) {
                metrics.addToPartitionPath(targetPath);
            }
        }
        long targetSize = CarbonUtil.copyCarbonDataFileToCarbonStorePath(localFilePath, targetPath, fileSizeInBytes);
        if (metrics != null) {
            metrics.incrementCount();
            metrics.addToOutputFiles(targetPath + localFilePath.substring(localFilePath.lastIndexOf(File.separator)) + ":" + targetSize);
            metrics.addOutputBytes(targetSize);
        }
    }

    public static long copyCarbonDataFileToCarbonStorePath(String localFilePath, String carbonDataDirectoryPath, long fileSizeInBytes) throws CarbonDataWriterException {
        long copyStartTime = System.currentTimeMillis();
        LOGGER.info((Object)String.format("Copying %s to %s, operation id %d", localFilePath, carbonDataDirectoryPath, copyStartTime));
        long targetSize = 0L;
        try {
            CarbonFile localCarbonFile = FileFactory.getCarbonFile(localFilePath);
            long localFileSize = localCarbonFile.getSize();
            if (localFileSize == 0L) {
                LOGGER.error((Object)("The size of local carbon file: " + localFilePath + " is 0."));
                throw new CarbonDataWriterException("The size of local carbon file is 0.");
            }
            String carbonFilePath = carbonDataDirectoryPath + localFilePath.substring(localFilePath.lastIndexOf(File.separator));
            CarbonUtil.copyLocalFileToCarbonStore(carbonFilePath, localFilePath, 24576, CarbonUtil.getMaxOfBlockAndFileSize(fileSizeInBytes, localFileSize));
            CarbonFile targetCarbonFile = FileFactory.getCarbonFile(carbonFilePath);
            targetSize = targetCarbonFile.getSize();
            if (targetSize == 0L || targetSize != localFileSize) {
                LOGGER.error((Object)("The size of carbon file: " + carbonFilePath + " is 0 or is not the same as the size of local carbon file: (carbon file size=" + targetSize + ", local carbon file size=" + localFileSize + ")"));
                throw new CarbonDataWriterException("The size of carbon file is 0 or is not the same as the size of local carbon file.");
            }
        }
        catch (Exception e) {
            throw new CarbonDataWriterException("Problem while copying file from local store to carbon store", e);
        }
        LOGGER.info((Object)String.format("Total copy time is %d ms, operation id %d", System.currentTimeMillis() - copyStartTime, copyStartTime));
        return targetSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyLocalFileToCarbonStore(String carbonStoreFilePath, String localFilePath, int bufferSize, long blockSize) throws IOException {
        DataOutputStream dataOutputStream = null;
        DataInputStream dataInputStream = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("HDFS file block size for file: " + carbonStoreFilePath + " is " + blockSize + " (bytes"));
            }
            dataOutputStream = FileFactory.getDataOutputStream(carbonStoreFilePath, bufferSize, blockSize);
            dataInputStream = FileFactory.getDataInputStream(localFilePath, bufferSize);
            IOUtils.copyBytes((InputStream)dataInputStream, (OutputStream)dataOutputStream, (int)bufferSize);
        }
        catch (Throwable throwable) {
            try {
                CarbonUtil.closeStream(dataInputStream);
                CarbonUtil.closeStream(dataOutputStream);
            }
            catch (IOException exception) {
                LOGGER.error((Object)exception.getMessage(), (Throwable)exception);
            }
            throw throwable;
        }
        try {
            CarbonUtil.closeStream(dataInputStream);
            CarbonUtil.closeStream(dataOutputStream);
        }
        catch (IOException exception) {
            LOGGER.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private static long getMaxOfBlockAndFileSize(long blockSize, long fileSize) {
        long remainder;
        long maxSize = blockSize;
        if (fileSize > blockSize) {
            maxSize = fileSize;
        }
        if ((remainder = maxSize % 512L) > 0L) {
            maxSize = maxSize + 512L - remainder;
        }
        String readableBlockSize = ByteUtil.convertByteToReadable(blockSize);
        String readableFileSize = ByteUtil.convertByteToReadable(fileSize);
        String readableMaxSize = ByteUtil.convertByteToReadable(maxSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("The configured block size is " + readableBlockSize + ", the actual carbon file size is " + readableFileSize + ", choose the max value " + readableMaxSize + " as the block size on HDFS"));
        }
        return maxSize;
    }

    public static String getBlockId(AbsoluteTableIdentifier identifier, String filePath, String segmentId, boolean isTransactionalTable, boolean isStandardTable) {
        return CarbonUtil.getBlockId(identifier, filePath, segmentId, isTransactionalTable, isStandardTable, false);
    }

    public static String getBlockId(AbsoluteTableIdentifier identifier, String filePath, String segmentId, boolean isTransactionalTable, boolean isStandardTable, boolean isPartitionTable) {
        String blockId;
        String blockName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        String tablePath = identifier.getTablePath();
        if (filePath.startsWith(tablePath)) {
            if (!isTransactionalTable || isStandardTable) {
                blockId = "Part0/Segment_" + segmentId + "/" + blockName;
            } else {
                String partitionDir = tablePath.length() + 1 < filePath.length() - blockName.length() - 1 ? filePath.substring(tablePath.length() + 1, filePath.length() - blockName.length() - 1) : "";
                blockId = isPartitionTable ? partitionDir.replace("/", "#") + "/" + blockName : partitionDir.replace("/", "#") + "/" + segmentId + "/" + blockName;
            }
        } else {
            blockId = filePath.substring(0, filePath.length() - blockName.length()).replace("/", "#") + "/" + "Segment_" + segmentId + "/" + blockName;
        }
        return blockId;
    }

    public static void setLocalDictColumnsToWrapperSchema(List<ColumnSchema> columns, Map<String, String> mainTableProperties, String isLocalDictEnabledForMainTable) {
        String[] listOfDictionaryIncludeColumns = null;
        String[] listOfDictionaryExcludeColumns = null;
        String localDictIncludeColumns = mainTableProperties.get("local_dictionary_include");
        String localDictExcludeColumns = mainTableProperties.get("local_dictionary_exclude");
        if (null != localDictIncludeColumns) {
            listOfDictionaryIncludeColumns = localDictIncludeColumns.trim().split("\\s*,\\s*");
        }
        if (null != localDictExcludeColumns) {
            listOfDictionaryExcludeColumns = localDictExcludeColumns.trim().split("\\s*,\\s*");
        }
        if (null != isLocalDictEnabledForMainTable && Boolean.parseBoolean(isLocalDictEnabledForMainTable)) {
            int ordinal = 0;
            for (int i = 0; i < columns.size(); ++i) {
                ColumnSchema column = columns.get(i);
                if (null == localDictIncludeColumns) {
                    if (null == localDictExcludeColumns) {
                        if (column.getDataType().isComplexType()) {
                            ordinal = i + 1;
                            ordinal = CarbonUtil.setLocalDictForComplexColumns(columns, ordinal, column.getNumberOfChild());
                            i = ordinal - 1;
                        } else {
                            ordinal = i;
                        }
                        if (ordinal >= columns.size() || !(column = columns.get(ordinal)).isDimensionColumn() || !column.getDataType().equals(DataTypes.STRING) && !column.getDataType().equals(DataTypes.VARCHAR)) continue;
                        column.setLocalDictColumn(true);
                        continue;
                    }
                    if (!Arrays.asList(listOfDictionaryExcludeColumns).contains(column.getColumnName()) && column.getDataType().isComplexType()) {
                        ordinal = i + 1;
                        ordinal = CarbonUtil.setLocalDictForComplexColumns(columns, ordinal, column.getNumberOfChild());
                        i = ordinal - 1;
                    } else if (Arrays.asList(listOfDictionaryExcludeColumns).contains(column.getColumnName()) && column.getDataType().isComplexType()) {
                        ordinal = i + 1;
                        ordinal = CarbonUtil.unsetLocalDictForComplexColumns(columns, ordinal, column.getNumberOfChild());
                        i = ordinal - 1;
                    } else {
                        ordinal = i;
                    }
                    if (ordinal >= columns.size() || !(column = columns.get(ordinal)).isDimensionColumn() || !column.getDataType().equals(DataTypes.STRING) && !column.getDataType().equals(DataTypes.VARCHAR) || Arrays.asList(listOfDictionaryExcludeColumns).contains(column.getColumnName())) continue;
                    column.setLocalDictColumn(true);
                    continue;
                }
                if (localDictIncludeColumns.contains(column.getColumnName()) && column.getDataType().isComplexType()) {
                    ordinal = i + 1;
                    ordinal = CarbonUtil.setLocalDictForComplexColumns(columns, ordinal, column.getNumberOfChild());
                    i = ordinal - 1;
                } else {
                    ordinal = i;
                }
                if (ordinal >= columns.size() || !(column = columns.get(ordinal)).isDimensionColumn() || !column.getDataType().equals(DataTypes.STRING) && !column.getDataType().equals(DataTypes.VARCHAR) || !localDictIncludeColumns.toLowerCase().contains(column.getColumnName().toLowerCase())) continue;
                for (String dictColumn : listOfDictionaryIncludeColumns) {
                    if (!dictColumn.trim().equalsIgnoreCase(column.getColumnName())) continue;
                    column.setLocalDictColumn(true);
                }
            }
        }
    }

    private static int setLocalDictForComplexColumns(List<ColumnSchema> allColumns, int dimensionOrdinal, int childColumnCount) {
        for (int i = 0; i < childColumnCount; ++i) {
            ColumnSchema column = allColumns.get(dimensionOrdinal);
            if (column.getNumberOfChild() > 0) {
                CarbonUtil.setLocalDictForComplexColumns(allColumns, ++dimensionOrdinal, column.getNumberOfChild());
            } else if (column.isDimensionColumn() && (column.getDataType().equals(DataTypes.STRING) || column.getDataType().equals(DataTypes.VARCHAR))) {
                column.setLocalDictColumn(true);
            }
            ++dimensionOrdinal;
        }
        return dimensionOrdinal;
    }

    private static int unsetLocalDictForComplexColumns(List<ColumnSchema> allColumns, int dimensionOrdinal, int childColumnCount) {
        for (int i = 0; i < childColumnCount; ++i) {
            ColumnSchema column = allColumns.get(dimensionOrdinal);
            if (column.getNumberOfChild() > 0) {
                ++dimensionOrdinal;
                dimensionOrdinal = CarbonUtil.unsetLocalDictForComplexColumns(allColumns, dimensionOrdinal, column.getNumberOfChild());
                continue;
            }
            ++dimensionOrdinal;
        }
        return dimensionOrdinal;
    }

    public static Map<String, LocalDictionaryGenerator> getLocalDictionaryModel(CarbonTable carbonTable) {
        List<ColumnSchema> wrapperColumnSchema = CarbonUtil.getColumnSchemaList(carbonTable.getVisibleDimensions(), carbonTable.getVisibleMeasures());
        boolean islocalDictEnabled = carbonTable.isLocalDictionaryEnabled();
        HashMap<String, LocalDictionaryGenerator> columnLocalDictGenMap = new HashMap<String, LocalDictionaryGenerator>();
        if (islocalDictEnabled) {
            int localDictionaryThreshold = carbonTable.getLocalDictionaryThreshold();
            for (ColumnSchema columnSchema : wrapperColumnSchema) {
                if (!columnSchema.isLocalDictColumn()) continue;
                columnLocalDictGenMap.put(columnSchema.getColumnName(), new ColumnLocalDictionaryGenerator(localDictionaryThreshold, columnSchema.getDataType() == DataTypes.VARCHAR ? 4 : 2));
            }
        }
        if (islocalDictEnabled) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Local dictionary is enabled for table: " + carbonTable.getTableUniqueName()));
                LOGGER.debug((Object)String.format("Local dictionary threshold for table %s is %d", carbonTable.getTableUniqueName(), carbonTable.getLocalDictionaryThreshold()));
            }
            Iterator iterator = columnLocalDictGenMap.entrySet().iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                stringBuilder.append((String)next.getKey());
                stringBuilder.append(',');
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Local dictionary will be generated for the columns: %s for table %s", stringBuilder.toString(), carbonTable.getTableUniqueName()));
            }
        }
        return columnLocalDictGenMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnarFormatVersion getFormatVersion(CarbonTable carbonTable) throws IOException {
        String segmentPath = null;
        boolean supportFlatFolder = carbonTable.isSupportFlatFolder();
        CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
        ColumnarFormatVersion version = null;
        SegmentIndexFileStore fileStore = new SegmentIndexFileStore();
        CarbonProperties carbonProperties = CarbonProperties.getInstance();
        if (supportFlatFolder) {
            segmentPath = carbonTable.getTablePath();
            if (FileFactory.isFileExist(segmentPath)) {
                Iterator<byte[]> iterator;
                fileStore.readAllIIndexOfSegment(segmentPath);
                Map<String, byte[]> carbonIndexMap = fileStore.getCarbonIndexMap();
                if (carbonIndexMap.size() == 0) {
                    version = carbonProperties.getFormatVersion();
                }
                if ((iterator = carbonIndexMap.values().iterator()).hasNext()) {
                    byte[] fileData = iterator.next();
                    try {
                        indexReader.openThriftReader(fileData);
                        IndexHeader indexHeader = indexReader.readIndexHeader();
                        version = ColumnarFormatVersion.valueOf((short)indexHeader.getVersion());
                    }
                    finally {
                        indexReader.closeThriftReader();
                    }
                }
            }
        } else {
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(carbonTable.getAbsoluteTableIdentifier());
            SegmentStatusManager.ValidAndInvalidSegmentsInfo validAndInvalidSegmentsInfo = segmentStatusManager.getValidAndInvalidSegments(carbonTable.isMV());
            List<Segment> validSegments = validAndInvalidSegmentsInfo.getValidSegments();
            if (validSegments.isEmpty()) {
                return carbonProperties.getFormatVersion();
            }
            for (Segment segment : validSegments) {
                segmentPath = carbonTable.getSegmentPath(segment.getSegmentNo());
                if (!FileFactory.isFileExist(segmentPath)) continue;
                fileStore.readAllIIndexOfSegment(segmentPath);
                Map<String, byte[]> carbonIndexMap = fileStore.getCarbonIndexMap();
                if (carbonIndexMap.size() == 0) {
                    LOGGER.warn((Object)("the valid segment path: " + segmentPath + " does not exist in the system of table: " + carbonTable.getTableUniqueName()));
                    continue;
                }
                Iterator<byte[]> iterator = carbonIndexMap.values().iterator();
                if (iterator.hasNext()) {
                    byte[] fileData = iterator.next();
                    try {
                        indexReader.openThriftReader(fileData);
                        IndexHeader indexHeader = indexReader.readIndexHeader();
                        version = ColumnarFormatVersion.valueOf((short)indexHeader.getVersion());
                    }
                    finally {
                        indexReader.closeThriftReader();
                    }
                }
                if (version == null) continue;
                break;
            }
            if (version == null) {
                version = CarbonProperties.getInstance().getFormatVersion();
            }
        }
        return version;
    }

    public static boolean isEncodedWithMeta(List<Encoding> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            Encoding encoding = encodings.get(0);
            switch (encoding) {
                case DIRECT_COMPRESS: 
                case DIRECT_STRING: 
                case ADAPTIVE_INTEGRAL: 
                case ADAPTIVE_DELTA_INTEGRAL: 
                case ADAPTIVE_FLOATING: 
                case ADAPTIVE_DELTA_FLOATING: 
                case INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isStandardCarbonTable(CarbonTable table) {
        return !table.isSupportFlatFolder() && !table.isHivePartitionTable();
    }

    public static FallbackEncodedColumnPage getFallBackEncodedColumnPage(ColumnPage columnPage, int pageIndex, TableSpec.ColumnSpec columnSpec) throws IOException {
        EncodedColumnPage newEncodedColumnPage;
        switch (columnSpec.getColumnType()) {
            case COMPLEX_ARRAY: 
            case COMPLEX_STRUCT: 
            case COMPLEX: {
                throw new RuntimeException("Unsupported DataType. Only COMPLEX_PRIMITIVE should come");
            }
            case COMPLEX_PRIMITIVE: {
                newEncodedColumnPage = ColumnPageEncoder.encodedColumn(columnPage);
                break;
            }
            default: {
                ColumnPageEncoder columnPageEncoder = DefaultEncodingFactory.getInstance().createEncoder(columnSpec, columnPage);
                newEncodedColumnPage = columnPageEncoder.encode(columnPage);
            }
        }
        FallbackEncodedColumnPage fallbackEncodedColumnPage = new FallbackEncodedColumnPage(newEncodedColumnPage, pageIndex);
        return fallbackEncodedColumnPage;
    }

    public static boolean hasEncoding(List<Encoding> encodings, Encoding encoding) {
        return encodings.contains(encoding);
    }

    public static int[] getInvertedReverseIndex(int[] invertedIndex) {
        int[] columnIndexTemp = new int[invertedIndex.length];
        for (int i = 0; i < invertedIndex.length; ++i) {
            columnIndexTemp[invertedIndex[i]] = i;
        }
        return columnIndexTemp;
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getIndexServerTempPath() {
        String tempFolderPath = CarbonProperties.getInstance().getProperty("carbon.indexserver.temp.path");
        tempFolderPath = null == tempFolderPath ? "/tmp/indexservertmp" : tempFolderPath + "/" + "indexservertmp";
        return CarbonUtil.checkAndAppendFileSystemURIScheme(tempFolderPath);
    }

    public static CarbonFile createTempFolderForIndexServer(String queryId) throws IOException {
        String path = CarbonUtil.getIndexServerTempPath();
        if (queryId == null) {
            if (!FileFactory.isFileExist(path)) {
                LOGGER.info((Object)("Creating Index Server temp folder:" + path));
                FileFactory.createDirectoryAndSetPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            }
            return null;
        }
        CarbonFile file = FileFactory.getCarbonFile(path + "/" + queryId);
        if (!file.mkdirs()) {
            LOGGER.info((Object)("Unable to create table directory: " + path + "/" + queryId));
            return null;
        }
        LOGGER.info((Object)("Successfully Created directory: " + path + "/" + queryId));
        return file;
    }

    public static List<org.apache.carbondata.format.ColumnSchema> reorderColumnsForLongString(List<org.apache.carbondata.format.ColumnSchema> columns, String longStringColumnsString) {
        ArrayList<org.apache.carbondata.format.ColumnSchema> sortColumns = new ArrayList<org.apache.carbondata.format.ColumnSchema>();
        ArrayList<org.apache.carbondata.format.ColumnSchema> dimColumns = new ArrayList<org.apache.carbondata.format.ColumnSchema>();
        ArrayList<org.apache.carbondata.format.ColumnSchema> otherColumns = new ArrayList<org.apache.carbondata.format.ColumnSchema>();
        boolean isResetDone = false;
        int otherColumnStartIndex = -1;
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i).getColumnProperties() != null) {
                String isSortColumn = (String)columns.get(i).getColumnProperties().get("sort_columns");
                if (isSortColumn == null || !isSortColumn.equalsIgnoreCase("true")) continue;
                sortColumns.add(columns.get(i));
                continue;
            }
            if (columns.get(i).getData_type() == org.apache.carbondata.format.DataType.ARRAY || columns.get(i).getData_type() == org.apache.carbondata.format.DataType.STRUCT || columns.get(i).getData_type() == org.apache.carbondata.format.DataType.MAP || !columns.get(i).isDimension()) {
                otherColumnStartIndex = i;
                break;
            }
            org.apache.carbondata.format.ColumnSchema col = columns.get(i);
            if (col.data_type == org.apache.carbondata.format.DataType.VARCHAR) {
                col.data_type = org.apache.carbondata.format.DataType.STRING;
                isResetDone = true;
            }
            dimColumns.add(col);
        }
        if (otherColumnStartIndex != -1) {
            otherColumns.addAll(columns.subList(otherColumnStartIndex, columns.size()));
        }
        if (isResetDone) {
            dimColumns.sort(new Comparator<org.apache.carbondata.format.ColumnSchema>(){

                @Override
                public int compare(org.apache.carbondata.format.ColumnSchema o1, org.apache.carbondata.format.ColumnSchema o2) {
                    return o1.getSchemaOrdinal() - o2.getSchemaOrdinal();
                }
            });
        }
        ArrayList<Object> nonVarCharDims = new ArrayList<Object>();
        if (!longStringColumnsString.isEmpty()) {
            String[] inputColumns = longStringColumnsString.split(",");
            HashSet<String> longStringSet = new HashSet<String>(Arrays.asList(inputColumns));
            ArrayList<org.apache.carbondata.format.ColumnSchema> varCharColumns = new ArrayList<org.apache.carbondata.format.ColumnSchema>();
            for (org.apache.carbondata.format.ColumnSchema dim : dimColumns) {
                if (longStringSet.contains(dim.getColumn_name())) {
                    dim.data_type = org.apache.carbondata.format.DataType.VARCHAR;
                    varCharColumns.add(dim);
                    continue;
                }
                nonVarCharDims.add(dim);
            }
            nonVarCharDims.addAll(varCharColumns);
        } else {
            nonVarCharDims = dimColumns;
        }
        if (otherColumns.size() != 0) {
            nonVarCharDims.addAll(otherColumns);
        }
        sortColumns.addAll(nonVarCharDims);
        return sortColumns;
    }

    public static long getExpiration_time(CarbonTable carbonTable) {
        String cacheExpirationTime = carbonTable.getTableInfo().getFactTable().getTableProperties().get("index_cache_expiration_seconds");
        if (null == cacheExpirationTime) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(cacheExpirationTime);
    }
}

