/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.reader.CarbonFooterReader;
import org.apache.carbondata.core.util.AbstractDataFileFooterConverter;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.FileFooter;
import org.apache.hadoop.conf.Configuration;

public class DataFileFooterConverter
extends AbstractDataFileFooterConverter {
    public DataFileFooterConverter(Configuration configuration) {
        super(configuration);
    }

    public DataFileFooterConverter() {
        super(FileFactory.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataFileFooter readDataFileFooter(TableBlockInfo tableBlockInfo) throws IOException {
        DataFileFooter dataFileFooter = new DataFileFooter();
        FileReader fileReader = null;
        try {
            long completeBlockLength = tableBlockInfo.getBlockLength();
            long footerPointer = completeBlockLength - 8L;
            fileReader = FileFactory.getFileHolder(FileFactory.getFileType(tableBlockInfo.getFilePath()));
            long actualFooterOffset = fileReader.readLong(tableBlockInfo.getFilePath(), footerPointer);
            CarbonFooterReader reader = new CarbonFooterReader(tableBlockInfo.getFilePath(), actualFooterOffset);
            FileFooter footer = reader.readFooter();
            dataFileFooter.setVersionId(ColumnarFormatVersion.valueOf((short)footer.getVersion()));
            dataFileFooter.setNumberOfRows(footer.getNum_rows());
            ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
            List table_columns = footer.getTable_columns();
            for (int i = 0; i < table_columns.size(); ++i) {
                columnSchemaList.add(this.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)table_columns.get(i)));
            }
            dataFileFooter.setColumnInTable(columnSchemaList);
            List leaf_node_indices_Thrift = footer.getBlocklet_index_list();
            ArrayList<org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex> blockletIndexList = new ArrayList<org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex>();
            for (int i = 0; i < leaf_node_indices_Thrift.size(); ++i) {
                org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex blockletIndex = this.getBlockletIndex((BlockletIndex)leaf_node_indices_Thrift.get(i));
                blockletIndexList.add(blockletIndex);
            }
            List leaf_node_infos_Thrift = footer.getBlocklet_info_list();
            ArrayList<BlockletInfo> blockletInfoList = new ArrayList<BlockletInfo>();
            for (int i = 0; i < leaf_node_infos_Thrift.size(); ++i) {
                BlockletInfo blockletInfo = this.getBlockletInfo((org.apache.carbondata.format.BlockletInfo)leaf_node_infos_Thrift.get(i));
                blockletInfo.setBlockletIndex((org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex)blockletIndexList.get(i));
                blockletInfoList.add(blockletInfo);
            }
            dataFileFooter.setBlockletList(blockletInfoList);
            dataFileFooter.setBlockletIndex(this.getBlockletIndexForDataFileFooter(blockletIndexList));
        }
        finally {
            if (null != fileReader) {
                fileReader.finish();
            }
        }
        return dataFileFooter;
    }

    private BlockletInfo getBlockletInfo(org.apache.carbondata.format.BlockletInfo blockletInfoThrift) {
        BlockletInfo blockletInfo = new BlockletInfo();
        blockletInfo.setNumberOfRows(blockletInfoThrift.getNum_rows());
        return blockletInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> getSchema(TableBlockInfo tableBlockInfo) throws IOException {
        FileReader fileReader = null;
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        try {
            long completeBlockLength = tableBlockInfo.getBlockLength();
            long footerPointer = completeBlockLength - 8L;
            fileReader = FileFactory.getFileHolder(FileFactory.getFileType(tableBlockInfo.getFilePath()));
            long actualFooterOffset = fileReader.readLong(tableBlockInfo.getFilePath(), footerPointer);
            CarbonFooterReader reader = new CarbonFooterReader(tableBlockInfo.getFilePath(), actualFooterOffset);
            FileFooter footer = reader.readFooter();
            List table_columns = footer.getTable_columns();
            for (int i = 0; i < table_columns.size(); ++i) {
                columnSchemaList.add(this.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)table_columns.get(i)));
            }
        }
        finally {
            if (null != fileReader) {
                fileReader.finish();
            }
        }
        return columnSchemaList;
    }
}

