/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.reader.CarbonFooterReaderV3;
import org.apache.carbondata.core.reader.CarbonHeaderReader;
import org.apache.carbondata.core.util.AbstractDataFileFooterConverter;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.BlockletInfo3;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.FileFooter3;
import org.apache.carbondata.format.FileHeader;
import org.apache.hadoop.conf.Configuration;

public class DataFileFooterConverterV3
extends AbstractDataFileFooterConverter {
    public DataFileFooterConverterV3(Configuration configuration) {
        super(configuration);
    }

    public DataFileFooterConverterV3() {
        super(FileFactory.getConfiguration());
    }

    @Override
    public DataFileFooter readDataFileFooter(TableBlockInfo tableBlockInfo) throws IOException {
        CarbonHeaderReader carbonHeaderReader = new CarbonHeaderReader(tableBlockInfo.getFilePath());
        FileHeader fileHeader = carbonHeaderReader.readHeader();
        CarbonFooterReaderV3 reader = new CarbonFooterReaderV3(tableBlockInfo.getFilePath(), tableBlockInfo.getBlockOffset());
        FileFooter3 footer = reader.readFooterVersion3();
        return this.convertDataFileFooter(fileHeader, footer);
    }

    public DataFileFooter convertDataFileFooter(FileHeader fileHeader, FileFooter3 footer) {
        DataFileFooter dataFileFooter = new DataFileFooter();
        dataFileFooter.setVersionId(ColumnarFormatVersion.valueOf((short)fileHeader.getVersion()));
        dataFileFooter.setNumberOfRows(footer.getNum_rows());
        dataFileFooter.setSchemaUpdatedTimeStamp(fileHeader.getTime_stamp());
        if (footer.isSetIs_sort()) {
            dataFileFooter.setSorted(footer.isIs_sort());
        } else {
            dataFileFooter.setSorted(null);
        }
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        List table_columns = fileHeader.getColumn_schema();
        for (int i = 0; i < table_columns.size(); ++i) {
            columnSchemaList.add(this.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)table_columns.get(i)));
        }
        dataFileFooter.setColumnInTable(columnSchemaList);
        List leaf_node_indices_Thrift = footer.getBlocklet_index_list();
        ArrayList<org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex> blockletIndexList = new ArrayList<org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex>();
        for (int i = 0; i < leaf_node_indices_Thrift.size(); ++i) {
            org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex blockletIndex = this.getBlockletIndex((BlockletIndex)leaf_node_indices_Thrift.get(i));
            blockletIndexList.add(blockletIndex);
        }
        List leaf_node_infos_Thrift = footer.getBlocklet_info_list3();
        ArrayList<BlockletInfo> blockletInfoList = new ArrayList<BlockletInfo>();
        for (int i = 0; i < leaf_node_infos_Thrift.size(); ++i) {
            BlockletInfo blockletInfo = this.getBlockletInfo((BlockletInfo3)leaf_node_infos_Thrift.get(i), CarbonUtil.getNumberOfDimensionColumns(columnSchemaList));
            blockletInfo.setBlockletIndex((org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex)blockletIndexList.get(i));
            blockletInfoList.add(blockletInfo);
        }
        dataFileFooter.setBlockletList(blockletInfoList);
        dataFileFooter.setBlockletIndex(this.getBlockletIndexForDataFileFooter(blockletIndexList));
        return dataFileFooter;
    }

    @Override
    public List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> getSchema(TableBlockInfo tableBlockInfo) throws IOException {
        CarbonHeaderReader carbonHeaderReader = new CarbonHeaderReader(tableBlockInfo.getFilePath());
        FileHeader fileHeader = carbonHeaderReader.readHeader();
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        List table_columns = fileHeader.getColumn_schema();
        for (int i = 0; i < table_columns.size(); ++i) {
            columnSchemaList.add(this.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)table_columns.get(i)));
        }
        return columnSchemaList;
    }

    public BlockletInfo getBlockletInfo(BlockletInfo3 blockletInfoThrift, int numberOfDimensionColumns) {
        BlockletInfo blockletInfo = new BlockletInfo();
        List<Long> dimensionColumnChunkOffsets = blockletInfoThrift.getColumn_data_chunks_offsets().subList(0, numberOfDimensionColumns);
        List<Long> measureColumnChunksOffsets = blockletInfoThrift.getColumn_data_chunks_offsets().subList(numberOfDimensionColumns, blockletInfoThrift.getColumn_data_chunks_offsets().size());
        List<Integer> dimensionColumnChunkLength = blockletInfoThrift.getColumn_data_chunks_length().subList(0, numberOfDimensionColumns);
        List<Integer> measureColumnChunksLength = blockletInfoThrift.getColumn_data_chunks_length().subList(numberOfDimensionColumns, blockletInfoThrift.getColumn_data_chunks_offsets().size());
        blockletInfo.setDimensionChunkOffsets(dimensionColumnChunkOffsets);
        blockletInfo.setMeasureChunkOffsets(measureColumnChunksOffsets);
        blockletInfo.setDimensionChunksLength(dimensionColumnChunkLength);
        blockletInfo.setMeasureChunksLength(measureColumnChunksLength);
        blockletInfo.setNumberOfRows(blockletInfoThrift.getNum_rows());
        blockletInfo.setDimensionOffset(blockletInfoThrift.getDimension_offsets());
        blockletInfo.setMeasureOffsets(blockletInfoThrift.getMeasure_offsets());
        blockletInfo.setNumberOfPages(blockletInfoThrift.getNumber_number_of_pages());
        if (blockletInfoThrift.getRow_count_in_page() != null && blockletInfoThrift.getRow_count_in_page().size() != 0) {
            int[] rowCountInPages = new int[blockletInfoThrift.getRow_count_in_page().size()];
            for (int i = 0; i < blockletInfoThrift.getRow_count_in_page().size(); ++i) {
                rowCountInPages[i] = (Integer)blockletInfoThrift.getRow_count_in_page().get(i);
            }
            blockletInfo.setNumberOfRowsPerPage(rowCountInPages);
        }
        return blockletInfo;
    }
}

