/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.bool.BooleanConvert;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.log4j.Logger;

public final class DataTypeUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DataTypeUtil.class.getName());
    private static final ThreadLocal<DateFormat> timeStampformatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat(CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss"));
            dateFormat.setLenient(false);
            return dateFormat;
        }
    };
    private static final ThreadLocal<DateFormat> dateformatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd"));
        }
    };
    private static DataTypeConverter converter;

    public static Object getMeasureValueBasedOnDataType(String msrValue, DataType dataType, int scale, int precision) {
        return DataTypeUtil.getMeasureValueBasedOnDataType(msrValue, dataType, scale, precision, false);
    }

    public static Object getMeasureValueBasedOnDataType(String msrValue, DataType dataType, int scale, int precision, boolean useConverter) {
        if (dataType == DataTypes.BOOLEAN) {
            return BooleanConvert.parseBoolean(msrValue);
        }
        if (DataTypes.isDecimal(dataType)) {
            BigDecimal bigDecimal = new BigDecimal(msrValue).setScale(scale, RoundingMode.HALF_UP);
            BigDecimal decimal = DataTypeUtil.normalizeDecimalValue(bigDecimal, precision);
            if (useConverter) {
                return converter.convertFromBigDecimalToDecimal(decimal);
            }
            return decimal;
        }
        if (dataType == DataTypes.SHORT) {
            return Short.parseShort(msrValue);
        }
        if (dataType == DataTypes.INT) {
            return Integer.parseInt(msrValue);
        }
        if (dataType == DataTypes.LONG) {
            return Long.valueOf(msrValue);
        }
        if (dataType == DataTypes.FLOAT) {
            return Float.valueOf(Float.parseFloat(msrValue));
        }
        if (dataType == DataTypes.BYTE) {
            return Byte.parseByte(msrValue);
        }
        Double parsedValue = Double.valueOf(msrValue);
        if (Double.isInfinite(parsedValue) || Double.isNaN(parsedValue)) {
            return null;
        }
        return parsedValue;
    }

    public static Object getNoDictionaryValueBasedOnDataType(String dimValue, DataType dataType, int scale, int precision, boolean useConverter, String timeStampFormat) {
        if (dataType == DataTypes.BOOLEAN) {
            return BooleanConvert.parseBoolean(dimValue);
        }
        if (DataTypes.isDecimal(dataType)) {
            BigDecimal bigDecimal = new BigDecimal(dimValue).setScale(scale, RoundingMode.HALF_UP);
            BigDecimal decimal = DataTypeUtil.normalizeDecimalValue(bigDecimal, precision);
            if (useConverter) {
                return converter.convertFromBigDecimalToDecimal(decimal);
            }
            return decimal;
        }
        if (dataType == DataTypes.SHORT) {
            return Short.parseShort(dimValue);
        }
        if (dataType == DataTypes.INT) {
            return Integer.parseInt(dimValue);
        }
        if (dataType == DataTypes.LONG) {
            return Long.valueOf(dimValue);
        }
        if (dataType == DataTypes.FLOAT) {
            return Float.valueOf(Float.parseFloat(dimValue));
        }
        if (dataType == DataTypes.BYTE) {
            return Byte.parseByte(dimValue);
        }
        if (dataType == DataTypes.TIMESTAMP) {
            Date dateToStr = null;
            DateFormat dateFormatter = null;
            try {
                if (null != timeStampFormat && !timeStampFormat.trim().isEmpty()) {
                    dateFormatter = new SimpleDateFormat(timeStampFormat);
                    dateFormatter.setLenient(false);
                } else {
                    dateFormatter = timeStampformatter.get();
                }
                dateToStr = dateFormatter.parse(dimValue);
                return dateToStr.getTime();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        Double parsedValue = Double.valueOf(dimValue);
        if (Double.isInfinite(parsedValue) || Double.isNaN(parsedValue)) {
            return null;
        }
        return parsedValue;
    }

    public static Object getMeasureObjectFromDataType(byte[] data, DataType dataType) {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(data);
        if (dataType == DataTypes.BOOLEAN) {
            return BooleanConvert.byte2Boolean(bb.get());
        }
        if (dataType == DataTypes.SHORT) {
            return (short)bb.getLong();
        }
        if (dataType == DataTypes.INT) {
            return (int)bb.getLong();
        }
        if (dataType == DataTypes.LONG) {
            return bb.getLong();
        }
        if (dataType == DataTypes.FLOAT) {
            return Float.valueOf(bb.getFloat());
        }
        if (dataType == DataTypes.BYTE) {
            return bb.get();
        }
        if (DataTypes.isDecimal(dataType)) {
            return DataTypeUtil.byteToBigDecimal(data);
        }
        return bb.getDouble();
    }

    public static Object getMeasureObjectBasedOnDataType(ColumnPage measurePage, int index, DataType dataType, CarbonMeasure carbonMeasure) {
        if (dataType == DataTypes.BOOLEAN) {
            return measurePage.getBoolean(index);
        }
        if (dataType == DataTypes.SHORT) {
            return (short)measurePage.getLong(index);
        }
        if (dataType == DataTypes.INT) {
            return (int)measurePage.getLong(index);
        }
        if (dataType == DataTypes.LONG) {
            return measurePage.getLong(index);
        }
        if (dataType == DataTypes.FLOAT) {
            return Float.valueOf(measurePage.getFloat(index));
        }
        if (dataType == DataTypes.BYTE) {
            return measurePage.getByte(index);
        }
        if (DataTypes.isDecimal(dataType)) {
            BigDecimal bigDecimalMsrValue = measurePage.getDecimal(index);
            if (null != bigDecimalMsrValue && carbonMeasure.getScale() > bigDecimalMsrValue.scale()) {
                bigDecimalMsrValue = bigDecimalMsrValue.setScale(carbonMeasure.getScale(), RoundingMode.HALF_UP);
            }
            if (null != bigDecimalMsrValue) {
                return DataTypeUtil.normalizeDecimalValue(bigDecimalMsrValue, carbonMeasure.getPrecision());
            }
            return null;
        }
        return measurePage.getDouble(index);
    }

    private static BigDecimal normalizeDecimalValue(BigDecimal bigDecimal, int allowedPrecision) {
        if (bigDecimal.precision() > allowedPrecision) {
            return null;
        }
        return bigDecimal;
    }

    public static byte[] bigDecimalToByte(BigDecimal num) {
        BigInteger sig = new BigInteger(num.unscaledValue().toString());
        int scale = num.scale();
        byte[] bscale = new byte[]{(byte)scale};
        byte[] buff = sig.toByteArray();
        byte[] completeArr = new byte[buff.length + bscale.length];
        System.arraycopy(bscale, 0, completeArr, 0, bscale.length);
        System.arraycopy(buff, 0, completeArr, bscale.length, buff.length);
        return completeArr;
    }

    public static BigDecimal byteToBigDecimal(byte[] raw) {
        int scale = raw[0] & 0xFF;
        byte[] unscale = new byte[raw.length - 1];
        System.arraycopy(raw, 1, unscale, 0, unscale.length);
        BigInteger sig = new BigInteger(unscale);
        return new BigDecimal(sig, scale);
    }

    public static BigDecimal byteToBigDecimal(byte[] raw, int offset, int length) {
        int scale = raw[offset] & 0xFF;
        byte[] unscale = new byte[length - 1];
        System.arraycopy(raw, offset + 1, unscale, 0, unscale.length);
        BigInteger sig = new BigInteger(unscale);
        return new BigDecimal(sig, scale);
    }

    public static Object getDataBasedOnDataType(String data, DataType actualDataType) {
        return DataTypeUtil.getDataBasedOnDataType(data, actualDataType, DataTypeUtil.getDataTypeConverter());
    }

    public static Object getDataBasedOnDataType(String data, DataType actualDataType, DataTypeConverter converter) {
        if (null == data || "@NU#LL$!".equals(data)) {
            return null;
        }
        try {
            if (actualDataType == DataTypes.BOOLEAN) {
                if (data.isEmpty()) {
                    return null;
                }
                return BooleanConvert.parseBoolean(data);
            }
            if (actualDataType == DataTypes.INT) {
                if (data.isEmpty()) {
                    return null;
                }
                return Integer.parseInt(data);
            }
            if (actualDataType == DataTypes.SHORT) {
                if (data.isEmpty()) {
                    return null;
                }
                return Short.parseShort(data);
            }
            if (actualDataType == DataTypes.FLOAT) {
                if (data.isEmpty()) {
                    return null;
                }
                return Float.valueOf(Float.parseFloat(data));
            }
            if (actualDataType == DataTypes.DOUBLE) {
                if (data.isEmpty()) {
                    return null;
                }
                return Double.parseDouble(data);
            }
            if (actualDataType == DataTypes.LONG) {
                if (data.isEmpty()) {
                    return null;
                }
                return Long.parseLong(data);
            }
            if (actualDataType == DataTypes.DATE) {
                if (data.isEmpty()) {
                    return null;
                }
                try {
                    Date dateToStr = dateformatter.get().parse(data);
                    return dateToStr.getTime() * 1000L;
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("Cannot convert value to Time/Long type value" + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
            if (actualDataType == DataTypes.TIMESTAMP) {
                if (data.isEmpty()) {
                    return null;
                }
                try {
                    Date dateToStr = timeStampformatter.get().parse(data);
                    return dateToStr.getTime() * 1000L;
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("Cannot convert value to Time/Long type value" + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
            if (DataTypes.isDecimal(actualDataType)) {
                if (data.isEmpty()) {
                    return null;
                }
                return converter.convertFromStringToDecimal(data);
            }
            return converter.convertFromStringToUTF8String(data);
        }
        catch (NumberFormatException ex) {
            LOGGER.error((Object)("Problem while converting data type" + data));
            return null;
        }
    }

    public static byte[] getBytesBasedOnDataTypeForNoDictionaryColumn(String dimensionValue, DataType actualDataType, String dateFormat) {
        if (actualDataType == DataTypes.BOOLEAN) {
            return ByteUtil.toBytes(BooleanConvert.parseBoolean(dimensionValue));
        }
        if (actualDataType == DataTypes.SHORT) {
            return ByteUtil.toXorBytes(Short.parseShort(dimensionValue));
        }
        if (actualDataType == DataTypes.INT) {
            return ByteUtil.toXorBytes(Integer.parseInt(dimensionValue));
        }
        if (actualDataType == DataTypes.LONG) {
            return ByteUtil.toXorBytes(Long.parseLong(dimensionValue));
        }
        if (actualDataType == DataTypes.DOUBLE) {
            return ByteUtil.toXorBytes(Double.parseDouble(dimensionValue));
        }
        if (actualDataType == DataTypes.FLOAT) {
            return ByteUtil.toXorBytes(Float.parseFloat(dimensionValue));
        }
        if (actualDataType == DataTypes.BYTE) {
            return new byte[]{Byte.parseByte(dimensionValue)};
        }
        if (DataTypes.isDecimal(actualDataType)) {
            return DataTypeUtil.bigDecimalToByte(new BigDecimal(dimensionValue));
        }
        if (actualDataType == DataTypes.TIMESTAMP) {
            Date dateToStr = null;
            DateFormat dateFormatter = null;
            try {
                if (null != dateFormat && !dateFormat.trim().isEmpty()) {
                    dateFormatter = new SimpleDateFormat(dateFormat);
                    dateFormatter.setLenient(false);
                } else {
                    dateFormatter = timeStampformatter.get();
                }
                dateToStr = dateFormatter.parse(dimensionValue);
                return ByteUtil.toXorBytes(dateToStr.getTime());
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        return ByteUtil.toBytes(dimensionValue);
    }

    public static Object getDataDataTypeForNoDictionaryColumn(String dimensionValue, DataType actualDataType, String dateFormat) {
        if (actualDataType == DataTypes.BOOLEAN) {
            return BooleanConvert.parseBoolean(dimensionValue);
        }
        if (actualDataType == DataTypes.SHORT) {
            return Short.parseShort(dimensionValue);
        }
        if (actualDataType == DataTypes.INT) {
            return Integer.parseInt(dimensionValue);
        }
        if (actualDataType == DataTypes.LONG) {
            return Long.parseLong(dimensionValue);
        }
        if (actualDataType == DataTypes.DOUBLE) {
            return Double.parseDouble(dimensionValue);
        }
        if (DataTypes.isDecimal(actualDataType)) {
            return new BigDecimal(dimensionValue);
        }
        if (actualDataType == DataTypes.TIMESTAMP) {
            Date dateToStr = null;
            DateFormat dateFormatter = null;
            try {
                if (null != dateFormat && !dateFormat.trim().isEmpty()) {
                    dateFormatter = new SimpleDateFormat(dateFormat);
                    dateFormatter.setLenient(false);
                } else {
                    dateFormatter = timeStampformatter.get();
                }
                dateToStr = dateFormatter.parse(dimensionValue);
                return dateToStr.getTime();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        return converter.convertFromStringToUTF8String(dimensionValue);
    }

    public static byte[] getBytesDataDataTypeForNoDictionaryColumn(Object dimensionValue, DataType actualDataType) {
        if (dimensionValue == null) {
            if (actualDataType == DataTypes.STRING) {
                return CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
            }
            return new byte[0];
        }
        if (actualDataType == DataTypes.BOOLEAN) {
            return ByteUtil.toBytes((Boolean)dimensionValue);
        }
        if (actualDataType == DataTypes.SHORT) {
            return ByteUtil.toXorBytes((Short)dimensionValue);
        }
        if (actualDataType == DataTypes.INT) {
            return ByteUtil.toXorBytes((Integer)dimensionValue);
        }
        if (actualDataType == DataTypes.LONG) {
            return ByteUtil.toXorBytes((Long)dimensionValue);
        }
        if (actualDataType == DataTypes.DOUBLE) {
            return ByteUtil.toXorBytes((Double)dimensionValue);
        }
        if (actualDataType == DataTypes.FLOAT) {
            return ByteUtil.toXorBytes(((Float)dimensionValue).floatValue());
        }
        if (DataTypes.isDecimal(actualDataType)) {
            return DataTypeUtil.bigDecimalToByte(new BigDecimal(dimensionValue.toString()));
        }
        if (actualDataType == DataTypes.BYTE) {
            return ByteUtil.toXorBytes(((Byte)dimensionValue).byteValue());
        }
        if (actualDataType == DataTypes.TIMESTAMP) {
            return ByteUtil.toXorBytes((Long)dimensionValue);
        }
        if (actualDataType == DataTypes.BINARY) {
            if (dimensionValue instanceof String) {
                return ((String)dimensionValue).getBytes(Charset.forName("UTF-8"));
            }
            return (byte[])dimensionValue;
        }
        return ByteUtil.toBytes(dimensionValue.toString());
    }

    public static byte[] getMinMaxBytesBasedOnDataTypeForNoDictionaryColumn(Object dimensionValue, DataType actualDataType) {
        if (dimensionValue == null) {
            if (actualDataType == DataTypes.STRING) {
                return CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
            }
            return new byte[0];
        }
        if (actualDataType == DataTypes.BOOLEAN) {
            return ByteUtil.toBytes(ByteUtil.toBoolean((Byte)dimensionValue));
        }
        if (actualDataType == DataTypes.SHORT) {
            return ByteUtil.toXorBytes((Short)dimensionValue);
        }
        if (actualDataType == DataTypes.INT) {
            return ByteUtil.toXorBytes((Integer)dimensionValue);
        }
        if (actualDataType == DataTypes.LONG) {
            return ByteUtil.toXorBytes((Long)dimensionValue);
        }
        if (actualDataType == DataTypes.TIMESTAMP) {
            return ByteUtil.toXorBytes((Long)dimensionValue);
        }
        return ByteUtil.toBytes(dimensionValue.toString());
    }

    public static boolean isFixedSizeDataType(DataType dataType) {
        return dataType != DataTypes.STRING && dataType != DataTypes.VARCHAR && dataType != DataTypes.BINARY && !DataTypes.isDecimal(dataType);
    }

    public static Object getDataBasedOnDataTypeForNoDictionaryColumn(byte[] dataInBytes, DataType actualDataType) {
        return DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(dataInBytes, actualDataType, true);
    }

    public static Object getDataBasedOnDataTypeForNoDictionaryColumn(byte[] dataInBytes, DataType actualDataType, boolean isTimeStampConversion) {
        if (null == dataInBytes || Arrays.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, dataInBytes)) {
            return null;
        }
        try {
            if (actualDataType == DataTypes.BOOLEAN) {
                return ByteUtil.toBoolean(dataInBytes);
            }
            if (actualDataType == DataTypes.BYTE) {
                return dataInBytes[0];
            }
            if (actualDataType == DataTypes.SHORT) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                return ByteUtil.toXorShort(dataInBytes, 0, dataInBytes.length);
            }
            if (actualDataType == DataTypes.INT) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                return ByteUtil.toXorInt(dataInBytes, 0, dataInBytes.length);
            }
            if (actualDataType == DataTypes.LONG) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                return ByteUtil.toXorLong(dataInBytes, 0, dataInBytes.length);
            }
            if (actualDataType == DataTypes.TIMESTAMP) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                if (isTimeStampConversion) {
                    return ByteUtil.toXorLong(dataInBytes, 0, dataInBytes.length) * 1000L;
                }
                return ByteUtil.toXorLong(dataInBytes, 0, dataInBytes.length);
            }
            if (actualDataType == DataTypes.DOUBLE) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                return ByteUtil.toXorDouble(dataInBytes, 0, dataInBytes.length);
            }
            if (actualDataType == DataTypes.FLOAT) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                return Float.valueOf(ByteUtil.toXorFloat(dataInBytes, 0, dataInBytes.length));
            }
            if (DataTypes.isDecimal(actualDataType)) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                return DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal(DataTypeUtil.byteToBigDecimal(dataInBytes));
            }
            if (actualDataType == DataTypes.BINARY) {
                if (DataTypeUtil.isEmptyByteArray(dataInBytes)) {
                    return null;
                }
                return dataInBytes;
            }
            return DataTypeUtil.getDataTypeConverter().convertFromByteToUTF8String(dataInBytes);
        }
        catch (Throwable ex) {
            String data = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
            LOGGER.error((Object)("Cannot convert" + data + " to " + actualDataType.getName() + " type value" + ex.getMessage()));
            LOGGER.error((Object)("Problem while converting data type" + data));
            return null;
        }
    }

    private static boolean isEmptyByteArray(byte[] dataInBytes) {
        return dataInBytes.length == 0;
    }

    public static Object getDataBasedOnDataType(byte[] dataInBytes, CarbonDimension dimension) {
        if (null == dataInBytes || Arrays.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, dataInBytes)) {
            return null;
        }
        try {
            DataType dataType = dimension.getDataType();
            if (dataType == DataTypes.INT) {
                String data1 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data1.isEmpty()) {
                    return null;
                }
                return Integer.parseInt(data1);
            }
            if (dataType == DataTypes.SHORT) {
                String data2 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data2.isEmpty()) {
                    return null;
                }
                return Short.parseShort(data2);
            }
            if (dataType == DataTypes.DOUBLE) {
                String data3 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data3.isEmpty()) {
                    return null;
                }
                return Double.parseDouble(data3);
            }
            if (dataType == DataTypes.LONG) {
                String data4 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data4.isEmpty()) {
                    return null;
                }
                return Long.parseLong(data4);
            }
            if (dataType == DataTypes.DATE) {
                String data5 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data5.isEmpty()) {
                    return null;
                }
                try {
                    Date dateToStr = dateformatter.get().parse(data5);
                    return dateToStr.getTime() * 1000L;
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("Cannot convert value to Time/Long type value" + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
            if (dataType == DataTypes.TIMESTAMP) {
                String data6 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data6.isEmpty()) {
                    return null;
                }
                try {
                    Date dateToStr = timeStampformatter.get().parse(data6);
                    return dateToStr.getTime() * 1000L;
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("Cannot convert value to Time/Long type value" + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
            if (DataTypes.isDecimal(dataType)) {
                String data7 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data7.isEmpty()) {
                    return null;
                }
                BigDecimal javaDecVal = new BigDecimal(data7);
                if (dimension.getColumnSchema().getScale() > javaDecVal.scale()) {
                    javaDecVal = javaDecVal.setScale(dimension.getColumnSchema().getScale());
                }
                return DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal(javaDecVal);
            }
            if (dataType == DataTypes.BOOLEAN) {
                String data8 = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
                if (data8.isEmpty()) {
                    return null;
                }
                return BooleanConvert.parseBoolean(data8);
            }
            return DataTypeUtil.getDataTypeConverter().convertFromByteToUTF8String(dataInBytes);
        }
        catch (NumberFormatException ex) {
            String data = new String(dataInBytes, CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
            LOGGER.error((Object)("Problem while converting data type" + data));
            return null;
        }
    }

    public static Object normalizeIntAndLongValues(String data, DataType actualDataType) {
        if (null == data) {
            return null;
        }
        try {
            if (actualDataType == DataTypes.SHORT) {
                Short.parseShort(data);
            } else if (actualDataType == DataTypes.INT) {
                Integer.parseInt(data);
            } else if (actualDataType == DataTypes.LONG) {
                Long.parseLong(data);
            } else {
                return data;
            }
            return data;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String normalizeColumnValueForItsDataType(String value, CarbonColumn dimension) {
        try {
            Object parsedValue = null;
            DataType dataType = dimension.getDataType();
            if (DataTypes.isDecimal(dataType)) {
                return DataTypeUtil.parseStringToBigDecimal(value, dimension);
            }
            if (dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG) {
                parsedValue = DataTypeUtil.normalizeIntAndLongValues(value, dimension.getDataType());
            } else if (dataType == DataTypes.DOUBLE) {
                parsedValue = Double.parseDouble(value);
            } else {
                return value;
            }
            if (null != parsedValue) {
                return value;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String parseValue(String value, CarbonDimension dimension) {
        if (null == value) {
            return null;
        }
        try {
            DataType dataType = dimension.getDataType();
            if (DataTypes.isDecimal(dataType)) {
                return DataTypeUtil.parseStringToBigDecimal(value, dimension);
            }
            if (dataType == DataTypes.INT) {
                Integer.parseInt(value);
            } else if (dataType == DataTypes.DOUBLE) {
                Double.parseDouble(value);
            } else if (dataType == DataTypes.LONG) {
                Long.parseLong(value);
            } else if (dataType == DataTypes.FLOAT) {
                Float.parseFloat(value);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return value;
    }

    private static String parseStringToBigDecimal(String value, CarbonColumn dimension) {
        BigDecimal bigDecimal = new BigDecimal(value).setScale(dimension.getColumnSchema().getScale(), RoundingMode.HALF_UP);
        BigDecimal normalizedValue = DataTypeUtil.normalizeDecimalValue(bigDecimal, dimension.getColumnSchema().getPrecision());
        if (null != normalizedValue) {
            return normalizedValue.toString();
        }
        return null;
    }

    public static int compareDoubleWithNan(Double d1, Double d2) {
        if (d1.doubleValue() == d2.doubleValue() || Double.isNaN(d1) && Double.isNaN(d2)) {
            return 0;
        }
        if (d1 < d2) {
            return -1;
        }
        return 1;
    }

    public static byte[] convertDataToBytesBasedOnDataType(String data, ColumnSchema columnSchema) {
        if (null == data) {
            return null;
        }
        if ("@NU#LL$!".equals(data)) {
            LOGGER.error((Object)("Default value should not be carbon specific null value : " + data));
            return null;
        }
        try {
            long parsedIntVal = 0L;
            DataType dataType = columnSchema.getDataType();
            if (dataType == DataTypes.INT) {
                parsedIntVal = Integer.parseInt(data);
                return String.valueOf(parsedIntVal).getBytes(Charset.forName("UTF-8"));
            }
            if (dataType == DataTypes.SHORT) {
                parsedIntVal = Short.parseShort(data);
                return String.valueOf(parsedIntVal).getBytes(Charset.forName("UTF-8"));
            }
            if (dataType == DataTypes.DOUBLE) {
                return String.valueOf(Double.parseDouble(data)).getBytes(Charset.forName("UTF-8"));
            }
            if (dataType == DataTypes.LONG) {
                return String.valueOf(Long.parseLong(data)).getBytes(Charset.forName("UTF-8"));
            }
            if (dataType == DataTypes.DATE) {
                DirectDictionaryGenerator directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(columnSchema.getDataType());
                int value = directDictionaryGenerator.generateDirectSurrogateKey(data);
                return String.valueOf(value).getBytes(Charset.forName("UTF-8"));
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (columnSchema.getDataType() == DataTypes.DATE) {
                    DirectDictionaryGenerator directDictionaryGenerator1 = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(columnSchema.getDataType());
                    int value1 = directDictionaryGenerator1.generateDirectSurrogateKey(data);
                    return String.valueOf(value1).getBytes(Charset.forName("UTF-8"));
                }
                try {
                    timeStampformatter.remove();
                    Date dateToStr = timeStampformatter.get().parse(data);
                    return ByteUtil.toXorBytes(dateToStr.getTime());
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("Cannot convert value to Time/Long type value. Value is considered as null" + e.getMessage()));
                    return null;
                }
            }
            if (DataTypes.isDecimal(dataType)) {
                String parsedValue = DataTypeUtil.parseStringToBigDecimal(data, columnSchema);
                if (null == parsedValue) {
                    return null;
                }
                BigDecimal javaDecVal = new BigDecimal(parsedValue);
                return DataTypeUtil.bigDecimalToByte(javaDecVal);
            }
            return DataTypeUtil.getDataTypeConverter().convertFromStringToByte(data);
        }
        catch (NumberFormatException ex) {
            LOGGER.error((Object)("Problem while converting data type" + data));
            return null;
        }
    }

    public static String normalizeColumnValueForItsDataType(String value, ColumnSchema columnSchema) {
        try {
            Object parsedValue = null;
            DataType dataType = columnSchema.getDataType();
            if (DataTypes.isDecimal(dataType)) {
                return DataTypeUtil.parseStringToBigDecimal(value, columnSchema);
            }
            if (dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG) {
                parsedValue = DataTypeUtil.normalizeIntAndLongValues(value, columnSchema.getDataType());
            } else if (dataType == DataTypes.DOUBLE) {
                parsedValue = Double.parseDouble(value);
            } else {
                return value;
            }
            if (null != parsedValue) {
                return value;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String parseStringToBigDecimal(String value, ColumnSchema columnSchema) {
        BigDecimal bigDecimal = new BigDecimal(value).setScale(columnSchema.getScale(), RoundingMode.HALF_UP);
        BigDecimal normalizedValue = DataTypeUtil.normalizeDecimalValue(bigDecimal, columnSchema.getPrecision());
        if (null != normalizedValue) {
            return normalizedValue.toString();
        }
        return null;
    }

    public static void setDataTypeConverter(DataTypeConverter converterLocal) {
        if (converterLocal != null) {
            converter = converterLocal;
            timeStampformatter.remove();
            dateformatter.remove();
        }
    }

    public static void clearFormatter() {
        timeStampformatter.remove();
        dateformatter.remove();
    }

    public static DataTypeConverter getDataTypeConverter() {
        if (converter == null) {
            converter = new DataTypeConverterImpl();
        }
        return converter;
    }

    public static DataType valueOf(String name) {
        if (DataTypes.STRING.getName().equalsIgnoreCase(name)) {
            return DataTypes.STRING;
        }
        if (DataTypes.DATE.getName().equalsIgnoreCase(name)) {
            return DataTypes.DATE;
        }
        if (DataTypes.TIMESTAMP.getName().equalsIgnoreCase(name)) {
            return DataTypes.TIMESTAMP;
        }
        if (DataTypes.BOOLEAN.getName().equalsIgnoreCase(name)) {
            return DataTypes.BOOLEAN;
        }
        if (DataTypes.BYTE.getName().equalsIgnoreCase(name)) {
            return DataTypes.BYTE;
        }
        if (DataTypes.SHORT.getName().equalsIgnoreCase(name)) {
            return DataTypes.SHORT;
        }
        if (DataTypes.SHORT_INT.getName().equalsIgnoreCase(name)) {
            return DataTypes.SHORT_INT;
        }
        if (DataTypes.INT.getName().equalsIgnoreCase(name)) {
            return DataTypes.INT;
        }
        if (DataTypes.LONG.getName().equalsIgnoreCase(name)) {
            return DataTypes.LONG;
        }
        if (DataTypes.FLOAT.getName().equalsIgnoreCase(name)) {
            return DataTypes.FLOAT;
        }
        if (DataTypes.DOUBLE.getName().equalsIgnoreCase(name)) {
            return DataTypes.DOUBLE;
        }
        if (DataTypes.VARCHAR.getName().equalsIgnoreCase(name)) {
            return DataTypes.VARCHAR;
        }
        if (DataTypes.NULL.getName().equalsIgnoreCase(name)) {
            return DataTypes.NULL;
        }
        if (DataTypes.BYTE_ARRAY.getName().equalsIgnoreCase(name)) {
            return DataTypes.BYTE_ARRAY;
        }
        if (DataTypes.BINARY.getName().equalsIgnoreCase(name)) {
            return DataTypes.BINARY;
        }
        if (name.equalsIgnoreCase("decimal")) {
            return DataTypes.createDefaultDecimalType();
        }
        if (name.equalsIgnoreCase("array")) {
            return DataTypes.createDefaultArrayType();
        }
        if (name.equalsIgnoreCase("struct")) {
            return DataTypes.createDefaultStructType();
        }
        if (name.equalsIgnoreCase("map")) {
            return DataTypes.createDefaultMapType();
        }
        throw new RuntimeException("create DataType with invalid name: " + name);
    }

    public static DataType valueOf(DataType dataType, int precision, int scale) {
        if (DataTypes.isDecimal(dataType)) {
            return DataTypes.createDecimalType(precision, scale);
        }
        return DataTypeUtil.valueOf(dataType.getName());
    }

    public static long getDataBasedOnRestructuredDataType(byte[] data, DataType restructuredDataType, int currentDataOffset, int length) {
        long value = 0L;
        if (restructuredDataType == DataTypes.INT) {
            value = ByteUtil.toXorInt(data, currentDataOffset, length);
        } else if (restructuredDataType == DataTypes.LONG) {
            value = ByteUtil.toXorLong(data, currentDataOffset, length);
        }
        return value;
    }

    public static boolean isPrimitiveColumn(DataType dataType) {
        return dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE || dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP || DataTypes.isDecimal(dataType) || dataType == DataTypes.FLOAT || dataType == DataTypes.DOUBLE;
    }

    public static boolean isByteArrayComplexChildColumn(DataType dataType) {
        return dataType == DataTypes.STRING || dataType == DataTypes.VARCHAR || dataType == DataTypes.BINARY || dataType == DataTypes.DATE || DataTypes.isDecimal(dataType) || dataType == DataTypes.BYTE_ARRAY;
    }
}

