/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.log4j.Logger;

public final class DeleteLoadFolders {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DeleteLoadFolders.class.getName());

    private DeleteLoadFolders() {
    }

    private static String getSegmentPath(AbsoluteTableIdentifier identifier, LoadMetadataDetails oneLoad) {
        String segmentId = oneLoad.getLoadName();
        return CarbonTablePath.getSegmentPath(identifier.getTablePath(), segmentId);
    }

    public static void physicalFactAndMeasureMetadataDeletion(CarbonTable carbonTable, LoadMetadataDetails[] newAddedLoadHistoryList, boolean isForceDelete, List<PartitionSpec> specs) {
        LoadMetadataDetails[] currentDetails = SegmentStatusManager.readLoadMetadata(carbonTable.getMetadataPath());
        DeleteLoadFolders.physicalFactAndMeasureMetadataDeletion(carbonTable, currentDetails, isForceDelete, specs, currentDetails);
        if (newAddedLoadHistoryList != null && newAddedLoadHistoryList.length > 0) {
            DeleteLoadFolders.physicalFactAndMeasureMetadataDeletion(carbonTable, newAddedLoadHistoryList, isForceDelete, specs, currentDetails);
        }
    }

    private static void physicalFactAndMeasureMetadataDeletion(CarbonTable carbonTable, LoadMetadataDetails[] loadDetails, boolean isForceDelete, List<PartitionSpec> specs, LoadMetadataDetails[] currLoadDetails) {
        ArrayList<TableIndex> indexes = new ArrayList<TableIndex>();
        try {
            for (TableIndex index : IndexStoreManager.getInstance().getAllCGAndFGIndexes(carbonTable)) {
                if (!index.getIndexSchema().isIndex()) continue;
                indexes.add(index);
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)String.format("Failed to get indexes for %s.%s, therefore the index files could not be cleaned.", carbonTable.getAbsoluteTableIdentifier().getDatabaseName(), carbonTable.getAbsoluteTableIdentifier().getTableName()));
        }
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(carbonTable, currLoadDetails);
        for (LoadMetadataDetails oneLoad : loadDetails) {
            if (!DeleteLoadFolders.checkIfLoadCanBeDeletedPhysically(oneLoad, isForceDelete)) continue;
            try {
                if (oneLoad.getSegmentFile() != null) {
                    SegmentFileStore.deleteSegment(carbonTable.getAbsoluteTableIdentifier().getTablePath(), new Segment(oneLoad.getLoadName(), oneLoad.getSegmentFile()), specs, updateStatusManager);
                } else {
                    String path = DeleteLoadFolders.getSegmentPath(carbonTable.getAbsoluteTableIdentifier(), oneLoad);
                    boolean status = false;
                    if (FileFactory.isFileExist(path)) {
                        CarbonFile file = FileFactory.getCarbonFile(path);
                        CarbonFile[] filesToBeDeleted = file.listFiles(new CarbonFileFilter(){

                            @Override
                            public boolean accept(CarbonFile file) {
                                return CarbonTablePath.isCarbonDataFile(file.getName()) || CarbonTablePath.isCarbonIndexFile(file.getName());
                            }
                        });
                        if (filesToBeDeleted.length == 0) {
                            status = true;
                        } else {
                            for (CarbonFile eachFile : filesToBeDeleted) {
                                if (!eachFile.delete()) {
                                    LOGGER.warn((Object)("Unable to delete the file as per delete command " + eachFile.getAbsolutePath()));
                                    status = false;
                                    continue;
                                }
                                status = true;
                            }
                        }
                        if (status && !file.delete()) {
                            LOGGER.warn((Object)("Unable to delete the folder as per delete command " + file.getAbsolutePath()));
                        }
                    }
                }
                ArrayList<Segment> segments = new ArrayList<Segment>(1);
                for (TableIndex index : indexes) {
                    segments.clear();
                    segments.add(new Segment(oneLoad.getLoadName()));
                    index.deleteIndexData(segments);
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to delete the file as per delete command " + oneLoad.getLoadName()));
            }
        }
    }

    private static boolean checkIfLoadCanBeDeleted(LoadMetadataDetails oneLoad, boolean isForceDelete) {
        if ((SegmentStatus.MARKED_FOR_DELETE == oneLoad.getSegmentStatus() || SegmentStatus.COMPACTED == oneLoad.getSegmentStatus() || SegmentStatus.INSERT_IN_PROGRESS == oneLoad.getSegmentStatus() || SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS == oneLoad.getSegmentStatus()) && oneLoad.getVisibility().equalsIgnoreCase("true")) {
            if (isForceDelete) {
                return true;
            }
            long deletionTime = oneLoad.getModificationOrdeletionTimesStamp();
            return CarbonUpdateUtil.isMaxQueryTimeoutExceeded(deletionTime);
        }
        return false;
    }

    private static boolean checkIfLoadCanBeDeletedPhysically(LoadMetadataDetails oneLoad, boolean isForceDelete) {
        if (!(SegmentStatus.MARKED_FOR_DELETE != oneLoad.getSegmentStatus() && SegmentStatus.COMPACTED != oneLoad.getSegmentStatus() || oneLoad.getPath() != null && !oneLoad.getPath().equalsIgnoreCase("NA"))) {
            if (isForceDelete) {
                return true;
            }
            long deletionTime = oneLoad.getModificationOrdeletionTimesStamp();
            return CarbonUpdateUtil.isMaxQueryTimeoutExceeded(deletionTime);
        }
        return false;
    }

    private static LoadMetadataDetails getCurrentLoadStatusOfSegment(String segmentId, String metadataPath) {
        LoadMetadataDetails[] currentDetails;
        for (LoadMetadataDetails oneLoad : currentDetails = SegmentStatusManager.readLoadMetadata(metadataPath)) {
            if (!oneLoad.getLoadName().equalsIgnoreCase(segmentId)) continue;
            return oneLoad;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteLoadFoldersFromFileSystem(AbsoluteTableIdentifier absoluteTableIdentifier, boolean isForceDelete, LoadMetadataDetails[] details, String metadataPath) {
        boolean isDeleted = false;
        if (details != null && details.length != 0) {
            for (LoadMetadataDetails oneLoad : details) {
                if (!DeleteLoadFolders.checkIfLoadCanBeDeleted(oneLoad, isForceDelete)) continue;
                ICarbonLock segmentLock = CarbonLockFactory.getCarbonLockObj(absoluteTableIdentifier, CarbonTablePath.addSegmentPrefix(oneLoad.getLoadName()) + ".lock");
                try {
                    if (oneLoad.getSegmentStatus() == SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS || oneLoad.getSegmentStatus() == SegmentStatus.INSERT_IN_PROGRESS) {
                        if (segmentLock.lockWithRetries(1, 5)) {
                            LOGGER.info((Object)("Info: Acquired segment lock on segment:" + oneLoad.getLoadName()));
                            LoadMetadataDetails currentDetails = DeleteLoadFolders.getCurrentLoadStatusOfSegment(oneLoad.getLoadName(), metadataPath);
                            if (currentDetails == null || !DeleteLoadFolders.checkIfLoadCanBeDeleted(currentDetails, isForceDelete)) continue;
                            oneLoad.setVisibility("false");
                            isDeleted = true;
                            LOGGER.info((Object)("Info: Deleted the load " + oneLoad.getLoadName()));
                            continue;
                        }
                        LOGGER.info((Object)("Info: Load in progress for segment" + oneLoad.getLoadName()));
                        boolean bl = isDeleted;
                        return bl;
                    }
                    oneLoad.setVisibility("false");
                    isDeleted = true;
                    LOGGER.info((Object)("Info: Deleted the load " + oneLoad.getLoadName()));
                }
                finally {
                    segmentLock.unlock();
                    LOGGER.info((Object)("Info: Segment lock on segment:" + oneLoad.getLoadName() + " is released"));
                }
            }
        }
        return isDeleted;
    }
}

