/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.log4j.Logger;

public class ObjectSerializationUtil {
    private static final Logger LOG = LogServiceFactory.getLogService((String)ObjectSerializationUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertObjectToString(Object obj) throws IOException {
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(baos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(obj);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (gos != null) {
                    gos.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return CarbonUtil.encodeToString(baos.toByteArray());
    }

    public static Object convertStringToObject(String objectString) throws IOException {
        if (objectString == null) {
            return null;
        }
        byte[] bytes = CarbonUtil.decodeStringToBytes(objectString);
        ByteArrayInputStream bais = null;
        GZIPInputStream gis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            gis = new GZIPInputStream(bais);
            ois = new ClassLoaderObjectInputStream(Thread.currentThread().getContextClassLoader(), (InputStream)gis);
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not read object", e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (gis != null) {
                    gis.close();
                }
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

