/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.lang.reflect.Method;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.log4j.Logger;

public final class ObjectSizeCalculator {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ObjectSizeCalculator.class.getName());
    private static String className = "org.apache.spark.util.SizeEstimator";
    private static Method estimateMethod = null;
    private static boolean methodAccessible = true;

    public static long estimate(Object anObject, long defValue) {
        try {
            if (methodAccessible) {
                if (null == estimateMethod) {
                    estimateMethod = Class.forName(className).getMethod("estimate", Object.class);
                    estimateMethod.setAccessible(true);
                }
                return (Long)estimateMethod.invoke(null, anObject);
            }
            return defValue;
        }
        catch (Throwable ex) {
            LOGGER.error((Object)"Could not access method SizeEstimator:estimate.Returning default value", ex);
            methodAccessible = false;
            return defValue;
        }
    }
}

