/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.constants.LoggerAction;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.log4j.Logger;

public class SessionParams
implements Serializable,
Cloneable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CacheProvider.class.getName());
    private static final long serialVersionUID = -7801994600594915264L;
    private Map<String, String> sProps = new HashMap<String, String>();
    private ConcurrentHashMap<String, String> addedProps = new ConcurrentHashMap();
    private Map<String, Object> extraInfo = new HashMap<String, Object>();

    public void setExtraInfo(String key, Object value) {
        this.extraInfo.put(key, value);
    }

    public Object getExtraInfo(String key) {
        return this.extraInfo.get(key);
    }

    public String getProperty(String key) {
        return this.sProps.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (!this.sProps.containsKey(key)) {
            return defaultValue;
        }
        return this.sProps.get(key);
    }

    public SessionParams addProperty(String key, String value) throws InvalidConfigurationException {
        boolean isValidConf = this.validateKeyValue(key, value);
        if (isValidConf) {
            if (key.equals("carbon.options.bad.records.action")) {
                value = value.toUpperCase();
            }
            LOGGER.info((Object)("The key " + key + " with value " + value + " added in the session param"));
            this.sProps.put(key, value);
        }
        return this;
    }

    public Map<String, String> getAll() {
        return this.sProps;
    }

    public SessionParams addProps(Map<String, String> addedProps) {
        this.addedProps.putAll(addedProps);
        return this;
    }

    public Map<String, String> getAddedProps() {
        return this.addedProps;
    }

    private boolean validateKeyValue(String key, String value) throws InvalidConfigurationException {
        boolean isValid = false;
        switch (key) {
            case "carbon.si.lookup.partialstring": 
            case "enable.unsafe.sort": 
            case "enable.offheap.sort": 
            case "carbon.custom.block.distribution": 
            case "carbon.options.bad.records.logger.enable": 
            case "carbon.options.is.empty.data.bad.record": 
            case "carbon.enable.vector.reader": 
            case "enable.unsafe.in.query.processing": 
            case "carbon.enable.auto.load.merge": 
            case "carbon.push.rowfilters.for.vector": 
            case "carbon.enable.index.server": 
            case "carbon.query.stage.input.enable": 
            case "disable_sql_rewrite": {
                isValid = CarbonUtil.validateBoolean(value);
                if (isValid) break;
                throw new InvalidConfigurationException("Invalid value " + value + " for key " + key);
            }
            case "carbon.options.bad.records.action": {
                try {
                    LoggerAction.valueOf((String)value.toUpperCase());
                    isValid = true;
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new InvalidConfigurationException("The key " + key + " can have only either FORCE or IGNORE or REDIRECT or FAIL.");
                }
            }
            case "carbon.options.sort.scope": {
                isValid = CarbonUtil.isValidSortOption(value);
                if (isValid) break;
                throw new InvalidConfigurationException("The sort scope " + key + " can have only either NO_SORT, LOCAL_SORT or GLOBAL_SORT.");
            }
            case "carbon.options.global.sort.partitions": 
            case "carbon.number.of.cores.while.loading": 
            case "carbon.number.of.cores.while.compacting": 
            case "carbon.blockletgroup.size.in.mb": 
            case "carbon.major.compaction.size": {
                isValid = CarbonUtil.validateValidIntType(value);
                if (isValid) break;
                throw new InvalidConfigurationException("The configured value for key " + key + " must be valid integer.");
            }
            case "carbon.options.bad.record.path": {
                isValid = CarbonUtil.isValidBadStorePath(value);
                if (isValid) break;
                throw new InvalidConfigurationException("Invalid bad records location.");
            }
            case "carbon.options.date.format": {
                isValid = true;
                break;
            }
            case "carbon.options.timestamp.format": {
                isValid = true;
                break;
            }
            case "carbon.options.serialization.null.format": {
                isValid = true;
                break;
            }
            case "carbon.compaction.level.threshold": {
                int[] values = CarbonProperties.getInstance().getIntArray(value);
                if (values.length != 2) {
                    throw new InvalidConfigurationException("Invalid COMPACTION_SEGMENT_LEVEL_THRESHOLD: " + value);
                }
                isValid = true;
                break;
            }
            default: {
                if (key.startsWith("carbon.enable.index.server") && key.split("\\.").length == 6) {
                    isValid = true;
                    break;
                }
                if (key.startsWith("carbon.input.segments.")) {
                    isValid = CarbonUtil.validateRangeOfSegmentList(value);
                    if (isValid) break;
                    throw new InvalidConfigurationException("Invalid CARBON_INPUT_SEGMENT_IDs");
                }
                if (key.startsWith("carbon.index.visible.")) {
                    isValid = true;
                    break;
                }
                if (key.startsWith("carbon.load.indexes.parallel.")) {
                    isValid = CarbonUtil.validateBoolean(value);
                    if (isValid) break;
                    throw new InvalidConfigurationException("Invalid value " + value + " for key " + key);
                }
                if (key.startsWith("carbon.table.load.sort.scope.")) {
                    isValid = CarbonUtil.isValidSortOption(value);
                    if (isValid) break;
                    throw new InvalidConfigurationException("The sort scope " + key + " can have only either NO_SORT, LOCAL_SORT or GLOBAL_SORT.");
                }
                throw new InvalidConfigurationException("The key " + key + " not supported for dynamic configuration.");
            }
        }
        return isValid;
    }

    public void removeProperty(String property) {
        this.sProps.remove(property);
    }

    public void removeExtraInfo(String key) {
        this.extraInfo.remove(key);
    }

    public void clear() {
        this.sProps.clear();
    }

    public SessionParams clone() throws CloneNotSupportedException {
        super.clone();
        SessionParams newObj = new SessionParams();
        newObj.addedProps.putAll(this.addedProps);
        newObj.sProps.putAll(this.sProps);
        newObj.extraInfo.putAll(this.extraInfo);
        return newObj;
    }
}

