/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;

public class TaskMetricsMap {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)TaskMetricsMap.class.getName());
    private static final InheritableThreadLocal<Long> threadLocal = new InheritableThreadLocal();
    public static final Map<Long, List<CarbonFSBytesReadOnThreadCallback>> metricMap = new ConcurrentHashMap<Long, List<CarbonFSBytesReadOnThreadCallback>>();
    public static final TaskMetricsMap taskMetricsMap = new TaskMetricsMap();

    public static TaskMetricsMap getInstance() {
        return taskMetricsMap;
    }

    public static InheritableThreadLocal<Long> getThreadLocal() {
        return threadLocal;
    }

    public static void initializeThreadLocal() {
        if (threadLocal.get() == null) {
            threadLocal.set(Thread.currentThread().getId());
        }
    }

    public void registerThreadCallback() {
        if (null != threadLocal.get()) {
            long parentThreadId = (Long)threadLocal.get();
            new CarbonFSBytesReadOnThreadCallback(parentThreadId);
        }
    }

    public void removeEntry(long threadId) {
        metricMap.remove(threadId);
    }

    public List<CarbonFSBytesReadOnThreadCallback> getCallbackList(long threadId) {
        return metricMap.get(threadId);
    }

    public boolean isCallbackEmpty(long threadId) {
        List<CarbonFSBytesReadOnThreadCallback> callbackList = this.getCallbackList(threadId);
        if (null == callbackList) {
            return true;
        }
        return callbackList.isEmpty();
    }

    public void updateReadBytes(long callbackThreadId) {
        long parentThreadId;
        List<CarbonFSBytesReadOnThreadCallback> callbackList;
        if (null != threadLocal.get() && null != (callbackList = this.getCallbackList(parentThreadId = ((Long)threadLocal.get()).longValue()))) {
            for (CarbonFSBytesReadOnThreadCallback callback : callbackList) {
                if (callback.threadId != callbackThreadId) continue;
                callback.updatedReadBytes += callback.readbytes();
                break;
            }
        }
    }

    public long getReadBytesSum(long threadName) {
        List<CarbonFSBytesReadOnThreadCallback> callbacks = this.getCallbackList(threadName);
        long sum = 0L;
        if (null != callbacks) {
            for (CarbonFSBytesReadOnThreadCallback callback : callbacks) {
                sum += callback.getReadBytes();
            }
        }
        return sum;
    }

    private void addEntry(long parentThreadId, CarbonFSBytesReadOnThreadCallback callback) {
        List<CarbonFSBytesReadOnThreadCallback> callbackList = this.getCallbackList(parentThreadId);
        if (null == callbackList) {
            CopyOnWriteArrayList<CarbonFSBytesReadOnThreadCallback> list = new CopyOnWriteArrayList<CarbonFSBytesReadOnThreadCallback>();
            list.add(callback);
            metricMap.put(parentThreadId, list);
        } else {
            callbackList.add(callback);
        }
    }

    class CarbonFSBytesReadOnThreadCallback {
        long baseline = 0L;
        long updatedReadBytes = 0L;
        long threadId = Thread.currentThread().getId();

        CarbonFSBytesReadOnThreadCallback(long parentThread) {
            this.baseline = this.readbytes();
            TaskMetricsMap.this.addEntry(parentThread, this);
        }

        public long readbytes() {
            List statisticsList = FileSystem.getAllStatistics();
            long sum = 0L;
            try {
                for (FileSystem.Statistics statistics : statisticsList) {
                    Class<?> statisticsClass = Class.forName(statistics.getClass().getName());
                    Method getThreadStatisticsMethod = statisticsClass.getDeclaredMethod("getThreadStatistics", new Class[0]);
                    Class<?> statisticsDataClass = Class.forName("org.apache.hadoop.fs.FileSystem$Statistics$StatisticsData");
                    Method getBytesReadMethod = statisticsDataClass.getDeclaredMethod("getBytesRead", new Class[0]);
                    sum += ((Long)getBytesReadMethod.invoke(statisticsDataClass.cast(getThreadStatisticsMethod.invoke((Object)statistics, null)), null)).longValue();
                }
            }
            catch (Exception ex) {
                LOGGER.debug((Object)ex.getLocalizedMessage());
            }
            return sum;
        }

        public long getReadBytes() {
            return this.updatedReadBytes - this.baseline;
        }
    }
}

