/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.SessionParams;
import org.apache.hadoop.conf.Configuration;

public class ThreadLocalSessionInfo {
    static final InheritableThreadLocal<CarbonSessionInfo> threadLocal = new InheritableThreadLocal();

    public static void setCarbonSessionInfo(CarbonSessionInfo carbonSessionInfo) {
        threadLocal.set(carbonSessionInfo);
    }

    public static CarbonSessionInfo getCarbonSessionInfo() {
        return (CarbonSessionInfo)threadLocal.get();
    }

    public static synchronized CarbonSessionInfo getOrCreateCarbonSessionInfo() {
        CarbonSessionInfo info = (CarbonSessionInfo)threadLocal.get();
        if (info == null || info.getSessionParams() == null) {
            info = new CarbonSessionInfo();
            info.setSessionParams(new SessionParams());
            threadLocal.set(info);
        }
        return info;
    }

    public static void setConfigurationToCurrentThread(Configuration configuration) {
        ThreadLocalSessionInfo.getOrCreateCarbonSessionInfo().getNonSerializableExtraInfo().put("carbonConf", configuration);
    }

    public static void unsetAll() {
        threadLocal.remove();
    }

    public static void shouldHaveCarbonConf() {
        CarbonSessionInfo sessionInfo = ThreadLocalSessionInfo.getCarbonSessionInfo();
        if (sessionInfo == null) {
            throw new RuntimeException("the thread not contain CarbonSessionInfo");
        }
        Object conf = sessionInfo.getNonSerializableExtraInfo().get("carbonConf");
        if (conf == null) {
            throw new RuntimeException("the thread not contain hadoop configuration");
        }
    }
}

