/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util;

import org.apache.carbondata.core.util.CarbonTaskInfo;
import org.apache.carbondata.core.util.CarbonUtil;

public class ThreadLocalTaskInfo {
    static final InheritableThreadLocal<CarbonTaskInfo> threadLocal = new InheritableThreadLocal();

    public static void setCarbonTaskInfo(CarbonTaskInfo carbonTaskInfo) {
        threadLocal.set(carbonTaskInfo);
    }

    public static CarbonTaskInfo getCarbonTaskInfo() {
        if (null == threadLocal.get()) {
            CarbonTaskInfo carbonTaskInfo = new CarbonTaskInfo();
            carbonTaskInfo.setTaskId(CarbonUtil.generateUUID());
            ThreadLocalTaskInfo.setCarbonTaskInfo(carbonTaskInfo);
        }
        return (CarbonTaskInfo)threadLocal.get();
    }

    public static void clearCarbonTaskInfo() {
        if (null != threadLocal.get()) {
            threadLocal.set(null);
        }
    }
}

