/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util.comparator;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.comparator.BigDecimalSerializableComparator;
import org.apache.carbondata.core.util.comparator.BooleanSerializableComparator;
import org.apache.carbondata.core.util.comparator.ByteArraySerializableComparator;
import org.apache.carbondata.core.util.comparator.DoubleSerializableComparator;
import org.apache.carbondata.core.util.comparator.FloatSerializableComparator;
import org.apache.carbondata.core.util.comparator.IntSerializableComparator;
import org.apache.carbondata.core.util.comparator.LongSerializableComparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;
import org.apache.carbondata.core.util.comparator.ShortSerializableComparator;

public final class Comparator {
    private static final SerializableComparator BOOLEAN = new BooleanSerializableComparator();
    private static final SerializableComparator INT = new IntSerializableComparator();
    private static final SerializableComparator SHORT = new ShortSerializableComparator();
    private static final SerializableComparator DOUBLE = new DoubleSerializableComparator();
    private static final SerializableComparator FLOAT = new FloatSerializableComparator();
    private static final SerializableComparator LONG = new LongSerializableComparator();
    private static final SerializableComparator DECIMAL = new BigDecimalSerializableComparator();
    private static final SerializableComparator BYTE = new ByteArraySerializableComparator();

    public static SerializableComparator getComparator(DataType dataType) {
        if (dataType == DataTypes.DATE || dataType == DataTypes.TIMESTAMP) {
            return LONG;
        }
        if (dataType == DataTypes.STRING) {
            return BYTE;
        }
        return Comparator.getComparatorByDataTypeForMeasure(dataType);
    }

    public static SerializableComparator getComparatorByDataTypeForMeasure(DataType dataType) {
        if (dataType == DataTypes.BOOLEAN) {
            return BOOLEAN;
        }
        if (dataType == DataTypes.INT) {
            return INT;
        }
        if (dataType == DataTypes.SHORT) {
            return SHORT;
        }
        if (dataType == DataTypes.LONG) {
            return LONG;
        }
        if (dataType == DataTypes.DOUBLE) {
            return DOUBLE;
        }
        if (dataType == DataTypes.FLOAT) {
            return FLOAT;
        }
        if (DataTypes.isDecimal(dataType)) {
            return DECIMAL;
        }
        if (dataType == DataTypes.BYTE) {
            return BYTE;
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType.getName());
    }
}

