/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.util.path;

import java.io.File;
import java.util.Objects;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.hadoop.conf.Configuration;

public class CarbonTablePath {
    private static final String METADATA_DIR = "Metadata";
    private static final String DICTIONARY_EXT = ".dict";
    public static final String SCHEMA_FILE = "schema";
    private static final String FACT_DIR = "Fact";
    private static final String SEGMENT_PREFIX = "Segment_";
    private static final String PARTITION_PREFIX = "Part";
    private static final String DATA_PART_PREFIX = "part-";
    private static final String BATCH_PREFIX = "_batchno";
    private static final String LOCK_DIR = "LockFiles";
    public static final String TABLE_STATUS_FILE = "tablestatus";
    public static final String TABLE_STATUS_HISTORY_FILE = "tablestatus.history";
    public static final String CARBON_DATA_EXT = ".carbondata";
    public static final String INDEX_FILE_EXT = ".carbonindex";
    public static final String MERGE_INDEX_FILE_EXT = ".carbonindexmerge";
    public static final String SEGMENT_EXT = ".segment";
    private static final String STREAMING_DIR = ".streaming";
    private static final String STREAMING_LOG_DIR = "log";
    private static final String STREAMING_CHECKPOINT_DIR = "checkpoint";
    private static final String STAGE_DIR = "stage";
    private static final String STAGE_DATA_DIR = "stage_data";
    public static final String SUCCESS_FILE_SUBFIX = ".success";
    private static final String SNAPSHOT_FILE_NAME = "snapshot";
    public static final String SYSTEM_FOLDER_DIR = "_system";
    public static final String DEPRECATED_PARTITION_ID = "0";

    private CarbonTablePath() {
    }

    public static String getStageDir(String tablePath) {
        return CarbonTablePath.getMetadataPath(tablePath) + "/" + STAGE_DIR;
    }

    public static String getStageDataDir(String tablePath) {
        return tablePath + "/" + STAGE_DATA_DIR;
    }

    public static String getStageSnapshotFile(String tablePath) {
        return CarbonTablePath.getStageDir(tablePath) + "/" + SNAPSHOT_FILE_NAME;
    }

    public static String getFolderContainingFile(String carbonFilePath) {
        int lastIndex = carbonFilePath.lastIndexOf(47);
        if (-1 == lastIndex) {
            lastIndex = carbonFilePath.lastIndexOf(File.separator);
        }
        return carbonFilePath.substring(0, lastIndex);
    }

    public static String getDictionaryFileName(String columnId) {
        return columnId + DICTIONARY_EXT;
    }

    public static Boolean isDictionaryFile(CarbonFile carbonFile) {
        return !carbonFile.isDirectory() && carbonFile.getName().endsWith(DICTIONARY_EXT);
    }

    public static boolean isCarbonDataFile(String fileNameWithPath) {
        int pos = fileNameWithPath.lastIndexOf(46);
        if (pos != -1) {
            return fileNameWithPath.substring(pos).startsWith(CARBON_DATA_EXT);
        }
        return false;
    }

    public static boolean isCarbonIndexFile(String fileNameWithPath) {
        int pos = fileNameWithPath.lastIndexOf(46);
        if (pos != -1) {
            return fileNameWithPath.substring(pos).startsWith(INDEX_FILE_EXT);
        }
        return false;
    }

    public static String getDictionaryFilePath(String tablePath, String columnId) {
        return CarbonTablePath.getMetadataPath(tablePath) + "/" + CarbonTablePath.getDictionaryFileName(columnId);
    }

    public static String getMetadataPath(String tablePath) {
        return tablePath + "/" + METADATA_DIR;
    }

    public static String getSchemaFilePath(String tablePath) {
        return CarbonTablePath.getActualSchemaFilePath(tablePath, null);
    }

    public static String getSchemaFilePath(String tablePath, Configuration hadoopConf) {
        return CarbonTablePath.getActualSchemaFilePath(tablePath, hadoopConf);
    }

    private static String getActualSchemaFilePath(String tablePath, Configuration hadoopConf) {
        String metaPath = tablePath + "/" + METADATA_DIR;
        CarbonFile carbonFile = hadoopConf != null ? FileFactory.getCarbonFile(metaPath, hadoopConf) : FileFactory.getCarbonFile(metaPath);
        CarbonFile[] schemaFile = carbonFile.listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile file) {
                return file.getName().startsWith(CarbonTablePath.SCHEMA_FILE);
            }
        });
        if (schemaFile != null && schemaFile.length > 0 && FileFactory.getFileType(tablePath) != FileFactory.FileType.ALLUXIO) {
            return schemaFile[0].getAbsolutePath();
        }
        return metaPath + "/" + SCHEMA_FILE;
    }

    public static String getTableStatusFilePath(String tablePath) {
        return CarbonTablePath.getMetadataPath(tablePath) + "/" + TABLE_STATUS_FILE;
    }

    public static String getTableStatusFilePathWithUUID(String tablePath, String uuid) {
        if (!uuid.isEmpty()) {
            return CarbonTablePath.getTableStatusFilePath(tablePath) + "_" + uuid;
        }
        return CarbonTablePath.getTableStatusFilePath(tablePath);
    }

    private static String getCarbonIndexFilePath(String tablePath, final String taskId, String segmentId, final String bucketNumber) {
        String segmentDir = CarbonTablePath.getSegmentPath(tablePath, segmentId);
        CarbonFile carbonFile = FileFactory.getCarbonFile(segmentDir);
        CarbonFile[] files = carbonFile.listFiles(new CarbonFileFilter(){

            @Override
            public boolean accept(CarbonFile file) {
                if (bucketNumber.equals("-1")) {
                    return file.getName().startsWith(taskId) && file.getName().endsWith(CarbonTablePath.INDEX_FILE_EXT);
                }
                return file.getName().startsWith(taskId + "-" + bucketNumber) && file.getName().endsWith(CarbonTablePath.INDEX_FILE_EXT);
            }
        });
        if (files.length > 0) {
            return files[0].getAbsolutePath();
        }
        throw new RuntimeException("Missing Carbon index file for Segment[" + segmentId + "], taskId[" + taskId + "]");
    }

    public static String getCarbonIndexFilePath(String tablePath, String taskId, String segmentId, String bucketNumber, String timeStamp, ColumnarFormatVersion columnarFormatVersion) {
        switch (columnarFormatVersion) {
            case V3: {
                String segmentDir = CarbonTablePath.getSegmentPath(tablePath, segmentId);
                return segmentDir + "/" + CarbonTablePath.getCarbonIndexFileName(taskId, Integer.parseInt(bucketNumber), timeStamp, segmentId);
            }
        }
        throw new UnsupportedOperationException("Unsupported file version: " + (Object)((Object)columnarFormatVersion));
    }

    private static String getCarbonIndexFileName(String taskNo, int bucketNumber, String factUpdatedtimeStamp, String segmentNo) {
        if (bucketNumber == -1) {
            return taskNo + "-" + segmentNo + "-" + factUpdatedtimeStamp + INDEX_FILE_EXT;
        }
        return taskNo + "-" + bucketNumber + "-" + segmentNo + "-" + factUpdatedtimeStamp + INDEX_FILE_EXT;
    }

    public static String getSegmentPath(String tablePath, String segmentId) {
        return CarbonTablePath.getPartitionDir(tablePath) + "/" + SEGMENT_PREFIX + segmentId;
    }

    public static String getCarbonDataFileName(Integer filePartNo, String taskNo, int bucketNumber, int batchNo, String factUpdateTimeStamp, String segmentNo, String compressor) {
        Objects.requireNonNull(filePartNo);
        Objects.requireNonNull(taskNo);
        Objects.requireNonNull(factUpdateTimeStamp);
        Objects.requireNonNull(compressor);
        return DATA_PART_PREFIX + filePartNo + "-" + taskNo + BATCH_PREFIX + batchNo + "-" + bucketNumber + "-" + segmentNo + "-" + factUpdateTimeStamp + "." + compressor + CARBON_DATA_EXT;
    }

    public static String getShardName(String taskNo, int bucketNumber, int batchNo, String factUpdateTimeStamp, String segmentNo) {
        return taskNo + BATCH_PREFIX + batchNo + "-" + bucketNumber + "-" + segmentNo + "-" + factUpdateTimeStamp;
    }

    public static String getCarbonIndexFileName(String taskNo, int bucketNumber, int batchNo, String factUpdatedTimeStamp, String segmentNo) {
        return CarbonTablePath.getShardName(taskNo, bucketNumber, batchNo, factUpdatedTimeStamp, segmentNo) + INDEX_FILE_EXT;
    }

    public static String getCarbonStreamIndexFileName() {
        return CarbonTablePath.getCarbonIndexFileName(DEPRECATED_PARTITION_ID, 0, 0, DEPRECATED_PARTITION_ID, DEPRECATED_PARTITION_ID);
    }

    public static String getCarbonStreamIndexFilePath(String segmentDir) {
        return segmentDir + "/" + CarbonTablePath.getCarbonStreamIndexFileName();
    }

    public static String getPartitionDir(String tablePath) {
        return CarbonTablePath.getFactDir(tablePath) + "/" + PARTITION_PREFIX + DEPRECATED_PARTITION_ID;
    }

    public static String getFactDir(String tablePath) {
        return tablePath + "/" + FACT_DIR;
    }

    public static String getStreamingLogDir(String tablePath) {
        return tablePath + "/" + STREAMING_DIR + "/" + STREAMING_LOG_DIR;
    }

    public static String getStreamingCheckpointDir(String tablePath) {
        return tablePath + "/" + STREAMING_DIR + "/" + STREAMING_CHECKPOINT_DIR;
    }

    public static String getIndexStorePathOnShardName(String tablePath, String segmentId, String indexName, String shardName) {
        return CarbonTablePath.getIndexesStorePath(tablePath, segmentId, indexName) + "/" + shardName;
    }

    public static String getIndexesStorePath(String tablePath, String segmentId, String indexName) {
        return tablePath + "/" + indexName + "/" + segmentId;
    }

    public static String getCarbonDataFileName(String carbonDataFilePath) {
        return carbonDataFilePath.substring(carbonDataFilePath.lastIndexOf("/") + 1, carbonDataFilePath.lastIndexOf(CARBON_DATA_EXT));
    }

    public static String getCarbonDataPrefix() {
        return DATA_PART_PREFIX;
    }

    public static String getCarbonDataExtension() {
        return CARBON_DATA_EXT;
    }

    public static String getCarbonIndexExtension() {
        return INDEX_FILE_EXT;
    }

    public static String getCarbonMergeIndexExtension() {
        return MERGE_INDEX_FILE_EXT;
    }

    public static String getShortBlockId(String blockId) {
        return blockId.replace(PARTITION_PREFIX, "").replace(SEGMENT_PREFIX, "").replace(DATA_PART_PREFIX, "").replace(CARBON_DATA_EXT, "");
    }

    public static String getShortBlockIdForPartitionTable(String blockId) {
        return blockId.replace(DATA_PART_PREFIX, "").replace(CARBON_DATA_EXT, "");
    }

    public static String addDataPartPrefix(String value) {
        return DATA_PART_PREFIX + value;
    }

    public static String addPartPrefix(String value) {
        return PARTITION_PREFIX + value;
    }

    public static String addSegmentPrefix(String value) {
        return SEGMENT_PREFIX + value;
    }

    public static String getShardName(String actualBlockName) {
        String segmentNoStr = DataFileUtil.getSegmentNo(actualBlockName);
        StringBuilder shardName = new StringBuilder();
        if (null != segmentNoStr) {
            shardName.append(DataFileUtil.getTaskNo(actualBlockName)).append("-");
            shardName.append(DataFileUtil.getBucketNo(actualBlockName)).append("-");
            shardName.append(segmentNoStr).append("-");
            shardName.append(DataFileUtil.getTimeStampFromFileName(actualBlockName));
            return shardName.toString();
        }
        shardName.append(DataFileUtil.getTaskNo(actualBlockName)).append("-");
        shardName.append(DataFileUtil.getBucketNo(actualBlockName)).append("-");
        shardName.append(DataFileUtil.getTimeStampFromFileName(actualBlockName));
        return shardName.toString();
    }

    public static String getSegmentFilesLocation(String tablePath) {
        return CarbonTablePath.getMetadataPath(tablePath) + "/" + "segments";
    }

    public static String getSegmentFilePath(String tablePath, String segmentFileName) {
        return CarbonTablePath.getMetadataPath(tablePath) + "/" + "segments" + "/" + segmentFileName;
    }

    public static String getLockFilesDirPath(String tablePath) {
        return tablePath + "/" + LOCK_DIR;
    }

    public static String getLockFilePath(String tablePath, String lockType) {
        return CarbonTablePath.getLockFilesDirPath(tablePath) + "/" + lockType;
    }

    public static boolean isSegmentLockFilePath(String lockFileName) {
        return lockFileName.startsWith(SEGMENT_PREFIX) && lockFileName.endsWith(".lock");
    }

    public static String getTableStatusHistoryFilePath(String tablePath) {
        return CarbonTablePath.getMetadataPath(tablePath) + "/" + TABLE_STATUS_HISTORY_FILE;
    }

    public static String generateBadRecordsPath(String badLogStoreLocation, String segmentId, String taskNo, boolean isTransactionalTable) {
        if (!isTransactionalTable) {
            return badLogStoreLocation + "/" + "SdkWriterBadRecords" + "/" + taskNo;
        }
        return badLogStoreLocation + "/" + segmentId + "/" + taskNo;
    }

    public static String getParentPath(String dataFilePath) {
        int endIndex = dataFilePath.lastIndexOf("/");
        if (endIndex > -1) {
            return dataFilePath.substring(0, endIndex);
        }
        return dataFilePath;
    }

    public static class DataFileUtil {
        public static String getTimeStampFromFileName(String carbonDataFileName) {
            String fileName = DataFileUtil.getFileName(carbonDataFileName);
            int startIndex = carbonDataFileName.endsWith(CarbonTablePath.MERGE_INDEX_FILE_EXT) ? fileName.lastIndexOf("_") + 1 : fileName.lastIndexOf("-") + 1;
            int endIndex = fileName.indexOf(".", startIndex);
            return fileName.substring(startIndex, endIndex);
        }

        public static Boolean compareCarbonFileTimeStamp(String fileName, Long timestamp) {
            int startIndex = fileName.lastIndexOf("-");
            int endIndex = fileName.indexOf(".", startIndex);
            if (startIndex > 0 && endIndex > 0) {
                return fileName.substring(startIndex + 1, endIndex).equals(timestamp.toString());
            }
            return false;
        }

        public static String getTimeStampFromDeleteDeltaFile(String fileName) {
            return DataFileUtil.getTimeStampFromFileName(fileName);
        }

        public static String getBlockNameFromDeleteDeltaFile(String fileName) {
            return fileName.substring(0, fileName.lastIndexOf("-"));
        }

        public static String getBucketNo(String carbonFilePath) {
            int firstDashPos;
            int secondDash;
            int startIndex;
            String fileName = DataFileUtil.getFileName(carbonFilePath);
            int endIndex = fileName.indexOf("-", startIndex = fileName.indexOf("-", (secondDash = fileName.indexOf("-", (firstDashPos = fileName.indexOf("-")) + 1)) + 1) + 1);
            if (endIndex == -1) {
                return "-1";
            }
            return fileName.substring(startIndex, endIndex);
        }

        public static String getPartNo(String carbonDataFileName) {
            String fileName = DataFileUtil.getFileName(carbonDataFileName);
            int startIndex = fileName.indexOf("-") + 1;
            int endIndex = fileName.indexOf("-", startIndex);
            return fileName.substring(startIndex, endIndex);
        }

        public static String getTaskNo(String carbonDataFileName) {
            String fileName = DataFileUtil.getFileName(carbonDataFileName);
            int firstDashPos = fileName.indexOf("-");
            int startIndex = fileName.indexOf("-", firstDashPos + 1) + 1;
            int endIndex = fileName.indexOf("-", startIndex);
            return fileName.substring(startIndex, endIndex);
        }

        public static long getTaskId(String carbonDataFileName) {
            return Long.parseLong(DataFileUtil.getTaskNo(carbonDataFileName).split(CarbonTablePath.BATCH_PREFIX)[0]);
        }

        public static String getSegmentNo(String carbonDataFileName) {
            int firstDashPos;
            int startIndex1;
            int endIndex1;
            String fileName = DataFileUtil.getFileName(carbonDataFileName);
            int startIndex = fileName.indexOf("-", (endIndex1 = fileName.indexOf("-", startIndex1 = fileName.indexOf("-", (firstDashPos = fileName.indexOf("-")) + 1) + 1)) + 1);
            if (startIndex > -1) {
                int endIndex;
                if ((endIndex = fileName.indexOf("-", ++startIndex)) == -1) {
                    return null;
                }
                return fileName.substring(startIndex, endIndex);
            }
            return null;
        }

        public static String getTaskIdFromTaskNo(String taskNo) {
            return taskNo.split(CarbonTablePath.BATCH_PREFIX)[0];
        }

        public static int getBatchNoFromTaskNo(String taskNo) {
            return Integer.parseInt(taskNo.split(CarbonTablePath.BATCH_PREFIX)[1]);
        }

        public static String getFileName(String dataFilePath) {
            int endIndex = dataFilePath.lastIndexOf("/");
            if (endIndex > -1) {
                return dataFilePath.substring(endIndex + 1, dataFilePath.length());
            }
            return dataFilePath;
        }

        public static String getSegmentIdFromPath(String dataFileAbsolutePath) {
            String tempdataFileAbsolutePath = dataFileAbsolutePath.replace("\\", "/");
            int endIndex = tempdataFileAbsolutePath.lastIndexOf("/");
            int startIndex = tempdataFileAbsolutePath.lastIndexOf("/", endIndex - 1) + 1;
            String segmentDirStr = dataFileAbsolutePath.substring(startIndex, endIndex);
            String[] segmentDirSplits = segmentDirStr.split("_");
            try {
                if (segmentDirSplits.length == 2) {
                    return segmentDirSplits[1];
                }
            }
            catch (Exception e) {
                return "-1";
            }
            return "-1";
        }
    }
}

