/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.view;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.view.MVCatalog;
import org.apache.carbondata.core.view.MVCatalogFactory;
import org.apache.carbondata.core.view.MVProvider;
import org.apache.carbondata.core.view.MVSchema;
import org.apache.carbondata.core.view.MVStatus;
import org.apache.carbondata.core.view.MVStatusDetail;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public abstract class MVManager {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)MVManager.class.getName());
    private final MVProvider schemaProvider = new MVProvider();
    private volatile MVCatalog<?> catalog;
    private final Object lock = new Object();

    public abstract List<String> getDatabases();

    public abstract String getDatabaseLocation(String var1);

    public boolean hasSchemaOnTable(CarbonTable table) throws IOException {
        List<MVSchema> schemas = this.getSchemas();
        for (MVSchema schema : schemas) {
            for (RelationIdentifier relatedTable : schema.getRelatedTables()) {
                if (!relatedTable.getDatabaseName().equalsIgnoreCase(table.getDatabaseName()) || !relatedTable.getTableName().equalsIgnoreCase(table.getTableName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<MVSchema> getSchemasOnTable(CarbonTable table) throws IOException {
        ArrayList<MVSchema> schemasOnTable = new ArrayList<MVSchema>();
        List<MVSchema> schemas = this.getSchemas();
        for (MVSchema schema : schemas) {
            boolean isSchemaOnTable = false;
            for (RelationIdentifier relatedTable : schema.getRelatedTables()) {
                if (!relatedTable.getDatabaseName().equalsIgnoreCase(table.getDatabaseName()) || !relatedTable.getTableName().equalsIgnoreCase(table.getTableName())) continue;
                isSchemaOnTable = true;
                break;
            }
            if (!isSchemaOnTable) continue;
            schemasOnTable.add(schema);
        }
        return schemasOnTable;
    }

    public List<MVSchema> getSchemasOnTable(String databaseName, CarbonTable carbonTable) throws IOException {
        return this.schemaProvider.getSchemas(this, databaseName, carbonTable);
    }

    public List<MVSchema> getSchemas() throws IOException {
        ArrayList<MVSchema> schemas = new ArrayList<MVSchema>();
        for (String database : this.getDatabases()) {
            schemas.addAll(this.getSchemas(database));
        }
        return schemas;
    }

    public List<MVSchema> getSchemas(String databaseName) throws IOException {
        return this.schemaProvider.getSchemas(this, databaseName);
    }

    public MVSchema getSchema(String databaseName, String viewName) throws IOException {
        return this.schemaProvider.getSchema(this, databaseName, viewName);
    }

    public void createSchema(String databaseName, MVSchema viewSchema) throws IOException {
        this.schemaProvider.saveSchema(this, databaseName, viewSchema);
    }

    public void deleteSchema(String databaseName, String viewName) throws IOException {
        this.schemaProvider.dropSchema(this, databaseName, viewName);
    }

    public MVCatalog<?> getCatalog() {
        return this.catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MVCatalog<?> getCatalog(MVCatalogFactory<?> catalogFactory, boolean reload) throws IOException {
        MVCatalog<?> catalog = this.catalog;
        if (reload || catalog == null) {
            Object object = this.lock;
            synchronized (object) {
                catalog = this.catalog;
                if (reload || catalog == null) {
                    catalog = catalogFactory.newCatalog();
                    List<MVSchema> schemas = this.getSchemas();
                    if (null == catalog) {
                        throw new RuntimeException("Internal Error.");
                    }
                    for (MVSchema schema : schemas) {
                        try {
                            catalog.registerSchema(schema);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"Error while registering schema", (Throwable)e);
                        }
                    }
                    this.catalog = catalog;
                }
            }
        }
        return catalog;
    }

    public static String getUpdatedSegmentMap(String mergedLoadName, MVSchema viewSchema, LoadMetadataDetails[] viewLoadMetadataDetails) {
        HashMap segmentMapping = new HashMap();
        List<RelationIdentifier> relationIdentifiers = viewSchema.getRelatedTables();
        for (RelationIdentifier relationIdentifier : relationIdentifiers) {
            for (LoadMetadataDetails loadMetadataDetail : viewLoadMetadataDetails) {
                if (loadMetadataDetail.getSegmentStatus() != SegmentStatus.COMPACTED || !mergedLoadName.equalsIgnoreCase(loadMetadataDetail.getMergedLoadName())) continue;
                Map segmentMap = (Map)new Gson().fromJson(loadMetadataDetail.getExtraInfo(), Map.class);
                if (segmentMapping.isEmpty()) {
                    segmentMapping.putAll(segmentMap);
                    continue;
                }
                ((List)segmentMapping.get(relationIdentifier.getDatabaseName() + "." + relationIdentifier.getTableName())).addAll((List)segmentMap.get(relationIdentifier.getDatabaseName() + "." + relationIdentifier.getTableName()));
            }
        }
        Gson gson = new Gson();
        return gson.toJson(segmentMapping);
    }

    public List<MVStatusDetail> getEnabledStatusDetails() throws IOException {
        ArrayList<MVStatusDetail> statusDetails = new ArrayList<MVStatusDetail>();
        for (String database : this.getDatabases()) {
            statusDetails.addAll(this.getEnabledStatusDetails(database));
        }
        return statusDetails;
    }

    List<MVStatusDetail> getEnabledStatusDetails(String databaseName) throws IOException {
        List<MVStatusDetail> statusDetails = this.schemaProvider.getStatusDetails(this, databaseName);
        ArrayList<MVStatusDetail> enabledStatusDetails = new ArrayList<MVStatusDetail>(statusDetails.size());
        for (MVStatusDetail statusDetail : statusDetails) {
            if (statusDetail.getStatus() != MVStatus.ENABLED) continue;
            enabledStatusDetails.add(statusDetail);
        }
        return enabledStatusDetails;
    }

    public void setStatus(RelationIdentifier viewIdentifier, MVStatus viewStatus) throws IOException {
        MVSchema schema = this.getSchema(viewIdentifier.getDatabaseName(), viewIdentifier.getTableName());
        if (schema != null) {
            this.schemaProvider.updateStatus(this, Collections.singletonList(schema), viewStatus);
        }
    }

    public void setStatus(List<MVSchema> viewSchemas, MVStatus viewStatus) throws IOException {
        if (viewSchemas != null && !viewSchemas.isEmpty()) {
            this.schemaProvider.updateStatus(this, viewSchemas, viewStatus);
        }
    }

    public void onDrop(String databaseName, String viewName) throws IOException {
        MVSchema viewSchema = this.getSchema(databaseName, viewName);
        if (viewSchema != null) {
            this.schemaProvider.updateStatus(this, Collections.singletonList(viewSchema), MVStatus.DROPPED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTruncate(List<MVSchema> schemas) throws IOException {
        for (MVSchema schema : schemas) {
            if (!schema.isRefreshOnManual()) {
                this.setStatus(schema.identifier, MVStatus.DISABLED);
            }
            RelationIdentifier relationIdentifier = schema.getIdentifier();
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(AbsoluteTableIdentifier.from(relationIdentifier.getTablePath(), relationIdentifier.getDatabaseName(), relationIdentifier.getTableName()));
            ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
            try {
                if (carbonLock.lockWithRetries()) {
                    LoadMetadataDetails[] loadMetadataDetails;
                    LOGGER.info((Object)("Acquired lock for table" + relationIdentifier.getDatabaseName() + "." + relationIdentifier.getTableName() + " for table status updation"));
                    String metaDataPath = CarbonTablePath.getMetadataPath(relationIdentifier.getTablePath());
                    for (LoadMetadataDetails entry : loadMetadataDetails = SegmentStatusManager.readLoadMetadata(metaDataPath)) {
                        entry.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                    }
                    SegmentStatusManager.writeLoadDetailsIntoFile(CarbonTablePath.getTableStatusFilePath(relationIdentifier.getTablePath()), loadMetadataDetails);
                    continue;
                }
                LOGGER.error((Object)("Not able to acquire the lock for Table status updation for table " + relationIdentifier.getDatabaseName() + "." + relationIdentifier.getTableName()));
            }
            finally {
                if (carbonLock.unlock()) {
                    LOGGER.info((Object)("Table unlocked successfully after table status updation" + relationIdentifier.getDatabaseName() + "." + relationIdentifier.getTableName()));
                    continue;
                }
                LOGGER.error((Object)("Unable to unlock Table lock for table" + relationIdentifier.getDatabaseName() + "." + relationIdentifier.getTableName() + " during table status updation"));
            }
        }
    }
}

